# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from pgm.timing import implicit
import pgm

from elisa.plugins.pigment.graph.image import Image
from elisa.plugins.pigment.widgets.theme import Theme

from twisted.internet import reactor

import math


class LoadableMixin(object):
    """
    Add loading animation feedback functionality to widgets.
    """

    loading_attribute = None

    def activate(self, previous=None):
        # FIXME: we need the frontend to use cloned images (by
        # "load_from_theme). This a cheap - UGLY - way to get the frontend
        # without changing much client code.
        from elisa.core.common import application
        self.frontend = application.interface_controller.frontends['frontend1']

        if previous:
            if previous != self:
                previous._toggle_loading_animation(False)

        if previous != self:
            self._allow_animation = True
            icon = getattr(self, self.loading_attribute)
            self.animated_icon = implicit.AnimatedObject(icon)
            settings = {'end_callback' : lambda ctrl: self._toggle_loading_animation(True),
                        'duration' : 400}
            self.animated_icon.setup_next_animations(**settings)
            self.animated_icon.opacity = 0

            self._interaction = None
            self._loading = False
            self._rotation_matrix = pgm.mat4x4_new_identity()
            self._rotation_matrix.translate(0.5, 0.5, 0.0)
            self._rotation_matrix.rotate_z(-math.pi / 30.0)
            self._rotation_matrix.translate(-0.5, -0.5, 0.0)

            self._create_interaction()

    def _create_interaction(self):
        self._interaction = Image()
        self.add(self._interaction)

        icon = getattr(self, self.loading_attribute)
        width, height = (icon.width, icon.height)
        x, y = (icon.x, icon.y)
        self._interaction.width, self._interaction.height = (width, height)
        self._interaction.x, self._interaction.y = (x, y)

        # downscaling
        scale = pgm.mat4x4_new_identity()
        scale.translate(0.5, 0.5, 0.0)
        factor = 2.0
        scale.scale(factor, factor, 0.0)
        scale.translate(-0.5, -0.5, 0.0)

        self._interaction.bg_color = (0, 0, 0, 0)
        self._interaction.opacity = 255
        self._interaction.visible = True

    def _toggle_loading_animation(self, enabled):
        if enabled and self._allow_animation:
            if self._loading:
                return
            if not hasattr(self, '_interaction') or not self._interaction:
                self._create_interaction()
            wait_icon = Theme.get_default().get_resource("elisa.plugins.poblesec.waiting_icon")
            self._interaction.visible = True
            self.frontend.load_from_theme("elisa.plugins.poblesec.waiting_icon", self._interaction)
            self._interaction.set_name('wait icon')
            self._loading = True
            reactor.callLater(0.023, self._transform_mapping_matrix_cb)
        else:
            self._allow_animation = False
            self._loading = False
            self._interaction.clear()
            self._interaction.visible = False
            settings = {'end_callback' : None,
                        'duration' : 400}
            self.animated_icon.setup_next_animations(**settings)
            self.animated_icon.opacity = 255

    def _transform_mapping_matrix_cb(self):
        if self._loading:
            self._interaction.mapping_matrix *= self._rotation_matrix
            reactor.callLater(0.017, self._transform_mapping_matrix_cb)
