
from elisa.core.tests.test_media_provider import TestMediaProvider
from elisa.core.tests.elisa_test_case import BoilerPlateApp
from elisa.core import common
from elisa.core.media_uri import MediaUri
from elisa.core.db_backend import DBBackend, DBBackendError
from elisa.core.utils import classinit
from elisa.plugins.media_db.elisa_media import ElisaMedia

import pkg_resources
import os, platform
import threading
import shutil

class TestElisaMedia(TestMediaProvider):

    component_class = ElisaMedia

    def setUp(self):
        TestMediaProvider.setUp(self)

        common.boot()

        db_file = os.path.join('data', 'elisa.db')
        db_module = 'elisa.plugins.media_db.tests'

        db = pkg_resources.resource_filename(db_module, db_file)
        shutil.copy(db, os.getcwd())

    def get_valid_uris(self):
        return [MediaUri("elisa:///")]

    # FIXME: this test doesn't test much...
    def test_get_artists(self):
        lc = []

        def gotchildren(result):
            res = MediaUri('elisa://localhost/artists/archive')

            uris = [i[0] for i in result]
            self.failUnless(res in uris)

        uri = MediaUri('elisa://localhost/artists')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)

        return dfr
    
    if platform.system() == 'Windows':
        test_get_artists.skip = "Skipped under windows, to fix"


    def test_get_artists_by_name(self):

        lc = []

        def gotchildren(l):
            r = 'elisa://localhost/artists/archive/albums/'
            expected_uris = [ MediaUri('%s%s' % (r, u))
                              for u in ('lights',
                                        'londinium',
                                        'take%20my%20head',
                                        'you%20all%20look%20the%20same%20to%20me')
                             ]
            uris = []
            for ur,els in l:
                uris.append(ur)

            self.assertEqual(expected_uris, uris)

        uri = MediaUri('elisa://localhost/artists/archive')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr
    
    if platform.system() == 'Windows':
        test_get_artists_by_name.skip = "Skipped under windows, to fix"


    def test_get_artists_by_name_by_album(self):

        lc = []

        def gotchildren(l):
            uri = MediaUri('elisa://localhost/artists/archive/albums/londinium')
            uris = []
            for ur,els in l:
                uris.append(ur)

            self.failUnless(uri in uris)

        uri = MediaUri('elisa://localhost/artists/archive/albums')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr
    
    if platform.system() == 'Windows':
        test_get_artists_by_name_by_album.skip = "Skipped under windows, to fix"

    def test_get_files(self):

        lc = []

        def gotchildren(l):
            expected_len = 1364
            self.failUnless(len(l) == expected_len)


        uri = MediaUri('elisa://localhost/files')
        dfr = self.component.get_direct_children(uri, lc)
        dfr.addCallback(gotchildren)
        return dfr
    
    if platform.system() == 'Windows':
        test_get_files.skip = "Skipped under windows, to fix"
