# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import media_uri
from elisa.plugins.media_db.db import MediaDB
from elisa.base_components import media_provider, metadata_provider
from elisa.core.tests.test_metadata_provider import FooMetadataProvider
import shutil, os

from twisted.internet import defer
 
class TestMediaManager(ElisaTestCase):
    def setUp(self):
        ElisaTestCase.setUp(self)
    
        self._tmp_dir = 'test_media_db'
        if os.path.exists(self._tmp_dir):
            shutil.rmtree(self._tmp_dir)
        os.mkdir(self._tmp_dir)

        open(os.path.join(self._tmp_dir, 'test.mp3'), 'w').close() 
        self.tmp_uri = media_uri.MediaUri(u'file://%s' % self._tmp_dir)
        self.media_db = MediaDB.get_connection()

    def test_add_hide_show_source(self): 
        self.media_db.add_source(self.tmp_uri)
        source = self.media_db.get_source_for_uri(self.tmp_uri)
        self.failUnless(source is not None)

        self.media_db.hide_source(self.tmp_uri)
        source = self.media_db.get_source_for_uri(self.tmp_uri)
        # we only hide the source
        self.failUnless(source is not None)

        self.media_db.show_source(self.tmp_uri)
        source = self.media_db.get_source_for_uri(self.tmp_uri)
        self.failUnless(source is not None)
        self.failUnless(source.available)
