# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

"""
A nice status osd for playback
"""

import pgm, gobject
from pgm.graph.text import Text
from pgm.graph.group import Group
from pgm.graph.image import Image

from elisa.plugins.pigment_osd.progressbar_osd import ProgressBarOsd

__maintainter__ = "Benjamin Kampmann <benjamin@fluendo.com>"


class StatusOsd(Group):
    """
    The status osd has a background, a title, a status_text and a progress
    bar.

    @ivar background:   the background of the status bar
    @type background:   L{pgm.graph.image.Image}
    @ivar title:        the title that gets displayed on top
    @type title:        L{pgm.graph.text.Text}
    @ivar progressbar:  the progressbar in the middle
    @type progressbar:  L{elisa.plguisn.pigment_osd.progressbar_osd.ProgressBarOsd}
    @ivar status_text:  the text in the right bottom corner
    @type status_text:  L{pgm.graph.text.Text}
    """

    def __init__(self):
        super(StatusOsd, self).__init__()

        # FIXME: temporary
        width = 1.0
        height = 1.0

        # build the background
        self.background = Image()
        self.background.size = (width, height)
        self.background.bg_color = (0, 0, 0, 0)
        self.background.layout = pgm.IMAGE_FILLED
        self.add(self.background)
        self.background.visible = True

        inner_width = width * 0.9
        inner_x = (width - inner_width)/2.0

        # build the title
        self.title = Text()
        self.title.label = ""
        self.title.ellipsize = pgm.TEXT_ELLIPSIZE_MIDDLE
        self.title.fg_color = (220, 220, 220, 255)
        self.title.bg_color = (0, 0, 0, 0)
        self.title.position = (inner_x, 0.05, 0.0)
        self.title.size = (inner_width, height*0.33)
        self.add(self.title)
        self.title.visible = True

        # build the time bar
        self.progressbar = ProgressBarOsd()
        self.progressbar.bg_color = (0, 0, 0, 0)
        self.progressbar.position = (inner_x, height*(0.33+0.10), 0.)
        self.progressbar.size = (inner_width, height*0.2)
        self.add(self.progressbar)
        self.progressbar.visible = True

        # build the total time text
        self.status_text = Text()
        self.status_text.label = ""
        self.status_text.fg_color = (255, 255, 255, 255)
        self.status_text.bg_color = (0, 0, 0, 0)
        self.status_text.alignment = pgm.TEXT_ALIGN_RIGHT
        self.status_text.position = (inner_x, height*(0.33+0.2+0.15), 0.)
        self.status_text.size = (inner_width, height*0.2)
        self.add(self.status_text)
        self.status_text.visible = True
