# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Benjamin Kampmann <benjamin@fluendo.com>'

from elisa.base_components.action import Action


class EnqueueAction(Action):

    def __init__(self):
        Action.__init__(self)
        self.parent_model = None
        self.playlist_model = None
        self.empty_playlist_before = False

    def __call__(self, sth):
        if self.empty_playlist_before:
            self.playlist_model[:] = []

        for model in self.parent_model.children:
            if hasattr(model, 'uri') and model.uri != None:
                if not model.has_children:
                    self.playlist_model.append(model)
