# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.


__maintainer__ = 'Florian Boucault <florian@fluendo.com>'


from elisa.core import manager

class ServiceManager(manager.Manager):
    """
    ServiceManager instanciates the ServiceProvider components and keeps track
    of them.
    """

    def start(self):
        """ Start all the registered ServiceProviders.
        """
        self.info("Starting")

        for i in self._components:
            i.start()

    def stop(self):
        """ Stop all the registered ServiceProviders.
        """
        self.info("Stopping")

        # FIXME: do not do that if ServiceManager was not started
        for i in self._components:
            i.stop()

        manager.Manager.stop(self)

    def unregister_component(self, component):
        """ Clean a ServiceProvider and unregister it from the ServiceManager.

        @param component: the ServiceProvider instance to unregister
        @type component:  L{elisa.base_components.service_provider.ServiceProvider}

        @raise CannotUnregister : raised when the component cannot be removed
        """
        if manager.Manager.unregister_component(self, component):
            component.clean()
