# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core.manager import Manager
from elisa.core.component import Component


class SimpleComponent(Component):
    running = False

    def clean(self):
        self.running = False

class TestManager(ElisaTestCase):
    def setUp(self):
        ElisaTestCase.setUp(self)
        self._manager = Manager()
        self._provider = SimpleComponent()
        self._manager.register_component(self._provider)
        return self._manager.initialize()

    def test_component_registered(self):
        reg = self._manager.component_registered(self._provider)
        self.assertEquals(reg, True)

    def test_component_start(self):
        self._provider.running = False
        self._manager.start()
        self.assertEquals(self._provider.running, False)

    def test_component_stop(self):
        self._provider.running = True
        self._manager.stop()
        self.assertEquals(self._provider.running, False)
