# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from elisa.core.tests.elisa_test_case import ElisaTestCase
from elisa.core import plugin
from elisa.core import media_manager, metadata_manager, media_uri
from elisa.base_components import media_provider, metadata_provider
from elisa.core.tests.test_metadata_provider import FooMetadataProvider
import tempfile, shutil, os, tempfile

from twisted.internet import defer

class FooMediaProvider(media_provider.MediaProvider):

    def supported_uri_schemes__get(self):
        return {'foo': 0}

class AnotherFooMediaProvider(media_provider.MediaProvider):

    def supported_uri_schemes__get(self):
        return {'foo': 2, 'bar': 0}

class FooPlugin(plugin.Plugin):
    name = 'foo'
    components = {'foo_media_provider': {'path': FooMediaProvider}}

class FooPlugin2(plugin.Plugin):
    name = 'foo2'
    components = {'another_foo_media_provider': {'path':AnotherFooMediaProvider},
                  'foo_metadata_provider': {'path': FooMetadataProvider}}
    
class TestMediaManager(ElisaTestCase):
    def setUp(self):
        ElisaTestCase.setUp(self)

        from elisa.core.common import application
##         application.plugin_registry.register_plugin(LFS)
        application.plugin_registry.register_plugin(FooPlugin)
        application.plugin_registry.register_plugin(FooPlugin2)

        c = application.plugin_registry.create_component

        self._metadata_manager = metadata_manager.MetadataManager()
        self._metadata_manager.register_component(c('foo2:foo_metadata_provider'))

        self._media_manager = media_manager.MediaManager(self._metadata_manager)

        self._media_manager.register_component(c('foo:foo_media_provider'))
        self._media_manager.register_component(c('foo2:another_foo_media_provider'))

        self._media_manager.start()     
        
        self._tmp_dir = tempfile.mkdtemp()
        open(os.path.join(self._tmp_dir, 'test.mp3'), 'w').close()
        
        self.tmp_uri = media_uri.MediaUri(u'file://%s' % self._tmp_dir)

    def tearDown(self):
        self._metadata_manager.stop()
        self._media_manager.stop()
        shutil.rmtree(self._tmp_dir)
        ElisaTestCase.tearDown(self)

    def test_media_provider_access(self):
        # FIXME: looks like this could be tested through the public API?
        self.assertEquals(len(self._media_manager._components), 2)
        for provider in self._media_manager._components:
            self.failUnless(isinstance(provider, media_provider.MediaProvider))

        foo_uri = media_uri.MediaUri(u'foo://bar')
        foo_provider = self._media_manager._get_media_provider(foo_uri)
        self.failUnless(isinstance(foo_provider, FooMediaProvider))

        bar_uri = media_uri.MediaUri(u'bar://boo')
        bar_provider = self._media_manager._get_media_provider(bar_uri)
        self.failUnless(isinstance(bar_provider, AnotherFooMediaProvider))


    def test_get_tags(self):
        foo_uri = media_uri.MediaUri(u'foo://bar')

        # TODO: test db caching

        dfr = self._media_manager.get_metadata({'uri':foo_uri, 'artist':None,
                                                'album': None})
        dfr.addCallback(lambda tags: self.assertEquals(tags, {'uri': foo_uri,
                                                              'artist':'foo',
                                                              'album': 'bar'}))
        return dfr
