# -*- coding: utf-8 -*-
# Elisa - Home multimedia server
# Copyright (C) 2006-2008 Fluendo Embedded S.L. (www.fluendo.com).
# All rights reserved.
#
# This file is available under one of two license agreements.
#
# This file is licensed under the GPL version 3.
# See "LICENSE.GPL" in the root of this distribution including a special
# exception to use Elisa with Fluendo's plugins.
#
# The GPL part of Elisa is also available under a commercial licensing
# agreement from Fluendo.
# See "LICENSE.Elisa" in the root directory of this distribution package
# for details on that license.

from twisted.trial import unittest

from elisa.core.tests.component_test_case import ComponentTestCase
from elisa.core.media_uri import MediaUri

from elisa.base_components.media_provider import MediaProvider, media_types

class TestMediaProvider(ComponentTestCase):

    component_class = MediaProvider

    def setUp(self):
        dfr = ComponentTestCase.setUp(self)
        self._uris = self.get_valid_uris()
        return dfr
    
    def get_valid_uris(self):
        """
        Return a list of validated URIs used by the generic tests.
        
        @rtype: list of MediaUris for testing
        """
        return []
    
    def test_scannable_uri_schemes(self):
        schemes = self.component.scannable_uri_schemes
        self.failUnless(isinstance(schemes, list))

        for scheme in schemes:
            self.failUnless(isinstance(scheme, str))

    def test_supported_uri_schemes(self):
        schemes = self.component.supported_uri_schemes
        self.failUnless(isinstance(schemes, dict))

        for key, value in schemes.items():
            self.failUnless(isinstance(key, str))
            self.failUnless(isinstance(value, int))

    def test_get_real_uri(self):
        for uri in self._uris:
            real = self.component.get_real_uri(uri)
            self.failUnless(isinstance(real, MediaUri))

    def test_get_media_type(self):
        def get_media_type_next(result, uri_index):
            if uri_index == len(self._uris):
                # finished
                return

            uri = self._uris[uri_index]
            dfr = self.component.get_media_type(uri)
            dfr.addCallback(get_media_type_done)
            dfr.addCallback(get_media_type_next, uri_index + 1)

            return dfr

        def get_media_type_done(media_type):
            self.assertEquals(set(media_type.keys()),
                              set(['file_type', 'mime_type']))
            self.failUnless(media_type['file_type'] in media_types or \
                            media_type['file_type'] == '')
            self.failUnless(isinstance(media_type['mime_type'], str))
            
            return media_type

        # start from the first and continue to the next at every callback, this
        # is easier to debug than doing a bunch of get_media_type() and
        # returning a DeferredList
        return get_media_type_next(None, 0)

#    def test_is_directory(self):
#        pass
#    test_is_directory.skip = "Not implemented yet"


#    def test_has_children_with_types(self):
#        pass
#    test_has_children_with_types.skip = "Not implemented yet"

#    def test_get_direct_children(self):
#        pass
#    test_get_direct_children.skip = "Not implemented yet"


#    def test_open(self):
#        pass
#    test_open.skip = "Not implemented yet"

    
#    def test_close(self):
#        pass
#    test_close.skip = "Not implemented yet"

#    def test_seek(self):
#        pass
#    test_seek.skip = "Not implemented yet"

#    def test_read(self):
#        pass
#    test_read.skip = "Not implemented yet"

#    def test_next_location(self):
#        pass
#    test_next_location.skip = "Not implemented yet"

#    def test_previous_location(self):
#        pass
#    test_previous_location.skip = "Not implemented yet"

    def test_monitor_uri(self):
        try:
            to_monitor = []

            for uri in self._uris:
                is_monitorable = self.component.uri_is_monitorable(uri)
                self.failUnless(isinstance(is_monitorable, bool))

                # monitor only 2 of them
                if is_monitorable and len(to_monitor) < 2:
                    to_monitor.append(uri)

                self.failUnless(not self.component.uri_is_monitored(uri))

            for uri in to_monitor:
                def do_nothing():
                    pass
                self.component.monitor_uri(uri, do_nothing)
                self.failUnless(self.component.uri_is_monitored(uri))
        except NotImplementedError:
            return

#    def test_copy(self):
#        pass
#    test_copy.skip = "Not implemented yet"
#
#    def test_move(self):
#        pass
#    test_move.skip = "Not implemented yet"
#
#    def test_delete(self):
#        pass
#    test_delete.skip = "Not implemented yet"
