#include <kdebug.h>
#include <qpopupmenu.h>
#include <klineedit.h>
#include <libept/filterlist.h>
#include <libept/quickfilter.h>
#include <libept/statefilter.h>
#include <libept/easytagfilter.h>
#include <tagcoll/InputMerger.h>
#include <apt-front/cache/component/tags.h>

using namespace ept;
using namespace Tagcoll;

// TODO: Beat enrico till this lands in some of our libs...
template< typename PKG, typename TAG >
class TagcollConsumerAdaptor :
    public utils::ConsumerImpl< PKG,TagcollConsumerAdaptor<PKG, TAG> >
{
protected:
	Consumer<PKG, TAG>& m_out;

public:
	TagcollConsumerAdaptor( Consumer<PKG, TAG>& out) : m_out( out ) {}
	virtual void consume( const PKG& a ) {
		if (a != PKG())
			m_out.consume(a, a.tags());
	}
};

PredicateInterface::PredicateInterface( QWidget *w, const char *n )
    : ItemExtender( w, n )
{
}

void PredicateInterface::widgetsChanged() {
    kdDebug() << "PredicateInterface::widgetsChanged()" << endl;
    emit predicateDrop( m_pred );
    m_pred = predicate();
    emit predicateAdd( m_pred );
    downcast< FilterItem >( item() ).setPredicate( m_pred );
}

FilterList::FilterList( QWidget *parent, const char *name )
    : ExtendableList( parent, name ),
      m_pred( predicate::True< entity::Entity >() ),
      m_hidden( predicate::True< entity::Entity >() )
{
    addColumn( " ", 20 );
    addColumn( "Active filters", 240 );
    // setSortColumn( -1 );
    /* setItemsMovable( true );
    setDragEnabled( true );
    setAcceptDrops( true ); */
    setResizeMode( LastColumn );
    setAllColumnsShowFocus (true);

    // fixme
    m_baseIcon = SmallIcon( "extender_closed" );
    m_extendedIcon = SmallIcon( "extender_opened" );

    resize( 240, 180 );
    connect( this, SIGNAL(
                 contextMenuRequested( QListViewItem *, const QPoint
                                       &, int ) ),
             this, SLOT( contextMenu( QListViewItem *, const
                                      QPoint &, int) ) );
}

void FilterList::plugLister( Lister *l ) {
    m_lister = l;
    connect( this, SIGNAL( predicateChanged( Lister::Predicate ) ),
             l, SLOT( baseSet( Lister::Predicate ) ) );
}

void FilterList::setPredicate( Predicate p ) {
    clear();
    m_pred = p;
    appendPredicate( p );
    emit predicateChanged( m_hidden and m_pred );
}

void FilterList::setHiddenPredicate( Predicate p ) {
    m_hidden = p;
    emit predicateChanged( m_hidden and m_pred );
}

void FilterList::editorPredicateDrop( Predicate p ) {
    m_pred = predicate::remove( m_pred, p );
    emit predicateChanged( m_hidden and m_pred );
}

void FilterList::editorPredicateAdd( Predicate p ) {
    kdDebug() << "FilterList::editorPredicateAdd" << endl;
    m_pred = m_pred and p;
    emit predicateChanged( m_hidden and m_pred );
}

void FilterList::appendPredicate( Predicate p ) {
    if (p.isType< And >()) {
        And a = p;
        for (utils::Range< Predicate > r = a.parts();
             r != r.last(); ++r )
            appendPredicate( *r );
    } else if (p.isType< predicate::True< entity::Entity > >() ) {
        // we generally ignore truth
    } else {
        m_pred = m_pred and p;
        kdDebug() << p.serialize() << endl;
        kdDebug() << p.prettyPrint() << endl;
        FilterItem *i;
        i = new FilterItem( this );
        i->setPredicate( p );
    }
}

void FilterList::contextMenu( QListViewItem *it, const QPoint &pt, int /*c*/ )
{
    std::cerr << "FilterList::contextMenu(p);" <<  std::endl;
    FilterItem *i = dynamic_cast< FilterItem * >( it );
    if (! i)
        return filterMenu( pt );
    QPopupMenu *m = new QPopupMenu( this );
    m->insertItem( "Remove Filter", 0 );
    m_context = i;
    connect(m, SIGNAL(activated(int)), this, SLOT(contextActivated(int)));
    m->exec(pt);
    delete m;
}

void FilterList::filterMenu( const QPoint &pt )
{
    Cache &cache = cache::Global::get(); // FIXME?
    typedef InputMerger< entity::Package, entity::Tag > Coll;
    typedef std::map< entity::Facet, vector< entity::Tag > > Map;
    QPopupMenu *m = new QPopupMenu( this );
    m->insertItem( "Add Quick Filter", 0 );
    m->insertItem( "Add State Filter", 1 );
    m->insertItem( "Add Easy Tag Filter", 2 );
    m->insertSeparator();
    Map c;
    OpSet< entity::Tag > t;

    if (m_lister->itemCount() < 0)
        return;
    if (m_lister->itemCount() > 1000) {
        t = cache.tags().tags();
    } else {
        Coll coll;
        utils::Range< entity::Package > r = utils::range( m_lister->content() );
        r.output( TagcollConsumerAdaptor< entity::Package, entity::Tag>( coll ));
        t = coll.getAllTags();
    }

    for (OpSet<entity::Tag>::const_iterator i = t.begin(); i != t.end(); ++i)
	{
        c[i->facet()].push_back(*i);
	}

    int id = 8;
    m_tagMenuMap.clear();
	for (Map::const_iterator i = c.begin(); i != c.end(); ++i) {
        QPopupMenu *sub = new QPopupMenu( m );
        m->insertItem( i->first.name(), sub );
		for (vector<entity::Tag>::const_iterator j = i->second.begin();
             j != i->second.end(); j++) {
            sub->insertItem( "[" + j->name() + "] " +
                             j->shortDescription(), id++ );
            m_tagMenuMap.push_back( *j );
        }
        connect(sub, SIGNAL(activated(int)),
                this, SLOT(filterMenuActivated(int)));
    }
    connect(m, SIGNAL(activated(int)), this, SLOT(filterMenuActivated(int)));
    m->exec(pt);
    delete m;
}

void FilterList::filterMenuActivated( int i )
{
    kdDebug() << "filter menu id: " << i << endl;
    predicate::Predicate< entity::Entity > p;
    switch (i) {
    case 0:
        p = predicate::adapt< entity::Entity >(
            QuickFilter< entity::Package >() );
        break;
    case 1:
        p = predicate::adapt< entity::Entity >(
            StateFilter< entity::Package >() );
        break;
    case 2:
        p = predicate::adapt< entity::Entity >(
            EasyTagFilter< entity::Package >() );
        break;
    }
    if (i >= 8) {
        kdDebug() << "tag: " << m_tagMenuMap[i - 2].fullname() << endl;
        TagFilter< entity::Package > f;
        f.setTag( m_tagMenuMap[i - 8] );
        p = predicate::adapt< entity::Entity >( f );
    }
    if (p.impl()) {
        kdDebug() << "summary: " <<
           downcast< InterfacingPredicate >( p ).summary() << endl;
        appendPredicate( p );
        emit predicateChanged( m_pred );
    }
}

void FilterList::contextActivated( int i )
{
    if (i == 0) {
        m_pred = remove( m_pred, m_context->predicate() );
        delete m_context;
    }
    emit predicateChanged( m_pred );
}

ItemExtender *FilterItem::createExtender()
{
    PredicateInterface *o = 0;
    if (m_pred.isType< QuickFilter< entity::Package > >()) {
        o = new QuickFilterWidget( list(), 0 );
    } else if (m_pred.isType< StateFilter< entity::Package > >()) {
        o = new StateFilterWidget( list(), 0 );
    } else if (m_pred.isType< EasyTagFilter< entity::Package > >()) {
        o = new EasyTagFilterWidget( list(), 0 );
    }
    if (o) {
        o->setPredicate( m_pred );
        QObject::connect( o, SIGNAL( predicateAdd( Predicate ) ),
                          list(), SLOT( editorPredicateAdd( Predicate ) ) );
        QObject::connect( o, SIGNAL( predicateDrop( Predicate ) ),
                          list(), SLOT( editorPredicateDrop( Predicate ) ) );
    }
    return o;
}

QString FilterItem::text( int c ) const {
    InterfacingPredicate &ip = downcast< InterfacingPredicate >( m_pred.impl() );
    if (c == 1)
        return ip.summary();
    return "";
}
