/* -*- C++ -*- */
#ifndef TESTUI_APP_H
#define TESTUI_APP_H

#include <kmainwindow.h>
#include <kparts/part.h>
#include <kactionclasses.h>
#include <apt-front/cache/observer.h>
#include <apt-front/cache/component/state.h>
#include <apt-front/cache/component/history.h>
#include <apt-front/cache/component/desktop.h>
#include <libept/view.h>
#include <libept/commitprogress.h>
#include <libept/installerview.h>
#include <libept/application.h>

class QVBox;
class QWidgetStack;
class QSplitter;
class KAction;
class KPushButton;
namespace ept {
class AcqProgressWidget;
}

using namespace aptFront;
using namespace ept;

struct GroupPolicy : cache::component::Desktop::GroupPolicy {
    virtual std::string groupForCategories( utils::Range< std::string > );
};

struct IconPolicy : GroupedDesktopSelector::IconPolicy {
    virtual QString iconForGroup( QString );
};

class App : public KMainWindow, Application {
    Q_OBJECT
public:
    enum State { Select, Preview, Inspect, Commit };
    void setupActions();
    ExtTerminalInterface *terminal();
	App();

    // check if the changes in cache are consistent with what is
    // checked in the tree and we don't have any suspicious removals
    // or other artifacts (broken packages)
    bool consistent();

protected slots:
    void start();
    void commit();
    void inspect();

    void delayed();

    void undo() { Application::undo(); }
    void redo() { Application::redo(); }
    void checkpoint() { Application::checkpoint(); }

    void setHistoryEnabled( bool );

    void disableNext();
    void disableButtons();
    void setNext( QString str, const char *slot );
    void togglePreview();

    void request( cache::entity::Package, cache::component::State::Action );

    bool confirmRequest( entity::Package, component::State::Action );
    void requestOk() { m_currentRequestOk = true; }

protected:
    friend class WaitForLister;

    void setState( State s ) { m_lastState = m_state; m_state = s; }

    virtual void notifyPreRebuild( cache::component::Base * );
    virtual void notifyPostChange( cache::component::Base * );
    virtual void notifyPreChange( cache::component::Base * );

    QWidgetStack *m_stack;
    QVBox *m_all;
    QHBox *m_buttons;
    QLabel *m_bye;
    KPushButton *m_next, *m_quit;

    // stacked widgets
    ept::AcqProgressWidget *m_progress;
    ept::CommitProgress *m_commitProgress;
    // ept::GroupedDesktopSelector *m_desktopSelector;
    ept::InstallerView *m_view;
    ept::View *m_preview;

    // other stuff
    std::vector<KAction *> m_actions;
    QMap< QString, QString > m_icons;
    KAction *m_undo, *m_redo;
    KToggleAction *m_previewAction;
    State m_state, m_lastState;

    typedef std::list< component::State::Request > RequestList;
    RequestList m_requests;

    // XXX hack
    bool m_currentRequestOk;
};

class WaitForLister : public QObject {
    Q_OBJECT
public:
    WaitForLister( App *a, const char *s )
        : app( a ), slot( s )
        {
            waiting();
        }
protected slots:
    void waiting();
protected:
    App *app;
    const char *slot;
    
};

#endif
