# EVMS_SELECT_PLUGINS
#
# By default, all EVMS plugins are built. Each one can be individually
# disabled by the user with a "--disable-plugin" argument to ./configure
# This macro determines which plugins to enable, and checks any additional
# dependencies that each plugin might have. The final result of this macro
# is a $plugin_dirs variable that is used by the plugins/Makefile.am to
# decide which plugin directories to process.

AC_DEFUN([EVMS_SELECT_PLUGINS],[
AC_MSG_NOTICE([checking which EVMS plugins to build:])

# Check if the user wants to disable any plugins
AC_ARG_ENABLE([disk],
	      AC_HELP_STRING([--disable-disk],
			     [Disable the local disk manager]),
	      [build_disk="$enableval"],
	      [build_disk="yes"])
AC_ARG_ENABLE([dos],
	      AC_HELP_STRING([--disable-dos],
			     [Disable the DOS segment manager]),
	      [build_dos="$enableval"],
	      [build_dos="yes"])
AC_ARG_ENABLE([gpt],
	      AC_HELP_STRING([--disable-gpt],
			     [Disable the GPT segment manager]),
	      [build_gpt="$enableval"],
	      [build_gpt="yes"])
AC_ARG_ENABLE([s390],
	      AC_HELP_STRING([--disable-s390],
			     [Disable the S/390 segment manager]),
	      [build_s390="$enableval"],
	      [build_s390="yes"])
AC_ARG_ENABLE([bbr-seg],
	      AC_HELP_STRING([--disable-bbr-seg],
			     [Disable the BBR segment manager]),
	      [build_bbr_seg="$enableval"],
	      [build_bbr_seg="yes"])
AC_ARG_ENABLE([bsd],
	      AC_HELP_STRING([--disable-bsd],
			     [Disable the BSD segment manager]),
	      [build_bsd="$enableval"],
	      [build_bsd="yes"])
AC_ARG_ENABLE([mac],
	      AC_HELP_STRING([--disable-mac],
			     [Disable the Macintosh segment manager]),
	      [build_mac="$enableval"],
	      [build_mac="yes"])
AC_ARG_ENABLE([csm],
	      AC_HELP_STRING([--disable-csm],
			     [Disable the Cluster segment manager]),
	      [build_csm="$enableval"],
	      [build_csm="yes"])
AC_ARG_ENABLE([multipath],
	      AC_HELP_STRING([--disable-multipath],
			     [Disable the Multipath segment manager]),
	      [build_multipath="$enableval"],
	      [build_multipath="yes"])
AC_ARG_ENABLE([lvm],
	      AC_HELP_STRING([--disable-lvm],
			     [Disable the LVM plugin]),
	      [build_lvm="$enableval"],
	      [build_lvm="yes"])
AC_ARG_ENABLE([md],
	      AC_HELP_STRING([--disable-md],
			     [Disable the MD/Software-RAID plugin]),
	      [build_md="$enableval"],
	      [build_md="yes"])
AC_ARG_ENABLE([drivelink],
	      AC_HELP_STRING([--disable-drivelink],
			     [Disable the DriveLinking plugin]),
	      [build_drivelink="$enableval"],
	      [build_drivelink="yes"])
AC_ARG_ENABLE([bbr],
	      AC_HELP_STRING([--disable-bbr],
			     [Disable the BBR feature plugin]),
	      [build_bbr="$enableval"],
	      [build_bbr="yes"])
AC_ARG_ENABLE([snapshot],
	      AC_HELP_STRING([--disable-snapshot],
			     [Disable the Snapshot plugin]),
	      [build_snapshot="$enableval"],
	      [build_snapshot="yes"])
AC_ARG_ENABLE([ext2],
	      AC_HELP_STRING([--disable-ext2],
			     [Disable the Ext2/3 FSIM]),
	      [build_ext2="$enableval"],
	      [build_ext2="yes"])
AC_ARG_ENABLE([jfs],
	      AC_HELP_STRING([--disable-jfs],
			     [Disable the JFS FSIM]),
	      [build_jfs="$enableval"],
	      [build_jfs="yes"])
AC_ARG_ENABLE([ogfs],
	      AC_HELP_STRING([--disable-ogfs],
			     [Disable the OpenGFS FSIM]),
	      [build_ogfs="$enableval"],
	      [build_ogfs="yes"])
AC_ARG_ENABLE([reiser],
	      AC_HELP_STRING([--disable-reiser],
			     [Disable the ReiserFS FSIM]),
	      [build_reiser="$enableval"],
	      [build_reiser="yes"])
AC_ARG_ENABLE([xfs],
	      AC_HELP_STRING([--disable-xfs],
			     [Disable the XFS FSIM]),
	      [build_xfs="$enableval"],
	      [build_xfs="yes"])
AC_ARG_ENABLE([swap],
	      AC_HELP_STRING([--disable-swap],
			     [Disable the Swap FSIM]),
	      [build_swap="$enableval"],
	      [build_swap="yes"])
AC_ARG_ENABLE([replace],
	      AC_HELP_STRING([--disable-replace],
			     [Disable the Replace plugin]),
	      [build_replace="$enableval"],
	      [build_replace="yes"])
AC_ARG_ENABLE([ha],
	      AC_HELP_STRING([--disable-ha],
			     [Disable the HA plugin]),
	      [build_ha="$enableval"],
	      [build_ha="yes"])
AC_ARG_ENABLE([rsct],
	      AC_HELP_STRING([--disable-rsct],
			     [Disable the RSCT plugin]),
	      [build_rsct="$enableval"],
	      [build_rsct="yes"])

# Create the list of plugin directories to build. This is where each plugin
# can specify its dependencies.
plugin_dirs=""
plugin_distdirs="bbr bbr_seg bsd csm disk dos drivelink ext2 gpt ha jfs lvm mac md multipath ogfs reiser replace rsct s390 snapshot swap xfs"

# BBR
if test "$build_bbr" = "no"; then
	AC_MSG_NOTICE([     not building bbr ... disabled by user])
else
	plugin_dirs="$plugin_dirs bbr"
	AC_MSG_NOTICE([     building bbr])
fi

# BSD
if test "$build_bsd" = "no"; then
	AC_MSG_NOTICE([     not building bsd ... disabled by user])
else
	plugin_dirs="$plugin_dirs bsd"
	AC_MSG_NOTICE([     building bsd])
fi

# BBR Seg.
if test "$build_bbr_seg" = "no"; then
	AC_MSG_NOTICE([     not building bbr_seg ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building bbr_seg ... requires uuid library])
else
	plugin_dirs="$plugin_dirs bbr_seg"
	AC_MSG_NOTICE([     building bbr_seg])
fi

# CSM
if test "$build_csm" = "no"; then
	AC_MSG_NOTICE([     not building csm ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building csm ... requires uuid library])
else
	plugin_dirs="$plugin_dirs csm"
	AC_MSG_NOTICE([     building csm])
fi

# Disk
if test "$build_disk" = "no"; then
	AC_MSG_NOTICE([     not building disk ... disabled by user])
else
	plugin_dirs="$plugin_dirs disk"
	AC_MSG_NOTICE([     building disk])
fi

# DOS
if test "$build_dos" = "no"; then
	AC_MSG_NOTICE([     not building dos ... disabled by user])
else
	plugin_dirs="$plugin_dirs dos"
	AC_MSG_NOTICE([     building dos])
fi

# DriveLink
if test "$build_drivelink" = "no"; then
	AC_MSG_NOTICE([     not building drivelink ... disabled by user])
else
	plugin_dirs="$plugin_dirs drivelink"
	AC_MSG_NOTICE([     building drivelink])
fi

# Ext2
if test "$build_ext2" = "no"; then
	AC_MSG_NOTICE([     not building ext2 ... disabled by user])
else
	plugin_dirs="$plugin_dirs ext2"
	AC_MSG_NOTICE([     building ext2])
fi

# GPT
if test "$build_gpt" = "no"; then
	AC_MSG_NOTICE([     not building gpt ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building gpt ... requires uuid library])
else
	plugin_dirs="$plugin_dirs gpt"
	AC_MSG_NOTICE([     building gpt])
fi

# HA
if test "$build_ha" = "no"; then
	AC_MSG_NOTICE([     not building ha ... disabled by user])
elif test "$have_ha" = "no"; then
	AC_MSG_NOTICE([     not building ha ... requires linux-ha package])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building ha ... requires glib library])
else
	plugin_dirs="$plugin_dirs ha"
	AC_MSG_NOTICE([     building ha])
fi

# JFS
if test "$build_jfs" = "no"; then
	AC_MSG_NOTICE([     not building jfs ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building jfs ... requires uuid library])
else
	plugin_dirs="$plugin_dirs jfs"
	AC_MSG_NOTICE([     building jfs])
fi

# LVM
if test "$build_lvm" = "no"; then
	AC_MSG_NOTICE([     not building lvm ... disabled by user])
elif test "$have_utsname_h" = "no"; then
	AC_MSG_NOTICE([     not building lvm ... requires sys/utsname.h])
else
	plugin_dirs="$plugin_dirs lvm"
	AC_MSG_NOTICE([     building lvm])
fi

# Macintosh
if test "$build_mac" = "no"; then
	AC_MSG_NOTICE([     not building mac ... disabled by user])
else
	plugin_dirs="$plugin_dirs mac"
	AC_MSG_NOTICE([     building mac])
fi

# MD
if test "$build_md" = "no"; then
	AC_MSG_NOTICE([     not building md ... disabled by user])
else
	plugin_dirs="$plugin_dirs md"
	AC_MSG_NOTICE([     building md])
fi

# Multipath
if test "$build_multipath" = "no"; then
	AC_MSG_NOTICE([     not building multipath ... disabled by user])
else
	plugin_dirs="$plugin_dirs multipath"
	AC_MSG_NOTICE([     building multipath])
fi

# OGFS
if test "$build_ogfs" = "no"; then
	AC_MSG_NOTICE([     not building ogfs ... disabled by user])
else
	plugin_dirs="$plugin_dirs ogfs"
	AC_MSG_NOTICE([     building ogfs])
fi

# Reiser
if test "$build_reiser" = "no"; then
	AC_MSG_NOTICE([     not building reiser ... disabled by user])
else
	plugin_dirs="$plugin_dirs reiser"
	AC_MSG_NOTICE([     building reiser])
fi

# Replace
if test "$build_replace" = "no"; then
	AC_MSG_NOTICE([     not building replace ... disabled by user])
else
	plugin_dirs="$plugin_dirs replace"
	AC_MSG_NOTICE([     building replace])
fi

# RSCT
if test "$build_rsct" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... disabled by user])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires glib library])
elif test "$have_ha_gs_r" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires ha_gs_r library])
elif test "$have_ha_gs_h" = "no"; then
	AC_MSG_NOTICE([     not building rsct ... requires ha_gs.h])
else
	plugin_dirs="$plugin_dirs rsct"
	AC_MSG_NOTICE([     building rsct])
fi

# S/390
if test "$build_s390" = "no"; then
	AC_MSG_NOTICE([     not building s390 ... disabled by user])
elif test "$have_vtoc_h" = "no"; then
	AC_MSG_NOTICE([     not building s390 ... requires asm/vtoc.h])
else
	plugin_dirs="$plugin_dirs s390"
	AC_MSG_NOTICE([     building s390])
fi

# Snapshot
if test "$build_snapshot" = "no"; then
	AC_MSG_NOTICE([     not building snapshot ... disabled by user])
else
	plugin_dirs="$plugin_dirs snapshot"
	AC_MSG_NOTICE([     building snapshot])
fi

# Swap
if test "$build_swap" = "no"; then
	AC_MSG_NOTICE([     not building swap ... disabled by user])
else
	plugin_dirs="$plugin_dirs swap"
	AC_MSG_NOTICE([     building swap])
fi

# XFS
if test "$build_xfs" = "no"; then
	AC_MSG_NOTICE([     not building xfs ... disabled by user])
elif test "$have_uuid" = "no"; then
	AC_MSG_NOTICE([     not building xfs ... requires uuid library])
else
	plugin_dirs="$plugin_dirs xfs"
	AC_MSG_NOTICE([     building xfs])
fi

AC_SUBST(plugin_dirs)
AC_SUBST(plugin_distdirs)
])


# EVMS_SELECT_INTERFACES
#
# By default, all EVMS user interfaces are built. Each one can be individually
# disabled by the user with a "--disable-interface" argument to ./configure
# This macro determines which interfaces to enable, and checks any additional
# dependencies that each interface might have. The final result of this macro
# is a $ui_dirs variable that is used by the ui/Makefile.am to
# decide which ui directories to process.

AC_DEFUN([EVMS_SELECT_INTERFACES],[
AC_MSG_NOTICE([checking which EVMS user interfaces to build:])

# Check if the user wants to disable any interfaces
AC_ARG_ENABLE([cli],
	      AC_HELP_STRING([--disable-cli],
			     [Disable the Command Line User Interface]),
	      [build_cli="$enableval"],
	      [build_cli="yes"])
AC_ARG_ENABLE([gui],
	      AC_HELP_STRING([--disable-gui],
			     [Disable the Graphical User Interface]),
	      [build_gui="$enableval"],
	      [build_gui="yes"])
AC_ARG_ENABLE([text-mode],
	      AC_HELP_STRING([--disable-text-mode],
			     [Disable the Text-Mode User Interface]),
	      [build_ncurses="$enableval"],
	      [build_ncurses="yes"])
AC_ARG_ENABLE([utilsl],
	      AC_HELP_STRING([--disable-utils],
			     [Disable the command-line utilities]),
	      [build_utils="$enableval"],
	      [build_utils="yes"])

# Create the list of interface directories to build. This is where each
# interface can specify its dependencies.
ui_dirs=""
ui_distdirs="cli gtk ncurses utils"

# CLI
if test "$build_cli" = "no"; then
	AC_MSG_NOTICE([     not building cli ... disabled by user])
else
	ui_dirs="$ui_dirs cli"
	AC_MSG_NOTICE([     building cli])
fi

# GUI
if test "$build_gui" = "no"; then
	AC_MSG_NOTICE([     not building gui ... disabled by user])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building gui ... requires glib library])
elif test "$have_gtk" = "no"; then
	AC_MSG_NOTICE([     not building gui ... requires gtk library])
else
	ui_dirs="$ui_dirs gtk"
	AC_MSG_NOTICE([     building gui])
fi

# Ncurses
if test "$build_ncurses" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... disabled by user])
elif test "$have_ncurses" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires ncurses library])
elif test "$have_panel" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires panel library])
elif test "$have_glib" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires glib library])
elif test "$have_math" = "no"; then
	AC_MSG_NOTICE([     not building text-mode ... requires math library])
else
	ui_dirs="$ui_dirs ncurses"
	AC_MSG_NOTICE([     building text-mode])
fi

# Utilities
if test "$build_utils" = "no"; then
	AC_MSG_NOTICE([     not building utils ... disabled by user])
else
	ui_dirs="$ui_dirs utils"
	AC_MSG_NOTICE([     building utils])

	# Make sure we can build evms_mpathd.
	if test "$have_devmapper" == "yes" -a "$have_devmapper_h" == "yes"; then
		utils_evms_mpathd="evms_mpathd"
	else
		AC_MSG_NOTICE([     not building evms_mpathd ... requires libdevmapper])
	fi
fi

AC_SUBST(ui_dirs)
AC_SUBST(ui_distdirs)
AC_SUBST(utils_evms_mpathd)
])


# AC_PATH_GLIB
#
# AC_PATH_GLIB([min-version, [action-if-found], [action-if-not-found],[modules])
# Test for GLIB, and define GLIB_CPPFLAGS and GLIB_LIBS. If "gmodule" or
# "gthread" is specified in MODULES, pass to glib-config. This gets the cflags
# and libraries from the glib-config script.

AC_DEFUN([AC_PATH_GLIB], [
AC_ARG_WITH([glib-prefix],
	    AC_HELP_STRING([--with-glib-prefix=PFX],
			   [Prefix where GLIB is installed (optional)]),
	    [glib_config_prefix="$withval"],
	    [glib_config_prefix=""])
AC_ARG_WITH([glib-exec-prefix],
	    AC_HELP_STRING([--with-glib-exec-prefix=PFX],
			   [Exec prefix where GLIB is installed (optional)]),
	    [glib_config_exec_prefix="$withval"],
	    [glib_config_exec_prefix=""])
AC_ARG_ENABLE([glibtest],
	      AC_HELP_STRING([--disable-glibtest],
			     [Do not try to compile and run a test GLIB program]),
	      [ ],
	      [enable_glibtest="yes"])

for module in . $4; do
	case "$module" in
		gmodule)
			glib_config_args="$glib_config_args gmodule"
			;;
		gthread)
			glib_config_args="$glib_config_args gthread"
			;;
	esac
done

if test x$glib_config_exec_prefix != x; then
	glib_config_args="$glib_config_args --exec-prefix=$glib_config_exec_prefix"
	if test x${GLIB_CONFIG+set} != xset; then
		GLIB_CONFIG=$glib_config_exec_prefix/bin/glib-config
	fi
fi

if test x$glib_config_prefix != x; then
	glib_config_args="$glib_config_args --prefix=$glib_config_prefix"
	if x${GLIB_CONFIG+set} != xset; then
		GLIB_CONFIG=$glib_config_prefix/bin/glib-config
	fi
fi

AC_PATH_PROG([GLIB_CONFIG], [glib-config], [no])
min_glib_version=ifelse([$1], , [0.99.7], [$1])
AC_MSG_CHECKING([for GLIB - version >= $min_glib_version])
no_glib=""
if test "$GLIB_CONFIG" = "no"; then
	no_glib="yes"
else
	GLIB_CPPFLAGS=`$GLIB_CONFIG $glib_config_args --cflags`
    	GLIB_LIBS=`$GLIB_CONFIG $glib_config_args --libs`
	glib_config_major_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	glib_config_minor_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	glib_config_micro_version=`$GLIB_CONFIG $glib_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
	if test "x$enable_glibtest" = "xyes" ; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $GLIB_CPPFLAGS"
		LIBS="$GLIB_LIBS $LIBS"

		# Now check if the installed GLIB is sufficiently new. (Also
		# sanity checks the results of glib-config to some extent)

		rm -f conf.glibtest
		AC_TRY_RUN([

#include <glib.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system ("touch conf.glibtest");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = g_strdup("$min_glib_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", "$min_glib_version");
		exit(1);
	}

	if ((glib_major_version != $glib_config_major_version) ||
	    (glib_minor_version != $glib_config_minor_version) ||
	    (glib_micro_version != $glib_config_micro_version)) {
		printf("\n*** 'glib-config --version' returned %d.%d.%d, "
		       "but GLIB (%d.%d.%d)\n", $glib_config_major_version,
		       $glib_config_minor_version, $glib_config_micro_version,
		       glib_major_version, glib_minor_version,
		       glib_micro_version);
		printf("*** was found! If glib-config was correct, then it "
		       "is best\n");
		printf("*** to remove the old version of GLIB. You may also "
		       "be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH enviroment "
		       "variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig "
		       "if that is\n");
		printf("*** required on your system.\n");
		printf("*** If glib-config was wrong, set the environment "
		       "variable GLIB_CONFIG\n");
		printf("*** to point to the correct copy of glib-config, and "
		       "remove the file config.cache\n");
		printf("*** before re-running configure\n");
	} else if ((glib_major_version != GLIB_MAJOR_VERSION) ||
		   (glib_minor_version != GLIB_MINOR_VERSION) ||
		   (glib_micro_version != GLIB_MICRO_VERSION)) {
		printf("*** GLIB header files (version %d.%d.%d) do not "
		       "match\n", GLIB_MAJOR_VERSION, GLIB_MINOR_VERSION,
		       GLIB_MICRO_VERSION);
		printf("*** library (version %d.%d.%d)\n", glib_major_version,
		       glib_minor_version, glib_micro_version);
	} else {
		if ((glib_major_version > major) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version > minor)) ||
		    ((glib_major_version == major) &&
		     (glib_minor_version == minor) &&
		     (glib_micro_version >= micro))) {
			return 0;
		} else {
			printf("\n*** An old version of GLIB (%d.%d.%d) was "
			       "found.\n", glib_major_version,
			       glib_minor_version, glib_micro_version);
			printf("*** You need a version of GLIB newer than "
			       "%d.%d.%d. The latest version of\n",
			       major, minor, micro);
			printf("*** GLIB is always available from "
			       "ftp://ftp.gtk.org.\n");
			printf("***\n");
			printf("*** If you have already installed a "
			       "sufficiently new version, this error\n");
			printf("*** probably means that the wrong copy of the "
			       "glib-config shell script is\n");
			printf("*** being found. The easiest way to fix this "
			       "is to remove the old version\n");
			printf("*** of GLIB, but you can also set the "
			       "GLIB_CONFIG environment to point to the\n");
			printf("*** correct copy of glib-config. (In this "
			       "case, you will have to\n");
			printf("*** modify your LD_LIBRARY_PATH enviroment "
			       "variable, or edit /etc/ld.so.conf\n");
			printf("*** so that the correct libraries are found "
			       "at run-time)\n");
		}
	}
  	return 1;
}

		],,
		[no_glib="yes"],
		[echo $ac_n "cross compiling; assumed OK... $ac_c"])
		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi
fi

if test "x$no_glib" = x; then
	AC_MSG_RESULT([yes])
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	if test "$GLIB_CONFIG" = "no" ; then
		echo "*** The glib-config script installed by GLIB could not be"
		echo "*** found. If GLIB was installed in PREFIX, make sure"
		echo "*** PREFIX/bin is in your path, or set the GLIB_CONFIG"
		echo "*** environment variable to the full path to glib-config."
	else
		if test -f conf.glibtest; then
			:
		else
			echo "*** Could not run GLIB test program, checking why..."
			CFLAGS="$CFLAGS $GLIB_CPPFLAGS"
			LIBS="$LIBS $GLIB_LIBS"
			AC_TRY_LINK([ #include <glib.h>
				      #include <stdio.h> ],
				    [ return ((glib_major_version) ||
					      (glib_minor_version) ||
					      (glib_micro_version)); ],
	[ echo "*** The test program compiled, but did not run. This usually"
	  echo "*** means that the run-time linker is not finding GLIB or"
	  echo "*** is finding the wrong version of GLIB. If it is not finding"
	  echo "*** GLIB, you'll need to set your LD_LIBRARY_PATH environment"
	  echo "*** variable, or edit /etc/ld.so.conf to point to the installed"
	  echo "*** location  Also, make sure you have run ldconfig if that is"
	  echo "*** required on your system"
	  echo "***"
	  echo "*** If you have an old version installed, it is best to remove"
	  echo "*** it, although you may also be able to get things to work by"
	  echo "*** modifying LD_LIBRARY_PATH"
	  echo "***"
	  echo "*** If you have a RedHat 5.0 system, you should remove the GTK"
	  echo "*** package that came with the system with the command"
	  echo "***"
	  echo "***    rpm --erase --nodeps gtk gtk-devel" ],
	[ echo "*** The test program failed to compile or link. See the file"
	  echo "*** config.log for the exact error that occured. This usually"
	  echo "*** means GLIB was incorrectly installed or that you have"
	  echo "*** moved GLIB since it was installed. In the latter case, you"
	  echo "*** may want to edit the glib-config script: $GLIB_CONFIG" ])
          CFLAGS="$ac_save_CFLAGS"
          LIBS="$ac_save_LIBS"

		fi
	fi
	GLIB_CPPFLAGS=""
	GLIB_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(GLIB_CPPFLAGS)
AC_SUBST(GLIB_LIBS)
rm -f conf.glibtest
])


# AC_PATH_GTK
#
# AC_PATH_GTK([min-version, [action-if-found], [action-if-not-found],[modules])
# Test for GTK, and define GTK_CPPFLAGS and GTK_LIBS. This gets the cflags
# and libraries from the glib-config script.
AC_DEFUN([AC_PATH_GTK], [
AC_ARG_WITH([gtk-prefix],
	    AC_HELP_STRING([--with-gtk-prefix=PFX],
			   [Prefix where GTK is installed (optional)]),
	    [gtk_config_prefix="$withval"],
	    [gtk_config_prefix=""])
AC_ARG_WITH([gtk-exec-prefix],
	    AC_HELP_STRING([--with-gtk-exec-prefix=PFX],
			   [Exec prefix where GTK is installed (optional)]),
	    [gtk_config_exec_prefix="$withval"],
	    [gtk_config_exec_prefix=""])
AC_ARG_ENABLE([gtktest],
	      AC_HELP_STRING([--disable-gtktest],
			     [Do not try to compile and run a test GTK program]),
	      [ ],
	      [enable_gtktest="yes"])

for module in . $4; do
	case "$module" in
		gthread)
			gtk_config_args="$gtk_config_args gthread"
			;;
	esac
done

if test x$gtk_config_exec_prefix != x; then
	gtk_config_args="$gtk_config_args --exec-prefix=$gtk_config_exec_prefix"
	if test x${GTK_CONFIG+set} != xset; then
		GTK_CONFIG=$gtk_config_exec_prefix/bin/gtk-config
	fi
fi

if test x$gtk_config_prefix != x; then
	gtk_config_args="$gtk_config_args --prefix=$gtk_config_prefix"
	if test x${GTK_CONFIG+set} != xset; then
		GTK_CONFIG=$gtk_config_prefix/bin/gtk-config
	fi
fi

AC_PATH_PROG([GTK_CONFIG], [gtk-config], [no])
min_gtk_version=ifelse([$1], , [0.99.7], [$1])
AC_MSG_CHECKING(for GTK - version >= $min_gtk_version)
no_gtk=""
if test "$GTK_CONFIG" = "no"; then
	no_gtk="yes"
else
	GTK_CPPFLAGS=`$GTK_CONFIG $gtk_config_args --cflags`
	GTK_LIBS=`$GTK_CONFIG $gtk_config_args --libs`
	gtk_config_major_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\1/'`
	gtk_config_minor_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\2/'`
	gtk_config_micro_version=`$GTK_CONFIG $gtk_config_args --version | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)/\3/'`
	if test "x$enable_gtktest" = "xyes"; then
		ac_save_CFLAGS="$CFLAGS"
		ac_save_LIBS="$LIBS"
		CFLAGS="$CFLAGS $GTK_CPPFLAGS"
		LIBS="$GTK_LIBS $LIBS"

		# Now check if the installed GTK is sufficiently new. (Also
		# sanity checks the results of gtk-config to some extent).

		rm -f conf.gtktest
		AC_TRY_RUN([

#include <gtk/gtk.h>
#include <stdio.h>
#include <stdlib.h>

int main()
{
	int major, minor, micro;
	char *tmp_version;

	system("touch conf.gtktest");

	/* HP/UX 9 (%@#!) writes to sscanf strings */
	tmp_version = g_strdup("$min_gtk_version");
	if (sscanf(tmp_version, "%d.%d.%d", &major, &minor, &micro) != 3) {
		printf("%s, bad version string\n", "$min_gtk_version");
		exit(1);
	}

	if ((gtk_major_version != $gtk_config_major_version) ||
	    (gtk_minor_version != $gtk_config_minor_version) ||
	    (gtk_micro_version != $gtk_config_micro_version)) {
		printf("\n*** 'gtk-config --version' returned %d.%d.%d, but "
		       "GTK+ (%d.%d.%d)\n", $gtk_config_major_version,
		       $gtk_config_minor_version, $gtk_config_micro_version,
		       gtk_major_version, gtk_minor_version, gtk_micro_version);
		printf("*** was found! If gtk-config was correct, then it is "
		       "best\n");
		printf("*** to remove the old version of GTK+. You may also "
		       "be able to fix the error\n");
		printf("*** by modifying your LD_LIBRARY_PATH enviroment "
		       "variable, or by editing\n");
		printf("*** /etc/ld.so.conf. Make sure you have run ldconfig "
		       "if that is\n");
		printf("*** required on your system.\n");
		printf("*** If gtk-config was wrong, set the environment "
		       "variable GTK_CONFIG\n");
		printf("*** to point to the correct copy of gtk-config, and "
		       "remove the file config.cache\n");
		printf("*** before re-running configure\n");
	}

#if defined (GTK_MAJOR_VERSION) && defined (GTK_MINOR_VERSION) && defined (GTK_MICRO_VERSION)
	else if ((gtk_major_version != GTK_MAJOR_VERSION) ||
		 (gtk_minor_version != GTK_MINOR_VERSION) ||
		 (gtk_micro_version != GTK_MICRO_VERSION)) {
		printf("*** GTK+ header files (version %d.%d.%d) do not "
		       "match\n", GTK_MAJOR_VERSION, GTK_MINOR_VERSION,
		       GTK_MICRO_VERSION);
		printf("*** library (version %d.%d.%d)\n", gtk_major_version,
		       gtk_minor_version, gtk_micro_version);
	}
#endif

	else {
		if ((gtk_major_version > major) ||
		    ((gtk_major_version == major) &&
		     (gtk_minor_version > minor)) ||
		    ((gtk_major_version == major) &&
		     (gtk_minor_version == minor) &&
		     (gtk_micro_version >= micro))) {
			return 0;
		} else {
			printf("\n*** An old version of GTK+ (%d.%d.%d) was "
			       "found.\n", gtk_major_version,
			       gtk_minor_version, gtk_micro_version);
			printf("*** You need a version of GTK+ newer than "
			       "%d.%d.%d. The latest version of\n",
			       major, minor, micro);
			printf("*** GTK+ is always available from "
			       "ftp://ftp.gtk.org.\n");
			printf("***\n");
			printf("*** If you have already installed a "
			       "sufficiently new version, this error\n");
			printf("*** probably means that the wrong copy of the "
			       "gtk-config shell script is\n");
			printf("*** being found. The easiest way to fix this "
			       "is to remove the old version\n");
			printf("*** of GTK+, but you can also set the "
			       "GTK_CONFIG environment topoint to the\n");
			printf("*** correct copy of gtk-config. (In this "
			       "case, you will have to\n");
			printf("*** modify your LD_LIBRARY_PATH enviroment "
			       "variable, or edit /etc/ld.so.conf\n");
			printf("*** so that the correct libraries are found at "
			       "run-time)\n");
		}
	}
	return 1;
}

		],,
		[no_gtk="yes"],
		[echo $ac_n "cross compiling; assumed OK... $ac_c"])
		CFLAGS="$ac_save_CFLAGS"
		LIBS="$ac_save_LIBS"
	fi
fi

if test "x$no_gtk" = x; then
	AC_MSG_RESULT(yes)
	ifelse([$2], , :, [$2])
else
	AC_MSG_RESULT(no)
	if test "$GTK_CONFIG" = "no"; then
		echo "*** The gtk-config script installed by GTK could not be"
		echo "*** found. If GTK was installed in PREFIX, make sure"
		echo "*** PREFIX/bin is in your path, or set the GTK_CONFIG"
		echo "*** environment variable to the full path to gtk-config."
	else
		if test -f conf.gtktest; then
			:
		else
			echo "*** Could not run GTK test program, checking why..."
			CFLAGS="$CFLAGS $GTK_CPPFLAGS"
			LIBS="$LIBS $GTK_LIBS"
			AC_TRY_LINK([ #include <gtk/gtk.h>
				      #include <stdio.h> ],
				    [ return ((gtk_major_version) ||
					      (gtk_minor_version) ||
					      (gtk_micro_version)); ],
	[ echo "*** The test program compiled, but did not run. This usually"
	  echo "*** means that the run-time linker is not finding GTK or"
	  echo "*** finding the wrong version of GTK. If it is not finding GTK,"
	  echo "*** you'll need to set your LD_LIBRARY_PATH environment"
	  echo "*** variable, or edit /etc/ld.so.conf to point to the installed"
	  echo "*** location  Also, make sure you have run ldconfig if that is"
	  echo "*** required on your system"
	  echo "***"
	  echo "*** If you have an old version installed, it is best to remove"
	  echo "*** it, although you may also be able to get things to work by"
	  echo "*** modifying LD_LIBRARY_PATH"
	  echo "***"
	  echo "*** If you have a RedHat 5.0 system, you should remove the GTK"
	  echo "*** package that came with the system with the command"
	  echo "***"
	  echo "***    rpm --erase --nodeps gtk gtk-devel" ],
	[ echo "*** The test program failed to compile or link. See the file"
	  echo "*** config.log for the exact error that occured. This usually"
	  echo "*** means GTK was incorrectly installed or that you have moved"
	  echo "*** GTK since it was installed. In the latter case, you may"
	  echo "*** want to edit the gtk-config script: $GTK_CONFIG" ])

			CFLAGS="$ac_save_CFLAGS"
          		LIBS="$ac_save_LIBS"
		fi
	fi
	GTK_CPPFLAGS=""
	GTK_LIBS=""
	ifelse([$3], , :, [$3])
fi
AC_SUBST(GTK_CPPFLAGS)
AC_SUBST(GTK_LIBS)
rm -f conf.gtktest
])


# AC_PATH_HA
#
# AC_PATH_HA([min-version], [action-if-found], [action-if-not-found], [modules])
# Test for the presence of the High-Availability clustering package.

AC_DEFUN([AC_PATH_HA], [

min_ha_version=ifelse([$1], , 0.4.9f, [$1])
AC_PATH_PROGS([HB], [heartbeat], ,[/usr/lib/heartbeat])
if test x"$HB" = x; then
	ifelse([$3], , :, [$3])
else
	AC_MSG_CHECKING([for HA version])
	HA_VERSION=`strings $HB | \
		    egrep '^[[0-9]]+\.[[0-9]]+\.[[0-9]]+[[a-z]]*$' | uniq`
	AC_MSG_RESULT([$HA_VERSION])

	HA_MAJOR=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)\([[a-z]]\)*/\1/'`
	HA_MINOR=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)\([[a-z]]\)*/\2/'`
	HA_PATCH=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)\([[a-z]]\)*/\3/'`
	HA_BETA=`echo $HA_VERSION | \
		sed 's/\([[0-9]]*\).\([[0-9]]*\).\([[0-9]]*\)\([[a-z]]\)*/\4/'`
	if [[ -z "$HA_BETA" ]]
	then
		HA_BETA=0
	fi

	AC_TRY_RUN([

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
int main()
{
	int major, minor, patch;
	char beta;
	char *tmp_version;

	tmp_version = (char *)strdup("$min_ha_version");
	if (sscanf(tmp_version, "%d.%d.%d%c",
		   &major, &minor, &patch, &beta) != 4) {
		printf("%s, bad version string\n", "$min_ha_version");
		return 1;
	}

	if (($HA_MAJOR > major)    ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR > minor))  ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR == minor) &&
	     ($HA_PATCH >= patch)) ||
	    (($HA_MAJOR == major) &&
	     ($HA_MINOR == minor) &&
	     ($HA_PATCH == patch) &&
	     ('$HA_BETA' >= beta))) {
		return(0);
	} else {
		printf("\n");
		printf("*** An old version of linux-ha (%d.%d.%d%c) was "
		       "found.\n", $HA_MAJOR, $HA_MINOR, $HA_PATCH, '$HA_BETA');
		printf("*** You need at least version %d.%d.%d. of linux-ha\n",
		       major, minor, patch);
		printf("*** The latest version is available from\n");
		printf("*** http://www.linux-ha.org/download/");
                printf("***\n");
                printf("*** If you have already installed a recent version,\n");
		printf("*** this error probably means that the wrong copy\n");
		printf("*** of the heartbeat daemon is being found. The\n");
		printf("*** easiest way to fix this is to remove the old\n");
		printf("*** version of linux-ha\n");
        }
        return(1);
}
		   ],
		   [have_ha_version="yes"],
		   [ifelse([$3], , :, [$3])])
fi

if test "$have_ha_version" = "yes"; then
	if test -d /usr/include/heartbeat -a	\
		-d /usr/include/clplumbing -a 	\
		-d /usr/include/ocf; then
		have_ha_headers="yes"
		HA_CPPFLAGS="-I/usr/include/heartbeat"
		tmp_cppflags=$CPPFLAGS
		CPPFLAGS="$HA_CPPFLAGS $GLIB_CPPFLAGS"
		AC_CHECK_HEADERS([heartbeat/heartbeat.h		\
				  heartbeat/ha_msg.h		\
				  heartbeat/hb_api.h		\
				  clplumbing/ipc.h		\
				  clplumbing/GSource.h		\
				  clplumbing/Gmain_timeout.h	\
				  clplumbing/base64.h		\
				  ocf/oc_event.h], [],
				 [have_ha_headers="no"])
		CPPFLAGS=$tmp_cppflags
		if test "$have_ha_headers" = "yes"; then
			HA_LIBS="-lhbclient -lccmclient -lplumb"
			for resourcedir in /etc/ha.d/resource.d /etc/heartbeat/resource.d; do
				if test -d "$resourcedir"; then
					HA_RESOURCEDIR="$resourcedir"
					ifelse([$2], , :, [$2])
				fi
			done
			if test -z "$HA_RESOURCEDIR"; then
				HA_CPPFLAGS=""
				ifelse([$3], , :, [$3])
			fi
		else
			HA_CPPFLAGS=""
			ifelse([$3], , :, [$3])
		fi
	else
		ifelse([$3], , :, [$3])
	fi
fi

AC_SUBST(HA_LIBS)
AC_SUBST(HA_CPPFLAGS)
AC_SUBST(HA_RESOURCEDIR)
AC_SUBST(HA_MAJOR)
AC_SUBST(HA_MINOR)
AC_SUBST(HA_PATCH)
])

# AC_WITH_EFENCE
#
# Check whether to link the EVMS user interfaces with the Electric Fence
# memory debugging library.

AC_DEFUN([AC_WITH_EFENCE],[
AC_ARG_WITH([efence],
	    AC_HELP_STRING([--with-efence],
			   [Link with Electric Fence memory debugging library]),
	    [have_efence="$withval"],
	    [have_efence="no"])

if test "$have_efence" = "yes"; then
	AC_CHECK_LIB([efence], [calloc], [EFENCE_LIBS="-lefence"])
fi

AC_SUBST(EFENCE_LIBS)
])


# AC_WITH_DEBUG
#
# Check whether to force debugging information to be added to EVMS.
AC_DEFUN([AC_WITH_DEBUG],[
AC_ARG_WITH([debug],
	    AC_HELP_STRING([--with-debug],[Add extra debugging information]),
	    [have_debug="$withval"], [have_debug="no"])
if test "$have_debug" = "yes"; then
	if test -z "$ac_test_CFLAGS"; then
		if test $ac_cv_prog_cc_g = "yes"; then
			CFLAGS=`echo $CFLAGS | sed 's/-O.//'`
			if test "$GCC" = "yes"; then
				CFLAGS=`echo $CFLAGS | sed 's/-g//'`
			fi
		fi
	fi
	if test "$GCC" = "yes"; then
		CFLAGS="$CFLAGS -g"
	fi
	EVMS_DEBUG="-DEVMS_DEBUG"
fi
AC_SUBST(EVMS_DEBUG)
])

# AC_STATIC_GLIB
#
# Check whether to force the text-mode UI to link statically to glib and panel.
# This is done to prevent linking to libraries in /usr.
AC_DEFUN([AC_WITH_STATIC_GLIB],[
AC_ARG_WITH([static-glib],
	    AC_HELP_STRING([--with-static-glib],[Link text-mode UI statically to glib]),
	    [static_glib="$withval"], [static_glib="no"])
if test "$static_glib" = "yes"; then
	STATIC_GLIB_OPEN="-Wl,-dn"
	STATIC_GLIB_CLOSE="-Wl,-dy"
fi
AC_SUBST(STATIC_GLIB_OPEN)
AC_SUBST(STATIC_GLIB_CLOSE)
])

