/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: discover.h
 *
 */

/*
 * Global data exported by discover.c
 */

extern boolean discover_in_progress;

/*
 * Global functions exported by discover.c
 */

extern void remove_corrupt_objects(list_anchor_t list);

extern int hasa_dev_node(char * volume_name,
                         u_int32_t major,
                         u_int32_t minor);

extern int ensure_dev_node(char    * name,
                           u_int32_t major,
                           u_int32_t minor);

extern int make_object_dev_node(storage_object_t * obj);

extern void propigate_cluster_info(list_anchor_t objects);

extern char * status_dots(int * status_count);

extern int check_for_stop_data(storage_object_t * obj);

extern void feature_header_disk_to_cpu(evms_feature_header_t * fh);

extern int compare_objects(void * thing1,
			   void * thing2);

extern int compare_containers(void * thing1,
			      void * thing2);

extern int compare_volumes(void * thing1,
			   void * thing2);

extern int discover(list_anchor_t objects,
		    boolean report_status);

extern int initial_discovery(void);

extern void set_volume_in_object(storage_object_t * obj,
				 logical_volume_t * vol);

extern int get_volume_sizes_and_limits(logical_volume_t * vol);

extern void find_fsim_for_volume(logical_volume_t * volume);

extern int make_volume_dev_node(logical_volume_t * volume);

extern int evms_mark_for_rediscover(char * name);

extern int rediscover(void);

extern int evms_rediscover(void);

