/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: remote.h
 *
 */

/*
 * Global functions exported by remote.c
 */

/* Internal functions to share with other Engine source modules */

extern int remote_verify_version(void);

int remote_open_engine(char           * node_name,
		       engine_mode_t    mode,
		       ui_callbacks_t * ui_callbacks,
		       debug_level_t    level,
                       char           * log_name);

int remote_get_plugin_list(evms_plugin_code_t    type,
			   plugin_search_flags_t flags,
			   handle_array_t    * * plugin_handle_list);

int remote_get_plugin_by_ID(plugin_id_t       plugin_ID,
			    plugin_handle_t * plugin_handle);

int remote_get_plugin_by_name(char            * plugin_name,
			      plugin_handle_t * plugin_handle);

int remote_changes_pending(boolean                 * result,
			   change_record_array_t * * p_changes);

int remote_set_debug_level(debug_level_t level);

int remote_commit_changes(void);

int remote_close_engine();

int remote_get_info(object_handle_t          thing,
		    handle_object_info_t * * user_info);

int remote_can_delete(object_handle_t thing);

int remote_can_destroy(object_handle_t thing);

int remote_can_expand(object_handle_t thing);

int remote_can_shrink(object_handle_t thing);

int remote_can_replace(object_handle_t source_handle,
		       object_handle_t target_handle);

int remote_can_set_info(object_handle_t thing);

int remote_delete(object_handle_t thing);

int remote_destroy(object_handle_t thing);

int remote_get_expand_points(object_handle_t           thing,
			     expand_handle_array_t * * expand_points);

int remote_expand(object_handle_t  thing,
		  handle_array_t * objects,
		  option_array_t * options);

int remote_get_shrink_points(object_handle_t           thing,
			     shrink_handle_array_t * * shrink_points);

int remote_shrink(object_handle_t  thing,
		  handle_array_t * objects,
		  option_array_t * options);

int remote_replace(object_handle_t  source,
		   object_handle_t  target);

int remote_get_handle_object_type(object_handle_t handle,
				  object_type_t * type);

int remote_get_info(object_handle_t          thing,
		    handle_object_info_t * * info);

int remote_get_extended_info(object_handle_t           thing,
			     char                    * descriptor_name,
			     extended_info_array_t * * info);

int remote_set_info(object_handle_t  object,
		    option_array_t * options);

int remote_get_object_handle_for_name(object_type_t     type,
				      char            * name,
				      object_handle_t * object_handle);

int remote_get_feature_list(object_handle_t    thing,
			    handle_array_t * * plugin_list);

int remote_create(plugin_handle_t    plugin,
		  handle_array_t   * input_objects,
		  option_array_t   * options,
		  handle_array_t * * output_objects);

int remote_transfer(object_handle_t  object,
		    plugin_handle_t  plugin,
		    object_handle_t  container,
		    option_array_t * options);

int remote_assign(object_handle_t  object,
		  plugin_handle_t  plugin,
		  option_array_t * options);

int remote_can_unassign(object_handle_t object);

int remote_unassign(object_handle_t object);

int remote_get_plugin_functions(engine_handle_t           thing,
				function_info_array_t * * actions);

int remote_get_object_list(object_type_t         object_type,
			   data_type_t           data_type,
			   plugin_handle_t       plugin_handle,
			   object_handle_t       disk_group_handle,
			   object_search_flags_t flags,
			   handle_array_t    * * object_handle_list);

int remote_do_plugin_function(engine_handle_t  thing,
			      task_action_t    action,
			      handle_array_t * objects,
			      option_array_t * options);

int remote_can_create_volume(object_handle_t object);

int remote_can_create_compatibility_volume(object_handle_t object);

int remote_can_set_volume_name(object_handle_t volume);

int remote_can_convert_to_evms_volume(object_handle_t volume);

int remote_can_convert_to_compatibility_volume(object_handle_t volume);

int remote_can_add_feature_to_volume(object_handle_t volume_handle,
				     plugin_handle_t feature_handle);

int remote_create_volume(object_handle_t object,
			 char          * name);

int remote_set_volume_name(object_handle_t volume,
			   char          * name);

int remote_create_compatibility_volume(object_handle_t object);

int remote_convert_to_evms_volume(object_handle_t volume,
				  char * name);

int remote_convert_to_compatibility_volume(object_handle_t volume);

int remote_add_feature_to_volume(object_handle_t  volume,
				 plugin_handle_t  feature,
				 option_array_t * options);

int remote_can_mkfs(object_handle_t volume,
		    plugin_handle_t fsim);

int remote_can_unmkfs(object_handle_t volume);

int remote_can_fsck(object_handle_t volume);

int remote_can_defrag(object_handle_t volume);

int remote_mkfs(object_handle_t  volume,
		plugin_handle_t  fsim,
		option_array_t * options);

int remote_unmkfs(object_handle_t volume);

int remote_fsck(object_handle_t  volume,
		option_array_t * options);

int remote_defrag(object_handle_t  volume,
		  option_array_t * options);

int remote_get_volume_list(object_handle_t       fsim_handle,
			   object_handle_t       disk_group_handle,
			   volume_search_flags_t flags,
			   handle_array_t    * * volume_handle_list);

int remote_can_mount(object_handle_t volume);

int remote_mount(object_handle_t volume,
		 char          * mount_point,
		 char          * options);

int remote_can_unmount(object_handle_t volume);

int remote_unmount(object_handle_t volume);

int remote_can_remount(object_handle_t volume);

int remote_remount(object_handle_t volume,
		   char          * options);

int remote_can_add_to_container(object_handle_t object,
				object_handle_t container);

int remote_can_remove_from_container(object_handle_t object);

int remote_create_container(plugin_handle_t   plugin,
			    handle_array_t  * input_objects,
			    option_array_t  * options,
			    object_handle_t * output_container);

int remote_get_container_list(object_handle_t          plugin_handle,
			      object_handle_t          disk_group_handle,
			      container_search_flags_t flags,
                              handle_array_t       * * container_handle_list);

int remote_create_task(engine_handle_t thing,
		       task_action_t   action,
		       task_handle_t * new_task_context);

int remote_invoke_task(task_handle_t      task,
		       handle_array_t * * resulting_objects);

int remote_destroy_task(task_handle_t task);

int remote_get_task_action (task_handle_t handle,
			    task_action_t *action);

int remote_get_acceptable_objects(task_handle_t      task,
				  handle_array_t * * acceptable_object_list);

int remote_get_selected_objects(task_handle_t      task,
				handle_array_t * * selected_object_list);

int remote_get_selected_object_limits(task_handle_t task,
				      u_int32_t   * miminum,
				      u_int32_t   * maximum);

int remote_set_selected_objects(task_handle_t               task,
				handle_array_t            * selected_object_list,
				declined_handle_array_t * * declined_list,
				task_effect_t             * effect);

int remote_get_option_count(task_handle_t task,
			    int         * count);

int remote_get_option_descriptor(task_handle_t           task,
				 u_int32_t               option,
				 option_descriptor_t * * descriptor);

int remote_set_option_value(task_handle_t   task,
			    u_int32_t       option,
			    value_t       * value,
			    task_effect_t * effect);

int remote_get_option_descriptor_by_name(task_handle_t           task,
					 const char            * option,
					 option_descriptor_t * * descriptor);

int remote_set_option_value_by_name(task_handle_t   task,
				    const char    * option_name,
				    value_t       * value,
				    task_effect_t * effect);

int remote_mark_for_rediscover(char * name);

int remote_rediscover(void);

int remote_shutdown(void);

void engine_router(ece_msg_t * msg);
