/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libcsm.so
 *
 *   File: containers.h
 */

#ifndef _CONTAINERS_H_
#define _CONTAINERS_H_


int     csm_can_create_container( list_anchor_t objects );

int     csm_can_delete_container( storage_container_t * container );


int     csm_can_add_object(     storage_object_t        * object,
				storage_container_t     * container );

int     csm_can_remove_object( storage_object_t * object );

int     csm_create_container_storage_object( char *name,
					     storage_container_t **container,
					     ece_nodeid_t *nodeid,
					     ece_clusterid_t *clusterid,
					     uint flags);

int     csm_create_container( list_anchor_t                   objects,
			      option_array_t            * options,
			      storage_container_t       ** container );

int     csm_add_object( storage_object_t        * region,
			storage_container_t     * container,
			option_array_t          * options );

int     csm_transfer_object( storage_object_t   	* object,
			     storage_container_t        * target_container,
			     option_array_t             * options );

int     csm_discard_container( storage_container_t * container );

int     csm_remove_object( storage_object_t * object );

int     csm_delete_container(storage_container_t        * container,
			     list_anchor_t                objects_consumed );

int     csm_commit_container_changes( storage_container_t   * container,
				      unsigned int            phase );

int     csm_get_container_info( storage_container_t     * container,
				char                    * name,
				extended_info_array_t   ** info_array );

int     csm_set_container_info( storage_container_t * container,
				option_array_t      * options );

int     csm_find_container( char *container_name, storage_container_t **container );

int     csm_get_plugin_functions(storage_container_t     * container,
				 function_info_array_t * * actions);

int     csm_plugin_function(storage_container_t * container,
			    task_action_t         action,
			    list_anchor_t         objects,
			    option_array_t      * options);

int     add_disk_to_container( storage_object_t    * ld,
			       storage_container_t * container );

int     allocate_csm_container( uint flags, storage_container_t **container );

void    free_csm_container( storage_container_t *container );

void    delete_all_csm_container_private_data(void);

int     get_csm_container_list( list_anchor_t *list );

#endif

