/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: md_discover.h
 */

#ifndef _MD_DISCOVER_H_
#define _MD_DISCOVER_H_ 1

// Functions exported by md_discover.c

int md_check_for_pv(storage_object_t * object, mdp_super_t ** buffer);
int md_check_for_saved_sb(storage_object_t * object, mdp_saved_super_t ** buffer);
int md_can_restore_saved_sb(storage_object_t *region);
int md_restore_saved_sb(md_volume_t *volume);
int md_discover_logical_volumes( void );
void md_discover_volumes(list_anchor_t input_list, list_anchor_t output_list);
int md_find_volume_for_object(storage_object_t * object, mdp_super_t * md_super_buffer);
int md_read_sb_from_disk(storage_object_t *object, mdp_super_t * buffer);
int md_write_sbs_to_disk(md_volume_t * volume);
int md_uuids_equal(mdp_super_t * sb1, mdp_super_t * sb2);
int md_register_name_space(void);
void md_discover_final_call(list_anchor_t input_list, list_anchor_t output_list, int *count);
int md_analyze_volume(md_volume_t *volume);
int md_rebuild_array_from_master_sb(md_volume_t *volume);
void md_remove_missing_disk_entries(md_volume_t * vol);
void md_print_array_sb(char *buf, u_int32_t buf_size, mdp_super_t *sb);
int md_free_volume(md_volume_t *volume);

#endif

