/*
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: mdregmgr
 * File: raid5_mgr.h
 */

#ifndef _RAID5_MGR_H_
#define _RAID5_MGR_H_ 1

typedef struct disk_info_s {
	storage_object_t        *dev;
	int                     operational;
	int                     number;
	int                     raid_disk;
	int                     write_only;
	int                     spare;
	int                     used_slot;
} disk_info_t;


typedef struct raid5_private_data {
	md_volume_t             *mddev;
	disk_info_t             disks[MD_SB_DISKS];
	disk_info_t             spare;
	int                     chunk_size;
	int                     level;
	int                     algorithm;
	int                     raid_disks;
	int                     active_disks;
	int                     spare_disks;
	int                     failed_disks;
	int                     failed_raid_disks;
	int                     failed_disk_index;
} raid5_conf_t;


#define mdvol_to_conf(mdvol) ((raid5_conf_t *) mdvol->private_data)


typedef struct chunk_s {
	storage_object_t * dev;
	lsn_t              lsn_on_dev;
	unsigned char    * data;
} chunk_t;


typedef struct stripe_s {
	md_volume_t   * volume;
	unsigned long   number;
	lsn_t           start_lsn;
	sector_count_t  data_size;
	chunk_t         chunk[MD_SB_DISKS];
} stripe_t;


typedef struct kill_sectors_s {
	storage_object_t      * region;
	lsn_t                   lsn;
	sector_count_t          count;
	struct kill_sectors_s * next;
} kill_sectors_t;


/********************/
/* "Create" options */
/********************/

/*
 * Our supported RAID levels
 */
#define RAID4_LEVEL_NAME	"RAID4"
#define RAID5_LEVEL_NAME	"RAID5"


/*
 * Names of our supported algorithms
 */
#define ALGORITHM_LEFT_ASYMMETRIC_NAME	"Left Asymmetric"
#define ALGORITHM_RIGHT_ASYMMETRIC_NAME	"Right Asymmetric"
#define ALGORITHM_LEFT_SYMMETRIC_NAME	"Left Symmetric"
#define ALGORITHM_RIGHT_SYMMETRIC_NAME	"Right Symmetric"


#define MD_OPTION_SPARE_DISK_INDEX		0
#define MD_OPTION_SPARE_DISK_NAME		"sparedisk"
#define MD_OPTION_CHUNK_SIZE_INDEX		1
#define MD_OPTION_CHUNK_SIZE_NAME		"chunksize"
#define MD_OPTION_RAID_LEVEL_INDEX		2
#define MD_OPTION_RAID_LEVEL_NAME		"level"
#define MD_OPTION_PARITY_ALGORITHM_INDEX	3
#define MD_OPTION_PARITY_ALGORITHM_NAME		"algorithm"
#define MD_NO_SELECTION				"None"

#define MD_CREATE_OPTIONS_COUNT			4


/*
 * Plug-in functions
 */
#define MD_RAID5_FUNCTION_FIX			EVMS_Task_Plugin_Function
#define MD_RAID5_FUNCTION_ADD_SPARE		(EVMS_Task_Plugin_Function + 1)
#define MD_RAID5_FUNCTION_REMOVE_SPARE  	(EVMS_Task_Plugin_Function + 2)
#define MD_RAID5_FUNCTION_REMOVE_FAULTY 	(EVMS_Task_Plugin_Function + 3)
#define MD_RAID5_FUNCTION_MARK_FAULTY   	(EVMS_Task_Plugin_Function + 4)
#define MD_RAID5_FUNCTION_REMOVE_STALE		(EVMS_Task_Plugin_Function + 5)
#define MD_RAID5_RESTORE_SUPERBLOCK	   	(EVMS_Task_Plugin_Function + 6)

#define MD_RAID5_FUNCTION_COUNT			7

/*
 * The following definitions and structures were taken from
 * <linux/evms/evms_md_k.h> and <linux/evms/evms_raid5.h>.  Keep them in sync
 * with the definitions in that file. That file cannot be included here because
 * it pulls in other kernel header files that do not like to be compiled in user
 * space.
 */
#define ALGORITHM_LEFT_ASYMMETRIC	0
#define ALGORITHM_RIGHT_ASYMMETRIC	1
#define ALGORITHM_LEFT_SYMMETRIC	2
#define ALGORITHM_RIGHT_SYMMETRIC	3

#define MD_RAID5_REGION_NEW			(1<<0)
#define MD_RAID5_CONFIG_CHANGE_PENDING		(1<<1)
#define MD_RAID5_IGNORE_VERIFY			(1<<2)

/* RAID5 plugin functions */
int raid5_add_spare_disk(md_volume_t * volume, storage_object_t * spare);
int raid5_remove_spare_disk(md_volume_t * volume, storage_object_t * spare);
int raid5_remove_faulty_disk(md_volume_t * volume, storage_object_t * faulty);
int raid5_remove_stale_disk(md_volume_t * volume, storage_object_t * stale);
int raid5_mark_faulty_disk(md_volume_t * volume, storage_object_t * active);

int raid5_fix_array(md_volume_t *volume);

#endif

