/*
 *
 *   (C) Copyright IBM Corp. 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libmac.so
 *
 *   File: options.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <plugin.h>

#include "mac_plugin.h"



/*
 * Returns segment specific information
 */
int mac_get_segment_info( storage_object_t  * object, extended_info_array_t * * info)
{
        int rc = EINVAL;
        extended_info_array_t   *Info;
        seg_private_data_t      *pdata = (seg_private_data_t *)object->private_data;

        LOG_ENTRY();

        rc    = ENOMEM;  // init to failed calloc
        *info = NULL;     // init to no info returned

        Info = EngFncs->engine_alloc( sizeof(extended_info_array_t) + ( SEG_INFO_COUNT * sizeof(extended_info_t) ) );
        if (Info) {

                Info->count = SEG_INFO_COUNT;

                Info->info[SEG_INFO_TYPE_INDEX].name = EngFncs->engine_strdup( "Type" );
                Info->info[SEG_INFO_TYPE_INDEX].title = EngFncs->engine_strdup( _("Type") );
                Info->info[SEG_INFO_TYPE_INDEX].desc = EngFncs->engine_strdup( _("This is the Apple partition type. ") );
                Info->info[SEG_INFO_TYPE_INDEX].type               = EVMS_Type_String;
                Info->info[SEG_INFO_TYPE_INDEX].unit               = EVMS_Unit_None;
                Info->info[SEG_INFO_TYPE_INDEX].value.s = EngFncs->engine_strdup( pdata->p_record.type );
                Info->info[SEG_INFO_TYPE_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[SEG_INFO_TYPE_INDEX].group, 0, sizeof(group_info_t));

                Info->info[SEG_INFO_NAME_INDEX].name = EngFncs->engine_strdup( "Name" );
                Info->info[SEG_INFO_NAME_INDEX].title = EngFncs->engine_strdup( _("Name") );
                Info->info[SEG_INFO_NAME_INDEX].desc = EngFncs->engine_strdup( _("This is the partition name.") );
                Info->info[SEG_INFO_NAME_INDEX].type               = EVMS_Type_String;
                Info->info[SEG_INFO_NAME_INDEX].unit               = EVMS_Unit_None;
                Info->info[SEG_INFO_NAME_INDEX].value.s = EngFncs->engine_strdup( pdata->p_record.name );
                Info->info[SEG_INFO_NAME_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[SEG_INFO_NAME_INDEX].group, 0, sizeof(group_info_t));

                Info->info[SEG_INFO_START_INDEX].name = EngFncs->engine_strdup( "Start" );
                Info->info[SEG_INFO_START_INDEX].title = EngFncs->engine_strdup( _("Start Logical Block Address") );
                Info->info[SEG_INFO_START_INDEX].desc = EngFncs->engine_strdup( _("This is the sector offset of the partition on the disk, i.e., the logical block address of the first sector of the partition.") );
                Info->info[SEG_INFO_START_INDEX].type               = EVMS_Type_Unsigned_Int64;
                Info->info[SEG_INFO_START_INDEX].unit               = EVMS_Unit_None;
                Info->info[SEG_INFO_START_INDEX].value.ui64         = object->start;
                Info->info[SEG_INFO_START_INDEX].format             = EVMS_Format_Normal;
                Info->info[SEG_INFO_START_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[SEG_INFO_START_INDEX].group, 0, sizeof(group_info_t));

                Info->info[SEG_INFO_SIZE_INDEX].name = EngFncs->engine_strdup( "Size" );
                Info->info[SEG_INFO_SIZE_INDEX].title = EngFncs->engine_strdup( _("Size") );
                Info->info[SEG_INFO_SIZE_INDEX].desc = EngFncs->engine_strdup( _("This is the size of the partition in sectors.") );
                Info->info[SEG_INFO_SIZE_INDEX].type               = EVMS_Type_Unsigned_Int64;
                Info->info[SEG_INFO_SIZE_INDEX].unit               = EVMS_Unit_Sectors;
                Info->info[SEG_INFO_SIZE_INDEX].value.ui64         = object->size;
                Info->info[SEG_INFO_SIZE_INDEX].format             = EVMS_Format_Normal;
                Info->info[SEG_INFO_SIZE_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[SEG_INFO_SIZE_INDEX].group, 0, sizeof(group_info_t));
                Info->info[SEG_INFO_SIZE_INDEX].flags |= EVMS_EINFO_FLAGS_NO_UNIT_CONVERSION;

                *info = Info;

                rc = 0;
        }
        else {
                LOG_ERROR("unable to malloc memory for extended info array\n");
        }


        LOG_EXIT_INT(rc);
        return rc;
}

/*
 * Returns MAC metadata specific information ... under construction
 */
int mac_get_metadata_info( storage_object_t  * object, extended_info_array_t * * info)
{

        int rc;
        extended_info_array_t   *Info;

        LOG_ENTRY();

        rc    = ENOMEM;  // init to failed calloc
        *info = NULL;     // init to no info returned

        Info = EngFncs->engine_alloc( sizeof(extended_info_array_t) + ( MAC_LABEL_INFO_COUNT  * sizeof(extended_info_t) ) );
        if (Info) {

                Info->count = MAC_LABEL_INFO_COUNT ;

        }

        LOG_EXIT_INT(rc);
        return rc;
}


/*
 * Returns plugin specific information
 */
int mac_get_plugin_info( char * descriptor_name, extended_info_array_t * * info )
{
        int rc = EINVAL;
        extended_info_array_t   *Info;
        char                     version_string[64];
        char                     required_engine_api_version_string[64];
        char                     required_plugin_api_version_string[64];


        LOG_ENTRY();

        // a measure of protection ...
        if (info == NULL) {
                LOG_EXIT_INT(rc);
                return rc;
        }

        rc    = ENOMEM;  // init to failed calloc
        *info = NULL;     // init to no info returned

        Info = EngFncs->engine_alloc( sizeof(extended_info_array_t) + (PLUGIN_INFO_COUNT*sizeof(extended_info_t))  );
        if (Info) {

                Info->count = PLUGIN_INFO_COUNT;

                sprintf(version_string, "%d.%d.%d",
                        MAJOR_VERSION,
                        MINOR_VERSION,
                        PATCH_LEVEL );

                sprintf(required_engine_api_version_string, "%d.%d.%d",
                        mac_plugin->required_engine_api_version.major,
                        mac_plugin->required_engine_api_version.minor,
                        mac_plugin->required_engine_api_version.patchlevel );

                sprintf(required_plugin_api_version_string, "%d.%d.%d",
                        mac_plugin->required_plugin_api_version.plugin.major,
                        mac_plugin->required_plugin_api_version.plugin.minor,
                        mac_plugin->required_plugin_api_version.plugin.patchlevel );

                Info->info[PLUGIN_INFO_SNAME_INDEX].name = EngFncs->engine_strdup( "ShortName" );
                Info->info[PLUGIN_INFO_SNAME_INDEX].title = EngFncs->engine_strdup( _("Short Name") );
                Info->info[PLUGIN_INFO_SNAME_INDEX].desc = EngFncs->engine_strdup( _("A short name given to this plug-in") );
                Info->info[PLUGIN_INFO_SNAME_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_SNAME_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_SNAME_INDEX].value.s = EngFncs->engine_strdup( mac_plugin->short_name );
                Info->info[PLUGIN_INFO_SNAME_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_SNAME_INDEX].group, 0, sizeof(group_info_t));

                Info->info[PLUGIN_INFO_LNAME_INDEX].name = EngFncs->engine_strdup( "LongName" );
                Info->info[PLUGIN_INFO_LNAME_INDEX].title = EngFncs->engine_strdup( _("Long Name") );
                Info->info[PLUGIN_INFO_LNAME_INDEX].desc = EngFncs->engine_strdup( _("A longer, more descriptive name for this plug-in") );
                Info->info[PLUGIN_INFO_LNAME_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_LNAME_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_LNAME_INDEX].value.s = EngFncs->engine_strdup( mac_plugin->long_name );
                Info->info[PLUGIN_INFO_LNAME_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_LNAME_INDEX].group, 0, sizeof(group_info_t));

                Info->info[PLUGIN_INFO_TYPE_INDEX].name = EngFncs->engine_strdup( "Type" );
                Info->info[PLUGIN_INFO_TYPE_INDEX].title = EngFncs->engine_strdup( _("Plug-in Type") );
                Info->info[PLUGIN_INFO_TYPE_INDEX].desc = EngFncs->engine_strdup( _("There are various types of plug-ins, each responsible for some kind of storage object or logical volume.") );
                Info->info[PLUGIN_INFO_TYPE_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_TYPE_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_TYPE_INDEX].value.s = EngFncs->engine_strdup( _("Segment Manager") );
                Info->info[PLUGIN_INFO_TYPE_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_TYPE_INDEX].group, 0, sizeof(group_info_t));

                Info->info[PLUGIN_INFO_VERSION_INDEX].name = EngFncs->engine_strdup( "Version" );
                Info->info[PLUGIN_INFO_VERSION_INDEX].title = EngFncs->engine_strdup( _("Plug-in Version") );
                Info->info[PLUGIN_INFO_VERSION_INDEX].desc = EngFncs->engine_strdup( _("This is the version number of the plugin.") );
                Info->info[PLUGIN_INFO_VERSION_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_VERSION_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_VERSION_INDEX].value.s = EngFncs->engine_strdup( version_string );
                Info->info[PLUGIN_INFO_VERSION_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_VERSION_INDEX].group, 0, sizeof(group_info_t));

                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].name = EngFncs->engine_strdup( "Required Engine Services Version" );
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].title = EngFncs->engine_strdup( _("Required Engine Services Version") );
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].desc = EngFncs->engine_strdup( _("This is the version of the Engine services that this plugin requires.  "
												"It will not run on older versions of the Engine services.") );
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].value.s = EngFncs->engine_strdup( required_engine_api_version_string );
                Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_REQENGSVCVERSION_INDEX].group, 0, sizeof(group_info_t));

                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].name = EngFncs->engine_strdup( "Required Engine Plug-in API Version" );
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].title = EngFncs->engine_strdup( _("Required Engine Plug-in API Version") );
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].desc = EngFncs->engine_strdup( _("This is the version of the Engine plug-in API that this plugin requires.  "
												 "It will not run on older versions of the Engine plug-in API.") );
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].type               = EVMS_Type_String;
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].unit               = EVMS_Unit_None;
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].value.s = EngFncs->engine_strdup( required_plugin_api_version_string );
                Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].collection_type    = EVMS_Collection_None;
                memset( &Info->info[PLUGIN_INFO_REQPLUGAPIVERSION_INDEX].group, 0, sizeof(group_info_t));

                *info = Info;

                rc = 0;
        }


        LOG_EXIT_INT(rc);
        return rc;
}

