/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: message.h
 */

#define MAX_BUTTON_CHARS    25
#define MAX_MESSAGE_BUTTONS 3
#define MAX_TIME_BUF_SIZE   127

typedef struct message_args_s {
	gint *answer;		/* the index of the choice made */
	gint choice_count;	/* count of choices when using buttons for choices */
	gchar *text;		/* the message or instructions */
	gchar **choices;	/* optional array of string of choices */
	GCond *wakeup_cond;	/* conditional used for blocking callback thread */
	GMutex *wakeup_mutex;	/* mutex used in g_cond_wait () function call */
	gboolean hide_window;	/* typically only set for info message window */
} message_args_t;

GtkWidget *create_informational_message_window(gchar * text, gboolean hide_window);

ui_callbacks_t *get_ui_callback_table(void);

void redisplay_info_messages_window(void);

void set_message_window_transient_for(GtkWindow * parent);
