/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * 	Module: ecemisc.h
 */
#ifndef __ECEMISC_H__
#define __ECEMISC_H__ 1

extern ece_event_t * 	create_ece_ev(gboolean, const oc_ev_membership_t *, 
				ece_event_type_t , 
				int *);
extern inline void 	delete_ece_ev(ece_event_t *);
extern int 		peer_send(void *, const int, IPC_Channel *);
extern int 		peer_recv(IPC_Message **, IPC_Channel *, gboolean);
extern int 		peer_recv_done(IPC_Message *);
extern char * 		oc2membstr(gboolean, const oc_ev_membership_t *, const int );
extern int 		membstr2oc(struct ha_msg *, oc_ev_membership_t **, gboolean *);
extern int  		condition_wait(char *, u_int32_t );
extern void		condition_check(const char *, const u_int32_t , 
						const int );
extern void 		condition_init(void);



typedef enum msg_enum_s {
	STL=1,
	SFL,
	DFS ,
	DSTR,
	DLTR,
	DLTS,
	DRTS,
	DFR
} msg_enum_t;
extern void 	msg_track(const gboolean , 
			const struct ha_msg *, 
			const char *, 
			const gboolean , 
			const msg_enum_t );



#endif /* __ECEMISC_H__ */
