/*
 *
 *   (C) Copyright IBM Corp. 2001, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 *   Module: libbsd.so
 *
 *   File: bsd_plugin.c
 */

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <errno.h>

#include <plugin.h>

#include "bsd_plugin.h"

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                         PRIVATE DATA AREAS AND SUBROUTINES                           +
+                                                                                      +
+-------------------------------------------------------------------------------------*/

static plugin_record_t          bsd_plugin_record;

plugin_record_t                *bsd_plugin = &bsd_plugin_record;

struct engine_functions_s      *EngFncs=NULL;


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                          Plugin Setup and Cleanup Functions                          +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static int bsd_setup( engine_functions_t * engine_functions )
{
        int rc = 0;
        EngFncs = engine_functions;
        LOG_ENTRY();
        LOG_EXIT_INT(rc);
        return rc;
}

static void bsd_cleanup(void)
{
        LOG_ENTRY();

        delete_all_bsd_segment_private_data();
        delete_all_bsd_disk_private_data();

        LOG_EXIT_VOID();
}

/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                              PLUGIN FUNCTION TABLE                                   +
+                                                                                      +
+--------------------------------------------------------------------------------------*/
static struct plugin_functions_s bsd_plugin_functions = {
        setup_evms_plugin:              bsd_setup,
        cleanup_evms_plugin:            bsd_cleanup,
        can_set_volume:                 bsd_can_set_volume,
        can_delete:                     bsd_can_delete,
        discover:                       bsd_discover,
        can_unassign:                   bsd_can_unassign,
        unassign:                       bsd_unassign,
        delete:                         bsd_destroy,
        discard:                        bsd_discard,
        add_sectors_to_kill_list:       bsd_add_sectors_to_kill_list,
        commit_changes:                 bsd_commit_changes,
        read:                           bsd_read,
        write:                          bsd_write,
        get_info:                       bsd_get_info,
        get_plugin_info:                bsd_get_plugin_info,
        can_activate:                   bsd_can_activate,
        activate:                       bsd_activate,
        can_deactivate:                 bsd_can_deactivate,
	deactivate:                     bsd_deactivate,
	backup_metadata:                bsd_backup_metadata,
};


/*-------------------------------------------------------------------------------------+
+                                                                                      +
+                       BUILD AND EXPORT AN EVMS PLUGIN RECORD                         +
+                                                                                      +
+--------------------------------------------------------------------------------------*/

static plugin_record_t bsd_plugin_record = {

        id:                                 EVMS_BSD_PLUGIN_ID,

        version:                            {MAJOR_VERSION, MINOR_VERSION, PATCH_LEVEL},

        required_engine_api_version:        {15,0,0},
        required_plugin_api_version:        {plugin: {13,1,0}},

        short_name:                         EVMS_BSD_PLUGIN_SHORT_NAME,
        long_name:                          EVMS_BSD_PLUGIN_LONG_NAME,
        oem_name:                           EVMS_IBM_OEM_NAME,

        functions:                          {plugin: &bsd_plugin_functions},

};

// Vector of plugin record ptrs that we export for the EVMS Engine.
plugin_record_t *evms_plugin_records[] = {
        &bsd_plugin_record,
        NULL
};


