/*
 *
 *   (C) Copyright IBM Corp. 2003, 2004
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */

extern plugin_record_t ogfs_plugin_record;
extern plugin_record_t *my_plugin_record;
extern engine_functions_t *EngFncs;

#define OGFS_PLUGIN_INFO_COUNT		6
#define OGFS_CG_INFO_COUNT		5
#define OGFS_SB_INFO_COUNT		4

#define OGFS_SB_OFFSET			(OGFS_SB_ADDR * OGFS_BASIC_BLOCK)
#define OGFS_LH_OFFSET			0
#define OGFS_CG_OFFSET			0

#define MINOGFS				(0x2000000)	/* min volume/journal == 32MB */
#define MINOGFS_TABLE			(0x100000)	/* min cidev == 1MB */

/* Types of OGFS volumes */
typedef enum {
	OGFS_FS_VOL,
	OGFS_CI_VOL,
	OGFS_JOURNAL_VOL,
	OGFS_UNKNOWN_VOL
} ogfs_volume_type_t;

#define OGFS_LOCKING_PROTOCOL_COUNT	2

#define OGFS_MIN_FS_BLOCKSIZE		512
#define OGFS_MAX_FS_BLOCKSIZE		65536
#define OGFS_DEFAULT_FS_BLOCKSIZE	4096

/* mkfs options */
#define OGFS_MKFS_OPTIONS_COUNT		4

#define OGFS_MKFS_BLOCKSIZE_INDEX	0
#define OGFS_MKFS_JOURNALS_INDEX	1
#define OGFS_MKFS_PROTOCOL_INDEX	2
#define OGFS_MKFS_LOCKDEV_INDEX		3

#define OGFS_MKFS_BLOCKSIZE_NAME	"blocksize"
#define OGFS_MKFS_JOURNALS_NAME		"journals"
#define OGFS_MKFS_PROTOCOL_NAME		"protocol"
#define OGFS_MKFS_LOCKDEV_NAME		"lockdev"

#define OGFS_MKFS_MAX_ARG_COUNT		10

#define OGFS_JOURNAL_CF_BUFSIZE		(EVMS_VOLUME_NAME_SIZE + 20)
