/*
 *
 *    Copyright 1995-1999 Regents of the University of Minnesota
 *    Portions Copyright 2001 Sistina Software, Inc.
 *    Copyright Linus Torvalds and others
 *
 *    This is free software released under the GNU General Public License.
 *    There is no warranty for this software.  See the file COPYING for
 *    details.
 *
 *    See the file AUTHORS for a list of contributors.
 *
 */

/*
 * Implements Linux kernel endianess conversations for user space.
 */
#ifndef _OSI_ENDIAN_H
#define _OSI_ENDIAN_H

#if defined(__linux__)

#include <features.h> /* here __GLIBC__ etc. is defined          */
                      /* this is necessary to include "endian.h" */

#if (__GLIBC__ >= 2)

#if (__GLIBC_MINOR__ == 0)
#include <bytesex.h>
#endif  /*  (__GLIBC_MINOR__ == 0)  */

#if (__GLIBC_MINOR__ == 1)
#include <endian.h>
#endif  /*  (__GLIBC_MINOR__ == 1)  */

#endif  /*  (__GLIBC__ >= 2)  */
#endif  /*  defined(__linux__)  */


#include "global.h"


#define swab16(x) \
        ((uint16)( \
                (((uint16)(x) & 0x00ffU) << 8) | \
                (((uint16)(x) & 0xff00U) >> 8) ))
#define swab32(x) \
        ((uint32)( \
                (((uint32)(x) & (uint32)0x000000ffUL) << 24) | \
                (((uint32)(x) & (uint32)0x0000ff00UL) <<  8) | \
                (((uint32)(x) & (uint32)0x00ff0000UL) >>  8) | \
                (((uint32)(x) & (uint32)0xff000000UL) >> 24) ))
#define swab64(x) \
        ((uint64)( \
                (uint64)(((uint64)(x) & (uint64)0x00000000000000ffULL) << 56) | \
                (uint64)(((uint64)(x) & (uint64)0x000000000000ff00ULL) << 40) | \
                (uint64)(((uint64)(x) & (uint64)0x0000000000ff0000ULL) << 24) | \
                (uint64)(((uint64)(x) & (uint64)0x00000000ff000000ULL) <<  8) | \
                (uint64)(((uint64)(x) & (uint64)0x000000ff00000000ULL) >>  8) | \
                (uint64)(((uint64)(x) & (uint64)0x0000ff0000000000ULL) >> 24) | \
                (uint64)(((uint64)(x) & (uint64)0x00ff000000000000ULL) >> 40) | \
                (uint64)(((uint64)(x) & (uint64)0xff00000000000000ULL) >> 56) ))

#define swab16p(x) swab16(*(x))
#define swab32p(x) swab32(*(x))
#define swab64p(x) swab64(*(x))

#define swab16s(x) do { *(x) = swab16p((x)); } while (0)
#define swab32s(x) do { *(x) = swab32p((x)); } while (0)
#define swab64s(x) do { *(x) = swab64p((x)); } while (0)



#if __BYTE_ORDER == __LITTLE_ENDIAN 

#define be16_to_cpus(x) swab16s(x)
#define be32_to_cpus(x) swab32s(x)
#define be64_to_cpus(x) swab64s(x)

#define cpu_to_be16s(x) swab16s(x)
#define cpu_to_be32s(x) swab32s(x)
#define cpu_to_be64s(x) swab64s(x)

#define cpu_to_be16p(x) swab16p(x)
#define cpu_to_be32p(x) swab32p(x)
#define cpu_to_be64p(x) swab64p(x)

#define be16_to_cpup(x) swab16p(x)
#define be32_to_cpup(x) swab32p(x)
#define be64_to_cpup(x) swab64p(x)

#define cpu_to_be16(x) swab16(x)
#define cpu_to_be32(x) swab32(x)
#define cpu_to_be64(x) swab64(x)

#define be16_to_cpu(x) swab16(x)
#define be32_to_cpu(x) swab32(x)
#define be64_to_cpu(x) swab64(x)

#define le16_to_cpus(x) (x)
#define le32_to_cpus(x) (x)
#define le64_to_cpus(x) (x)

#define cpu_to_le16s(x) (x)
#define cpu_to_le32s(x) (x)
#define cpu_to_le64s(x) (x)

#define cpu_to_le16p(x) (*(x))
#define cpu_to_le32p(x) (*(x))
#define cpu_to_le64p(x) (*(x))

#define le16_to_cpup(x) (*(x))
#define le32_to_cpup(x) (*(x))
#define le64_to_cpup(x) (*(x))

#define cpu_to_le16(x) (x)
#define cpu_to_le32(x) (x)
#define cpu_to_le64(x) (x)

#define le16_to_cpu(x) (x)
#define le32_to_cpu(x) (x)
#define le64_to_cpu(x) (x)

#else  /*  __BYTE_ORDER == __LITTLE_ENDIAN  */

#define be16_to_cpus(x) (x)
#define be32_to_cpus(x) (x)
#define be64_to_cpus(x) (x)

#define cpu_to_be16s(x) (x)
#define cpu_to_be32s(x) (x)
#define cpu_to_be64s(x) (x)

#define cpu_to_be16p(x) (*(x))
#define cpu_to_be32p(x) (*(x))
#define cpu_to_be64p(x) (*(x))

#define be16_to_cpup(x) (*(x))
#define be32_to_cpup(x) (*(x))
#define be64_to_cpup(x) (*(x))

#define cpu_to_be16(x) (x)
#define cpu_to_be32(x) (x)
#define cpu_to_be64(x) (x)

#define be16_to_cpu(x) (x)
#define be32_to_cpu(x) (x)
#define be64_to_cpu(x) (x)

#define le16_to_cpus(x) swab16s(x)
#define le32_to_cpus(x) swab32s(x)
#define le64_to_cpus(x) swab64s(x)

#define cpu_to_le16s(x) swab16s(x)
#define cpu_to_le32s(x) swab32s(x)
#define cpu_to_le64s(x) swab64s(x)

#define cpu_to_le16p(x) swab16p(x)
#define cpu_to_le32p(x) swab32p(x)
#define cpu_to_le64p(x) swab64p(x)

#define le16_to_cpup(x) swab16p(x)
#define le32_to_cpup(x) swab32p(x)
#define le64_to_cpup(x) swab64p(x)

#define cpu_to_le16(x) swab16(x)
#define cpu_to_le32(x) swab32(x)
#define cpu_to_le64(x) swab64(x)

#define le16_to_cpu(x) swab16(x)
#define le32_to_cpu(x) swab32(x)
#define le64_to_cpu(x) swab64(x)

#endif  /*  __BYTE_ORDER == __LITTLE_ENDIAN  */

#endif /* _OSI_ENDIAN_H  */
