/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or 
 *   (at your option) any later version.
 * 
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software 
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 */ 

/**
 *	struct plugin_func_info - information needed to start a plugin specific task
 *	@handle: the handle of the reference object
 *	@info: a copy of the function_info_t originally provided by the plugin
 *
 *	This structure is dynamically allocated and contains a copy of one
 *	function_info_t from the array returned from a call to evms_get_plugin_functions().
 */
struct plugin_func_info {
	object_handle_t handle;
	function_info_t info;
};

void append_plugin_function_menu_items(struct popup_menu *menu, object_handle_t handle);
struct selwin * create_plugin_selection_window(char *title, evms_plugin_code_t type, 
				gboolean support_containers, task_action_t action);
void process_plugin_task(char *title, evms_plugin_code_t type, gboolean support_containers,
				task_action_t action);
plugin_handle_t get_parent_plugin_for_object(object_handle_t object);
plugin_type_t get_parent_plugin_type(object_handle_t object);
inline char *get_parent_plugin_type_string(object_handle_t object, gboolean lowercase);
int actions_show_things_with_plugin_funcs_menuitem_activated(struct menu_item *item);
