/*
 *
 *   (C) Copyright IBM Corp. 2002, 2003
 *
 *   This program is free software;  you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY;  without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See
 *   the GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program;  if not, write to the Free Software
 *   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 *
 * Module: dmonmsg.h
 */

#include <byteswap.h>


#ifndef EVMS_DMONMSG2_H_INCLUDED
#define EVMS_DMONMSG2_H_INCLUDED 1

#define EVMS_DMONMSG_MAJOR_VERSION	5
#define EVMS_DMONMSG_MINOR_VERSION	1
#define EVMS_DMONMSG_PATCH_LEVEL	0
				
/*
 * Macros for putting information on the network.
 * Network protocol is big endian format.  These macros can be used to access
 * the fields of stuff on the network regardless of the endianness of the host
 * architecture.
 */
#if __BYTE_ORDER == __BIG_ENDIAN
#define NET_TO_HOST16(x)    (x)
#define NET_TO_HOST32(x)    (x)
#define NET_TO_HOST64(x)    (x)

#define HOST_TO_NET16(x)    (x)
#define HOST_TO_NET32(x)    (x)
#define HOST_TO_NET64(x)    (x)

#elif __BYTE_ORDER == __LITTLE_ENDIAN
#define NET_TO_HOST16(x)    (bswap_16(x))
#define NET_TO_HOST32(x)    (bswap_32(x))
#define NET_TO_HOST64(x)    (bswap_64(x))

#define HOST_TO_NET16(x)    (bswap_16(x))
#define HOST_TO_NET32(x)    (bswap_32(x))
#define HOST_TO_NET64(x)    (bswap_64(x))

#else
#error "__BYTE_ORDER must be defined as __LITTLE_ENDIAN or __BIG_ENDIAN"

#endif

typedef enum {
	MSG_GET_VERSION = 1,                            //   1  0x01
								
	EVMS_GET_API_VERSION,                           //   2  0x02
	EVMS_OPEN_ENGINE,                               //   3  0x03
	EVMS_GET_PLUGIN_LIST,                           //   4  0x04
	EVMS_GET_PLUGIN_BY_ID,                          //   5  0x05
	EVMS_GET_PLUGIN_BY_NAME,                        //   6  0x06
	EVMS_CHANGES_PENDING,                           //   7  0x07
	EVMS_WRITE_LOG_ENTRY,                           //   8  0x08
	EVMS_GET_DEBUG_LEVEL,                           //   9  0x09
	EVMS_SET_DEBUG_LEVEL,                           //  10  0x0a
	EVMS_COMMIT_CHANGES,                            //  11  0x0b
	EVMS_CLOSE_ENGINE,                              //  12  0x0c
	EVMS_CAN_DELETE,                                //  13  0x0d
	EVMS_CAN_DESTROY,                               //  14  0x0e
	EVMS_CAN_EXPAND,                                //  15  0x0f
	EVMS_CAN_SHRINK,                                //  16  0x10
	EVMS_CAN_REPLACE,                               //  17  0x11
	EVMS_CAN_SET_INFO,                              //  18  0x12
	EVMS_DELETE,                                    //  19  0x13
	EVMS_DESTROY,                                   //  20  0x14
	EVMS_GET_EXPAND_POINTS,                         //  21  0x15
	EVMS_EXPAND,                                    //  22  0x16
	EVMS_GET_SHRINK_POINTS,                         //  23  0x17
	EVMS_SHRINK,                                    //  24  0x18
	EVMS_REPLACE,                                   //  25  0x19
	EVMS_GET_HANDLE_OBJECT_TYPE,                    //  26  0x1a
	EVMS_GET_INFO,                                  //  27  0x1b
	EVMS_GET_EXTENDED_INFO,                         //  28  0x1c
	EVMS_SET_INFO,                                  //  29  0x1d
	EVMS_GET_OBJECT_HANDLE_FOR_NAME,                //  30  0x1e
	EVMS_GET_FEATURE_LIST,                          //  31  0x1f
	EVMS_CREATE,                                    //  32  0x20
	EVMS_ASSIGN,                                    //  33  0x21
	EVMS_CAN_UNASSIGN,                              //  34  0x22
	EVMS_UNASSIGN,                                  //  35  0x23
	EVMS_GET_OBJECT_LIST,                           //  36  0x24
	EVMS_GET_PLUGIN_FUNCTIONS,                      //  37  0x25
	EVMS_DO_PLUGIN_FUNCTION,                        //  38  0x26
	EVMS_CAN_CREATE_VOLUME,                         //  39  0x27
	EVMS_CAN_CREATE_COMPATIBILITY_VOLUME,           //  40  0x28
	EVMS_CAN_SET_VOLUME_NAME,                       //  41  0x29
	EVMS_CAN_CONVERT_TO_EVMS_VOLUME,                //  42  0x2a
	EVMS_CAN_CONVERT_TO_COMPATIBILITY_VOLUME,	//  43  0x2b
	EVMS_CAN_ADD_FEATURE_TO_VOLUME,                 //  44  0x2c
	EVMS_CREATE_VOLUME,                             //  45  0x2d
	EVMS_SET_VOLUME_NAME,                           //  46  0x2e
	EVMS_CREATE_COMPATIBILITY_VOLUME,               //  47  0x3f
	EVMS_CONVERT_TO_EVMS_VOLUME,                    //  48  0x30
	EVMS_CONVERT_TO_COMPATIBILITY_VOLUME,           //  59  0x31
	EVMS_ADD_FEATURE_TO_VOLUME,                     //  50  0x32
	EVMS_CAN_MKFS,                                  //  51  0x33
	EVMS_CAN_UNMKFS,                                //  52  0x34
	EVMS_CAN_FSCK,                                  //  53  0x35
	EVMS_MKFS,      				//  54  0x36
	EVMS_UNMKFS,                                    //  55  0x37
	EVMS_FSCK,                                      //  56  0x38
	EVMS_GET_VOLUME_LIST,                           //  57  0x39
	EVMS_CAN_MOUNT,                         	//  58  0x3a
	EVMS_MOUNT,                                     //  59  0x3b
	EVMS_CAN_UNMOUNT,                               //  60  0x3c
	EVMS_UNMOUNT,                                   //  61  0x3d
	EVMS_CAN_REMOUNT,                               //  62  0x3e
	EVMS_REMOUNT,                                   //  63  0x4f
	EVMS_CREATE_CONTAINER,                          //  64  0x40
	EVMS_GET_CONTAINER_LIST,                        //  65  0x41
	EVMS_CREATE_TASK,                               //  66  0x42
	EVMS_INVOKE_TASK,                               //  67  0x43
	EVMS_DESTROY_TASK,                              //  68  0x44
	EVMS_GET_TASK_ACTION,                           //  79  0x45
	EVMS_GET_ACCEPTABLE_OBJECTS,                    //  70  0x46
	EVMS_GET_SELECTED_OBJECTS,                      //  71  0x47
	EVMS_GET_SELECTED_OBJECT_LIMITS,                //  72  0x48
	EVMS_SET_SELECTED_OBJECTS,                      //  73  0x49
	EVMS_GET_OPTION_COUNT,                          //  74  0x4a
	EVMS_GET_OPTION_DESCRIPTOR,                     //  75  0x4b
	EVMS_SET_OPTION_VALUE,                          //  76  0x4c
	EVMS_GET_OPTION_DESCRIPTOR_BY_NAME,             //  77  0x4d
	EVMS_SET_OPTION_VALUE_BY_NAME,                  //  78  0x4e
	EVMS_MARK_FOR_REDISCOVER,                       //  79  0x4f
	EVMS_REDISCOVER,                                //  80  0x50
	USER_MESSAGE,                                   //  81  0x51
	PROGRESS,                                       //  82  0x52
	STATUS,                                         //  83  0x53
	SHUTDOWN,                                       //  84  0x54
	EVMS_CAN_ACTIVATE,                              //  85  0x55
	EVMS_ACTIVATE,                                  //  86  0x56
	EVMS_CAN_DEACTIVATE,                            //  87  0x57
	EVMS_DEACTIVATE,                                //  88  0x58
	EVMS_METADATA_BACKUP,                           //  89  0x59
	EVMS_ENGINE_READ,                               //  90  0x5a
	EVMS_ENGINE_WRITE,                              //  91  0x5b
	INVALID_COMMAND,                                //  92  0x5c

	MSG_INVALID_CMD         = 0x7fffffff
} msg_cmd_t;

#define COMMAND_RESPONSE	0x80000000
#define COMMAND_MASK		~COMMAND_RESPONSE


inline static char * msg_cmd_name(msg_cmd_t cmd) {
	switch (cmd & COMMAND_MASK) {
		case MSG_GET_VERSION:
			return "MSG_GET_VERSION";
		case EVMS_GET_API_VERSION:
			return "EVMS_GET_API_VERSION";
		case EVMS_OPEN_ENGINE:
			return "EVMS_OPEN_ENGINE";
		case EVMS_GET_PLUGIN_LIST:
			return "EVMS_GET_PLUGIN_LIST";
		case EVMS_GET_PLUGIN_BY_ID:
			return "EVMS_GET_PLUGIN_BY_ID";
		case EVMS_GET_PLUGIN_BY_NAME:
			return "EVMS_GET_PLUGIN_BY_NAME";
		case EVMS_CHANGES_PENDING:
			return "EVMS_CHANGES_PENDING";
		case EVMS_WRITE_LOG_ENTRY:
			return "EVMS_WRITE_LOG_ENTRY";
		case EVMS_GET_DEBUG_LEVEL:
			return "EVMS_GET_DEBUG_LEVEL";
		case EVMS_SET_DEBUG_LEVEL:
			return "EVMS_SET_DEBUG_LEVEL";
		case EVMS_COMMIT_CHANGES:
			return "EVMS_COMMIT_CHANGES";
		case EVMS_CLOSE_ENGINE:
			return "EVMS_CLOSE_ENGINE";
		case EVMS_CAN_DELETE:
			return "EVMS_CAN_DELETE";
		case EVMS_CAN_DESTROY:
			return "EVMS_CAN_DESTROY";
		case EVMS_CAN_EXPAND:
			return "EVMS_CAN_EXPAND";
		case EVMS_CAN_SHRINK:
			return "EVMS_CAN_SHRINK";
		case EVMS_CAN_REPLACE:
			return "EVMS_CAN_REPLACE";
		case EVMS_CAN_SET_INFO:
			return "EVMS_CAN_SET_INFO";
		case EVMS_DELETE:
			return "EVMS_DELETE";
		case EVMS_DESTROY:
			return "EVMS_DESTROY";
		case EVMS_GET_EXPAND_POINTS:
			return "EVMS_GET_EXPAND_POINTS";
		case EVMS_EXPAND:
			return "EVMS_EXPAND";
		case EVMS_GET_SHRINK_POINTS:
			return "EVMS_GET_SHRINK_POINTS";
		case EVMS_SHRINK:
			return "EVMS_SHRINK";
		case EVMS_REPLACE:
			return "EVMS_REPLACE";
		case EVMS_GET_HANDLE_OBJECT_TYPE:
			return "EVMS_GET_HANDLE_OBJECT_TYPE";
		case EVMS_GET_INFO:
			return "EVMS_GET_INFO";
		case EVMS_GET_EXTENDED_INFO:
			return "EVMS_GET_EXTENDED_INFO";
		case EVMS_SET_INFO:
			return "EVMS_SET_INFO";
		case EVMS_GET_OBJECT_HANDLE_FOR_NAME:
			return "EVMS_GET_OBJECT_HANDLE_FOR_NAME";
		case EVMS_GET_FEATURE_LIST:
			return "EVMS_GET_FEATURE_LIST";
		case EVMS_CREATE:
			return "EVMS_CREATE";
		case EVMS_ASSIGN:
			return "EVMS_ASSIGN";
		case EVMS_CAN_UNASSIGN:
			return "EVMS_CAN_UNASSIGN";
		case EVMS_UNASSIGN:
			return "EVMS_UNASSIGN";
		case EVMS_GET_OBJECT_LIST:
			return "EVMS_GET_OBJECT_LIST";
		case EVMS_GET_PLUGIN_FUNCTIONS:
			return "EVMS_GET_PLUGIN_FUNCTIONS";
		case EVMS_DO_PLUGIN_FUNCTION:
			return "EVMS_DO_PLUGIN_FUNCTION";
		case EVMS_CAN_CREATE_VOLUME:
			return "EVMS_CAN_CREATE_VOLUME";
		case EVMS_CAN_CREATE_COMPATIBILITY_VOLUME:
			return "EVMS_CAN_CREATE_COMPATIBILITY_VOLUME";
		case EVMS_CAN_SET_VOLUME_NAME:
			return "EVMS_CAN_SET_VOLUME_NAME";
		case EVMS_CAN_CONVERT_TO_EVMS_VOLUME:
			return "EVMS_CAN_CONVERT_TO_EVMS_VOLUME";
		case EVMS_CAN_CONVERT_TO_COMPATIBILITY_VOLUME:
			return "EVMS_CAN_CONVERT_TO_COMPATIBILITY_VOLUME";
		case EVMS_CAN_ADD_FEATURE_TO_VOLUME:
			return "EVMS_CAN_ADD_FEATURE_TO_VOLUME";
		case EVMS_CREATE_VOLUME:
			return "EVMS_CREATE_VOLUME";
		case EVMS_SET_VOLUME_NAME:
			return "EVMS_SET_VOLUME_NAME";
		case EVMS_CREATE_COMPATIBILITY_VOLUME:
			return "EVMS_CREATE_COMPATIBILITY_VOLUME";
		case EVMS_CONVERT_TO_EVMS_VOLUME:
			return "EVMS_CONVERT_TO_EVMS_VOLUME";
		case EVMS_CONVERT_TO_COMPATIBILITY_VOLUME:
			return "EVMS_CONVERT_TO_COMPATIBILITY_VOLUME";
		case EVMS_ADD_FEATURE_TO_VOLUME:
			return "EVMS_ADD_FEATURE_TO_VOLUME";
		case EVMS_CAN_MKFS:
			return "EVMS_CAN_MKFS";
		case EVMS_CAN_UNMKFS:
			return "EVMS_CAN_UNMKFS";
		case EVMS_CAN_FSCK:
			return "EVMS_CAN_FSCK";
		case EVMS_MKFS:
			return "EVMS_MKFS";
		case EVMS_UNMKFS:
			return "EVMS_UNMKFS";
		case EVMS_FSCK:
			return "EVMS_FSCK";
		case EVMS_GET_VOLUME_LIST:
			return "EVMS_GET_VOLUME_LIST";
		case EVMS_CAN_MOUNT:
			return "EVMS_CAN_MOUNT";
		case EVMS_MOUNT:
			return "EVMS_MOUNT";
		case EVMS_CAN_UNMOUNT:
			return "EVMS_CAN_UNMOUNT";
		case EVMS_UNMOUNT:
			return "EVMS_UNMOUNT";
		case EVMS_CAN_REMOUNT:
			return "EVMS_CAN_REMOUNT";
		case EVMS_REMOUNT:
			return "EVMS_REMOUNT";
		case EVMS_CREATE_CONTAINER:
			return "EVMS_CREATE_CONTAINER";
		case EVMS_GET_CONTAINER_LIST:
			return "EVMS_GET_CONTAINER_LIST";
		case EVMS_CREATE_TASK:
			return "EVMS_CREATE_TASK";
		case EVMS_INVOKE_TASK:
			return "EVMS_INVOKE_TASK";
		case EVMS_DESTROY_TASK:
			return "EVMS_DESTROY_TASK";
		case EVMS_GET_TASK_ACTION:
			return "EVMS_GET_TASK_ACTION";
		case EVMS_GET_ACCEPTABLE_OBJECTS:
			return "EVMS_GET_ACCEPTABLE_OBJECTS";
		case EVMS_GET_SELECTED_OBJECTS:
			return "EVMS_GET_SELECTED_OBJECTS";
		case EVMS_GET_SELECTED_OBJECT_LIMITS:
			return "EVMS_GET_SELECTED_OBJECT_LIMITS";
		case EVMS_SET_SELECTED_OBJECTS:
			return "EVMS_SET_SELECTED_OBJECTS";
		case EVMS_GET_OPTION_COUNT:
			return "EVMS_GET_OPTION_COUNT";
		case EVMS_GET_OPTION_DESCRIPTOR:
			return "EVMS_GET_OPTION_DESCRIPTOR";
		case EVMS_SET_OPTION_VALUE:
			return "EVMS_SET_OPTION_VALUE";
		case EVMS_GET_OPTION_DESCRIPTOR_BY_NAME:
			return "EVMS_GET_OPTION_DESCRIPTOR_BY_NAME";
		case EVMS_SET_OPTION_VALUE_BY_NAME:
			return "EVMS_SET_OPTION_VALUE_BY_NAME";
		case EVMS_MARK_FOR_REDISCOVER:
			return "EVMS_MARK_FOR_REDISCOVER";
		case EVMS_REDISCOVER:
			return "EVMS_REDISCOVER";
		case USER_MESSAGE:
			return "USER_MESSAGE";
		case PROGRESS:
			return "PROGRESS";
		case STATUS:
			return "STATUS";
		case SHUTDOWN:
			return "SHUTDOWN";
		case MSG_INVALID_CMD:
			return "MSG_INVALID_CMD ";
		case EVMS_CAN_ACTIVATE:
			return "EVMS_CAN_ACTIVATE";
		case EVMS_ACTIVATE:
			return "EVMS_ACTIVATE";
		case EVMS_CAN_DEACTIVATE:
			return "EVMS_CAN_DEACTIVATE";
		case EVMS_DEACTIVATE:
			return "EVMS_DEACTIVATE";
		case EVMS_METADATA_BACKUP:
			return "EVMS_METADATA_BACKUP";
		case EVMS_ENGINE_READ:
			return "EVMS_ENGINE_READ";
		case EVMS_ENGINE_WRITE:
			return "EVMS_ENGINE_WRITE";
		default:
			return "invalid command";
	}
}


typedef struct msg_hdr_s {
	u_int32_t signature;
	u_int32_t cmd;
	u_int32_t size;
} msg_hdr_t;

#define MSG_HDR_SIG	0x534D5645	/* "evms" */


int evms_mark_for_rediscover(char * name);

#define evms_mark_for_rediscover_args_f string_f

#define evms_mark_for_rediscover_rets_f int_f

int evms_rediscover(void);

#define evms_rediscover_args_f ""

#define evms_rediscover_rets_f int_f

extern int evms_engine_read(object_handle_t handle,
			    lsn_t           lsn,
			    sector_count_t  length,
			    void          * buffer);

#define evms_engine_read_args_f		object_handle_f	\
					lsn_f		\
					sector_count_f
						
#define evms_engine_read_rets_f int_f
/* User must concatenate "p{x<read-size>}" to the end of evms_engine_read_rets_f. */

extern int evms_engine_write(object_handle_t handle,
			     lsn_t           lsn,
			     sector_count_t  length,
			     void          * buffer);

#define evms_engine_write_args_f	object_handle_f	\
					lsn_f		\
					sector_count_f
/* User must concatenate "p{x<write-size>}" to the end of evms_engine_write_args_f. */
						
#define evms_engine_write_rets_f	int_f

#endif
