/*
 * Copyright (c) 2003, 2006 Matteo Frigo
 * Copyright (c) 2003, 2006 Massachusetts Institute of Technology
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 */

/* This file was automatically generated --- DO NOT EDIT */
/* Generated on Tue Mar  7 11:38:31 EST 2006 */

#include "codelet-rdft.h"

#ifdef HAVE_FMA

/* Generated by: ../../../genfft/gen_hc2hc -fma -reorder-insns -schedule-for-pipeline -compact -variables 4 -pipeline-latency 4 -sign 1 -n 10 -dif -name hb_10 -include hb.h */

/*
 * This function contains 102 FP additions, 72 FP multiplications,
 * (or, 48 additions, 18 multiplications, 54 fused multiply/add),
 * 73 stack variables, and 40 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_10(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP618033988, +0.618033988749894848204586834365638117720309180);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 18, MAKE_VOLATILE_STRIDE(ios)) {
	  E T22, T27, T24, T1Z, T28, T23;
	  {
	       E T1H, TP, Tk, T3, T21, T1D, T1M, T1K, TU, TS, T19, TJ, T7, Tq, TX;
	       E T1O, Th, Tl, T6, T8, TN, TO;
	       TN = iio[0];
	       TO = rio[WS(ios, 5)];
	       {
		    E T1A, Tx, TC, T1y, TH, T1B, TA, TD;
		    {
			 E TF, TG, Tv, Tw, Ty, Tz;
			 Tv = iio[-WS(ios, 2)];
			 Tw = rio[WS(ios, 7)];
			 TF = rio[WS(ios, 6)];
			 T1H = TN - TO;
			 TP = TN + TO;
			 T1A = Tv - Tw;
			 Tx = Tv + Tw;
			 TG = iio[-WS(ios, 1)];
			 Ty = rio[WS(ios, 8)];
			 Tz = iio[-WS(ios, 3)];
			 TC = iio[-WS(ios, 4)];
			 T1y = TG - TF;
			 TH = TF + TG;
			 T1B = Tz - Ty;
			 TA = Ty + Tz;
			 TD = rio[WS(ios, 9)];
		    }
		    {
			 E T1, T1C, T1I, TQ, TB, T1x, TE, T2;
			 T1 = rio[0];
			 T1C = T1A - T1B;
			 T1I = T1A + T1B;
			 TQ = Tx - TA;
			 TB = Tx + TA;
			 T1x = TC - TD;
			 TE = TC + TD;
			 T2 = iio[-WS(ios, 5)];
			 {
			      E Tb, Tc, Te, Tf;
			      Tb = rio[WS(ios, 4)];
			      {
				   E T1z, T1J, TR, TI;
				   T1z = T1x - T1y;
				   T1J = T1x + T1y;
				   TR = TE - TH;
				   TI = TE + TH;
				   Tk = T1 - T2;
				   T3 = T1 + T2;
				   T21 = FMA(KP618033988, T1z, T1C);
				   T1D = FNMS(KP618033988, T1C, T1z);
				   T1M = T1I - T1J;
				   T1K = T1I + T1J;
				   TU = TQ - TR;
				   TS = TQ + TR;
				   T19 = FNMS(KP618033988, TB, TI);
				   TJ = FMA(KP618033988, TI, TB);
				   Tc = iio[-WS(ios, 9)];
			      }
			      Te = iio[-WS(ios, 6)];
			      Tf = rio[WS(ios, 1)];
			      {
				   E T4, To, Td, Tp, Tg, T5;
				   T4 = rio[WS(ios, 2)];
				   To = Tb - Tc;
				   Td = Tb + Tc;
				   Tp = Te - Tf;
				   Tg = Te + Tf;
				   T5 = iio[-WS(ios, 7)];
				   T7 = iio[-WS(ios, 8)];
				   Tq = To + Tp;
				   TX = To - Tp;
				   T1O = Td - Tg;
				   Th = Td + Tg;
				   Tl = T4 - T5;
				   T6 = T4 + T5;
				   T8 = rio[WS(ios, 3)];
			      }
			 }
		    }
	       }
	       {
		    E T1r, T1P, T1v, T1o, T1u, T1f, T1c, T17, T1g, T1b, TT, Tm, T9, T1n, T1q;
		    T1r = TP + TS;
		    TT = FNMS(KP250000000, TS, TP);
		    Tm = T7 - T8;
		    T9 = T7 + T8;
		    {
			 E TM, T15, TZ, Tj, T1l, T1k, T1i, T1a, T12, TK, T1m, T1h;
			 {
			      E T1d, T1e, T18, Tu;
			      {
				   E Tt, Ts, TV, Tn, TW;
				   TM = W[17];
				   TV = FMA(KP559016994, TU, TT);
				   T1d = FNMS(KP559016994, TU, TT);
				   Tn = Tl + Tm;
				   TW = Tl - Tm;
				   {
					E Ta, TY, Tr, Ti;
					Ta = T6 + T9;
					T1P = T6 - T9;
					TY = FMA(KP618033988, TX, TW);
					T1e = FNMS(KP618033988, TW, TX);
					Tt = Tn - Tq;
					Tr = Tn + Tq;
					T1v = Ta - Th;
					Ti = Ta + Th;
					T15 = FMA(KP951056516, TY, TV);
					TZ = FNMS(KP951056516, TY, TV);
					Ts = FNMS(KP250000000, Tr, Tk);
					T1o = Tk + Tr;
					rio[0] = T3 + Ti;
					T1u = FNMS(KP250000000, Ti, T3);
				   }
				   Tj = W[16];
				   T18 = FNMS(KP559016994, Tt, Ts);
				   Tu = FMA(KP559016994, Tt, Ts);
			      }
			      T1l = FMA(KP951056516, T1e, T1d);
			      T1f = FNMS(KP951056516, T1e, T1d);
			      T1k = W[5];
			      T1i = FNMS(KP951056516, T19, T18);
			      T1a = FMA(KP951056516, T19, T18);
			      T12 = FNMS(KP951056516, TJ, Tu);
			      TK = FMA(KP951056516, TJ, Tu);
			      T1m = T1k * T1i;
			      T1h = W[4];
			 }
			 {
			      E T14, T11, TL, T10, T1j, T16, T13;
			      TL = Tj * TK;
			      T10 = TM * TK;
			      iio[-WS(ios, 6)] = FMA(T1h, T1l, T1m);
			      T1j = T1h * T1i;
			      rio[WS(ios, 9)] = FNMS(TM, TZ, TL);
			      iio[0] = FMA(Tj, TZ, T10);
			      T14 = W[1];
			      rio[WS(ios, 3)] = FNMS(T1k, T1l, T1j);
			      T11 = W[0];
			      T16 = T14 * T12;
			      T1c = W[13];
			      T13 = T11 * T12;
			      T17 = W[12];
			      iio[-WS(ios, 8)] = FMA(T11, T15, T16);
			      T1g = T1c * T1a;
			      rio[WS(ios, 1)] = FNMS(T14, T15, T13);
			      T1b = T17 * T1a;
			 }
		    }
		    iio[-WS(ios, 9)] = T1H + T1K;
		    iio[-WS(ios, 2)] = FMA(T17, T1f, T1g);
		    rio[WS(ios, 7)] = FNMS(T1c, T1f, T1b);
		    T1n = W[8];
		    T1q = W[9];
		    {
			 E T1Q, T26, T20, T1U, T1E, T1N, T25;
			 T1Q = FNMS(KP618033988, T1P, T1O);
			 T26 = FMA(KP618033988, T1O, T1P);
			 {
			      E T1p, T1s, T1w, T1L;
			      T1p = T1n * T1o;
			      T1s = T1q * T1o;
			      T1w = FNMS(KP559016994, T1v, T1u);
			      T20 = FMA(KP559016994, T1v, T1u);
			      T1L = FNMS(KP250000000, T1K, T1H);
			      rio[WS(ios, 5)] = FNMS(T1q, T1r, T1p);
			      iio[-WS(ios, 4)] = FMA(T1n, T1r, T1s);
			      T1U = FMA(KP951056516, T1D, T1w);
			      T1E = FNMS(KP951056516, T1D, T1w);
			      T1N = FNMS(KP559016994, T1M, T1L);
			      T25 = FMA(KP559016994, T1M, T1L);
			 }
			 {
			      E T1X, T2a, T2d, T2c, T29, T2e;
			      {
				   E T1G, T1R, T1t, T1S, T1F;
				   T1G = W[15];
				   T1R = FMA(KP951056516, T1Q, T1N);
				   T1X = FNMS(KP951056516, T1Q, T1N);
				   T1t = W[14];
				   T2a = FMA(KP951056516, T21, T20);
				   T22 = FNMS(KP951056516, T21, T20);
				   T1S = T1G * T1E;
				   T1F = T1t * T1E;
				   T2d = FNMS(KP951056516, T26, T25);
				   T27 = FMA(KP951056516, T26, T25);
				   T2c = W[7];
				   iio[-WS(ios, 1)] = FMA(T1t, T1R, T1S);
				   rio[WS(ios, 8)] = FNMS(T1G, T1R, T1F);
				   T29 = W[6];
				   T2e = T2c * T2a;
			      }
			      {
				   E T1W, T1T, T1Y, T2b, T1V;
				   T1W = W[3];
				   T2b = T29 * T2a;
				   iio[-WS(ios, 5)] = FMA(T29, T2d, T2e);
				   T1T = W[2];
				   T1Y = T1W * T1U;
				   rio[WS(ios, 4)] = FNMS(T2c, T2d, T2b);
				   T1V = T1T * T1U;
				   iio[-WS(ios, 7)] = FMA(T1T, T1X, T1Y);
				   T24 = W[11];
				   T1Z = W[10];
				   rio[WS(ios, 2)] = FNMS(T1W, T1X, T1V);
			      }
			 }
		    }
	       }
	  }
	  T28 = T24 * T22;
	  T23 = T1Z * T22;
	  iio[-WS(ios, 3)] = FMA(T1Z, T27, T28);
	  rio[WS(ios, 6)] = FNMS(T24, T27, T23);
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 10},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 10, "hb_10", twinstr, &GENUS, {48, 18, 54, 0}, 0, 0, 0 };

void X(codelet_hb_10) (planner *p) {
     X(khc2hc_register) (p, hb_10, &desc);
}
#else				/* HAVE_FMA */

/* Generated by: ../../../genfft/gen_hc2hc -compact -variables 4 -pipeline-latency 4 -sign 1 -n 10 -dif -name hb_10 -include hb.h */

/*
 * This function contains 102 FP additions, 60 FP multiplications,
 * (or, 72 additions, 30 multiplications, 30 fused multiply/add),
 * 39 stack variables, and 40 memory accesses
 */
/*
 * Generator Id's : 
 * $Id: algsimp.ml,v 1.9 2006-02-12 23:34:12 athena Exp $
 * $Id: fft.ml,v 1.4 2006-01-05 03:04:27 stevenj Exp $
 * $Id: gen_hc2hc.ml,v 1.16 2006-02-12 23:34:12 athena Exp $
 */

#include "hb.h"

static const R *hb_10(R *rio, R *iio, const R *W, stride ios, INT m, INT dist)
{
     DK(KP250000000, +0.250000000000000000000000000000000000000000000);
     DK(KP951056516, +0.951056516295153572116439333379382143405698634);
     DK(KP587785252, +0.587785252292473129168705954639072768597652438);
     DK(KP559016994, +0.559016994374947424102293417182819058860154590);
     INT i;
     for (i = m - 2; i > 0; i = i - 2, rio = rio + dist, iio = iio - dist, W = W + 18, MAKE_VOLATILE_STRIDE(ios)) {
	  E T3, Tk, Tw, T1w, TO, TP, T1E, T1D, Tr, TX, Ti, T1l, TZ, T10, T1s;
	  E T1p, T1z, T1B, TL, TS;
	  {
	       E T1, T2, Tu, Tv;
	       T1 = rio[0];
	       T2 = iio[-WS(ios, 5)];
	       T3 = T1 + T2;
	       Tk = T1 - T2;
	       Tu = iio[0];
	       Tv = rio[WS(ios, 5)];
	       Tw = Tu + Tv;
	       T1w = Tu - Tv;
	  }
	  {
	       E T6, Tl, Tg, Tp, T9, Tm, Td, To;
	       {
		    E T4, T5, Te, Tf;
		    T4 = rio[WS(ios, 2)];
		    T5 = iio[-WS(ios, 7)];
		    T6 = T4 + T5;
		    Tl = T4 - T5;
		    Te = iio[-WS(ios, 6)];
		    Tf = rio[WS(ios, 1)];
		    Tg = Te + Tf;
		    Tp = Te - Tf;
	       }
	       {
		    E T7, T8, Tb, Tc;
		    T7 = iio[-WS(ios, 8)];
		    T8 = rio[WS(ios, 3)];
		    T9 = T7 + T8;
		    Tm = T7 - T8;
		    Tb = rio[WS(ios, 4)];
		    Tc = iio[-WS(ios, 9)];
		    Td = Tb + Tc;
		    To = Tb - Tc;
	       }
	       TO = Tl - Tm;
	       TP = To - Tp;
	       T1E = Td - Tg;
	       T1D = T6 - T9;
	       {
		    E Tn, Tq, Ta, Th;
		    Tn = Tl + Tm;
		    Tq = To + Tp;
		    Tr = Tn + Tq;
		    TX = KP559016994 * (Tn - Tq);
		    Ta = T6 + T9;
		    Th = Td + Tg;
		    Ti = Ta + Th;
		    T1l = KP559016994 * (Ta - Th);
	       }
	  }
	  {
	       E Tz, T1n, TJ, T1r, TC, T1o, TG, T1q;
	       {
		    E Tx, Ty, TH, TI;
		    Tx = iio[-WS(ios, 2)];
		    Ty = rio[WS(ios, 7)];
		    Tz = Tx + Ty;
		    T1n = Tx - Ty;
		    TH = rio[WS(ios, 6)];
		    TI = iio[-WS(ios, 1)];
		    TJ = TH + TI;
		    T1r = TI - TH;
	       }
	       {
		    E TA, TB, TE, TF;
		    TA = rio[WS(ios, 8)];
		    TB = iio[-WS(ios, 3)];
		    TC = TA + TB;
		    T1o = TB - TA;
		    TE = iio[-WS(ios, 4)];
		    TF = rio[WS(ios, 9)];
		    TG = TE + TF;
		    T1q = TE - TF;
	       }
	       TZ = Tz + TC;
	       T10 = TG + TJ;
	       T1s = T1q - T1r;
	       T1p = T1n - T1o;
	       {
		    E T1x, T1y, TD, TK;
		    T1x = T1n + T1o;
		    T1y = T1q + T1r;
		    T1z = T1x + T1y;
		    T1B = KP559016994 * (T1x - T1y);
		    TD = Tz - TC;
		    TK = TG - TJ;
		    TL = TD + TK;
		    TS = KP559016994 * (TD - TK);
	       }
	  }
	  rio[0] = T3 + Ti;
	  iio[-WS(ios, 9)] = T1w + T1z;
	  {
	       E Ts, TM, Tj, Tt;
	       Ts = Tk + Tr;
	       TM = Tw + TL;
	       Tj = W[8];
	       Tt = W[9];
	       rio[WS(ios, 5)] = FNMS(Tt, TM, Tj * Ts);
	       iio[-WS(ios, 4)] = FMA(Tt, Ts, Tj * TM);
	  }
	  {
	       E T1t, T1F, T1Q, T1N, T1C, T1R, T1m, T1M, T1A, T1k;
	       T1t = FNMS(KP951056516, T1s, KP587785252 * T1p);
	       T1F = FNMS(KP951056516, T1E, KP587785252 * T1D);
	       T1Q = FMA(KP951056516, T1D, KP587785252 * T1E);
	       T1N = FMA(KP951056516, T1p, KP587785252 * T1s);
	       T1A = FNMS(KP250000000, T1z, T1w);
	       T1C = T1A - T1B;
	       T1R = T1B + T1A;
	       T1k = FNMS(KP250000000, Ti, T3);
	       T1m = T1k - T1l;
	       T1M = T1l + T1k;
	       {
		    E T1u, T1G, T1j, T1v;
		    T1u = T1m + T1t;
		    T1G = T1C - T1F;
		    T1j = W[14];
		    T1v = W[15];
		    rio[WS(ios, 8)] = FNMS(T1v, T1G, T1j * T1u);
		    iio[-WS(ios, 1)] = FMA(T1v, T1u, T1j * T1G);
	       }
	       {
		    E T1U, T1W, T1T, T1V;
		    T1U = T1M + T1N;
		    T1W = T1R - T1Q;
		    T1T = W[6];
		    T1V = W[7];
		    rio[WS(ios, 4)] = FNMS(T1V, T1W, T1T * T1U);
		    iio[-WS(ios, 5)] = FMA(T1V, T1U, T1T * T1W);
	       }
	       {
		    E T1I, T1K, T1H, T1J;
		    T1I = T1m - T1t;
		    T1K = T1F + T1C;
		    T1H = W[2];
		    T1J = W[3];
		    rio[WS(ios, 2)] = FNMS(T1J, T1K, T1H * T1I);
		    iio[-WS(ios, 7)] = FMA(T1J, T1I, T1H * T1K);
	       }
	       {
		    E T1O, T1S, T1L, T1P;
		    T1O = T1M - T1N;
		    T1S = T1Q + T1R;
		    T1L = W[10];
		    T1P = W[11];
		    rio[WS(ios, 6)] = FNMS(T1P, T1S, T1L * T1O);
		    iio[-WS(ios, 3)] = FMA(T1P, T1O, T1L * T1S);
	       }
	  }
	  {
	       E TQ, T11, T1c, T19, TY, T18, TT, T1d, TW, TR;
	       TQ = FNMS(KP951056516, TP, KP587785252 * TO);
	       T11 = FNMS(KP951056516, T10, KP587785252 * TZ);
	       T1c = FMA(KP951056516, TO, KP587785252 * TP);
	       T19 = FMA(KP951056516, TZ, KP587785252 * T10);
	       TW = FNMS(KP250000000, Tr, Tk);
	       TY = TW - TX;
	       T18 = TX + TW;
	       TR = FNMS(KP250000000, TL, Tw);
	       TT = TR - TS;
	       T1d = TS + TR;
	       {
		    E TU, T12, TN, TV;
		    TU = TQ + TT;
		    T12 = TY - T11;
		    TN = W[12];
		    TV = W[13];
		    iio[-WS(ios, 2)] = FMA(TN, TU, TV * T12);
		    rio[WS(ios, 7)] = FNMS(TV, TU, TN * T12);
	       }
	       {
		    E T1g, T1i, T1f, T1h;
		    T1g = T1d - T1c;
		    T1i = T18 + T19;
		    T1f = W[16];
		    T1h = W[17];
		    iio[0] = FMA(T1f, T1g, T1h * T1i);
		    rio[WS(ios, 9)] = FNMS(T1h, T1g, T1f * T1i);
	       }
	       {
		    E T14, T16, T13, T15;
		    T14 = TY + T11;
		    T16 = TT - TQ;
		    T13 = W[4];
		    T15 = W[5];
		    rio[WS(ios, 3)] = FNMS(T15, T16, T13 * T14);
		    iio[-WS(ios, 6)] = FMA(T13, T16, T15 * T14);
	       }
	       {
		    E T1a, T1e, T17, T1b;
		    T1a = T18 - T19;
		    T1e = T1c + T1d;
		    T17 = W[0];
		    T1b = W[1];
		    rio[WS(ios, 1)] = FNMS(T1b, T1e, T17 * T1a);
		    iio[-WS(ios, 8)] = FMA(T17, T1e, T1b * T1a);
	       }
	  }
     }
     return W;
}

static const tw_instr twinstr[] = {
     {TW_FULL, 0, 10},
     {TW_NEXT, 1, 0}
};

static const hc2hc_desc desc = { 10, "hb_10", twinstr, &GENUS, {72, 30, 30, 0}, 0, 0, 0 };

void X(codelet_hb_10) (planner *p) {
     X(khc2hc_register) (p, hb_10, &desc);
}
#endif				/* HAVE_FMA */
