/*
 * Decompiled with CFR 0.152.
 */
package apple.awt;

import apple.awt.CComponent;
import apple.awt.CToolkit;
import apple.awt.MyCScrollPane;
import com.apple.eawt.CocoaComponent;
import java.applet.Applet;
import java.awt.AWTEvent;
import java.awt.Canvas;
import java.awt.Component;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.event.MouseEvent;
import java.awt.peer.CanvasPeer;
import java.awt.peer.FramePeer;
import java.awt.peer.LabelPeer;
import java.awt.peer.PanelPeer;
import java.awt.peer.ScrollPanePeer;
import java.util.Date;
import jep.AppletHolder;
import jep.AppletHolderFactory;
import sun.awt.AppContext;
import sun.awt.PeerEvent;
import sun.awt.SunToolkit;

public class MyCToolkit
extends CToolkit {
    private static boolean showDebugInfo = false;

    public MyCToolkit() {
        if (showDebugInfo) {
            System.err.println("Calling MyCToolkit()");
        }
        if (!AppletHolderFactory.isJava142Update1()) {
            AppletHolderFactory.resetMainEventQueue();
        }
    }

    public FramePeer createFrame(Frame frame) {
        if (frame == null) {
            return super.createFrame(frame);
        }
        FramePeer peer = null;
        if (frame instanceof AppletHolder) {
            try {
                Object[] parms = new Object[]{frame, frame};
                peer = (FramePeer)AppletHolderFactory.myCAppletFrameCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createFrame(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(frame, peer);
        } else {
            peer = super.createFrame(frame);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createFrame(): Frame " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public PanelPeer createPanel(Panel panel) {
        Container next;
        if (panel == null) {
            return super.createPanel(panel);
        }
        Container ancestor = panel;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        PanelPeer peer = null;
        if (ancestor instanceof AppletHolder) {
            try {
                Object[] parms = new Object[]{panel, ancestor};
                peer = (PanelPeer)AppletHolderFactory.myCPanelCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createPanel(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(panel, peer);
        } else {
            peer = super.createPanel(panel);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createPanel(): Panel " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public ScrollPanePeer createScrollPane(ScrollPane scrollpane) {
        Container next;
        if (scrollpane == null) {
            return super.createScrollPane(scrollpane);
        }
        Container ancestor = scrollpane;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        ScrollPanePeer peer = null;
        if (ancestor instanceof AppletHolder) {
            try {
                Object[] parms = new Object[]{scrollpane, ancestor};
                peer = (ScrollPanePeer)AppletHolderFactory.myCScrollPaneCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createScrollPane(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(scrollpane, peer);
        } else {
            peer = super.createScrollPane(scrollpane);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createScrollPane(): ScrollPane " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public CanvasPeer createCanvas(Canvas canvas) {
        Container next;
        if (canvas == null) {
            return super.createCanvas(canvas);
        }
        Component ancestor = canvas;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        CanvasPeer peer = null;
        long nsView = 0L;
        if (ancestor instanceof AppletHolder) {
            if (canvas instanceof CocoaComponent) {
                nsView = ((CocoaComponent)canvas).createNSView();
            }
            try {
                Object[] parms = new Object[]{canvas, new Long(nsView), ancestor};
                peer = (CanvasPeer)AppletHolderFactory.myCCanvasCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createCanvas(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(canvas, peer);
        } else {
            peer = super.createCanvas(canvas);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createCanvas(): (nsView is 0x" + Long.toHexString(nsView) + ") Canvas " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public LabelPeer createLabel(Label label) {
        Container next;
        if (label == null || !AppletHolderFactory.isJava142Tiger()) {
            return super.createLabel(label);
        }
        Component ancestor = label;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        LabelPeer peer = null;
        if (ancestor instanceof AppletHolder) {
            try {
                Object[] parms = new Object[]{label, ancestor};
                peer = (LabelPeer)AppletHolderFactory.myCLabelCreateNew.invoke(null, parms);
            }
            catch (Throwable e) {
                System.err.println("MyCToolkit createLabel(): exception: " + e.getMessage());
                e.printStackTrace();
                return null;
            }
            SunToolkit.targetCreatedPeer(label, peer);
        } else {
            peer = super.createLabel(label);
        }
        if (showDebugInfo) {
            System.err.println("MyCToolkit createLabel(): Label " + peer.toString() + " thread " + Thread.currentThread().toString());
        }
        return peer;
    }

    public static boolean postMouseMovedEvent(Object peer, int x, int y, long when) {
        if (peer instanceof CComponent) {
            ((CComponent)peer).postEvent((AWTEvent)new MouseEvent(((CComponent)peer).fTarget, 503, when, 0, x, y, 0, false));
            return true;
        }
        return false;
    }

    public static void setScrollPanePosition(Object peer, int x, int y) {
        boolean setDirectly;
        Container next;
        if (!(peer instanceof MyCScrollPane)) {
            return;
        }
        MyCScrollPane scrollPanePeer = (MyCScrollPane)((Object)peer);
        ScrollPane scrollpane = (ScrollPane)scrollPanePeer.fTarget;
        if (scrollpane == null) {
            return;
        }
        Point currentPosition = scrollpane.getScrollPosition();
        if (currentPosition.x == x && currentPosition.y == y) {
            return;
        }
        Container ancestor = scrollpane;
        while ((next = ancestor.getParent()) != null) {
            ancestor = next;
        }
        if (!(ancestor instanceof AppletHolder)) {
            return;
        }
        if (((AppletHolder)ancestor).destroying) {
            return;
        }
        Applet applet = ((AppletHolder)ancestor).getApplet();
        AppContext appletContext = null;
        if (applet != null) {
            appletContext = SunToolkit.targetToAppContext(applet);
        }
        boolean bl = setDirectly = appletContext == null || AppContext.getAppContext().equals(appletContext);
        if (setDirectly) {
            scrollPanePeer.setSkipNextScrollView();
            scrollpane.setScrollPosition(x, y);
        } else {
            SunToolkit.postEvent(appletContext, new PeerEvent(applet, new SetScrollPanePosition((AppletHolder)ancestor, scrollPanePeer, x, y), 1L));
        }
    }

    public static void printStackTrace() {
        System.err.print(new Date() + " ");
        Throwable barf = new Throwable();
        barf.fillInStackTrace();
        barf.printStackTrace();
    }

    public static String getJavaThread() {
        return Thread.currentThread().toString();
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getName() + " (jep)";
    }

    static {
        if ("true".equalsIgnoreCase(System.getProperty("jep.debuginfo", "false"))) {
            showDebugInfo = true;
        }
    }

    private static class SetScrollPanePosition
    implements Runnable {
        private final AppletHolder holder;
        private final MyCScrollPane scrollPanePeer;
        private final int x;
        private final int y;

        SetScrollPanePosition(AppletHolder holder, MyCScrollPane scrollPanePeer, int x, int y) {
            this.holder = holder;
            this.scrollPanePeer = scrollPanePeer;
            this.x = x;
            this.y = y;
        }

        public void run() {
            this.scrollPanePeer.setSkipNextScrollView();
            ScrollPane scrollpane = (ScrollPane)this.scrollPanePeer.fTarget;
            this.holder.validateClips();
            scrollpane.setScrollPosition(this.x, this.y);
        }
    }
}

