; Script generated by the HM NIS Edit Script Wizard.

!include "freetds.nsh"

; HM NIS Edit Wizard helper defines
!define PRODUCT_NAME "FreeTDS ODBC driver"
!define PRODUCT_PUBLISHER "FreeTDS group"
!define PRODUCT_WEB_SITE "http://www.freetds.org"
!define PRODUCT_UNINST_KEY "Software\Microsoft\Windows\CurrentVersion\Uninstall\{fef6e1f0-ef60-43d2-80a4-bfb774df706c}"
!define PRODUCT_UNINST_ROOT_KEY "HKLM"
!define ODBC_DRIVER_NAME "FreeTDS ODBC Driver"
!define ODBC_REGKEY "SOFTWARE\ODBC\ODBCINST.INI\${ODBC_DRIVER_NAME}"
!define ODBC_ROOT_KEY "HKLM"

SetCompressor lzma

; MUI 1.67 compatible ------
!include "MUI.nsh"

; MUI Settings
!define MUI_ABORTWARNING
!define MUI_ICON "${NSISDIR}\Contrib\Graphics\Icons\modern-install.ico"
!define MUI_UNICON "${NSISDIR}\Contrib\Graphics\Icons\modern-uninstall.ico"

; Welcome page
!insertmacro MUI_PAGE_WELCOME
; License page
!insertmacro MUI_PAGE_LICENSE "..\COPYING"
; Directory page
!insertmacro MUI_PAGE_DIRECTORY
; Instfiles page
!insertmacro MUI_PAGE_INSTFILES
; Finish page
!insertmacro MUI_PAGE_FINISH

; Uninstaller pages
!insertmacro MUI_UNPAGE_INSTFILES

; Language files
!insertmacro MUI_LANGUAGE "English"

; Reserve files
!insertmacro MUI_RESERVEFILE_INSTALLOPTIONS

; MUI end ------

Name "${PRODUCT_NAME} ${PRODUCT_VERSION}"
OutFile "FreeTDS Setup.exe"
InstallDir "$PROGRAMFILES\${PRODUCT_NAME}"
ShowInstDetails show
ShowUnInstDetails show

Section "MainSection" SEC01
  SetOutPath "$SYSDIR"
  SetOverwrite ifnewer
  File "dev-cpp\FreeTDS.dll"

  ; install driver
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "Driver" "$SYSDIR\FreeTDS.dll"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "APILevel" "2"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "ConnectFunctions" "YYY"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "CPTimeout" "60"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "DriverODBCVer" "02.50"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "FileUsage" "0"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "Setup" "$SYSDIR\FreeTDS.dll"
  WriteRegStr ${ODBC_ROOT_KEY} "${ODBC_REGKEY}" "SQLLevel" "1"

  ; tell that our driver is installed
  WriteRegStr "HKLM" "SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers" "${ODBC_DRIVER_NAME}" "Installed"
SectionEnd

Section -Post
  SetOutPath "$INSTDIR"
  WriteUninstaller "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayName" "$(^Name)"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "UninstallString" "$INSTDIR\uninst.exe"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "DisplayVersion" "${PRODUCT_VERSION}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "URLInfoAbout" "${PRODUCT_WEB_SITE}"
  WriteRegStr ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}" "Publisher" "${PRODUCT_PUBLISHER}"
SectionEnd


Function un.onUninstSuccess
  HideWindow
  MessageBox MB_ICONINFORMATION|MB_OK "$(^Name) was successfully removed from your computer."
FunctionEnd

Function un.onInit
  MessageBox MB_ICONQUESTION|MB_YESNO|MB_DEFBUTTON2 "Are you sure you want to completely remove $(^Name) and all of its components?" IDYES +2
  Abort
FunctionEnd

Section Uninstall
  DeleteRegValue "HKLM" "SOFTWARE\ODBC\ODBCINST.INI\ODBC Drivers" "${ODBC_DRIVER_NAME}"
  DeleteRegKey ${ODBC_ROOT_KEY} "${ODBC_REGKEY}"

  Delete "$INSTDIR\uninst.exe"
  Delete "$SYSDIR\FreeTDS.dll"
  RMDir "$INSTDIR"

  DeleteRegKey ${PRODUCT_UNINST_ROOT_KEY} "${PRODUCT_UNINST_KEY}"
  SetAutoClose true
SectionEnd
