;; Machine description for IBM RISC System 6000 (POWER) for GNU C compiler
;; Copyright (C) 1990, 1991, 1992, 1993, 1994, 1995, 1996, 1997, 1998,
;; 1999, 2000, 2001, 2002, 2003, 2004, 2005 Free Software Foundation, Inc.
;; Contributed by Richard Kenner (kenner@vlsi1.ultra.nyu.edu)

;; This file is part of GCC.

;; GCC is free software; you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published
;; by the Free Software Foundation; either version 2, or (at your
;; option) any later version.

;; GCC is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY
;; or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public
;; License for more details.

;; You should have received a copy of the GNU General Public License
;; along with GCC; see the file COPYING.  If not, write to the
;; Free Software Foundation, 59 Temple Place - Suite 330, Boston,
;; MA 02111-1307, USA.

;;- See file "rtl.def" for documentation on define_insn, match_*, et. al.

;;
;; UNSPEC usage
;;

(define_constants
  [(UNSPEC_FRSP			0)	; frsp for POWER machines
   (UNSPEC_TIE			5)	; tie stack contents and stack pointer
   (UNSPEC_TOCPTR		6)	; address of a word pointing to the TOC
   (UNSPEC_TOC			7)	; address of the TOC (more-or-less)
   (UNSPEC_MOVSI_GOT		8)
   (UNSPEC_MV_CR_OV		9)	; move_from_CR_ov_bit
   (UNSPEC_FCTIWZ		10)
   (UNSPEC_LD_MPIC		15)	; load_macho_picbase
   (UNSPEC_MPIC_CORRECT		16)	; macho_correct_pic
   (UNSPEC_TLSGD		17)
   (UNSPEC_TLSLD		18)
   (UNSPEC_MOVESI_FROM_CR	19)
   (UNSPEC_MOVESI_TO_CR		20)
   (UNSPEC_TLSDTPREL		21)
   (UNSPEC_TLSDTPRELHA		22)
   (UNSPEC_TLSDTPRELLO		23)
   (UNSPEC_TLSGOTDTPREL		24)
   (UNSPEC_TLSTPREL		25)
   (UNSPEC_TLSTPRELHA		26)
   (UNSPEC_TLSTPRELLO		27)
   (UNSPEC_TLSGOTTPREL		28)
   (UNSPEC_TLSTLS		29)
   (UNSPEC_FIX_TRUNC_TF		30)	; fadd, rounding towards zero
   (UNSPEC_MV_CR_EQ            31)     ; move_from_CR_eq_bit
  ])

;;
;; UNSPEC_VOLATILE usage
;;

(define_constants
  [(UNSPECV_BLOCK		0)
   (UNSPECV_EH_RR		9)	; eh_reg_restore
  ])

;; Define an insn type attribute.  This is used in function unit delay
;; computations.
(define_attr "type" "integer,load,load_ext,load_ext_u,load_ext_ux,load_ux,load_u,store,store_ux,store_u,fpload,fpload_ux,fpload_u,fpstore,fpstore_ux,fpstore_u,vecload,vecstore,imul,imul2,imul3,lmul,idiv,ldiv,insert_word,branch,cmp,fast_compare,compare,delayed_compare,imul_compare,lmul_compare,fpcompare,cr_logical,delayed_cr,mfcr,mfcrf,mtcr,mfjmpr,mtjmpr,fp,fpsimple,dmul,sdiv,ddiv,ssqrt,dsqrt,jmpreg,brinc,vecsimple,veccomplex,vecdiv,veccmp,veccmpsimple,vecperm,vecfloat,vecfdiv"
  (const_string "integer"))

;; Length (in bytes).
; '(pc)' in the following doesn't include the instruction itself; it is 
; calculated as if the instruction had zero size.
(define_attr "length" ""
  (if_then_else (eq_attr "type" "branch")
		(if_then_else (and (ge (minus (match_dup 0) (pc))
				       (const_int -32768))
				   (lt (minus (match_dup 0) (pc))
				       (const_int 32764)))
			      (const_int 4)
			      (const_int 8))
		(const_int 4)))

;; Processor type -- this attribute must exactly match the processor_type
;; enumeration in rs6000.h.

(define_attr "cpu" "rios1,rios2,rs64a,mpccore,ppc403,ppc405,ppc440,ppc601,ppc603,ppc604,ppc604e,ppc620,ppc630,ppc750,ppc7400,ppc7450,ppc8540,power4,power5"
  (const (symbol_ref "rs6000_cpu_attr")))

(automata_option "ndfa")

(include "rios1.md")
(include "rios2.md")
(include "rs64.md")
(include "mpc.md")
(include "40x.md")
(include "440.md")
(include "603.md")
(include "6xx.md")
(include "7xx.md")
(include "7450.md")
(include "8540.md")
(include "power4.md")
(include "power5.md")


;; Start with fixed-point load and store insns.  Here we put only the more
;; complex forms.  Basic data transfer is done later.

(define_expand "zero_extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lbz%U1%X1 %0,%1
   rldicl %0,%1,0,56"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   rldicl. %2,%1,0,56
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   rldicl. %0,%1,0,56
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "extendqidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   extsb. %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   extsb. %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "zero_extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lhz%U1%X1 %0,%1
   rldicl %0,%1,0,48"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   rldicl. %2,%1,0,48
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   rldicl. %0,%1,0,48
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendhidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lha%U1%X1 %0,%1
   extsh %0,%1"
  [(set_attr "type" "load_ext,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   extsh. %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   extsh. %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "zero_extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_operand:SI 1 "reg_or_mem_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwz%U1%X1 %0,%1
   rldicl %0,%1,0,32"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   rldicl. %2,%1,0,32
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   rldicl. %0,%1,0,32
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendsidi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_operand:SI 1 "lwa_operand" "m,r")))]
  "TARGET_POWERPC64"
  "@
   lwa%U1%X1 %0,%1
   extsw %0,%1"
  [(set_attr "type" "load_ext,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   extsw. %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   extsw. %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(sign_extend:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(sign_extend:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "zero_extendqisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  ""
  "@
   {andil.|andi.} %2,%1,0xff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "reload_completed"
  [(set (match_dup 2)
	(zero_extend:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "@
   {andil.|andi.} %0,%1,0xff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_dup 1)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendqisi2"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqisi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqisi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqisi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqisi2_ppc"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  "TARGET_POWERPC"
  "@
   extsb. %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "TARGET_POWERPC && reload_completed"
  [(set (match_dup 2)
	(sign_extend:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_dup 1)))]
  "TARGET_POWERPC"
  "@
   extsb. %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:SI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_dup 1)))]
  "TARGET_POWERPC && reload_completed"
  [(set (match_dup 0)
	(sign_extend:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendqisi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqisi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendqihi2"
  [(set (match_operand:HI 0 "gpc_reg_operand" "")
	(zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:HI (match_operand:QI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lbz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r,r"))]
  ""
  "@
   {andil.|andi.} %2,%1,0xff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 ""))]
  "reload_completed"
  [(set (match_dup 2)
	(zero_extend:HI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:HI (match_dup 1)))]
  ""
  "@
   {andil.|andi.} %0,%1,0xff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:HI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "")
	(zero_extend:HI (match_dup 1)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extend:HI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendqihi2"
  [(use (match_operand:HI 0 "gpc_reg_operand" ""))
   (use (match_operand:QI 1 "gpc_reg_operand" ""))]
  ""
  "
{
  if (TARGET_POWERPC)
    emit_insn (gen_extendqihi2_ppc (operands[0], operands[1]));
  else if (TARGET_POWER)
    emit_insn (gen_extendqihi2_power (operands[0], operands[1]));
  else
    emit_insn (gen_extendqihi2_no_power (operands[0], operands[1]));
  DONE;
}")

(define_insn "extendqihi2_ppc"
  [(set (match_operand:HI 0 "gpc_reg_operand" "=r")
	(sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC"
  "extsb %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 "=r,r"))]
  "TARGET_POWERPC"
  "@
   extsb. %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:HI 2 ""))]
  "TARGET_POWERPC && reload_completed"
  [(set (match_dup 2)
	(sign_extend:HI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:HI (match_dup 1)))]
  "TARGET_POWERPC"
  "@
   extsb. %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:HI (match_operand:QI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:HI 0 "gpc_reg_operand" "")
	(sign_extend:HI (match_dup 1)))]
  "TARGET_POWERPC && reload_completed"
  [(set (match_dup 0)
	(sign_extend:HI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendqihi2_power"
  [(parallel [(set (match_dup 2)
		   (ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
			      (const_int 24)))
	      (clobber (scratch:SI))])
   (parallel [(set (match_operand:HI 0 "gpc_reg_operand" "")
		   (ashiftrt:SI (match_dup 2)
				(const_int 24)))
	      (clobber (scratch:SI))])]
  "TARGET_POWER"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "extendqihi2_no_power"
  [(set (match_dup 2)
	(ashift:SI (match_operand:QI 1 "gpc_reg_operand" "")
		   (const_int 24)))
   (set (match_operand:HI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 2)
		     (const_int 24)))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "
{ operands[0] = gen_lowpart (SImode, operands[0]);
  operands[1] = gen_lowpart (SImode, operands[1]);
  operands[2] = gen_reg_rtx (SImode); }")

(define_expand "zero_extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lhz%U1%X1 %0,%1
   {rlinm|rlwinm} %0,%1,0,0xffff"
  [(set_attr "type" "load,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  ""
  "@
   {andil.|andi.} %2,%1,0xffff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "reload_completed"
  [(set (match_dup 2)
	(zero_extend:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (match_dup 1)))]
  ""
  "@
   {andil.|andi.} %0,%1,0xffff
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (match_dup 1)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "extendhisi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_operand:HI 1 "reg_or_mem_operand" "m,r")))]
  ""
  "@
   lha%U1%X1 %0,%1
   {exts|extsh} %0,%1"
  [(set_attr "type" "load_ext,*")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  ""
  "@
   {exts.|extsh.} %2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "reload_completed"
  [(set (match_dup 2)
	(sign_extend:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(sign_extend:SI (match_dup 1)))]
  ""
  "@
   {exts.|extsh.} %0,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (sign_extend:SI (match_operand:HI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(sign_extend:SI (match_dup 1)))]
  "reload_completed"
  [(set (match_dup 0)
	(sign_extend:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Fixed-point arithmetic insns.

;; Discourage ai/addic because of carry but provide it in an alternative
;; allowing register zero as source.
(define_expand "addsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_arith_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
		&& ! add_operand (operands[2], SImode))
    {
      rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      HOST_WIDE_INT val = INTVAL (operands[2]);
      HOST_WIDE_INT low = ((val & 0xffff) ^ 0x8000) - 0x8000;
      HOST_WIDE_INT rest = trunc_int_for_mode (val - low, SImode);

      /* The ordering here is important for the prolog expander.
	 When space is allocated from the stack, adding 'low' first may
	 produce a temporary deallocation (which would be bad).  */
      emit_insn (gen_addsi3 (tmp, operands[1], GEN_INT (rest)));
      emit_insn (gen_addsi3 (operands[0], tmp, GEN_INT (low)));
      DONE;
    }
}")

(define_insn "*addsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,?r,r")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,b,r,b")
		 (match_operand:SI 2 "add_operand" "r,I,I,L")))]
  ""
  "@
   {cax|add} %0,%1,%2
   {cal %0,%2(%1)|addi %0,%1,%2}
   {ai|addic} %0,%1,%2
   {cau|addis} %0,%1,%v2"
  [(set_attr "length" "4,4,4,4")])

(define_insn "addsi3_high"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=b")
        (plus:SI (match_operand:SI 1 "gpc_reg_operand" "b")
                 (high:SI (match_operand 2 "" ""))))]
  "TARGET_MACHO && !TARGET_64BIT"
  "{cau|addis} %0,%1,ha16(%2)"
  [(set_attr "length" "4")])

(define_insn "*addsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I,r,I"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))]
  "TARGET_32BIT"
  "@
   {cax.|add.} %3,%1,%2
   {ai.|addic.} %3,%1,%2
   #
   #"
  [(set_attr "type" "fast_compare,compare,compare,compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "reg_or_short_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(plus:SI (match_dup 1)
		 (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*addsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
			     (match_operand:SI 2 "reg_or_short_operand" "r,I,r,I"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:SI (match_dup 1)
		 (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {cax.|add.} %0,%1,%2
   {ai.|addic.} %0,%1,%2
   #
   #"
  [(set_attr "type" "fast_compare,compare,compare,compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "reg_or_short_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (match_dup 1)
		 (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "non_add_cint_operand" "")))]
  ""
  [(set (match_dup 0) (plus:SI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:SI (match_dup 0) (match_dup 4)))]
"
{
  HOST_WIDE_INT val = INTVAL (operands[2]);
  HOST_WIDE_INT low = ((val & 0xffff) ^ 0x8000) - 0x8000;
  HOST_WIDE_INT rest = trunc_int_for_mode (val - low, SImode);

  operands[3] = GEN_INT (rest);
  operands[4] = GEN_INT (low);
}")

(define_insn "one_cmplsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(not:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "nor %0,%1,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  "TARGET_32BIT"
  "@
   nor. %2,%1,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 2)
	(not:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(not:SI (match_dup 1)))]
  "TARGET_32BIT"
  "@
   nor. %0,%1,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(not:SI (match_dup 1)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(not:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "rI")
		  (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "! TARGET_POWERPC"
  "{sf%I1|subf%I1c} %0,%2,%1")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "r,I")
		  (match_operand:SI 2 "gpc_reg_operand" "r,r")))]
  "TARGET_POWERPC"
  "@
   subf %0,%2,%1
   subfic %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "! TARGET_POWERPC"
  "@
   {sf.|subfc.} %3,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_POWERPC && TARGET_32BIT"
  "@
   subf. %3,%2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(minus:SI (match_dup 1)
		  (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWERPC"
  "@
   {sf.|subfc.} %0,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(minus:SI (match_dup 1)
		  (match_dup 2)))]
  "TARGET_POWERPC && TARGET_32BIT"
  "@
   subf. %0,%2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (minus:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 1)
		  (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(minus:SI (match_dup 1)
		  (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "subsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_operand:SI 1 "reg_or_short_operand" "")
		  (match_operand:SI 2 "reg_or_arith_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_addsi3 (operands[0], operands[1],
			     negate_rtx (SImode, operands[2])));
      DONE;
    }
}")

;; For SMIN, SMAX, UMIN, and UMAX, we use DEFINE_EXPAND's that involve a doz[i]
;; instruction and some auxiliary computations.  Then we just have a single
;; DEFINE_INSN for doz[i] and the define_splits to make them if made by
;; combine.

(define_expand "sminsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER || TARGET_ISEL"
  "
{
  if (TARGET_ISEL)
    {
      operands[2] = force_reg (SImode, operands[2]);
      rs6000_emit_minmax (operands[0], SMIN, operands[1], operands[2]);
      DONE;
    }

  operands[3] = gen_reg_rtx (SImode);
}")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smin:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 3)))]
  "")

(define_expand "smaxsi3"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_short_operand" ""))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER || TARGET_ISEL"
  "
{
  if (TARGET_ISEL)
    {
      operands[2] = force_reg (SImode, operands[2]);
      rs6000_emit_minmax (operands[0], SMAX, operands[1], operands[2]);
      DONE;
    }
  operands[3] = gen_reg_rtx (SImode);
}")

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(smax:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "TARGET_POWER"
  [(set (match_dup 3)
	(if_then_else:SI (gt:SI (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0) (plus:SI (match_dup 3) (match_dup 1)))]
  "")

(define_expand "uminsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(minus:SI (match_dup 2) (match_dup 3)))]
  "TARGET_POWER || TARGET_ISEL"
  "
{
  if (TARGET_ISEL)
    {
      rs6000_emit_minmax (operands[0], UMIN, operands[1], operands[2]);
      DONE;
    }
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_expand "umaxsi3"
  [(set (match_dup 3) (xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 4) (xor:SI (match_operand:SI 2 "gpc_reg_operand" "")
			      (match_dup 5)))
   (set (match_dup 3) (if_then_else:SI (gt (match_dup 3) (match_dup 4))
				       (const_int 0)
				       (minus:SI (match_dup 4) (match_dup 3))))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 3) (match_dup 1)))]
  "TARGET_POWER || TARGET_ISEL"
  "
{
  if (TARGET_ISEL)
    {
      rs6000_emit_minmax (operands[0], UMAX, operands[1], operands[2]);
      DONE;
    }
  operands[3] = gen_reg_rtx (SImode);
  operands[4] = gen_reg_rtx (SImode);
  operands[5] = GEN_INT (-2147483647 - 1);
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "reg_or_short_operand" "rI"))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_POWER"
  "@
   doz%I2. %3,%1,%2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "reg_or_short_operand" ""))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 3)
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER"
  "@
   doz%I2. %0,%1,%2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (if_then_else:SI (gt (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "reg_or_short_operand" ""))
			  (const_int 0)
			  (minus:SI (match_dup 2) (match_dup 1)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(if_then_else:SI (gt (match_dup 1) (match_dup 2))
			 (const_int 0)
			 (minus:SI (match_dup 2) (match_dup 1))))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; We don't need abs with condition code because such comparisons should
;; never be done.
(define_expand "abssi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "")))]
  ""
  "
{
  if (TARGET_ISEL)
    {
      emit_insn (gen_abssi2_isel (operands[0], operands[1]));
      DONE;
    }
  else if (! TARGET_POWER)
    {
      emit_insn (gen_abssi2_nopower (operands[0], operands[1]));
      DONE;
    }
}")

(define_insn "*abssi2_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "abs %0,%1")

(define_insn_and_split "abssi2_isel"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (abs:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
   (clobber (match_scratch:SI 2 "=&b"))
   (clobber (match_scratch:CC 3 "=y"))]
  "TARGET_ISEL"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (neg:SI (match_dup 1)))
   (set (match_dup 3)
	(compare:CC (match_dup 1)
		    (const_int 0)))
   (set (match_dup 0)
	(if_then_else:SI (ge (match_dup 3)
			     (const_int 0))
			 (match_dup 1)
			 (match_dup 2)))]
  "")

(define_insn_and_split "abssi2_nopower"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
        (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "! TARGET_POWER && ! TARGET_ISEL"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 0) (match_dup 2)))]
  "")

(define_insn "*nabs_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "nabs %0,%1")

(define_insn_and_split "*nabs_nopower"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,r")
        (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:SI 2 "=&r,&r"))]
  "! TARGET_POWER"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (ashiftrt:SI (match_dup 1) (const_int 31)))
   (set (match_dup 0) (xor:SI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:SI (match_dup 2) (match_dup 0)))]
  "")

(define_insn "negsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 "=r,r"))]
  "TARGET_32BIT"
  "@
   neg. %2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 2 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 2)
	(neg:SI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (match_dup 1)))]
  "TARGET_32BIT"
  "@
   neg. %0,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (neg:SI (match_operand:SI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(neg:SI (match_dup 1)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(neg:SI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "clzsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(clz:SI (match_operand:SI 1 "gpc_reg_operand" "r")))]
  ""
  "{cntlz|cntlzw} %0,%1")

(define_expand "ctzsi2"
  [(set (match_dup 2)
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
   (parallel [(set (match_dup 3) (and:SI (match_dup 1)
					 (match_dup 2)))
	      (clobber (scratch:CC))])
   (set (match_dup 4) (clz:SI (match_dup 3)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (const_int 31) (match_dup 4)))]
  ""
  {
     operands[2] = gen_reg_rtx (SImode);
     operands[3] = gen_reg_rtx (SImode);
     operands[4] = gen_reg_rtx (SImode);
  })
  
(define_expand "ffssi2"
  [(set (match_dup 2)
	(neg:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
   (parallel [(set (match_dup 3) (and:SI (match_dup 1)
					 (match_dup 2)))
	      (clobber (scratch:CC))])
   (set (match_dup 4) (clz:SI (match_dup 3)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(minus:SI (const_int 32) (match_dup 4)))]
  ""
  {
     operands[2] = gen_reg_rtx (SImode);
     operands[3] = gen_reg_rtx (SImode);
     operands[4] = gen_reg_rtx (SImode);
  })
  
(define_expand "mulsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_short_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_mulsi3_mq (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_mulsi3_no_mq (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "mulsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
   (clobber (match_scratch:SI 3 "=q,q"))]
  "TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set (attr "type") 
      (cond [(match_operand:SI 2 "s8bit_cint_operand" "")
		(const_string "imul3")
             (match_operand:SI 2 "short_cint_operand" "") 
		(const_string "imul2")]
	(const_string "imul")))])

(define_insn "mulsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "r,I")))]
  "! TARGET_POWER"
  "@
   {muls|mullw} %0,%1,%2
   {muli|mulli} %0,%1,%2"
   [(set (attr "type") 
      (cond [(match_operand:SI 2 "s8bit_cint_operand" "")
		(const_string "imul3")
             (match_operand:SI 2 "short_cint_operand" "") 
		(const_string "imul2")]
	(const_string "imul")))])

(define_insn "*mulsi3_mq_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))
   (clobber (match_scratch:SI 4 "=q,q"))]
  "TARGET_POWER"
  "@
   {muls.|mullw.} %3,%1,%2
   #"
  [(set_attr "type" "imul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 3)
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*mulsi3_no_mq_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "! TARGET_POWER"
  "@
   {muls.|mullw.} %3,%1,%2
   #"
  [(set_attr "type" "imul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "! TARGET_POWER && reload_completed"
  [(set (match_dup 3)
	(mult:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*mulsi3_mq_internal2"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,q"))]
  "TARGET_POWER"
  "@
   {muls.|mullw.} %0,%1,%2
   #"
  [(set_attr "type" "imul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
	(mult:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*mulsi3_no_mq_internal2"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(mult:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "@
   {muls.|mullw.} %0,%1,%2
   #"
  [(set_attr "type" "imul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:SI (match_operand:SI 1 "gpc_reg_operand" "")
			     (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(mult:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(mult:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Operand 1 is divided by operand 2; quotient goes to operand
;; 0 and remainder to operand 3.
;; ??? At some point, see what, if anything, we can do about if (x % y == 0).

(define_expand "divmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (div:SI (match_operand:SI 1 "gpc_reg_operand" "")
			   (match_operand:SI 2 "gpc_reg_operand" "")))
	      (set (match_operand:SI 3 "register_operand" "")
		   (mod:SI (match_dup 1) (match_dup 2)))])]
  "TARGET_POWER || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_divss_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      emit_move_insn (operands[3], gen_rtx_REG (SImode, 4));
      DONE;
    }
}")

(define_insn "*divmodsi4_internal"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "gpc_reg_operand" "r")))
   (set (match_operand:SI 3 "register_operand" "=q")
	(mod:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "divs %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_expand "udivsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
                 (match_operand:SI 2 "gpc_reg_operand" "")))]
  "TARGET_POWERPC || (! TARGET_POWER && ! TARGET_POWERPC)"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_quous_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_udivsi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "udivsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "divwu %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "*udivsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                 (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "divwu %0,%1,%2"
  [(set_attr "type" "idiv")])

;; For powers of two we can do srai/aze for divide and then adjust for
;; modulus.  If it isn't a power of two, FAIL on POWER so divmodsi4 will be
;; used; for PowerPC, force operands into register and do a normal divide;
;; for AIX common-mode, use quoss call on register operands.
(define_expand "divsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) > 0
      && exact_log2 (INTVAL (operands[2])) >= 0)
    ;
  else if (TARGET_POWERPC)
    {
      operands[2] = force_reg (SImode, operands[2]);
      if (TARGET_POWER)
	{
	  emit_insn (gen_divsi3_mq (operands[0], operands[1], operands[2]));
	  DONE;
	}
    }
  else if (TARGET_POWER)
    FAIL;
  else
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_quoss_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
}")

(define_insn "divsi3_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "divw %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_insn "*divsi3_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
                (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "divw %0,%1,%2"
  [(set_attr "type" "idiv")])

(define_expand "modsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  int i;
  rtx temp1;
  rtx temp2;

  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 0
      || (i = exact_log2 (INTVAL (operands[2]))) < 0)
    FAIL;

  temp1 = gen_reg_rtx (SImode);
  temp2 = gen_reg_rtx (SImode);

  emit_insn (gen_divsi3 (temp1, operands[1], operands[2]));
  emit_insn (gen_ashlsi3 (temp2, temp1, GEN_INT (i)));
  emit_insn (gen_subsi3 (operands[0], operands[1], temp2));
  DONE;
}")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(div:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "exact_log2_cint_operand" "N")))]
  ""
  "{srai|srawi} %0,%1,%p2\;{aze|addze} %0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "exact_log2_cint_operand" "N,N"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {srai|srawi} %3,%1,%p2\;{aze.|addze.} %3,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "exact_log2_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "reload_completed"
  [(set (match_dup 3)
	(div:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "exact_log2_cint_operand" "N,N"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(div:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {srai|srawi} %0,%1,%p2\;{aze.|addze.} %0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (div:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "exact_log2_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(div:SI (match_dup 1) (match_dup 2)))]
  "reload_completed"
  [(set (match_dup 0)
	(div:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(udiv:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "r"))
		   (const_int 32))
		  (zero_extend:DI (match_operand:SI 4 "register_operand" "2")))
	 (match_operand:SI 3 "gpc_reg_operand" "r")))
   (set (match_operand:SI 2 "register_operand" "=*q")
	(umod:SI
	 (plus:DI (ashift:DI
		   (zero_extend:DI (match_dup 1)) (const_int 32))
		  (zero_extend:DI (match_dup 4)))
	 (match_dup 3)))]
  "TARGET_POWER"
  "div %0,%1,%3"
  [(set_attr "type" "idiv")])

;; To do unsigned divide we handle the cases of the divisor looking like a
;; negative number.  If it is a constant that is less than 2**31, we don't
;; have to worry about the branches.  So make a few subroutines here.
;;
;; First comes the normal case.
(define_expand "udivmodsi4_normal"
  [(set (match_dup 4) (const_int 0))
   (parallel [(set (match_operand:SI 0 "" "")
		   (udiv:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_operand:SI 1 "" "")))
			    (match_operand:SI 2 "" "")))
	      (set (match_operand:SI 3 "" "")
		   (umod:SI (plus:DI (ashift:DI (zero_extend:DI (match_dup 4))
						(const_int 32))
				     (zero_extend:DI (match_dup 1)))
			    (match_dup 2)))])]
  "TARGET_POWER"
  "
{ operands[4] = gen_reg_rtx (SImode); }")

;; This handles the branches.
(define_expand "udivmodsi4_tests"
  [(set (match_operand:SI 0 "" "") (const_int 0))
   (set (match_operand:SI 3 "" "") (match_operand:SI 1 "" ""))
   (set (match_dup 5) (compare:CCUNS (match_dup 1) (match_operand:SI 2 "" "")))
   (set (pc) (if_then_else (ltu (match_dup 5) (const_int 0))
			   (label_ref (match_operand:SI 4 "" "")) (pc)))
   (set (match_dup 0) (const_int 1))
   (set (match_dup 3) (minus:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 6) (compare:CC (match_dup 2) (const_int 0)))
   (set (pc) (if_then_else (lt (match_dup 6) (const_int 0))
			   (label_ref (match_dup 4)) (pc)))]
  "TARGET_POWER"
  "
{ operands[5] = gen_reg_rtx (CCUNSmode);
  operands[6] = gen_reg_rtx (CCmode);
}")

(define_expand "udivmodsi4"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (udiv:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "reg_or_cint_operand" "")))
	      (set (match_operand:SI 3 "gpc_reg_operand" "")
		   (umod:SI (match_dup 1) (match_dup 2)))])]
  ""
  "
{
  rtx label = 0;

  if (! TARGET_POWER)
    {
      if (! TARGET_POWERPC)
        {
	  emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
	  emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
	  emit_insn (gen_divus_call ());
	  emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
	  emit_move_insn (operands[3], gen_rtx_REG (SImode, 4));
	  DONE;
        }
      else
        FAIL;
    }

  if (GET_CODE (operands[2]) != CONST_INT || INTVAL (operands[2]) < 0)
    {
      operands[2] = force_reg (SImode, operands[2]);
      label = gen_label_rtx ();
      emit (gen_udivmodsi4_tests (operands[0], operands[1], operands[2],
				  operands[3], label));
    }
  else
    operands[2] = force_reg (SImode, operands[2]);

  emit (gen_udivmodsi4_normal (operands[0], operands[1], operands[2],
			       operands[3]));
  if (label)
    emit_label (label);

  DONE;
}")

;; AIX architecture-independent common-mode multiply (DImode),
;; divide/modulus, and quotient subroutine calls.  Input operands in R3 and
;; R4; results in R3 and sometimes R4; link register always clobbered by bla
;; instruction; R0 sometimes clobbered; also, MQ sometimes clobbered but
;; assumed unused if generating common-mode, so ignore.
(define_insn "mulh_call"
  [(set (reg:SI 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (reg:SI 3))
			       (sign_extend:DI (reg:SI 4)))
		      (const_int 32))))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mulh"
  [(set_attr "type" "imul")])

(define_insn "mull_call"
  [(set (reg:DI 3)
	(mult:DI (sign_extend:DI (reg:SI 3))
		 (sign_extend:DI (reg:SI 4))))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __mull"
  [(set_attr "type" "imul")])

(define_insn "divss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(mod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divss"
  [(set_attr "type" "idiv")])

(define_insn "divus_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (set (reg:SI 4)
	(umod:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))
   (clobber (match_scratch:CC 1 "=x"))
   (clobber (reg:CC 69))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __divus"
  [(set_attr "type" "idiv")])

(define_insn "quoss_call"
  [(set (reg:SI 3)
	(div:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quoss"
  [(set_attr "type" "idiv")])

(define_insn "quous_call"
  [(set (reg:SI 3)
	(udiv:SI (reg:SI 3) (reg:SI 4)))
   (clobber (match_scratch:SI 0 "=l"))
   (clobber (reg:SI 0))
   (clobber (match_scratch:CC 1 "=x"))
   (clobber (reg:CC 69))]
  "! TARGET_POWER && ! TARGET_POWERPC"
  "bla __quous"
  [(set_attr "type" "idiv")])

;; Logical instructions
;; The logical instructions are mostly combined by using match_operator,
;; but the plain AND insns are somewhat different because there is no
;; plain 'andi' (only 'andi.'), no plain 'andis', and there are all
;; those rotate-and-mask operations.  Thus, the AND insns come first.

(define_insn "andsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r")
		(match_operand:SI 2 "and_operand" "?r,T,K,L")))
   (clobber (match_scratch:CC 3 "=X,X,x,x"))]
  ""
  "@
   and %0,%1,%2
   {rlinm|rlwinm} %0,%1,0,%m2,%M2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2")

;; Note to set cr's other than cr0 we do the and immediate and then
;; the test again -- this avoids a mfcr which on the higher end
;; machines causes an execution serialization

(define_insn "*andsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,?y,??y,??y,?y")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,L,T,r,K,L,T"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r,r,r,r,r"))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,x,x,X"))]
  "TARGET_32BIT"
  "@
   and. %3,%1,%2
   {andil.|andi.} %3,%1,%b2
   {andiu.|andis.} %3,%1,%u2
   {rlinm.|rlwinm.} %3,%1,0,%m2,%M2
   #
   #
   #
   #"
  [(set_attr "type" "compare,compare,compare,delayed_compare,compare,compare,compare,compare")
   (set_attr "length" "4,4,4,4,8,8,8,8")])

(define_insn "*andsi3_internal3"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,?y,??y,??y,?y")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,L,T,r,K,L,T"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r,r,r,r,r"))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,x,x,X"))]
  "TARGET_64BIT"
  "@
   #
   {andil.|andi.} %3,%1,%b2
   {andiu.|andis.} %3,%1,%u2
   {rlinm.|rlwinm.} %3,%1,0,%m2,%M2
   #
   #
   #
   #"
  [(set_attr "type" "compare,compare,compare,delayed_compare,compare,compare,compare,compare")
   (set_attr "length" "8,4,4,4,8,8,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "and_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:CC 4 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 3)
		   (and:SI (match_dup 1)
			   (match_dup 2)))
	      (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

;; We don't have a 32 bit "and. rt,ra,rb" for ppc64.  cr is set from the
;; whole 64 bit reg, and we don't know what is in the high 32 bits.

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(parallel [(set (match_dup 3)
		   (and:SI (match_dup 1)
			   (match_dup 2)))
	      (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*andsi3_internal4"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x,?y,??y,??y,?y")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,L,T,r,K,L,T"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r,r,r,r")
	(and:SI (match_dup 1)
		(match_dup 2)))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,x,x,X"))]
  "TARGET_32BIT"
  "@
   and. %0,%1,%2
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2
   {rlinm.|rlwinm.} %0,%1,0,%m2,%M2
   #
   #
   #
   #"
  [(set_attr "type" "compare,compare,compare,delayed_compare,compare,compare,compare,compare")
   (set_attr "length" "4,4,4,4,8,8,8,8")])

(define_insn "*andsi3_internal5"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x,?y,??y,??y,?y")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r")
			    (match_operand:SI 2 "and_operand" "r,K,L,T,r,K,L,T"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r,r,r,r")
	(and:SI (match_dup 1)
		(match_dup 2)))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,x,x,X"))]
  "TARGET_64BIT"
  "@
   #
   {andil.|andi.} %0,%1,%b2
   {andiu.|andis.} %0,%1,%u2
   {rlinm.|rlwinm.} %0,%1,0,%m2,%M2
   #
   #
   #
   #"
  [(set_attr "type" "compare,compare,compare,delayed_compare,compare,compare,compare,compare")
   (set_attr "length" "8,4,4,4,8,8,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "and_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (match_dup 1)
		(match_dup 2)))
   (clobber (match_scratch:CC 4 ""))]
  "reload_completed"
  [(parallel [(set (match_dup 0)
		   (and:SI (match_dup 1)
			   (match_dup 2)))
	      (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
	(compare:CC (and:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (match_dup 1)
		(match_dup 2)))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(parallel [(set (match_dup 0)
		   (and:SI (match_dup 1)
			   (match_dup 2)))
	      (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Handle the PowerPC64 rlwinm corner case

(define_insn_and_split "*andsi3_internal6"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "mask_operand_wrap" "i")))]
  "TARGET_POWERPC64"
  "#"
  "TARGET_POWERPC64"
  [(set (match_dup 0)
	(and:SI (rotate:SI (match_dup 1) (match_dup 3))
		(match_dup 4)))
   (set (match_dup 0)
	(rotate:SI (match_dup 0) (match_dup 5)))]
  "
{
  int mb = extract_MB (operands[2]);
  int me = extract_ME (operands[2]);
  operands[3] = GEN_INT (me + 1);
  operands[5] = GEN_INT (32 - (me + 1));
  operands[4] = GEN_INT (~((HOST_WIDE_INT) -1 << (33 + me - mb)));
}"
  [(set_attr "length" "8")])

(define_expand "iorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_logical_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && ! logical_operand (operands[2], SImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      emit_insn (gen_iorsi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_iorsi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_expand "xorsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(xor:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_logical_cint_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && ! logical_operand (operands[2], SImode))
    {
      HOST_WIDE_INT value = INTVAL (operands[2]);
      rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (SImode));

      emit_insn (gen_xorsi3 (tmp, operands[1],
			     GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
      emit_insn (gen_xorsi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*boolsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(match_operator:SI 3 "boolean_or_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "%r,r,r")
	  (match_operand:SI 2 "logical_operand" "r,K,L")]))]
  ""
  "@
   %q3 %0,%1,%2
   {%q3il|%q3i} %0,%1,%b2
   {%q3iu|%q3is} %0,%1,%u2")

(define_insn "*boolsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_or_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "%r,r")
	  (match_operand:SI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_32BIT"
  "@
   %q4. %3,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "")
	  (match_operand:SI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*boolsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "%r,r")
	  (match_operand:SI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_32BIT"
  "@
   %q4. %0,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "")
	  (match_operand:SI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Split a logical operation that we can't do in one insn into two insns, 
;; each of which does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_operator:SI 3 "boolean_or_operator"
	 [(match_operand:SI 1 "gpc_reg_operand" "")
	  (match_operand:SI 2 "non_logical_cint_operand" "")]))]
  ""
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 0) (match_dup 5))]
"
{
  rtx i;
  i = GEN_INT (INTVAL (operands[2]) & (~ (HOST_WIDE_INT) 0xffff));
  operands[4] = gen_rtx (GET_CODE (operands[3]), SImode,
			 operands[1], i);
  i = GEN_INT (INTVAL (operands[2]) & 0xffff);
  operands[5] = gen_rtx (GET_CODE (operands[3]), SImode,
			 operands[0], i);
}")

(define_insn "*boolcsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 3 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
	  (match_operand:SI 2 "gpc_reg_operand" "r")]))]
  ""
  "%q3 %0,%2,%1")

(define_insn "*boolcsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
	  (match_operand:SI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_32BIT"
  "@
   %q4. %3,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
	  (match_operand:SI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*boolcsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r"))
	  (match_operand:SI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_32BIT"
  "@
   %q4. %0,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
	  (match_operand:SI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*boolccsi3_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 3 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "r"))
	  (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))]))]
  ""
  "%q3 %0,%1,%2")

(define_insn "*boolccsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "r,r"))
	  (not:SI (match_operand:SI 2 "gpc_reg_operand" "r,r"))])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_32BIT"
  "@
   %q4. %3,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
	  (not:SI (match_operand:SI 2 "gpc_reg_operand" ""))])
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*boolccsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r"))
	  (not:SI (match_operand:SI 2 "gpc_reg_operand" "r,r"))])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_32BIT"
  "@
   %q4. %0,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 4 "boolean_operator"
	 [(not:SI (match_operand:SI 1 "gpc_reg_operand" ""))
	  (not:SI (match_operand:SI 2 "gpc_reg_operand" ""))])
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; maskir insn.  We need four forms because things might be in arbitrary
;; orders.  Don't define forms that only set CR fields because these
;; would modify an input register.

(define_insn "*maskir_internal1"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_dup 2)
			(match_operand:SI 3 "gpc_reg_operand" "r"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r"))
			(match_operand:SI 1 "gpc_reg_operand" "0"))
		(and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_dup 2))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			(match_operand:SI 3 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal4"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			(match_operand:SI 2 "gpc_reg_operand" "r"))
		(and:SI (not:SI (match_dup 2))
			(match_operand:SI 1 "gpc_reg_operand" "0"))))]
  "TARGET_POWER"
  "maskir %0,%3,%2")

(define_insn "*maskir_internal5"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r,r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0,0"))
		 (and:SI (match_dup 2)
			 (match_operand:SI 3 "gpc_reg_operand" "r,r")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))]
  "TARGET_POWER"
  "@
   maskir. %0,%3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" ""))
			 (match_operand:SI 1 "gpc_reg_operand" ""))
		 (and:SI (match_dup 2)
			 (match_operand:SI 3 "gpc_reg_operand" "")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 2) (match_dup 3))))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*maskir_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" "r,r"))
			 (match_operand:SI 1 "gpc_reg_operand" "0,0"))
		 (and:SI (match_operand:SI 3 "gpc_reg_operand" "r,r")
			 (match_dup 2)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))]
  "TARGET_POWER"
  "@
   maskir. %0,%3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ior:SI (and:SI (not:SI (match_operand:SI 2 "gpc_reg_operand" ""))
			 (match_operand:SI 1 "gpc_reg_operand" ""))
		 (and:SI (match_operand:SI 3 "gpc_reg_operand" "")
			 (match_dup 2)))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(ior:SI (and:SI (not:SI (match_dup 2)) (match_dup 1))
		(and:SI (match_dup 3) (match_dup 2))))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*maskir_internal7"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "r,r")
			 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0,0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "@
   maskir. %0,%3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 2 "gpc_reg_operand" "")
			 (match_operand:SI 3 "gpc_reg_operand" ""))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(ior:SI (and:SI (match_dup 2) (match_dup 3))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*maskir_internal8"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "gpc_reg_operand" "r,r"))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "0,0")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER"
  "@
   maskir. %0,%3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ior:SI (and:SI (match_operand:SI 3 "gpc_reg_operand" "")
			 (match_operand:SI 2 "gpc_reg_operand" ""))
		 (and:SI (not:SI (match_dup 2))
			 (match_operand:SI 1 "gpc_reg_operand" "")))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(ior:SI (and:SI (match_dup 3) (match_dup 2))
		(and:SI (not:SI (match_dup 2)) (match_dup 1))))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Rotate and shift insns, in all their variants.  These support shifts,
;; field inserts and extracts, and various combinations thereof.
(define_expand "insv"
  [(set (zero_extract (match_operand 0 "gpc_reg_operand" "")
		       (match_operand:SI 1 "const_int_operand" "")
		       (match_operand:SI 2 "const_int_operand" ""))
	(match_operand 3 "gpc_reg_operand" ""))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;

  if (TARGET_POWERPC64 && GET_MODE (operands[0]) == DImode)
    emit_insn (gen_insvdi (operands[0], operands[1], operands[2], operands[3]));
  else
    emit_insn (gen_insvsi (operands[0], operands[1], operands[2], operands[3]));
  DONE;
}")

(define_insn "insvsi"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:SI 3 "gpc_reg_operand" "r"))]
  ""
  "*
{
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}"
  [(set_attr "type" "insert_word")])

(define_insn "*insvsi_internal1"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashift:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		   (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}"
  [(set_attr "type" "insert_word")])

(define_insn "*insvsi_internal2"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(ashiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}"
  [(set_attr "type" "insert_word")])

(define_insn "*insvsi_internal3"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(lshiftrt:SI (match_operand:SI 3 "gpc_reg_operand" "r")
		     (match_operand:SI 4 "const_int_operand" "i")))]
  "(32 - (INTVAL (operands[4]) & 31)) >= INTVAL (operands[1])"
  "*
{
  int shift = INTVAL (operands[4]) & 31;
  int start = INTVAL (operands[2]) & 31;
  int size = INTVAL (operands[1]) & 31;

  operands[4] = GEN_INT (32 - shift - start - size);
  operands[1] = GEN_INT (start + size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h4,%h2,%h1\";
}"
  [(set_attr "type" "insert_word")])

(define_insn "*insvsi_internal4"
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(zero_extract:SI (match_operand:SI 3 "gpc_reg_operand" "r")
			 (match_operand:SI 4 "const_int_operand" "i")
			 (match_operand:SI 5 "const_int_operand" "i")))]
  "INTVAL (operands[4]) >= INTVAL (operands[1])"
  "*
{
  int extract_start = INTVAL (operands[5]) & 31;
  int extract_size = INTVAL (operands[4]) & 31;
  int insert_start = INTVAL (operands[2]) & 31;
  int insert_size = INTVAL (operands[1]) & 31;

/* Align extract field with insert field */
  operands[5] = GEN_INT (extract_start + extract_size - insert_start - insert_size);
  operands[1] = GEN_INT (insert_start + insert_size - 1);
  return \"{rlimi|rlwimi} %0,%3,%h5,%h2,%h1\";
}"
  [(set_attr "type" "insert_word")])

(define_insn "insvdi"
  [(set (zero_extract:DI (match_operand:DI 0 "gpc_reg_operand" "+r")
			 (match_operand:SI 1 "const_int_operand" "i")
			 (match_operand:SI 2 "const_int_operand" "i"))
	(match_operand:DI 3 "gpc_reg_operand" "r"))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[2]) & 63;
  int size = INTVAL (operands[1]) & 63;

  operands[1] = GEN_INT (64 - start - size);
  return \"rldimi %0,%3,%H1,%H2\";
}")

(define_expand "extzv"
  [(set (match_operand 0 "gpc_reg_operand" "")
	(zero_extract (match_operand 1 "gpc_reg_operand" "")
		       (match_operand:SI 2 "const_int_operand" "")
		       (match_operand:SI 3 "const_int_operand" "")))]
  ""
  "
{
  /* Do not handle 16/8 bit structures that fit in HI/QI modes directly, since
     the (SUBREG:SI (REG:HI xxx)) that is otherwise generated can confuse the
     compiler if the address of the structure is taken later.  */
  if (GET_CODE (operands[0]) == SUBREG
      && (GET_MODE_SIZE (GET_MODE (SUBREG_REG (operands[0]))) < UNITS_PER_WORD))
    FAIL;

  if (TARGET_POWERPC64 && GET_MODE (operands[1]) == DImode)
    emit_insn (gen_extzvdi (operands[0], operands[1], operands[2], operands[3]));
  else
    emit_insn (gen_extzvsi (operands[0], operands[1], operands[2], operands[3]));
  DONE;
}")

(define_insn "extzvsi"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm|rlwinm} %0,%1,%3,%s2,31\";
}")

(define_insn "*extzvsi_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "const_int_operand" "i,i")
			 (match_operand:SI 3 "const_int_operand" "i,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r,r"))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  /* Force split for non-cc0 compare.  */
  if (which_alternative == 1)
     return \"#\";

  /* If the bit-field being tested fits in the upper or lower half of a
     word, it is possible to use andiu. or andil. to test it.  This is
     useful because the condition register set-use delay is smaller for
     andi[ul]. than for rlinm.  This doesn't work when the starting bit
     position is 0 because the LT and GT bits may be set wrong.  */

  if ((start > 0 && start + size <= 16) || start >= 16)
    {
      operands[3] = GEN_INT (((1 << (16 - (start & 15)))
			      - (1 << (16 - (start & 15) - size))));
      if (start < 16)
	return \"{andiu.|andis.} %4,%1,%3\";
      else
	return \"{andil.|andi.} %4,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm.|rlwinm.} %4,%1,%3,%s2,31\";
}"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "const_int_operand" "")
			 (match_operand:SI 3 "const_int_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed"
  [(set (match_dup 4)
	(zero_extract:SI (match_dup 1) (match_dup 2)
			 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn "*extzvsi_internal2"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "const_int_operand" "i,i")
			 (match_operand:SI 3 "const_int_operand" "i,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  ""
  "*
{
  int start = INTVAL (operands[3]) & 31;
  int size = INTVAL (operands[2]) & 31;

  /* Force split for non-cc0 compare.  */
  if (which_alternative == 1)
     return \"#\";

  /* Since we are using the output value, we can't ignore any need for
     a shift.  The bit-field must end at the LSB.  */
  if (start >= 16 && start + size == 32)
    {
      operands[3] = GEN_INT ((1 << size) - 1);
      return \"{andil.|andi.} %0,%1,%3\";
    }

  if (start + size >= 32)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  return \"{rlinm.|rlwinm.} %0,%1,%3,%s2,31\";
}"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extract:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "const_int_operand" "")
			 (match_operand:SI 3 "const_int_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extract:SI (match_dup 1) (match_dup 2) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "extzvdi"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i")))]
  "TARGET_POWERPC64"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl %0,%1,%3,%2\";
}")

(define_insn "*extzvdi_internal1"
  [(set (match_operand:CC 0 "gpc_reg_operand" "=x")
	(compare:CC (zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (clobber (match_scratch:DI 4 "=r"))]
  "TARGET_64BIT"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl. %4,%1,%3,%2\";
}")

(define_insn "*extzvdi_internal2"
  [(set (match_operand:CC 4 "gpc_reg_operand" "=x")
	(compare:CC (zero_extract:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "const_int_operand" "i")
			 (match_operand:SI 3 "const_int_operand" "i"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extract:DI (match_dup 1) (match_dup 2) (match_dup 3)))]
  "TARGET_64BIT"
  "*
{
  int start = INTVAL (operands[3]) & 63;
  int size = INTVAL (operands[2]) & 63;

  if (start + size >= 64)
    operands[3] = const0_rtx;
  else
    operands[3] = GEN_INT (start + size);
  operands[2] = GEN_INT (64 - size);
  return \"rldicl. %0,%1,%3,%2\";
}")

(define_insn "rotlsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffffffff")

(define_insn "*rotlsi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffffffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "reload_completed"
  [(set (match_dup 3)
	(rotate:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(rotate:SI (match_dup 1) (match_dup 2)))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffffffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(rotate:SI (match_dup 1) (match_dup 2)))]
  "reload_completed"
  [(set (match_dup 0)
	(rotate:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal4"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "reg_or_cint_operand" "ri"))
		(match_operand:SI 3 "mask_operand" "n")))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,%m3,%M3")

(define_insn "*rotlsi3_internal5"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		     (match_operand:SI 3 "mask_operand" "n,n"))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 "=r,r"))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %4,%1,%h2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_cint_operand" ""))
		     (match_operand:SI 3 "mask_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "reload_completed"
  [(set (match_dup 4)
	(and:SI (rotate:SI (match_dup 1)
				(match_dup 2))
		     (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				(match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		     (match_operand:SI 3 "mask_operand" "n,n"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %0,%1,%h2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:SI
		     (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				(match_operand:SI 2 "reg_or_cint_operand" ""))
		     (match_operand:SI 3 "mask_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "reload_completed"
  [(set (match_dup 0)
	(and:SI (rotate:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal7"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xff")

(define_insn "*rotlsi3_internal8"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "reload_completed"
  [(set (match_dup 3)
	(zero_extend:SI (subreg:QI
		      (rotate:SI (match_dup 1)
				 (match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal9"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI
		     (subreg:QI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (subreg:QI (rotate:SI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal10"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")) 0)))]
  ""
  "{rl%I2nm|rlw%I2nm} %0,%1,%h2,0xffff")

(define_insn "*rotlsi3_internal11"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %3,%1,%h2,0xffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "reload_completed"
  [(set (match_dup 3)
	(zero_extend:SI (subreg:HI
		      (rotate:SI (match_dup 1)
				 (match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotlsi3_internal12"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  ""
  "@
   {rl%I2nm.|rlw%I2nm.} %0,%1,%h2,0xffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:SI
		     (subreg:HI
		      (rotate:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))]
  "reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (subreg:HI (rotate:SI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Note that we use "sle." instead of "sl." so that we can set
;; SHIFT_COUNT_TRUNCATED.

(define_expand "ashlsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashlsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashlsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashlsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   sle %0,%1,%2
   {sli|slwi} %0,%1,%h2")

(define_insn "ashlsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sl|slw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i,r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))
   (clobber (match_scratch:SI 4 "=q,X,q,X"))]
  "TARGET_POWER"
  "@
   sle. %3,%1,%2
   {sli.|slwi.} %3,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 3)
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "! TARGET_POWER && TARGET_32BIT"
  "@
   {sl|slw}%I2. %3,%1,%h2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "! TARGET_POWER && TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(ashift:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "r,i,r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X,q,X"))]
  "TARGET_POWER"
  "@
   sle. %0,%1,%2
   {sli.|slwi.} %0,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
	(ashift:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && TARGET_32BIT"
  "@
   {sl|slw}%I2. %0,%1,%h2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashift:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(ashift:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "n")))]
  "includes_lshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%h2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:SI 3 "mask_operand" "n,n"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r,r"))]
  "includes_lshift_p (operands[2], operands[3])"
  "@
   {rlinm.|rlwinm.} %4,%1,%h2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:SI 3 "mask_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "includes_lshift_p (operands[2], operands[3]) && reload_completed"
  [(set (match_dup 4)
	(and:SI (ashift:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:SI 3 "mask_operand" "n,n"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_lshift_p (operands[2], operands[3])"
  "@
   {rlinm.|rlwinm.} %0,%1,%h2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (ashift:SI (match_operand:SI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:SI 3 "mask_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_lshift_p (operands[2], operands[3]) && reload_completed"
  [(set (match_dup 0)
	(and:SI (ashift:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; The AIX assembler mis-handles "sri x,x,0", so write that case as
;; "sli x,x,0".
(define_expand "lshrsi3"
  [(use (match_operand:SI 0 "gpc_reg_operand" ""))
   (use (match_operand:SI 1 "gpc_reg_operand" ""))
   (use (match_operand:SI 2 "reg_or_cint_operand" ""))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_lshrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_lshrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "lshrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,O,i")))
   (clobber (match_scratch:SI 3 "=q,X,X"))]
  "TARGET_POWER"
  "@
  sre %0,%1,%2
  mr %0,%1
  {s%A2i|s%A2wi} %0,%1,%h2")

(define_insn "lshrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "O,ri")))]
  "! TARGET_POWER"
  "@
  mr %0,%1
  {sr|srw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,?y,?y,?y")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,O,i,r,O,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,X,r,r,X,r"))
   (clobber (match_scratch:SI 4 "=q,X,X,q,X,X"))]
  "TARGET_POWER"
  "@
  sre. %3,%1,%2
  mr. %1,%1
  {s%A2i.|s%A2wi.} %3,%1,%h2
  #
  #
  #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,4,8,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 3)
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "O,ri,O,ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=X,r,X,r"))]
  "! TARGET_POWER && TARGET_32BIT"
  "@
   mr. %1,%1
   {sr|srw}%I2. %3,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "! TARGET_POWER && TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,?y,?y,?y")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,O,i,r,O,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X,X,q,X,X"))]
  "TARGET_POWER"
  "@
  sre. %0,%1,%2
  mr. %0,%1
  {s%A2i.|s%A2wi.} %0,%1,%h2
  #
  #
  #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,4,8,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "O,ri,O,ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && TARGET_32BIT"
  "@
   mr. %0,%1
   {sr|srw}%I2. %0,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lshiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(lshiftrt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			     (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:SI 3 "mask_operand" "n")))]
  "includes_rshift_p (operands[2], operands[3])"
  "{rlinm|rlwinm} %0,%1,%s2,%m3,%M3")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:SI 3 "mask_operand" "n,n"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=r,r"))]
  "includes_rshift_p (operands[2], operands[3])"
  "@
   {rlinm.|rlwinm.} %4,%1,%s2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:SI 3 "mask_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "includes_rshift_p (operands[2], operands[3]) && reload_completed"
  [(set (match_dup 4)
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			      (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:SI 3 "mask_operand" "n,n"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_rshift_p (operands[2], operands[3])"
  "@
   {rlinm.|rlwinm.} %0,%1,%s2,%m3,%M3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			      (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:SI 3 "mask_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "includes_rshift_p (operands[2], operands[3]) && reload_completed"
  [(set (match_dup 0)
	(and:SI (lshiftrt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:QI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "{rlinm|rlwinm} %0,%1,%s2,0xff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "const_int_operand" "i,i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "@
   {rlinm.|rlwinm.} %3,%1,%s2,0xff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			(match_operand:SI 2 "const_int_operand" "")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "includes_rshift_p (operands[2], GEN_INT (255)) && reload_completed"
  [(set (match_dup 3)
	(zero_extend:SI (subreg:QI
	   (lshiftrt:SI (match_dup 1)
			(match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "const_int_operand" "i,i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (255))"
  "@
   {rlinm.|rlwinm.} %0,%1,%s2,0xff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (zero_extend:SI
	  (subreg:QI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			(match_operand:SI 2 "const_int_operand" "")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (255)) && reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (subreg:QI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(zero_extend:SI
	 (subreg:HI
	  (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "const_int_operand" "i")) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "{rlinm|rlwinm} %0,%1,%s2,0xffff")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "const_int_operand" "i,i")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "@
   {rlinm.|rlwinm.} %3,%1,%s2,0xffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			(match_operand:SI 2 "const_int_operand" "")) 0))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "includes_rshift_p (operands[2], GEN_INT (65535)) && reload_completed"
  [(set (match_dup 3)
	(zero_extend:SI (subreg:HI
	   (lshiftrt:SI (match_dup 1)
			(match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "const_int_operand" "i,i")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (65535))"
  "@
   {rlinm.|rlwinm.} %0,%1,%s2,0xffff
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (zero_extend:SI
	  (subreg:HI
	   (lshiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			(match_operand:SI 2 "const_int_operand" "")) 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))]
  "includes_rshift_p (operands[2], GEN_INT (65535)) && reload_completed"
  [(set (match_dup 0)
	(zero_extend:SI (subreg:HI (lshiftrt:SI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(ashiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(lshiftrt:SI (match_operand:SI 2 "gpc_reg_operand" "r")
		     (const_int 31)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_insn ""
  [(set (zero_extract:SI (match_operand:SI 0 "gpc_reg_operand" "+r")
			 (const_int 1)
			 (match_operand:SI 1 "gpc_reg_operand" "r"))
	(zero_extract:SI (match_operand:SI 2 "gpc_reg_operand" "r")
			 (const_int 1)
			 (const_int 0)))]
  "TARGET_POWER"
  "rrib %0,%1,%2")

(define_expand "ashrsi3"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  ""
  "
{
  if (TARGET_POWER)
    emit_insn (gen_ashrsi3_power (operands[0], operands[1], operands[2]));
  else
    emit_insn (gen_ashrsi3_no_power (operands[0], operands[1], operands[2]));
  DONE;
}")

(define_insn "ashrsi3_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "r,i")))
   (clobber (match_scratch:SI 3 "=q,X"))]
  "TARGET_POWER"
  "@
   srea %0,%1,%2
   {srai|srawi} %0,%1,%h2")

(define_insn "ashrsi3_no_power"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "! TARGET_POWER"
  "{sra|sraw}%I2 %0,%1,%h2")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i,r,i"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r,r,r"))
   (clobber (match_scratch:SI 4 "=q,X,q,X"))]
  "TARGET_POWER"
  "@
   srea. %3,%1,%2
   {srai.|srawi.} %3,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 3)
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "! TARGET_POWER"
  "@
   {sra|sraw}%I2. %3,%1,%h2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "! TARGET_POWER && reload_completed"
  [(set (match_dup 3)
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "r,i,r,i"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 "=q,X,q,X"))]
  "TARGET_POWER"
  "@
   srea. %0,%1,%2
   {srai.|srawi.} %0,%1,%h2
   #
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER"
  "@
   {sra|sraw}%I2. %0,%1,%h2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:SI (match_operand:SI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ashiftrt:SI (match_dup 1) (match_dup 2)))]
  "! TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(ashiftrt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Floating-point insns, excluding normal data motion.
;;
;; PowerPC has a full set of single-precision floating point instructions.
;;
;; For the POWER architecture, we pretend that we have both SFmode and
;; DFmode insns, while, in fact, all fp insns are actually done in double.
;; The only conversions we will do will be when storing to memory.  In that
;; case, we will use the "frsp" instruction before storing.
;;
;; Note that when we store into a single-precision memory location, we need to
;; use the frsp insn first.  If the register being stored isn't dead, we
;; need a scratch register for the frsp.  But this is difficult when the store
;; is done by reload.  It is not incorrect to do the frsp on the register in
;; this case, we just lose precision that we would have otherwise gotten but
;; is not guaranteed.  Perhaps this should be tightened up at some point.

(define_insn "extendsfdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float_extend:DF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"fmr %0,%1\";
}"
  [(set_attr "type" "fp")])

(define_insn "truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(float_truncate:SF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_insn "aux_truncdfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(unspec:SF [(match_operand:SF 1 "gpc_reg_operand" "f")] UNSPEC_FRSP))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "frsp %0,%1"
  [(set_attr "type" "fp")])

(define_expand "negsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(neg:SF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*negsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_expand "abssf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(abs:SF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn "*abssf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(abs:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (abs:SF (match_operand:SF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_expand "addsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fadds %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "subsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "")
		  (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsubs %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		  (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_expand "mulsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "")
		 (match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fmuls %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
		 (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "dmul")])

(define_expand "divsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "")
		(match_operand:SF 2 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fdivs %0,%1,%2"
  [(set_attr "type" "sdiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(div:SF (match_operand:SF 1 "gpc_reg_operand" "f")
		(match_operand:SF 2 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "ddiv")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "fmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			  (match_operand:SF 2 "gpc_reg_operand" "f"))
		 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "fmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
		  (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && HONOR_SIGNED_ZEROS (SFmode)"
  "fnmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (neg:SF (match_operand:SF 1 "gpc_reg_operand" "f"))
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && ! HONOR_SIGNED_ZEROS (SFmode)"
  "fnmadds %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (plus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				  (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (mult:SF (neg:SF (match_operand:SF 1 "gpc_reg_operand" "f"))
			   (match_operand:SF 2 "gpc_reg_operand" "f"))
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && ! HONOR_SIGNED_ZEROS (SFmode)"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && HONOR_SIGNED_ZEROS (SFmode)"
  "fnmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 3 "gpc_reg_operand" "f")
		  (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))))]
  "TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && ! HONOR_SIGNED_ZEROS (SFmode)"
  "fnmsubs %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(neg:SF (minus:SF (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
				   (match_operand:SF 2 "gpc_reg_operand" "f"))
			  (match_operand:SF 3 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(minus:SF (match_operand:SF 3 "gpc_reg_operand" "f")
		  (mult:SF (match_operand:SF 1 "gpc_reg_operand" "%f")
			   (match_operand:SF 2 "gpc_reg_operand" "f"))))]
  "! TARGET_POWERPC && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && ! HONOR_SIGNED_ZEROS (SFmode)"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_expand "sqrtsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT && TARGET_FPRS"
  "")

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GPOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsqrts %0,%1"
  [(set_attr "type" "ssqrt")])

(define_insn ""
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(sqrt:SF (match_operand:SF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWER2 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; For MIN, MAX, and conditional move, we use DEFINE_EXPAND's that involve a
;; fsel instruction and some auxiliary computations.  Then we just have a
;; single DEFINE_INSN for fsel and the define_splits to make them if made by
;; combine.
(define_expand "maxsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_operand:SF 1 "gpc_reg_operand" "")
			     (match_operand:SF 2 "gpc_reg_operand" ""))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{ rs6000_emit_minmax (operands[0], SMAX, operands[1], operands[2]); DONE;}")

(define_expand "minsf3"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(if_then_else:SF (ge (match_operand:SF 1 "gpc_reg_operand" "")
			     (match_operand:SF 2 "gpc_reg_operand" ""))
			 (match_dup 2)
			 (match_dup 1)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{ rs6000_emit_minmax (operands[0], SMIN, operands[1], operands[2]); DONE;}")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operator:SF 3 "min_max_operator"
	 [(match_operand:SF 1 "gpc_reg_operand" "")
	  (match_operand:SF 2 "gpc_reg_operand" "")]))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  [(const_int 0)]
  "
{ rs6000_emit_minmax (operands[0], GET_CODE (operands[3]), 
		      operands[1], operands[2]);
  DONE;
}")

(define_expand "movsicc"
   [(set (match_operand:SI 0 "gpc_reg_operand" "")
	 (if_then_else:SI (match_operand 1 "comparison_operator" "")
			  (match_operand:SI 2 "gpc_reg_operand" "")
			  (match_operand:SI 3 "gpc_reg_operand" "")))]
  "TARGET_ISEL"
  "
{
  if (rs6000_emit_cmove (operands[0], operands[1], operands[2], operands[3]))
    DONE;
  else
    FAIL;
}")

;; We use the BASE_REGS for the isel input operands because, if rA is
;; 0, the value of 0 is placed in rD upon truth.  Similarly for rB
;; because we may switch the operands and rB may end up being rA.
;;
;; We need 2 patterns: an unsigned and a signed pattern.  We could
;; leave out the mode in operand 4 and use one pattern, but reload can
;; change the mode underneath our feet and then gets confused trying
;; to reload the value.
(define_insn "isel_signed"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI
	 (match_operator 1 "comparison_operator"
			 [(match_operand:CC 4 "cc_reg_operand" "y")
			  (const_int 0)])
	 (match_operand:SI 2 "gpc_reg_operand" "b")
	 (match_operand:SI 3 "gpc_reg_operand" "b")))]
  "TARGET_ISEL"
  "*
{ return output_isel (operands); }"
  [(set_attr "length" "4")])

(define_insn "isel_unsigned"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(if_then_else:SI
	 (match_operator 1 "comparison_operator"
			 [(match_operand:CCUNS 4 "cc_reg_operand" "y")
			  (const_int 0)])
	 (match_operand:SI 2 "gpc_reg_operand" "b")
	 (match_operand:SI 3 "gpc_reg_operand" "b")))]
  "TARGET_ISEL"
  "*
{ return output_isel (operands); }"
  [(set_attr "length" "4")])

(define_expand "movsfcc"
   [(set (match_operand:SF 0 "gpc_reg_operand" "")
	 (if_then_else:SF (match_operand 1 "comparison_operator" "")
			  (match_operand:SF 2 "gpc_reg_operand" "")
			  (match_operand:SF 3 "gpc_reg_operand" "")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  if (rs6000_emit_cmove (operands[0], operands[1], operands[2], operands[3]))
    DONE;
  else
    FAIL;
}")

(define_insn "*fselsfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (match_operand:SF 4 "zero_fp_constant" "F"))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "*fseldfsf4"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(if_then_else:SF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (match_operand:DF 4 "zero_fp_constant" "F"))
			 (match_operand:SF 2 "gpc_reg_operand" "f")
			 (match_operand:SF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "negdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fneg %0,%1"
  [(set_attr "type" "fp")])

(define_insn "absdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(abs:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (abs:DF (match_operand:DF 1 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fnabs %0,%1"
  [(set_attr "type" "fp")])

(define_insn "adddf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fa|fadd} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "subdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		  (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fs|fsub} %0,%1,%2"
  [(set_attr "type" "fp")])

(define_insn "muldf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
		 (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fm|fmul} %0,%1,%2"
  [(set_attr "type" "dmul")])

(define_insn "divdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(div:DF (match_operand:DF 1 "gpc_reg_operand" "f")
		(match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fd|fdiv} %0,%1,%2"
  [(set_attr "type" "ddiv")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			  (match_operand:DF 2 "gpc_reg_operand" "f"))
		 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fma|fmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			   (match_operand:DF 2 "gpc_reg_operand" "f"))
		  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD"
  "{fms|fmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (plus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				  (match_operand:DF 2 "gpc_reg_operand" "f"))
			 (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && HONOR_SIGNED_ZEROS (DFmode)"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (mult:DF (neg:DF (match_operand:DF 1 "gpc_reg_operand" "f"))
			   (match_operand:DF 2 "gpc_reg_operand" "f"))
		  (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && ! HONOR_SIGNED_ZEROS (DFmode)"
  "{fnma|fnmadd} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(neg:DF (minus:DF (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
				   (match_operand:DF 2 "gpc_reg_operand" "f"))
			  (match_operand:DF 3 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD
   && HONOR_SIGNED_ZEROS (DFmode)"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn ""
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(minus:DF (match_operand:DF 3 "gpc_reg_operand" "f")
	          (mult:DF (match_operand:DF 1 "gpc_reg_operand" "%f")
			   (match_operand:DF 2 "gpc_reg_operand" "f"))))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_FUSED_MADD 
   && ! HONOR_SIGNED_ZEROS (DFmode)"
  "{fnms|fnmsub} %0,%1,%2,%3"
  [(set_attr "type" "dmul")])

(define_insn "sqrtdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(sqrt:DF (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "(TARGET_PPC_GPOPT || TARGET_POWER2) && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsqrt %0,%1"
  [(set_attr "type" "dsqrt")])

;; The conditional move instructions allow us to perform max and min
;; operations even when 

(define_expand "maxdf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_operand:DF 1 "gpc_reg_operand" "")
			     (match_operand:DF 2 "gpc_reg_operand" ""))
			 (match_dup 1)
			 (match_dup 2)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{ rs6000_emit_minmax (operands[0], SMAX, operands[1], operands[2]); DONE;}")

(define_expand "mindf3"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(if_then_else:DF (ge (match_operand:DF 1 "gpc_reg_operand" "")
			     (match_operand:DF 2 "gpc_reg_operand" ""))
			 (match_dup 2)
			 (match_dup 1)))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{ rs6000_emit_minmax (operands[0], SMIN, operands[1], operands[2]); DONE;}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operator:DF 3 "min_max_operator"
	 [(match_operand:DF 1 "gpc_reg_operand" "")
	  (match_operand:DF 2 "gpc_reg_operand" "")]))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  [(const_int 0)]
  "
{ rs6000_emit_minmax (operands[0], GET_CODE (operands[3]), 
		      operands[1], operands[2]);
  DONE;
}")

(define_expand "movdfcc"
   [(set (match_operand:DF 0 "gpc_reg_operand" "")
	 (if_then_else:DF (match_operand 1 "comparison_operator" "")
			  (match_operand:DF 2 "gpc_reg_operand" "")
			  (match_operand:DF 3 "gpc_reg_operand" "")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  if (rs6000_emit_cmove (operands[0], operands[1], operands[2], operands[3]))
    DONE;
  else
    FAIL;
}")

(define_insn "*fseldfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:DF 1 "gpc_reg_operand" "f")
			     (match_operand:DF 4 "zero_fp_constant" "F"))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

(define_insn "*fselsfdf4"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(if_then_else:DF (ge (match_operand:SF 1 "gpc_reg_operand" "f")
			     (match_operand:SF 4 "zero_fp_constant" "F"))
			 (match_operand:DF 2 "gpc_reg_operand" "f")
			 (match_operand:DF 3 "gpc_reg_operand" "f")))]
  "TARGET_PPC_GFXOPT"
  "fsel %0,%1,%2,%3"
  [(set_attr "type" "fp")])

;; Conversions to and from floating-point.

(define_expand "fixuns_truncsfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unsigned_fix:SI (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT && !TARGET_FPRS"
  "")

(define_expand "fix_truncsfsi2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:SI (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT && !TARGET_FPRS"
  "")

; For each of these conversions, there is a define_expand, a define_insn
; with a '#' template, and a define_split (with C code).  The idea is
; to allow constant folding with the template of the define_insn,
; then to have the insns split later (between sched1 and final).

(define_expand "floatsidf2"
  [(parallel [(set (match_operand:DF 0 "gpc_reg_operand" "")
		   (float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))
	      (clobber (match_dup 6))])]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  if (TARGET_POWERPC64)
    {
      rtx mem = assign_stack_temp (DImode, GET_MODE_SIZE (DImode), 0);
      rtx t1 = gen_reg_rtx (DImode);
      rtx t2 = gen_reg_rtx (DImode);
      emit_insn (gen_floatsidf_ppc64 (operands[0], operands[1], mem, t1, t2));
      DONE;
    }

  operands[2] = force_reg (SImode, GEN_INT (0x43300000));
  operands[3] = force_reg (DFmode, CONST_DOUBLE_ATOF (\"4503601774854144\", DFmode));
  operands[4] = assign_stack_temp (DFmode, GET_MODE_SIZE (DFmode), 0);
  operands[5] = gen_reg_rtx (DFmode);
  operands[6] = gen_reg_rtx (SImode);
}")

(define_insn "*floatsidf2_internal"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=&f")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (use (match_operand:SI 2 "gpc_reg_operand" "r"))
   (use (match_operand:DF 3 "gpc_reg_operand" "f"))
   (clobber (match_operand:DF 4 "memory_operand" "=o"))
   (clobber (match_operand:DF 5 "gpc_reg_operand" "=&f"))
   (clobber (match_operand:SI 6 "gpc_reg_operand" "=&r"))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  [(set_attr "length" "24")])

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand:DF 4 "offsettable_mem_operand" ""))
   (clobber (match_operand:DF 5 "gpc_reg_operand" ""))
   (clobber (match_operand:SI 6 "gpc_reg_operand" ""))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand:DF 4 "offsettable_mem_operand" ""))
   (clobber (match_operand:DF 5 "gpc_reg_operand" ""))
   (clobber (match_operand:SI 6 "gpc_reg_operand" ""))]
  "
{
  rtx lowword, highword;
  if (GET_CODE (operands[4]) != MEM)
    abort();
  highword = XEXP (operands[4], 0);
  lowword = plus_constant (highword, 4);
  if (! WORDS_BIG_ENDIAN)
    {
      rtx tmp;
      tmp = highword; highword = lowword; lowword = tmp;
    }

  emit_insn (gen_xorsi3 (operands[6], operands[1], 
			 GEN_INT (~ (HOST_WIDE_INT) 0x7fffffff)));
  emit_move_insn (gen_rtx_MEM (SImode, lowword), operands[6]);
  emit_move_insn (gen_rtx_MEM (SImode, highword), operands[2]);
  emit_move_insn (operands[5], operands[4]);
  emit_insn (gen_subdf3 (operands[0], operands[5], operands[3]));
  DONE;
}")

(define_expand "floatunssisf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
        (unsigned_float:SF (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT && !TARGET_FPRS"
  "")

(define_expand "floatunssidf2"
  [(parallel [(set (match_operand:DF 0 "gpc_reg_operand" "")
		   (unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
	      (use (match_dup 2))
	      (use (match_dup 3))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))])]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  if (TARGET_POWERPC64)
    {
      rtx mem = assign_stack_temp (DImode, GET_MODE_SIZE (DImode), 0);
      rtx t1 = gen_reg_rtx (DImode);
      rtx t2 = gen_reg_rtx (DImode);
      emit_insn (gen_floatunssidf_ppc64 (operands[0], operands[1], mem,
					 t1, t2));
      DONE;
    }

  operands[2] = force_reg (SImode, GEN_INT (0x43300000));
  operands[3] = force_reg (DFmode, CONST_DOUBLE_ATOF (\"4503599627370496\", DFmode));
  operands[4] = assign_stack_temp (DFmode, GET_MODE_SIZE (DFmode), 0);
  operands[5] = gen_reg_rtx (DFmode);
}")

(define_insn "*floatunssidf2_internal"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=&f")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (use (match_operand:SI 2 "gpc_reg_operand" "r"))
   (use (match_operand:DF 3 "gpc_reg_operand" "f"))
   (clobber (match_operand:DF 4 "memory_operand" "=o"))
   (clobber (match_operand:DF 5 "gpc_reg_operand" "=&f"))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  [(set_attr "length" "20")])

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand:DF 4 "offsettable_mem_operand" ""))
   (clobber (match_operand:DF 5 "gpc_reg_operand" ""))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "")))
   (use (match_operand:SI 2 "gpc_reg_operand" ""))
   (use (match_operand:DF 3 "gpc_reg_operand" ""))
   (clobber (match_operand:DF 4 "offsettable_mem_operand" ""))
   (clobber (match_operand:DF 5 "gpc_reg_operand" ""))]
  "
{
  rtx lowword, highword;
  if (GET_CODE (operands[4]) != MEM)
    abort();
  highword = XEXP (operands[4], 0);
  lowword = plus_constant (highword, 4);
  if (! WORDS_BIG_ENDIAN)
    {
      rtx tmp;
      tmp = highword; highword = lowword; lowword = tmp;
    }

  emit_move_insn (gen_rtx_MEM (SImode, lowword), operands[1]);
  emit_move_insn (gen_rtx_MEM (SImode, highword), operands[2]);
  emit_move_insn (operands[5], operands[4]);
  emit_insn (gen_subdf3 (operands[0], operands[5], operands[3]));
  DONE;
}")

(define_expand "fix_truncdfsi2"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))
	      (clobber (match_dup 2))
	      (clobber (match_dup 3))])]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  operands[2] = gen_reg_rtx (DImode);
  operands[3] = assign_stack_temp (DImode, GET_MODE_SIZE (DImode), 0);
}")

(define_insn "*fix_truncdfsi2_internal"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "f")))
   (clobber (match_operand:DI 2 "gpc_reg_operand" "=f"))
   (clobber (match_operand:DI 3 "memory_operand" "=o"))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  [(set_attr "length" "16")])

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))
   (clobber (match_operand:DI 2 "gpc_reg_operand" ""))
   (clobber (match_operand:DI 3 "offsettable_mem_operand" ""))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT && TARGET_FPRS"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(fix:SI (match_operand:DF 1 "gpc_reg_operand" "")))
   (clobber (match_operand:DI 2 "gpc_reg_operand" ""))
   (clobber (match_operand:DI 3 "offsettable_mem_operand" ""))]
  "
{
  rtx lowword;
  if (GET_CODE (operands[3]) != MEM)
    abort();
  lowword = XEXP (operands[3], 0);
  if (WORDS_BIG_ENDIAN)
    lowword = plus_constant (lowword, 4);

  emit_insn (gen_fctiwz (operands[2], operands[1]));
  emit_move_insn (operands[3], operands[2]);
  emit_move_insn (operands[0], gen_rtx_MEM (SImode, lowword));
  DONE;
}")

; Here, we use (set (reg) (unspec:DI [(fix:SI ...)] UNSPEC_FCTIWZ))
; rather than (set (subreg:SI (reg)) (fix:SI ...))
; because the first makes it clear that operand 0 is not live
; before the instruction.
(define_insn "fctiwz"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=*f")
	(unspec:DI [(fix:SI (match_operand:DF 1 "gpc_reg_operand" "f"))]
		   UNSPEC_FCTIWZ))]
  "(TARGET_POWER2 || TARGET_POWERPC) && TARGET_HARD_FLOAT && TARGET_FPRS"
  "{fcirz|fctiwz} %0,%1"
  [(set_attr "type" "fp")])

(define_expand "floatsisf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
        (float:SF (match_operand:SI 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT && !TARGET_FPRS"
  "")

(define_insn "floatdidf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float:DF (match_operand:DI 1 "gpc_reg_operand" "*f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fcfid %0,%1"
  [(set_attr "type" "fp")])

(define_insn_and_split "floatsidf_ppc64"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (clobber (match_operand:DI 2 "memory_operand" "=o"))
   (clobber (match_operand:DI 3 "gpc_reg_operand" "=r"))
   (clobber (match_operand:DI 4 "gpc_reg_operand" "=f"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  "&& 1"
  [(set (match_dup 3) (sign_extend:DI (match_dup 1)))
   (set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 2))
   (set (match_dup 0) (float:DF (match_dup 4)))]
  "")

(define_insn_and_split "floatunssidf_ppc64"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(unsigned_float:DF (match_operand:SI 1 "gpc_reg_operand" "r")))
   (clobber (match_operand:DI 2 "memory_operand" "=o"))
   (clobber (match_operand:DI 3 "gpc_reg_operand" "=r"))
   (clobber (match_operand:DI 4 "gpc_reg_operand" "=f"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  "&& 1"
  [(set (match_dup 3) (zero_extend:DI (match_dup 1)))
   (set (match_dup 2) (match_dup 3))
   (set (match_dup 4) (match_dup 2))
   (set (match_dup 0) (float:DF (match_dup 4)))]
  "")

(define_insn "fix_truncdfdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=*f")
	(fix:DI (match_operand:DF 1 "gpc_reg_operand" "f")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "fctidz %0,%1"
  [(set_attr "type" "fp")])

(define_expand "floatdisf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
        (float:SF (match_operand:DI 1 "gpc_reg_operand" "")))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  rtx val = operands[1];
  if (!flag_unsafe_math_optimizations)
    {
      rtx label = gen_label_rtx ();
      val = gen_reg_rtx (DImode);
      emit_insn (gen_floatdisf2_internal2 (val, operands[1], label));
      emit_label (label);
    }
  emit_insn (gen_floatdisf2_internal1 (operands[0], val));
  DONE;
}")

;; This is not IEEE compliant if rounding mode is "round to nearest".
;; If the DI->DF conversion is inexact, then it's possible to suffer
;; from double rounding.
(define_insn_and_split "floatdisf2_internal1"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
        (float:SF (match_operand:DI 1 "gpc_reg_operand" "*f")))
   (clobber (match_scratch:DF 2 "=f"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "#"
  "&& reload_completed"
  [(set (match_dup 2)
        (float:DF (match_dup 1)))
   (set (match_dup 0)
        (float_truncate:SF (match_dup 2)))]
  "")

;; Twiddles bits to avoid double rounding.
;; Bits that might be truncated when converting to DFmode are replaced
;; by a bit that won't be lost at that stage, but is below the SFmode
;; rounding position.
(define_expand "floatdisf2_internal2"
  [(set (match_dup 3) (ashiftrt:DI (match_operand:DI 1 "" "")
				   (const_int 53)))
   (parallel [(set (match_operand:DI 0 "" "") (and:DI (match_dup 1)
						      (const_int 2047)))
	      (clobber (scratch:CC))])
   (set (match_dup 3) (plus:DI (match_dup 3)
			       (const_int 1)))
   (set (match_dup 0) (plus:DI (match_dup 0)
			       (const_int 2047)))
   (set (match_dup 4) (compare:CCUNS (match_dup 3)
				     (const_int 3)))
   (set (match_dup 0) (ior:DI (match_dup 0)
			      (match_dup 1)))
   (parallel [(set (match_dup 0) (and:DI (match_dup 0)
					 (const_int -2048)))
	      (clobber (scratch:CC))])
   (set (pc) (if_then_else (geu (match_dup 4) (const_int 0))
			   (label_ref (match_operand:DI 2 "" ""))
			   (pc)))
   (set (match_dup 0) (match_dup 1))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  operands[3] = gen_reg_rtx (DImode);
  operands[4] = gen_reg_rtx (CCUNSmode);
}")

;; Define the DImode operations that can be done in a small number
;; of instructions.  The & constraints are to prevent the register
;; allocator from allocating registers that overlap with the inputs
;; (for example, having an input in 7,8 and an output in 6,7).  We
;; also allow for the output being the same as one of the inputs.

(define_insn "*adddi3_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,0,0")
		 (match_operand:DI 2 "reg_or_short_operand" "r,I,r,I")))]
  "! TARGET_POWERPC64"
  "*
{
  if (WORDS_BIG_ENDIAN)
    return (GET_CODE (operands[2])) != CONST_INT
	    ? \"{a|addc} %L0,%L1,%L2\;{ae|adde} %0,%1,%2\"
	    : \"{ai|addic} %L0,%L1,%2\;{a%G2e|add%G2e} %0,%1\";
  else
    return (GET_CODE (operands[2])) != CONST_INT
	    ? \"{a|addc} %0,%1,%2\;{ae|adde} %L0,%L1,%L2\"
	    : \"{ai|addic} %0,%1,%2\;{a%G2e|add%G2e} %L0,%L1\";
}"
  [(set_attr "length" "8")])

(define_insn "*subdi3_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,r,r,r")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "r,I,0,r,I")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r,r,0,0")))]
  "! TARGET_POWERPC64"
  "*
{
  if (WORDS_BIG_ENDIAN)
    return (GET_CODE (operands[1]) != CONST_INT)
	    ? \"{sf|subfc} %L0,%L2,%L1\;{sfe|subfe} %0,%2,%1\"
	    : \"{sfi|subfic} %L0,%L2,%1\;{sf%G1e|subf%G1e} %0,%2\";
  else
    return (GET_CODE (operands[1]) != CONST_INT)
	    ? \"{sf|subfc} %0,%2,%1\;{sfe|subfe} %L0,%L2,%L1\"
	    : \"{sfi|subfic} %0,%2,%1\;{sf%G1e|subf%G1e} %L0,%L2\";
}"
  [(set_attr "length" "8")])

(define_insn "*negdi2_noppc64"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))]
  "! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"{sfi|subfic} %L0,%L1,0\;{sfze|subfze} %0,%1\"
    : \"{sfi|subfic} %0,%1,0\;{sfze|subfze} %L0,%L1\";
}"
  [(set_attr "length" "8")])

(define_expand "mulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "! TARGET_POWERPC64"
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_mull_call ());
      if (WORDS_BIG_ENDIAN)
        emit_move_insn (operands[0], gen_rtx_REG (DImode, 3));
      else
	{
	  emit_move_insn (operand_subword (operands[0], 0, 0, DImode),
			  gen_rtx_REG (SImode, 3));
	  emit_move_insn (operand_subword (operands[0], 1, 0, DImode),
			  gen_rtx_REG (SImode, 4));
	}
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_mulsidi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "mulsidi3_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2\;mfmq %L0"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_insn "*mulsidi3_no_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC && ! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhw %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhw %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (sign_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (sign_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI (match_dup 1))
			       (sign_extend:DI (match_dup 2)))
		      (const_int 32))))
   (set (match_dup 4)
	(mult:SI (match_dup 1)
		 (match_dup 2)))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  operands[3] = operand_subword (operands[0], endian, 0, DImode);
  operands[4] = operand_subword (operands[0], 1 - endian, 0, DImode);
}")

(define_expand "umulsidi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64"
  "
{
  if (TARGET_POWER)
    {
      emit_insn (gen_umulsidi3_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "umulsidi3_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhwu %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhwu %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_insn "*umulsidi3_no_mq"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" "%r"))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" "r"))))]
  "TARGET_POWERPC && ! TARGET_POWER && ! TARGET_POWERPC64"
  "*
{
  return (WORDS_BIG_ENDIAN)
    ? \"mulhwu %0,%1,%2\;mullw %L0,%1,%2\"
    : \"mulhwu %L0,%1,%2\;mullw %0,%1,%2\";
}"
  [(set_attr "type" "imul")
   (set_attr "length" "8")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (zero_extend:DI (match_operand:SI 1 "gpc_reg_operand" ""))
		 (zero_extend:DI (match_operand:SI 2 "gpc_reg_operand" ""))))]
  "TARGET_POWERPC && ! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI (match_dup 1))
			       (zero_extend:DI (match_dup 2)))
		      (const_int 32))))
   (set (match_dup 4)
	(mult:SI (match_dup 1)
		 (match_dup 2)))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  operands[3] = operand_subword (operands[0], endian, 0, DImode);
  operands[4] = operand_subword (operands[0], 1 - endian, 0, DImode);
}")

(define_expand "smulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  ""
  "
{
  if (! TARGET_POWER && ! TARGET_POWERPC)
    {
      emit_move_insn (gen_rtx_REG (SImode, 3), operands[1]);
      emit_move_insn (gen_rtx_REG (SImode, 4), operands[2]);
      emit_insn (gen_mulh_call ());
      emit_move_insn (operands[0], gen_rtx_REG (SImode, 3));
      DONE;
    }
  else if (TARGET_POWER)
    {
      emit_insn (gen_smulsi3_highpart_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "smulsi3_highpart_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWER"
  "mul %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "*smulsi3_highpart_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (sign_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "mulhw %0,%1,%2"
  [(set_attr "type" "imul")])

(define_expand "umulsi3_highpart"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" ""))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "")))
		      (const_int 32))))]
  "TARGET_POWERPC"
  "
{
  if (TARGET_POWER)
    {
      emit_insn (gen_umulsi3_highpart_mq (operands[0], operands[1], operands[2]));
      DONE;
    }
}")

(define_insn "umulsi3_highpart_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))
   (clobber (match_scratch:SI 3 "=q"))]
  "TARGET_POWERPC && TARGET_POWER"
  "mulhwu %0,%1,%2"
  [(set_attr "type" "imul")])

(define_insn "*umulsi3_highpart_no_mq"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(truncate:SI
	 (lshiftrt:DI (mult:DI (zero_extend:DI
				(match_operand:SI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:DI
				(match_operand:SI 2 "gpc_reg_operand" "r")))
		      (const_int 32))))]
  "TARGET_POWERPC && ! TARGET_POWER"
  "mulhwu %0,%1,%2"
  [(set_attr "type" "imul")])

;; If operands 0 and 2 are in the same register, we have a problem.  But
;; operands 0 and 1 (the usual case) can be in the same register.  That's
;; why we have the strange constraints below.
(define_insn "ashldi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		   (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {sli|slwi} %0,%L1,%h2\;{cal %L0,0(0)|li %L0,0}
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2
   sl%I2q %L0,%L1,%h2\;sll%I2q %0,%1,%h2"
  [(set_attr "length" "8")])

(define_insn "lshrdi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,&r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,0,r")
		     (match_operand:SI 2 "reg_or_cint_operand" "M,i,r,r")))
   (clobber (match_scratch:SI 3 "=X,q,q,q"))]
  "TARGET_POWER"
  "@
   {s%A2i|s%A2wi} %L0,%1,%h2\;{cal %0,0(0)|li %0,0}
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2
   sr%I2q %0,%1,%h2\;srl%I2q %L0,%L1,%h2"
  [(set_attr "length" "8")])

;; Shift by a variable amount is too complex to be worth open-coding.  We
;; just handle shifts by constants.
(define_insn "ashrdi3_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "const_int_operand" "M,i")))
   (clobber (match_scratch:SI 3 "=X,q"))]
  "TARGET_POWER"
  "@
   {srai|srawi} %0,%1,31\;{srai|srawi} %L0,%1,%h2
   sraiq %0,%1,%h2\;srliq %L0,%L1,%h2"
  [(set_attr "length" "8")])

(define_insn "ashrdi3_no_power"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		     (match_operand:SI 2 "const_int_operand" "M,i")))]
  "TARGET_32BIT && !TARGET_POWERPC64 && !TARGET_POWER && WORDS_BIG_ENDIAN"
  "@
   {srai|srawi} %0,%1,31\;{srai|srawi} %L0,%1,%h2
   {sri|srwi} %L0,%L1,%h2\;insrwi %L0,%1,%h2,0\;{srai|srawi} %0,%1,%h2"
  [(set_attr "length" "8,12")])

(define_insn "*ashrdisi3_noppc64"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (subreg:SI (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")    
                                (const_int 32)) 4))]
  "TARGET_32BIT && !TARGET_POWERPC64"
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]))
    return \"\";
  else
    return \"mr %0,%1\";
}"
   [(set_attr "length" "4")])      


;; PowerPC64 DImode operations.

(define_expand "adddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_add_cint64_operand" "")))]
  ""
  "
{
  if (! TARGET_POWERPC64)
    {
      if (non_short_cint_operand (operands[2], DImode))
	FAIL;
    }
  else
    if (GET_CODE (operands[2]) == CONST_INT
	&& ! add_operand (operands[2], DImode))
      {
	rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		   ? operands[0] : gen_reg_rtx (DImode));

	HOST_WIDE_INT val = INTVAL (operands[2]);
	HOST_WIDE_INT low = ((val & 0xffff) ^ 0x8000) - 0x8000;
	HOST_WIDE_INT rest = trunc_int_for_mode (val - low, DImode);

	if (!CONST_OK_FOR_LETTER_P (rest, 'L'))
	  FAIL;

	/* The ordering here is important for the prolog expander.
	   When space is allocated from the stack, adding 'low' first may
	   produce a temporary deallocation (which would be bad).  */
	emit_insn (gen_adddi3 (tmp, operands[1], GEN_INT (rest)));
	emit_insn (gen_adddi3 (operands[0], tmp, GEN_INT (low)));
	DONE;
      }
}")

;; Discourage ai/addic because of carry but provide it in an alternative
;; allowing register zero as source.

(define_insn "*adddi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,?r,r")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,b,r,b")
		 (match_operand:DI 2 "add_operand" "r,I,I,L")))]
  "TARGET_POWERPC64"
  "@
   add %0,%1,%2
   addi %0,%1,%2
   addic %0,%1,%2
   addis %0,%1,%v2")

(define_insn "*adddi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r")
			     (match_operand:DI 2 "reg_or_short_operand" "r,I,r,I"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r,r,r"))]
  "TARGET_64BIT"
  "@
   add. %3,%1,%2
   addic. %3,%1,%2
   #
   #"
  [(set_attr "type" "fast_compare,compare,compare,compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
			     (match_operand:DI 2 "reg_or_short_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(plus:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*adddi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r")
			     (match_operand:DI 2 "reg_or_short_operand" "r,I,r,I"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   add. %0,%1,%2
   addic. %0,%1,%2
   #
   #"
  [(set_attr "type" "fast_compare,compare,compare,compare")
   (set_attr "length" "4,4,8,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
			     (match_operand:DI 2 "reg_or_short_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(plus:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Split an add that we can't do in one insn into two insns, each of which
;; does one 16-bit part.  This is used by combine.  Note that the low-order
;; add should be last in case the result gets used in an address.

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "non_add_cint_operand" "")))]
  "TARGET_POWERPC64"
  [(set (match_dup 0) (plus:DI (match_dup 1) (match_dup 3)))
   (set (match_dup 0) (plus:DI (match_dup 0) (match_dup 4)))]
"
{
  HOST_WIDE_INT val = INTVAL (operands[2]);
  HOST_WIDE_INT low = ((val & 0xffff) ^ 0x8000) - 0x8000;
  HOST_WIDE_INT rest = trunc_int_for_mode (val - low, DImode);

  operands[4] = GEN_INT (low);
  if (CONST_OK_FOR_LETTER_P (rest, 'L'))
    operands[3] = GEN_INT (rest);
  else if (! no_new_pseudos)
    {
      operands[3] = gen_reg_rtx (DImode);
      emit_move_insn (operands[3], operands[2]);
      emit_insn (gen_adddi3 (operands[0], operands[1], operands[3]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn "one_cmpldi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(not:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "nor %0,%1,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   nor. %2,%1,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(not:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(not:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   nor. %0,%1,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(not:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(not:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "r,I")
		  (match_operand:DI 2 "gpc_reg_operand" "r,r")))]
  "TARGET_POWERPC64"
  "@
   subf %0,%2,%1
   subfic %0,%2,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			      (match_operand:DI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   subf. %3,%2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "")
			      (match_operand:DI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(minus:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			      (match_operand:DI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(minus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   subf. %0,%2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (minus:DI (match_operand:DI 1 "gpc_reg_operand" "")
			      (match_operand:DI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(minus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(minus:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "subdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(minus:DI (match_operand:DI 1 "reg_or_short_operand" "")
		  (match_operand:DI 2 "reg_or_sub_cint64_operand" "")))]
  ""
  "
{
  if (GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_adddi3 (operands[0], operands[1],
			     negate_rtx (DImode, operands[2])));
      DONE;
    }
}")

(define_insn_and_split "absdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
        (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0")))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (ashiftrt:DI (match_dup 1) (const_int 63)))
   (set (match_dup 0) (xor:DI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:DI (match_dup 0) (match_dup 2)))]
  "")

(define_insn_and_split "*nabsdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,r")
        (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,0"))))
   (clobber (match_scratch:DI 2 "=&r,&r"))]
  "TARGET_POWERPC64"
  "#"
  "&& reload_completed"
  [(set (match_dup 2) (ashiftrt:DI (match_dup 1) (const_int 63)))
   (set (match_dup 0) (xor:DI (match_dup 2) (match_dup 1)))
   (set (match_dup 0) (minus:DI (match_dup 2) (match_dup 0)))]
  "")

(define_expand "negdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "")))]
  ""
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "neg %0,%1")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 "=r,r"))]
  "TARGET_64BIT"
  "@
   neg. %2,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 2 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2)
	(neg:DI (match_dup 1)))
   (set (match_dup 0)
	(compare:CC (match_dup 2)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(neg:DI (match_dup 1)))]
  "TARGET_64BIT"
  "@
   neg. %0,%1
   #"
  [(set_attr "type" "fast_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (neg:DI (match_operand:DI 1 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(neg:DI (match_dup 1)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(neg:DI (match_dup 1)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "clzdi2"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(clz:DI (match_operand:DI 1 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "cntlzd %0,%1")

(define_expand "ctzdi2"
  [(set (match_dup 2)
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
   (parallel [(set (match_dup 3) (and:DI (match_dup 1)      
					 (match_dup 2)))   
	      (clobber (scratch:CC))])
   (set (match_dup 4) (clz:DI (match_dup 3)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(minus:DI (const_int 63) (match_dup 4)))]
  "TARGET_POWERPC64"
  {
     operands[2] = gen_reg_rtx (DImode); 
     operands[3] = gen_reg_rtx (DImode);
     operands[4] = gen_reg_rtx (DImode);
  })

(define_expand "ffsdi2"
  [(set (match_dup 2)
	(neg:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
   (parallel [(set (match_dup 3) (and:DI (match_dup 1)      
					 (match_dup 2)))   
	      (clobber (scratch:CC))])
   (set (match_dup 4) (clz:DI (match_dup 3)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(minus:DI (const_int 64) (match_dup 4)))]
  "TARGET_POWERPC64"
  {
     operands[2] = gen_reg_rtx (DImode); 
     operands[3] = gen_reg_rtx (DImode);
     operands[4] = gen_reg_rtx (DImode);
  })

(define_insn "muldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(mult:DI (match_operand:DI 1 "gpc_reg_operand" "%r")
		 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "mulld %0,%1,%2"
   [(set_attr "type" "lmul")])

(define_insn "*muldi3_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:DI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_POWERPC64"
  "@
   mulld. %3,%1,%2
   #"
  [(set_attr "type" "lmul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:DI (match_operand:DI 1 "gpc_reg_operand" "")
			     (match_operand:DI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(mult:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*muldi3_internal2"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (mult:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r")
			     (match_operand:DI 2 "gpc_reg_operand" "r,r"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(mult:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "@
   mulld. %0,%1,%2
   #"
  [(set_attr "type" "lmul_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (mult:DI (match_operand:DI 1 "gpc_reg_operand" "")
			     (match_operand:DI 2 "gpc_reg_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(mult:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(mult:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "smuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (sign_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (sign_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhd %0,%1,%2"
  [(set_attr "type" "lmul")])

(define_insn "umuldi3_highpart"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(truncate:DI
	 (lshiftrt:TI (mult:TI (zero_extend:TI
				(match_operand:DI 1 "gpc_reg_operand" "%r"))
			       (zero_extend:TI
				(match_operand:DI 2 "gpc_reg_operand" "r")))
		      (const_int 64))))]
  "TARGET_POWERPC64"
  "mulhdu %0,%1,%2"
  [(set_attr "type" "lmul")])

(define_expand "divdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(div:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (GET_CODE (operands[2]) == CONST_INT
      && INTVAL (operands[2]) > 0
      && exact_log2 (INTVAL (operands[2])) >= 0)
    ;
  else
    operands[2] = force_reg (DImode, operands[2]);
}")

(define_expand "moddi3"
  [(use (match_operand:DI 0 "gpc_reg_operand" ""))
   (use (match_operand:DI 1 "gpc_reg_operand" ""))
   (use (match_operand:DI 2 "reg_or_cint_operand" ""))]
  "TARGET_POWERPC64"
  "
{
  int i;
  rtx temp1;
  rtx temp2;

  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 0
      || (i = exact_log2 (INTVAL (operands[2]))) < 0)
    FAIL;

  temp1 = gen_reg_rtx (DImode);
  temp2 = gen_reg_rtx (DImode);

  emit_insn (gen_divdi3 (temp1, operands[1], operands[2]));
  emit_insn (gen_ashldi3 (temp2, temp1, GEN_INT (i)));
  emit_insn (gen_subdi3 (operands[0], operands[1], temp2));
  DONE;
}")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		(match_operand:DI 2 "exact_log2_cint_operand" "N")))]
  "TARGET_POWERPC64"
  "sradi %0,%1,%p2\;addze %0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:DI 2 "exact_log2_cint_operand" "N,N"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   sradi %3,%1,%p2\;addze. %3,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:DI 2 "exact_log2_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(div:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:DI 2 "exact_log2_cint_operand" "N,N"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(div:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   sradi %0,%1,%p2\;addze. %0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (div:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:DI 2 "exact_log2_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(div:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(div:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (div:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divd %0,%1,%2"
  [(set_attr "type" "ldiv")])

(define_insn "udivdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
        (udiv:DI (match_operand:DI 1 "gpc_reg_operand" "r")
                 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_POWERPC64"
  "divdu %0,%1,%2"
  [(set_attr "type" "ldiv")])

(define_insn "rotldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		   (match_operand:DI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,0")

(define_insn "*rotldi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %3,%1,%H2,0
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
			       (match_operand:DI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(rotate:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			       (match_operand:DI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(rotate:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %0,%1,%H2,0
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
			       (match_operand:DI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(rotate:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(rotate:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal4"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			   (match_operand:DI 2 "reg_or_cint_operand" "ri"))
		(match_operand:DI 3 "mask64_operand" "n")))]
  "TARGET_POWERPC64"
  "rld%I2c%B3 %0,%1,%H2,%S3")

(define_insn "*rotldi3_internal5"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				(match_operand:DI 2 "reg_or_cint_operand" "ri,ri"))
		     (match_operand:DI 3 "mask64_operand" "n,n"))
		    (const_int 0)))
   (clobber (match_scratch:DI 4 "=r,r"))]
  "TARGET_64BIT"
  "@
   rld%I2c%B3. %4,%1,%H2,%S3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				(match_operand:DI 2 "reg_or_cint_operand" ""))
		     (match_operand:DI 3 "mask64_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 4)
	(and:DI (rotate:DI (match_dup 1)
				(match_dup 2))
		     (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				(match_operand:DI 2 "reg_or_cint_operand" "ri,ri"))
		     (match_operand:DI 3 "mask64_operand" "n,n"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(and:DI (rotate:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_64BIT"
  "@
   rld%I2c%B3. %0,%1,%H2,%S3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:DI
		     (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				(match_operand:DI 2 "reg_or_cint_operand" ""))
		     (match_operand:DI 3 "mask64_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (rotate:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(and:DI (rotate:DI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal7"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:QI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,56")

(define_insn "*rotldi3_internal8"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %3,%1,%H2,56
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(zero_extend:DI (subreg:QI
		      (rotate:DI (match_dup 1)
				 (match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal9"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (subreg:QI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %0,%1,%H2,56
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:QI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (subreg:QI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:QI (rotate:DI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal10"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:HI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,48")

(define_insn "*rotldi3_internal11"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %3,%1,%H2,48
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(zero_extend:DI (subreg:HI
		      (rotate:DI (match_dup 1)
				 (match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal12"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (subreg:HI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %0,%1,%H2,48
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:HI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (subreg:HI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:HI (rotate:DI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal13"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(zero_extend:DI
	 (subreg:SI
	  (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:DI 2 "reg_or_cint_operand" "ri")) 0)))]
  "TARGET_POWERPC64"
  "rld%I2cl %0,%1,%H2,32")

(define_insn "*rotldi3_internal14"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %3,%1,%H2,32
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(zero_extend:DI (subreg:SI
		      (rotate:DI (match_dup 1)
				 (match_dup 2)) 0)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*rotldi3_internal15"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:DI 2 "reg_or_cint_operand" "ri,ri")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(zero_extend:DI (subreg:SI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_64BIT"
  "@
   rld%I2cl. %0,%1,%H2,32
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (zero_extend:DI
		     (subreg:SI
		      (rotate:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:DI 2 "reg_or_cint_operand" "")) 0))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(zero_extend:DI (subreg:SI (rotate:DI (match_dup 1) (match_dup 2)) 0)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(zero_extend:DI (subreg:SI (rotate:DI (match_dup 1) (match_dup 2)) 0)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "ashldi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
		   (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64 || TARGET_POWER"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER)
    {
      emit_insn (gen_ashldi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn "*ashldi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		   (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "sld%I2 %0,%1,%H2"
  [(set_attr "length" "8")])
  
(define_insn "*ashldi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   sld%I2. %3,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])
  
(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(ashift:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*ashldi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			       (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(ashift:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   sld%I2. %0,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			       (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashift:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(ashift:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*ashldi3_internal4"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:DI 3 "const_int_operand" "n")))]
  "TARGET_POWERPC64 && includes_rldic_lshift_p (operands[2], operands[3])"
  "rldic %0,%1,%H2,%W3")

(define_insn "ashldi3_internal5"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:DI 3 "const_int_operand" "n,n"))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 "=r,r"))]
  "TARGET_64BIT && includes_rldic_lshift_p (operands[2], operands[3])"
  "@
   rldic. %4,%1,%H2,%W3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:DI 3 "const_int_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_POWERPC64 && reload_completed
   && includes_rldic_lshift_p (operands[2], operands[3])"
  [(set (match_dup 4)
	(and:DI (ashift:DI (match_dup 1) (match_dup 2))
		(match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn "*ashldi3_internal6"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		    (match_operand:DI 3 "const_int_operand" "n,n"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(and:DI (ashift:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_64BIT && includes_rldic_lshift_p (operands[2], operands[3])"
  "@
   rldic. %0,%1,%H2,%W3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:DI 3 "const_int_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (ashift:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWERPC64 && reload_completed
   && includes_rldic_lshift_p (operands[2], operands[3])"
  [(set (match_dup 0)
	(and:DI (ashift:DI (match_dup 1) (match_dup 2))
		(match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*ashldi3_internal7"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			   (match_operand:SI 2 "const_int_operand" "i"))
		(match_operand:DI 3 "mask64_operand" "n")))]
  "TARGET_POWERPC64 && includes_rldicr_lshift_p (operands[2], operands[3])"
  "rldicr %0,%1,%H2,%S3")

(define_insn "ashldi3_internal8"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		 (match_operand:DI 3 "mask64_operand" "n,n"))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 "=r,r"))]
  "TARGET_64BIT && includes_rldicr_lshift_p (operands[2], operands[3])"
  "@
   rldicr. %4,%1,%H2,%S3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:DI 3 "mask64_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_POWERPC64 && reload_completed
   && includes_rldicr_lshift_p (operands[2], operands[3])"
  [(set (match_dup 4)
	(and:DI (ashift:DI (match_dup 1) (match_dup 2))
		(match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn "*ashldi3_internal9"
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			    (match_operand:SI 2 "const_int_operand" "i,i"))
		    (match_operand:DI 3 "mask64_operand" "n,n"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(and:DI (ashift:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_64BIT && includes_rldicr_lshift_p (operands[2], operands[3])"
  "@
   rldicr. %0,%1,%H2,%S3
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:DI (ashift:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:SI 2 "const_int_operand" ""))
		 (match_operand:DI 3 "mask64_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (ashift:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWERPC64 && reload_completed
   && includes_rldicr_lshift_p (operands[2], operands[3])"
  [(set (match_dup 0)
	(and:DI (ashift:DI (match_dup 1) (match_dup 2))
		(match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "lshrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "TARGET_POWERPC64 || TARGET_POWER"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER)
    {
      emit_insn (gen_lshrdi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn "*lshrdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "srd%I2 %0,%1,%H2")

(define_insn "*lshrdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT "
  "@
   srd%I2. %3,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(lshiftrt:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*lshrdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(lshiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   srd%I2. %0,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (lshiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(lshiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(lshiftrt:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "ashrdi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
		     (match_operand:SI 2 "reg_or_cint_operand" "")))]
  "WORDS_BIG_ENDIAN"
  "
{
  if (TARGET_POWERPC64)
    ;
  else if (TARGET_POWER && GET_CODE (operands[2]) == CONST_INT)
    {
      emit_insn (gen_ashrdi3_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else if (TARGET_32BIT && GET_CODE (operands[2]) == CONST_INT
	   && WORDS_BIG_ENDIAN)
    {
      emit_insn (gen_ashrdi3_no_power (operands[0], operands[1], operands[2]));
      DONE;
    }
  else
    FAIL;
}")

(define_insn "*ashrdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		     (match_operand:SI 2 "reg_or_cint_operand" "ri")))]
  "TARGET_POWERPC64"
  "srad%I2 %0,%1,%H2")

(define_insn "*ashrdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   srad%I2. %3,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3)
	(ashiftrt:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*ashrdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
				 (match_operand:SI 2 "reg_or_cint_operand" "ri,ri"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   srad%I2. %0,%1,%H2
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (ashiftrt:DI (match_operand:DI 1 "gpc_reg_operand" "")
				 (match_operand:SI 2 "reg_or_cint_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(ashiftrt:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0)
	(ashiftrt:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "anddi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r")
		(match_operand:DI 2 "and64_2_operand" "?r,S,K,J,t")))
   (clobber (match_scratch:CC 3 "=X,X,x,x,X"))]
  "TARGET_POWERPC64"
  "@
   and %0,%1,%2
   rldic%B2 %0,%1,0,%S2
   andi. %0,%1,%b2
   andis. %0,%1,%u2
   #"
  [(set_attr "length" "4,4,4,4,8")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "mask64_2_operand" "")))
   (clobber (match_scratch:CC 3 ""))]
  "TARGET_POWERPC64
    && (fixed_regs[CR0_REGNO] || !logical_operand (operands[2], DImode))
    && !mask64_operand (operands[2], DImode)"
  [(set (match_dup 0)
	(and:DI (rotate:DI (match_dup 1)
			   (match_dup 4))
		(match_dup 5)))
   (set (match_dup 0)
	(and:DI (rotate:DI (match_dup 0)
			   (match_dup 6))
		(match_dup 7)))]
  "
{
  build_mask64_2_operands (operands[2], &operands[4]);
}")

(define_insn "*anddi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,x,?y,?y,??y,??y,?y")
	(compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
			    (match_operand:DI 2 "and64_2_operand" "r,S,K,J,t,r,S,K,J,t"))
		    (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r,r,r,r,r,r,r,r,r"))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,X,X,x,x,X"))]
  "TARGET_64BIT"
  "@
   and. %3,%1,%2
   rldic%B2. %3,%1,0,%S2
   andi. %3,%1,%b2
   andis. %3,%1,%u2
   #
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare,delayed_compare,compare,compare,delayed_compare,compare,compare,compare,compare,compare")
   (set_attr "length" "4,4,4,4,8,8,8,8,8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
        (compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "")
                            (match_operand:DI 2 "and64_operand" ""))
                    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(parallel [(set (match_dup 3)
                   (and:DI (match_dup 1)
                           (match_dup 2)))
              (clobber (match_dup 4))])
   (set (match_dup 0)
        (compare:CC (match_dup 3)
                    (const_int 0)))]
  "")

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
        (compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "")
                            (match_operand:DI 2 "mask64_2_operand" ""))
                    (const_int 0)))
   (clobber (match_scratch:DI 3 ""))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed
    && (fixed_regs[CR0_REGNO] || !logical_operand (operands[2], DImode))
    && !mask64_operand (operands[2], DImode)"
  [(set (match_dup 3)
	(and:DI (rotate:DI (match_dup 1)
			   (match_dup 5))
		(match_dup 6)))
   (parallel [(set (match_dup 0)
		   (compare:CC (and:DI (rotate:DI (match_dup 3)
						  (match_dup 7))
				       (match_dup 8))
			       (const_int 0)))
	      (clobber (match_dup 3))])]
  "
{
  build_mask64_2_operands (operands[2], &operands[5]);
}")

(define_insn "*anddi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,x,x,x,?y,?y,??y,??y,?y")
	(compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
			    (match_operand:DI 2 "and64_2_operand" "r,S,K,J,t,r,S,K,J,t"))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r,r,r,r,r,r")
	(and:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:CC 4 "=X,X,X,X,X,X,X,x,x,X"))]
  "TARGET_64BIT"
  "@
   and. %0,%1,%2
   rldic%B2. %0,%1,0,%S2
   andi. %0,%1,%b2
   andis. %0,%1,%u2
   #
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare,delayed_compare,compare,compare,delayed_compare,compare,compare,compare,compare,compare")
   (set_attr "length" "4,4,4,4,8,8,8,8,8,12")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "")
			    (match_operand:DI 2 "and64_operand" ""))
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(parallel [(set (match_dup 0)
		    (and:DI (match_dup 1) (match_dup 2)))
	       (clobber (match_dup 4))])
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
        (compare:CC (and:DI (match_operand:DI 1 "gpc_reg_operand" "")
                            (match_operand:DI 2 "mask64_2_operand" ""))
                    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(and:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:CC 4 ""))]
  "TARGET_POWERPC64 && reload_completed
    && (fixed_regs[CR0_REGNO] || !logical_operand (operands[2], DImode))
    && !mask64_operand (operands[2], DImode)"
  [(set (match_dup 0)
	(and:DI (rotate:DI (match_dup 1)
			   (match_dup 5))
		(match_dup 6)))
   (parallel [(set (match_dup 3)
		   (compare:CC (and:DI (rotate:DI (match_dup 0)
						  (match_dup 7))
				       (match_dup 8))
			       (const_int 0)))
	      (set (match_dup 0)
		   (and:DI (rotate:DI (match_dup 0)
				      (match_dup 7))
			   (match_dup 8)))])]
  "
{
  build_mask64_2_operands (operands[2], &operands[5]);
}")

(define_expand "iordi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(ior:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_logical_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (non_logical_cint_operand (operands[2], DImode))
    {
      HOST_WIDE_INT value;
      rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (DImode));

      if (GET_CODE (operands[2]) == CONST_INT)
        {
          value = INTVAL (operands[2]);
	  emit_insn (gen_iordi3 (tmp, operands[1],
				 GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
	}
      else
        {
	  value = CONST_DOUBLE_LOW (operands[2]);
	  emit_insn (gen_iordi3 (tmp, operands[1],
				 immed_double_const (value
						     & (~ (HOST_WIDE_INT) 0xffff),
						     0, DImode)));
	}

      emit_insn (gen_iordi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_expand "xordi3"
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(xor:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_logical_cint_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  if (non_logical_cint_operand (operands[2], DImode))
    {
      HOST_WIDE_INT value;
      rtx tmp = ((no_new_pseudos || rtx_equal_p (operands[0], operands[1]))
		 ? operands[0] : gen_reg_rtx (DImode));

      if (GET_CODE (operands[2]) == CONST_INT)
        {
          value = INTVAL (operands[2]);
	  emit_insn (gen_xordi3 (tmp, operands[1],
				 GEN_INT (value & (~ (HOST_WIDE_INT) 0xffff))));
	}
      else
        {
	  value = CONST_DOUBLE_LOW (operands[2]);
	  emit_insn (gen_xordi3 (tmp, operands[1],
				 immed_double_const (value
						     & (~ (HOST_WIDE_INT) 0xffff),
						     0, DImode)));
	}

      emit_insn (gen_xordi3 (operands[0], tmp, GEN_INT (value & 0xffff)));
      DONE;
    }
}")

(define_insn "*booldi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r")
	(match_operator:DI 3 "boolean_or_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "%r,r,r")
	  (match_operand:DI 2 "logical_operand" "r,K,JF")]))]
  "TARGET_POWERPC64"
  "@
   %q3 %0,%1,%2
   %q3i %0,%1,%b2
   %q3is %0,%1,%u2")

(define_insn "*booldi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_or_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "%r,r")
	  (match_operand:DI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   %q4. %3,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "")
	  (match_operand:DI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*booldi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "%r,r")
	  (match_operand:DI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_64BIT"
  "@
   %q4. %0,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "")
	  (match_operand:DI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Split a logical operation that we can't do in one insn into two insns, 
;; each of which does one 16-bit part.  This is used by combine.

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operator:DI 3 "boolean_or_operator"
	 [(match_operand:DI 1 "gpc_reg_operand" "")
	  (match_operand:DI 2 "non_logical_cint_operand" "")]))]
  "TARGET_POWERPC64"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 0) (match_dup 5))]
"
{
  rtx i3,i4;
  
  if (GET_CODE (operands[2]) == CONST_DOUBLE)
    {
      HOST_WIDE_INT value = CONST_DOUBLE_LOW (operands[2]);
      i3 = immed_double_const (value & (~ (HOST_WIDE_INT) 0xffff),
					0, DImode);
      i4 = GEN_INT (value & 0xffff);
    }
  else
    {
      i3 = GEN_INT (INTVAL (operands[2])
			     & (~ (HOST_WIDE_INT) 0xffff));
      i4 = GEN_INT (INTVAL (operands[2]) & 0xffff);
    }
  operands[4] = gen_rtx (GET_CODE (operands[3]), DImode,
			 operands[1], i3);
  operands[5] = gen_rtx (GET_CODE (operands[3]), DImode,
			 operands[0], i4);
}")

(define_insn "*boolcdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operator:DI 3 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
	  (match_operand:DI 2 "gpc_reg_operand" "r")]))]
  "TARGET_POWERPC64"
  "%q3 %0,%2,%1")

(define_insn "*boolcdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
	  (match_operand:DI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   %q4. %3,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
	  (match_operand:DI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*boolcdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r"))
	  (match_operand:DI 2 "gpc_reg_operand" "r,r")])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_64BIT"
  "@
   %q4. %0,%2,%1
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
	  (match_operand:DI 2 "gpc_reg_operand" "")])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn "*boolccdi3_internal1"
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operator:DI 3 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "r"))
	  (not:DI (match_operand:DI 2 "gpc_reg_operand" "r"))]))]
  "TARGET_POWERPC64"
  "%q3 %0,%1,%2")

(define_insn "*boolccdi3_internal2"
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "r,r"))
	  (not:DI (match_operand:DI 2 "gpc_reg_operand" "r,r"))])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=r,r"))]
  "TARGET_64BIT"
  "@
   %q4. %3,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
	  (not:DI (match_operand:DI 2 "gpc_reg_operand" ""))])
	 (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 3) (match_dup 4))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn "*boolccdi3_internal3"
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r"))
	  (not:DI (match_operand:DI 2 "gpc_reg_operand" "r,r"))])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(match_dup 4))]
  "TARGET_64BIT"
  "@
   %q4. %0,%1,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "4,8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:DI 4 "boolean_operator"
	 [(not:DI (match_operand:DI 1 "gpc_reg_operand" ""))
	  (not:DI (match_operand:DI 2 "gpc_reg_operand" ""))])
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_dup 4))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0) (match_dup 4))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; Now define ways of moving data around.

;; Elf specific ways of loading addresses for non-PIC code.
;; The output of this could be r0, but we make a very strong
;; preference for a base register because it will usually
;; be needed there.
(define_insn "elf_high"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=b*r")
	(high:SI (match_operand 1 "" "")))]
  "TARGET_ELF && ! TARGET_64BIT"
  "{liu|lis} %0,%1@ha")

(define_insn "elf_low"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b,!*r")
		   (match_operand 2 "" "")))]
   "TARGET_ELF && ! TARGET_64BIT"
   "@
    {cal|la} %0,%2@l(%1)
    {ai|addic} %0,%1,%K2")

;; Mach-O PIC trickery.
(define_insn "macho_high"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=b*r")
	(high:SI (match_operand 1 "" "")))]
  "TARGET_MACHO && ! TARGET_64BIT"
  "{liu|lis} %0,ha16(%1)")

(define_insn "macho_low"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b,!*r")
		   (match_operand 2 "" "")))]
   "TARGET_MACHO && ! TARGET_64BIT"
   "@
    {cal %0,%a2@l(%1)|la %0,lo16(%2)(%1)}
    {cal %0,%a2@l(%1)|addic %0,%1,lo16(%2)}")

;; Set up a register with a value from the GOT table

(define_expand "movsi_got"
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unspec:SI [(match_operand:SI 1 "got_operand" "")
		    (match_dup 2)] UNSPEC_MOVSI_GOT))]
  "DEFAULT_ABI == ABI_V4 && flag_pic == 1"
  "
{
  if (GET_CODE (operands[1]) == CONST)
    {
      rtx offset = const0_rtx;
      HOST_WIDE_INT value;

      operands[1] = eliminate_constant_term (XEXP (operands[1], 0), &offset);
      value = INTVAL (offset);
      if (value != 0)
	{
	  rtx tmp = (no_new_pseudos ? operands[0] : gen_reg_rtx (Pmode));
	  emit_insn (gen_movsi_got (tmp, operands[1]));
	  emit_insn (gen_addsi3 (operands[0], tmp, offset));
	  DONE;
	}
    }

  operands[2] = rs6000_got_register (operands[1]);
}")

(define_insn "*movsi_got_internal"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "got_no_const_operand" "")
		    (match_operand:SI 2 "gpc_reg_operand" "b")]
		   UNSPEC_MOVSI_GOT))]
  "DEFAULT_ABI == ABI_V4 && flag_pic == 1"
  "{l|lwz} %0,%a1@got(%2)"
  [(set_attr "type" "load")])

;; Used by sched, shorten_branches and final when the GOT pseudo reg
;; didn't get allocated to a hard register.
(define_split 
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(unspec:SI [(match_operand:SI 1 "got_no_const_operand" "")
		    (match_operand:SI 2 "memory_operand" "")]
		   UNSPEC_MOVSI_GOT))]
  "DEFAULT_ABI == ABI_V4
    && flag_pic == 1
    && (reload_in_progress || reload_completed)"
  [(set (match_dup 0) (match_dup 2))
   (set (match_dup 0) (unspec:SI [(match_dup 1)(match_dup 0)]
				 UNSPEC_MOVSI_GOT))]
  "")

;; For SI, we special-case integers that can't be loaded in one insn.  We
;; do the load 16-bits at a time.  We could do this by loading from memory,
;; and this is even supposed to be faster, but it is simpler not to get
;; integers in the TOC.
(define_expand "movsi"
  [(set (match_operand:SI 0 "general_operand" "")
	(match_operand:SI 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], SImode); DONE; }")

(define_insn "movsi_low"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (mem:SI (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b")
                           (match_operand 2 "" ""))))]
  "TARGET_MACHO && ! TARGET_64BIT"
  "{l|lwz} %0,lo16(%2)(%1)"
  [(set_attr "type" "load")
   (set_attr "length" "4")])

(define_insn "movsi_low_st"
  [(set (mem:SI (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b")
                           (match_operand 2 "" "")))
	(match_operand:SI 0 "gpc_reg_operand" "r"))]
  "TARGET_MACHO && ! TARGET_64BIT"
  "{st|stw} %0,lo16(%2)(%1)"
  [(set_attr "type" "store")
   (set_attr "length" "4")])

(define_insn "movdf_low"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f,!r")
        (mem:DF (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b,b")
                           (match_operand 2 "" ""))))]
  "TARGET_MACHO && TARGET_HARD_FLOAT && TARGET_FPRS && ! TARGET_64BIT"
  "*
{
  switch (which_alternative)
    {
      case 0:
	return \"lfd %0,lo16(%2)(%1)\";
      case 1:
	{
	  rtx operands2[4];
	  operands2[0] = operands[0];
	  operands2[1] = operands[1];
	  operands2[2] = operands[2];
	  if (TARGET_POWERPC64 && TARGET_32BIT)
	    /* Note, old assemblers didn't support relocation here.  */
	    return \"ld %0,lo16(%2)(%1)\";
	  else
	  {
	    operands2[3] = gen_rtx_REG (SImode, RS6000_PIC_OFFSET_TABLE_REGNUM);     
	    output_asm_insn (\"{l|lwz} %0,lo16(%2)(%1)\", operands);
#if TARGET_MACHO
	    if (MACHO_DYNAMIC_NO_PIC_P)
	      output_asm_insn (\"{liu|lis} %L0,ha16(%2+4)\", operands);
	    else     
	    /* We cannot rely on ha16(low half)==ha16(high half), alas,
	       although in practice it almost always is.  */
	    output_asm_insn (\"{cau|addis} %L0,%3,ha16(%2+4)\", operands2);
#endif
	    return (\"{l|lwz} %L0,lo16(%2+4)(%L0)\");
	  }
	}
      default:
	abort();
    }
}"
  [(set_attr "type" "load")
   (set_attr "length" "4,12")])

(define_insn "movdf_low_st"
  [(set (mem:DF (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b")
                           (match_operand 2 "" "")))
	(match_operand:DF 0 "gpc_reg_operand" "f"))]
  "TARGET_MACHO && TARGET_HARD_FLOAT && TARGET_FPRS && ! TARGET_64BIT"
  "stfd %0,lo16(%2)(%1)"
  [(set_attr "type" "store")
   (set_attr "length" "4")])

(define_insn "movsf_low"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f,!r")
        (mem:SF (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b,b")
                           (match_operand 2 "" ""))))]
  "TARGET_MACHO && TARGET_HARD_FLOAT && TARGET_FPRS && ! TARGET_64BIT"
  "@
   lfs %0,lo16(%2)(%1)
   {l|lwz} %0,lo16(%2)(%1)"
  [(set_attr "type" "load")
   (set_attr "length" "4")])

(define_insn "movsf_low_st"
  [(set (mem:SF (lo_sum:SI (match_operand:SI 1 "gpc_reg_operand" "b,b")
                           (match_operand 2 "" "")))
	(match_operand:SF 0 "gpc_reg_operand" "f,!r"))]
  "TARGET_MACHO && TARGET_HARD_FLOAT && TARGET_FPRS && ! TARGET_64BIT"
  "@
   stfs %0,lo16(%2)(%1)
   {st|stw} %0,lo16(%2)(%1)"
  [(set_attr "type" "store")
   (set_attr "length" "4")])

(define_insn "*movsi_internal1"
  [(set (match_operand:SI 0 "nonimmediate_operand" "=r,r,r,m,r,r,r,r,r,*q,*c*l,*h,*h")
	(match_operand:SI 1 "input_operand" "r,U,m,r,I,L,n,R,*h,r,r,r,0"))]
  "gpc_reg_operand (operands[0], SImode)
   || gpc_reg_operand (operands[1], SImode)"
  "@
   mr %0,%1
   {cal|la} %0,%a1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%v1
   #
   {cal|la} %0,%a1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   mt%0 %1
   {cror 0,0,0|nop}"
  [(set_attr "type" "*,*,load,store,*,*,*,*,mfjmpr,*,mtjmpr,*,*")
   (set_attr "length" "4,4,4,4,4,4,8,4,4,4,4,4,4")])

;; Split a load of a large constant into the appropriate two-insn
;; sequence.

(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(match_operand:SI 1 "const_int_operand" ""))]
  "(unsigned HOST_WIDE_INT) (INTVAL (operands[1]) + 0x8000) >= 0x10000
   && (INTVAL (operands[1]) & 0xffff) != 0"
  [(set (match_dup 0)
	(match_dup 2))
   (set (match_dup 0)
	(ior:SI (match_dup 0)
		(match_dup 3)))]
  "
{ rtx tem = rs6000_emit_set_const (operands[0], SImode, operands[1], 2);

  if (tem == operands[0])
    DONE;
  else
    FAIL;
}")

(define_insn "*movsi_internal2"
  [(set (match_operand:CC 2 "cc_reg_operand" "=y,x,?y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "0,r,r")
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r") (match_dup 1))]
  "TARGET_32BIT"
  "@
   {cmpi|cmpwi} %2,%0,0
   mr. %0,%1
   #"
  [(set_attr "type" "cmp,compare,cmp")
   (set_attr "length" "4,4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "") (match_dup 1))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_expand "movhi"
  [(set (match_operand:HI 0 "general_operand" "")
	(match_operand:HI 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], HImode); DONE; }")

(define_insn "*movhi_internal"
  [(set (match_operand:HI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:HI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], HImode)
   || gpc_reg_operand (operands[1], HImode)"
  "@
   mr %0,%1
   lhz%U1%X1 %0,%1
   sth%U0%X0 %1,%0
   {lil|li} %0,%w1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   {cror 0,0,0|nop}"
  [(set_attr "type" "*,load,store,*,mfjmpr,*,mtjmpr,*")])

(define_expand "movqi"
  [(set (match_operand:QI 0 "general_operand" "")
	(match_operand:QI 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], QImode); DONE; }")

(define_insn "*movqi_internal"
  [(set (match_operand:QI 0 "nonimmediate_operand" "=r,r,m,r,r,*q,*c*l,*h")
	(match_operand:QI 1 "input_operand" "r,m,r,i,*h,r,r,0"))]
  "gpc_reg_operand (operands[0], QImode)
   || gpc_reg_operand (operands[1], QImode)"
  "@
   mr %0,%1
   lbz%U1%X1 %0,%1
   stb%U0%X0 %1,%0
   {lil|li} %0,%1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   {cror 0,0,0|nop}"
  [(set_attr "type" "*,load,store,*,mfjmpr,*,mtjmpr,*")])

;; Here is how to move condition codes around.  When we store CC data in
;; an integer register or memory, we store just the high-order 4 bits.
;; This lets us not shift in the most common case of CR0.
(define_expand "movcc"
  [(set (match_operand:CC 0 "nonimmediate_operand" "")
	(match_operand:CC 1 "nonimmediate_operand" ""))]
  ""
  "")

(define_insn "*movcc_internal1"
  [(set (match_operand:CC 0 "nonimmediate_operand" "=y,x,?y,r,r,r,r,q,cl,r,m")
	(match_operand:CC 1 "nonimmediate_operand" "y,r,r,x,y,r,h,r,r,m,r"))]
  "register_operand (operands[0], CCmode)
   || register_operand (operands[1], CCmode)"
  "@
   mcrf %0,%1
   mtcrf 128,%1
   {rlinm|rlwinm} %1,%1,%F0,0xffffffff\;mtcrf %R0,%1\;{rlinm|rlwinm} %1,%1,%f0,0xffffffff
   mfcr %0%Q1
   mfcr %0%Q1\;{rlinm|rlwinm} %0,%0,%f1,0xf0000000
   mr %0,%1
   mf%1 %0
   mt%0 %1
   mt%0 %1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%U1|stw%U0%U1} %1,%0"
  [(set (attr "type")
     (cond [(eq_attr "alternative" "0")
		(const_string "cr_logical")
	    (eq_attr "alternative" "1,2")
		(const_string "mtcr")
	    (eq_attr "alternative" "5,7")
		(const_string "integer")
	    (eq_attr "alternative" "6")
		(const_string "mfjmpr")
	    (eq_attr "alternative" "8")
		(const_string "mtjmpr")
	    (eq_attr "alternative" "9")
		(const_string "load")
	    (eq_attr "alternative" "10")
		(const_string "store")
	    (ne (symbol_ref "TARGET_MFCRF") (const_int 0))
		(const_string "mfcrf")
	   ]
	(const_string "mfcr")))
   (set_attr "length" "4,4,12,4,8,4,4,4,4,4,4")])

;; For floating-point, we normally deal with the floating-point registers
;; unless -msoft-float is used.  The sole exception is that parameter passing
;; can produce floating-point values in fixed-point registers.  Unless the
;; value is a simple constant or already in memory, we deal with this by
;; allocating memory and copying the value explicitly via that memory location.
(define_expand "movsf"
  [(set (match_operand:SF 0 "nonimmediate_operand" "")
	(match_operand:SF 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], SFmode); DONE; }")

(define_split
  [(set (match_operand:SF 0 "gpc_reg_operand" "")
	(match_operand:SF 1 "const_double_operand" ""))]
  "reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 3))]
  "
{
  long l;
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_SINGLE (rv, l);

  if (! TARGET_POWERPC64)
    operands[2] = operand_subword (operands[0], 0, 0, SFmode);
  else
    operands[2] = gen_lowpart (SImode, operands[0]);

  operands[3] = gen_int_mode (l, SImode);
}")

(define_insn "*movsf_hardfloat"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=!r,!r,m,f,f,m,!cl,!q,!r,!r,!r")
	(match_operand:SF 1 "input_operand" "r,m,r,f,m,f,r,r,h,G,Fn"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode))
   && (TARGET_HARD_FLOAT && TARGET_FPRS)"
  "@
   mr %0,%1
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   fmr %0,%1
   lfs%U1%X1 %0,%1
   stfs%U0%X0 %1,%0
   mt%0 %1
   mt%0 %1
   mf%1 %0
   #
   #"
  [(set_attr "type" "*,load,store,fp,fpload,fpstore,*,mtjmpr,*,*,*")
   (set_attr "length" "4,4,4,4,4,4,4,4,4,4,8")])

(define_insn "*movsf_softfloat"
  [(set (match_operand:SF 0 "nonimmediate_operand" "=r,cl,q,r,r,m,r,r,r,r,r,*h")
	(match_operand:SF 1 "input_operand" "r,r,r,h,m,r,I,L,R,G,Fn,0"))]
  "(gpc_reg_operand (operands[0], SFmode)
   || gpc_reg_operand (operands[1], SFmode))
   && (TARGET_SOFT_FLOAT || !TARGET_FPRS)"
  "@
   mr %0,%1
   mt%0 %1
   mt%0 %1
   mf%1 %0
   {l%U1%X1|lwz%U1%X1} %0,%1
   {st%U0%X0|stw%U0%X0} %1,%0
   {lil|li} %0,%1
   {liu|lis} %0,%v1
   {cal|la} %0,%a1
   #
   #
   {cror 0,0,0|nop}"
  [(set_attr "type" "*,mtjmpr,*,*,load,store,*,*,*,*,*,*")
   (set_attr "length" "4,4,4,4,4,4,4,4,4,4,8,4")])


(define_expand "movdf"
  [(set (match_operand:DF 0 "nonimmediate_operand" "")
	(match_operand:DF 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], DFmode); DONE; }")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "const_int_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 1))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  HOST_WIDE_INT value = INTVAL (operands[1]);

  operands[2] = operand_subword (operands[0], endian, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1 - endian, 0, DFmode);
#if HOST_BITS_PER_WIDE_INT == 32
  operands[4] = (value & 0x80000000) ? constm1_rtx : const0_rtx;
#else
  operands[4] = GEN_INT (value >> 32);
  operands[1] = GEN_INT (((value & 0xffffffff) ^ 0x80000000) - 0x80000000);
#endif
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "const_double_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  long l[2];
  REAL_VALUE_TYPE rv;

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_DOUBLE (rv, l);

  operands[2] = operand_subword (operands[0], endian, 0, DFmode);
  operands[3] = operand_subword (operands[0], 1 - endian, 0, DFmode);
  operands[4] = gen_int_mode (l[endian], SImode);
  operands[5] = gen_int_mode (l[1 - endian], SImode);
}")

(define_split
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(match_operand:DF 1 "easy_fp_constant" ""))]
  "TARGET_POWERPC64 && reload_completed
   && ((GET_CODE (operands[0]) == REG && REGNO (operands[0]) <= 31)
       || (GET_CODE (operands[0]) == SUBREG
	   && GET_CODE (SUBREG_REG (operands[0])) == REG
	   && REGNO (SUBREG_REG (operands[0])) <= 31))"
  [(set (match_dup 2) (match_dup 3))]
  "
{
  int endian = (WORDS_BIG_ENDIAN == 0);
  long l[2];
  REAL_VALUE_TYPE rv;
#if HOST_BITS_PER_WIDE_INT >= 64
  HOST_WIDE_INT val;
#endif

  REAL_VALUE_FROM_CONST_DOUBLE (rv, operands[1]);
  REAL_VALUE_TO_TARGET_DOUBLE (rv, l);

  operands[2] = gen_lowpart (DImode, operands[0]);
  /* HIGHPART is lower memory address when WORDS_BIG_ENDIAN.  */
#if HOST_BITS_PER_WIDE_INT >= 64
  val = ((HOST_WIDE_INT)(unsigned long)l[endian] << 32
         | ((HOST_WIDE_INT)(unsigned long)l[1 - endian]));

  operands[3] = gen_int_mode (val, DImode);
#else
  operands[3] = immed_double_const (l[1 - endian], l[endian], DImode);
#endif
}")

;; Don't have reload use general registers to load a constant.  First,
;; it might not work if the output operand is the equivalent of
;; a non-offsettable memref, but also it is less efficient than loading
;; the constant into an FP register, since it will probably be used there.
;; The "??" is a kludge until we can figure out a more reasonable way
;; of handling these non-offsettable values.
(define_insn "*movdf_hardfloat32"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=!r,??r,m,f,f,m,!r,!r,!r")
	(match_operand:DF 1 "input_operand" "r,m,r,f,m,f,G,H,F"))]
  "! TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS
   && (gpc_reg_operand (operands[0], DFmode)
       || gpc_reg_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register
	 of operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      if (offsettable_memref_p (operands[1])
	  || (GET_CODE (operands[1]) == MEM
	      && (GET_CODE (XEXP (operands[1], 0)) == LO_SUM
		  || GET_CODE (XEXP (operands[1], 0)) == PRE_INC
		  || GET_CODE (XEXP (operands[1], 0)) == PRE_DEC)))
	{
	  /* If the low-address word is used in the address, we must load
	     it last.  Otherwise, load it first.  Note that we cannot have
	     auto-increment in that case since the address register is
	     known to be dead.  */
	  if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
				 operands[1], 0))
	    return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
	  else
	    return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
	}
      else
	{
	  rtx addreg;

	  addreg = find_addr_reg (XEXP (operands[1], 0));
	  if (refers_to_regno_p (REGNO (operands[0]),
				 REGNO (operands[0]) + 1,
				 operands[1], 0))
	    {
	      output_asm_insn (\"{cal|la} %0,4(%0)\", &addreg);
	      output_asm_insn (\"{lx|lwzx} %L0,%1\", operands);
	      output_asm_insn (\"{cal|la} %0,-4(%0)\", &addreg);
	      return \"{lx|lwzx} %0,%1\";
	    }
	  else
	    {
	      output_asm_insn (\"{lx|lwzx} %0,%1\", operands);
	      output_asm_insn (\"{cal|la} %0,4(%0)\", &addreg);
	      output_asm_insn (\"{lx|lwzx} %L0,%1\", operands);
	      output_asm_insn (\"{cal|la} %0,-4(%0)\", &addreg);
	      return \"\";
	    }
	}
    case 2:
      if (offsettable_memref_p (operands[0])
	  || (GET_CODE (operands[0]) == MEM
	      && (GET_CODE (XEXP (operands[0], 0)) == LO_SUM
		  || GET_CODE (XEXP (operands[0], 0)) == PRE_INC
		  || GET_CODE (XEXP (operands[0], 0)) == PRE_DEC)))
	return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
      else
	{
	  rtx addreg;

	  addreg = find_addr_reg (XEXP (operands[0], 0));
	  output_asm_insn (\"{stx|stwx} %1,%0\", operands);
	  output_asm_insn (\"{cal|la} %0,4(%0)\", &addreg);
	  output_asm_insn (\"{stx|stwx} %L1,%0\", operands);
	  output_asm_insn (\"{cal|la} %0,-4(%0)\", &addreg);
	  return \"\";
	}
    case 3:
      return \"fmr %0,%1\";
    case 4:
      return \"lfd%U1%X1 %0,%1\";
    case 5:
      return \"stfd%U0%X0 %1,%0\";
    case 6:
    case 7:
    case 8:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,store,fp,fpload,fpstore,*,*,*")
   (set_attr "length" "8,16,16,4,4,4,8,12,16")])

(define_insn "*movdf_softfloat32"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,r,m,r,r,r")
	(match_operand:DF 1 "input_operand" "r,m,r,G,H,F"))]
  "! TARGET_POWERPC64 && (TARGET_SOFT_FLOAT || !TARGET_FPRS)
   && (gpc_reg_operand (operands[0], DFmode)
       || gpc_reg_operand (operands[1], DFmode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      /* We normally copy the low-numbered register first.  However, if
	 the first register operand 0 is the same as the second register of
	 operand 1, we must copy in the opposite order.  */
      if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
	return \"mr %L0,%L1\;mr %0,%1\";
      else
	return \"mr %0,%1\;mr %L0,%L1\";
    case 1:
      /* If the low-address word is used in the address, we must load
	 it last.  Otherwise, load it first.  Note that we cannot have
	 auto-increment in that case since the address register is
	 known to be dead.  */
      if (refers_to_regno_p (REGNO (operands[0]), REGNO (operands[0]) + 1,
			     operands[1], 0))
	return \"{l|lwz} %L0,%L1\;{l|lwz} %0,%1\";
      else
	return \"{l%U1|lwz%U1} %0,%1\;{l|lwz} %L0,%L1\";
    case 2:
      return \"{st%U0|stw%U0} %1,%0\;{st|stw} %L1,%L0\";
    case 3:
    case 4:
    case 5:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,store,*,*,*")
   (set_attr "length" "8,8,8,8,12,16")])

; ld/std require word-aligned displacements -> 'Y' constraint.
; List Y->r and r->Y before r->r for reload.
(define_insn "*movdf_hardfloat64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=Y,r,b,!r,f,f,m,!cl,!r,!r,!r,!r")
	(match_operand:DF 1 "input_operand" "r,Y,m,r,f,m,f,r,h,G,H,F"))]
  "TARGET_POWERPC64 && TARGET_HARD_FLOAT && TARGET_FPRS
   && (gpc_reg_operand (operands[0], DFmode)
       || gpc_reg_operand (operands[1], DFmode))"
  "@
   std%U0%X0 %1,%0
   ld%U1%X1 %0,%1
   #
   mr %0,%1
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0
   mt%0 %1
   mf%1 %0
   #
   #
   #"
  [(set_attr "type" "store,load,load,*,fp,fpload,fpstore,mtjmpr,*,*,*,*")
   (set_attr "length" "4,4,8,4,4,4,4,4,4,8,12,16")])

(define_split
  [(set (match_operand:DF 0 "base_reg_operand" "")
	(match_operand:DF 1 "invalid_gpr_mem" ""))]
  "TARGET_POWERPC64 && no_new_pseudos"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (match_dup 4))]
  "
{
  operands[2] = gen_rtx_REG (Pmode, REGNO (operands[0]));
  operands[3] = XEXP (operands[1], 0);
  operands[4] = replace_equiv_address (operands[1], operands[2]);
}")

(define_expand "reload_outdf"
  [(parallel [(match_operand:DF 0 "invalid_gpr_mem" "")
	      (match_operand:DF 1 "register_operand" "")
	      (match_operand:DI 2 "register_operand" "=&b")])]
  "TARGET_POWERPC64"
{
  if (!TARGET_64BIT)
    operands[2] = gen_rtx_REG (SImode, REGNO (operands[2]));
  emit_move_insn (operands[2], XEXP (operands[0], 0));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_expand "reload_indf"
  [(parallel [(match_operand:DF 0 "register_operand" "")
	      (match_operand:DF 1 "invalid_gpr_mem" "")
	      (match_operand:DI 2 "register_operand" "=&b")])]
  "TARGET_POWERPC64"
{
  if (!TARGET_64BIT)
    operands[2] = gen_rtx_REG (SImode, REGNO (operands[2]));
  emit_move_insn (operands[2], XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_insn "*movdf_softfloat64"
  [(set (match_operand:DF 0 "nonimmediate_operand" "=r,Y,r,cl,r,r,r,r,*h")
	(match_operand:DF 1 "input_operand" "Y,r,r,r,h,G,H,F,0"))]
  "TARGET_POWERPC64 && (TARGET_SOFT_FLOAT || !TARGET_FPRS)
   && (gpc_reg_operand (operands[0], DFmode)
       || gpc_reg_operand (operands[1], DFmode))"
  "@
   ld%U1%X1 %0,%1
   std%U0%X0 %1,%0
   mr %0,%1
   mt%0 %1
   mf%1 %0
   #
   #
   #
   nop"
  [(set_attr "type" "load,store,*,*,*,*,*,*,*")
   (set_attr "length" "4,4,4,4,4,8,12,16,4")])

(define_expand "movtf"
  [(set (match_operand:TF 0 "general_operand" "")
	(match_operand:TF 1 "any_operand" ""))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "{ rs6000_emit_move (operands[0], operands[1], TFmode); DONE; }")

; It's important to list the o->f and f->o moves before f->f because
; otherwise reload, given m->f, will try to pick f->f and reload it,
; which doesn't make progress.
(define_insn_and_split "*movtf_internal"
  [(set (match_operand:TF 0 "nonimmediate_operand" "=o,f,f,rm,r")
	(match_operand:TF 1 "input_operand"         "f,o,f,r,mGHF"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128
   && (gpc_reg_operand (operands[0], TFmode)
       || gpc_reg_operand (operands[1], TFmode))"
  "#"
  "&& reload_completed"
  [(pc)]
{ rs6000_split_multireg_move (operands[0], operands[1]); DONE; }
  [(set_attr "length" "8,8,8,20,20")])

(define_expand "extenddftf2"
  [(parallel [(set (match_operand:TF 0 "nonimmediate_operand" "")
		   (float_extend:TF (match_operand:DF 1 "input_operand" "")))
	      (use (match_dup 2))])]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
{
  operands[2] = CONST0_RTX (DFmode);
})

(define_insn_and_split "*extenddftf2_internal"
  [(set (match_operand:TF 0 "nonimmediate_operand" "=o,f,&f,r")
       (float_extend:TF (match_operand:DF 1 "input_operand" "fr,mf,mf,rmGHF")))
   (use (match_operand:DF 2 "input_operand" "rf,m,f,n"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "#"
  "&& reload_completed"
  [(pc)]
{
  const int lo_word = FLOAT_WORDS_BIG_ENDIAN ? GET_MODE_SIZE (DFmode) : 0;
  const int hi_word = FLOAT_WORDS_BIG_ENDIAN ? 0 : GET_MODE_SIZE (DFmode);
  emit_move_insn (simplify_gen_subreg (DFmode, operands[0], TFmode, hi_word),
		  operands[1]);
  emit_move_insn (simplify_gen_subreg (DFmode, operands[0], TFmode, lo_word),
		  operands[2]);
  DONE;
})  

(define_expand "extendsftf2"
  [(set (match_operand:TF 0 "nonimmediate_operand" "")
	(float_extend:TF (match_operand:SF 1 "gpc_reg_operand" "")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
{
  rtx tmp = gen_reg_rtx (DFmode);
  emit_insn (gen_extendsfdf2 (tmp, operands[1]));
  emit_insn (gen_extenddftf2 (operands[0], tmp));
  DONE;
})

(define_expand "trunctfdf2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "")
	(float_truncate:DF (match_operand:TF 1 "gpc_reg_operand" "")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "")

(define_insn_and_split "trunctfdf2_internal1"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f,?f")
	(float_truncate:DF (match_operand:TF 1 "gpc_reg_operand" "0,f")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN) && !TARGET_XL_COMPAT
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "@
   #
   fmr %0,%1"
  "&& reload_completed && REGNO (operands[0]) == REGNO (operands[1])"
  [(const_int 0)]
{
  emit_note (NOTE_INSN_DELETED);
  DONE;
}
  [(set_attr "type" "fp")])

(define_insn "trunctfdf2_internal2"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(float_truncate:DF (match_operand:TF 1 "gpc_reg_operand" "f")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN) && TARGET_XL_COMPAT
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "fadd %0,%1,%L1"
  [(set_attr "type" "fp")])

(define_insn_and_split "trunctfsf2"
  [(set (match_operand:SF 0 "gpc_reg_operand" "=f")
	(float_truncate:SF (match_operand:TF 1 "gpc_reg_operand" "f")))
   (clobber (match_scratch:DF 2 "=f"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "#"
  "&& reload_completed"
  [(set (match_dup 2)
	(float_truncate:DF (match_dup 1)))
   (set (match_dup 0)
	(float_truncate:SF (match_dup 2)))]
  "")

(define_expand "floatsitf2"
  [(set (match_operand:TF 0 "gpc_reg_operand" "=f")
        (float:TF (match_operand:SI 1 "gpc_reg_operand" "r")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
{
  rtx tmp = gen_reg_rtx (DFmode);
  expand_float (tmp, operands[1], false);
  emit_insn (gen_extenddftf2 (operands[0], tmp));
  DONE;
})

; fadd, but rounding towards zero.
; This is probably not the optimal code sequence.
(define_insn "fix_trunc_helper"
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(unspec:DF [(match_operand:TF 1 "gpc_reg_operand" "f")]
		   UNSPEC_FIX_TRUNC_TF))
   (clobber (match_operand:DF 2 "gpc_reg_operand" "=&f"))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "mffs %2\n\tmtfsb1 31\n\tmtfsb0 30\n\tfadd %0,%1,%L1\n\tmtfsf 1,%2"
  [(set_attr "type" "fp")
   (set_attr "length" "20")])

(define_expand "fix_trunctfsi2"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "")
		   (fix:SI (match_operand:TF 1 "gpc_reg_operand" "")))
	      (clobber (match_dup 2))
	      (clobber (match_dup 3))
	      (clobber (match_dup 4))
	      (clobber (match_dup 5))])]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && (TARGET_POWER2 || TARGET_POWERPC)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
{
  operands[2] = gen_reg_rtx (DFmode);
  operands[3] = gen_reg_rtx (DFmode);
  operands[4] = gen_reg_rtx (DImode);
  operands[5] = assign_stack_temp (DImode, GET_MODE_SIZE (DImode), 0);
})

(define_insn_and_split "*fix_trunctfsi2_internal"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (fix:SI (match_operand:TF 1 "gpc_reg_operand" "f")))
   (clobber (match_operand:DF 2 "gpc_reg_operand" "=f"))
   (clobber (match_operand:DF 3 "gpc_reg_operand" "=&f"))
   (clobber (match_operand:DI 4 "gpc_reg_operand" "=f"))
   (clobber (match_operand:DI 5 "memory_operand" "=o"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "#"
  "&& reload_completed"
  [(pc)]
{
  rtx lowword;
  emit_insn (gen_fix_trunc_helper (operands[2], operands[1], operands[3]));

  if (GET_CODE (operands[5]) != MEM)
    abort();
  lowword = XEXP (operands[5], 0);
  if (WORDS_BIG_ENDIAN)
    lowword = plus_constant (lowword, 4);

  emit_insn (gen_fctiwz (operands[4], operands[2]));
  emit_move_insn (operands[5], operands[4]);
  emit_move_insn (operands[0], gen_rtx_MEM (SImode, lowword));
  DONE;
})

(define_insn "negtf2"
  [(set (match_operand:TF 0 "gpc_reg_operand" "=f")
	(neg:TF (match_operand:TF 1 "gpc_reg_operand" "f")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "*
{
  if (REGNO (operands[0]) == REGNO (operands[1]) + 1)
    return \"fneg %L0,%L1\;fneg %0,%1\";
  else
    return \"fneg %0,%1\;fneg %L0,%L1\";
}"
  [(set_attr "type" "fp")
   (set_attr "length" "8")])

(define_expand "abstf2"
  [(set (match_operand:TF 0 "gpc_reg_operand" "=f")
	(abs:TF (match_operand:TF 1 "gpc_reg_operand" "f")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "
{
  rtx label = gen_label_rtx ();
  emit_insn (gen_abstf2_internal (operands[0], operands[1], label));
  emit_label (label);
  DONE;
}")

(define_expand "abstf2_internal"
  [(set (match_operand:TF 0 "gpc_reg_operand" "=f")
	(match_operand:TF 1 "gpc_reg_operand" "f"))
   (set (match_dup 3) (match_dup 5))
   (set (match_dup 5) (abs:DF (match_dup 5)))
   (set (match_dup 4) (compare:CCFP (match_dup 3) (match_dup 5)))
   (set (pc) (if_then_else (eq (match_dup 4) (const_int 0))
			   (label_ref (match_operand 2 "" ""))
			   (pc)))
   (set (match_dup 6) (neg:DF (match_dup 6)))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "
{
  const int hi_word = FLOAT_WORDS_BIG_ENDIAN ? 0 : GET_MODE_SIZE (DFmode);
  const int lo_word = FLOAT_WORDS_BIG_ENDIAN ? GET_MODE_SIZE (DFmode) : 0;
  operands[3] = gen_reg_rtx (DFmode);
  operands[4] = gen_reg_rtx (CCFPmode);
  operands[5] = simplify_gen_subreg (DFmode, operands[0], TFmode, hi_word);
  operands[6] = simplify_gen_subreg (DFmode, operands[0], TFmode, lo_word);
}")

;; Next come the multi-word integer load and store and the load and store
;; multiple insns.
(define_expand "movdi"
  [(set (match_operand:DI 0 "general_operand" "")
	(match_operand:DI 1 "any_operand" ""))]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], DImode); DONE; }")

(define_insn "*movdi_internal32"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=r,r,m,f,f,m,r,r,r,r,r")
	(match_operand:DI 1 "input_operand" "r,m,r,f,m,f,IJK,n,G,H,F"))]
  "! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], DImode)
       || gpc_reg_operand (operands[1], DImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
    case 1:
    case 2:
      return \"#\";
    case 3:
      return \"fmr %0,%1\";
    case 4:
      return \"lfd%U1%X1 %0,%1\";
    case 5:
      return \"stfd%U0%X0 %1,%0\";
    case 6:
    case 7:
    case 8:
    case 9:
    case 10:
      return \"#\";
    }
}"
  [(set_attr "type" "*,load,store,fp,fpload,fpstore,*,*,*,*,*")])

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_int_operand" ""))]
  "! TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 1))]
  "
{
  HOST_WIDE_INT value = INTVAL (operands[1]);
  operands[2] = operand_subword_force (operands[0], WORDS_BIG_ENDIAN == 0,
				       DImode);
  operands[3] = operand_subword_force (operands[0], WORDS_BIG_ENDIAN != 0,
				       DImode);
#if HOST_BITS_PER_WIDE_INT == 32
  operands[4] = (value & 0x80000000) ? constm1_rtx : const0_rtx;
#else
  operands[4] = GEN_INT (value >> 32);
  operands[1] = GEN_INT (((value & 0xffffffff) ^ 0x80000000) - 0x80000000);
#endif
}")

(define_split
  [(set (match_operand:DI 0 "nonimmediate_operand" "")
        (match_operand:DI 1 "input_operand" ""))]
  "reload_completed && !TARGET_POWERPC64 
   && gpr_or_gpr_p (operands[0], operands[1])"
  [(pc)]
{ rs6000_split_multireg_move (operands[0], operands[1]); DONE; })

(define_split
  [(set (match_operand:TI 0 "gpc_reg_operand" "")
	(match_operand:TI 1 "const_double_operand" ""))]
  "TARGET_POWERPC64"
  [(set (match_dup 2) (match_dup 4))
   (set (match_dup 3) (match_dup 5))]
  "
{
  operands[2] = operand_subword_force (operands[0], WORDS_BIG_ENDIAN == 0,
				       TImode);
  operands[3] = operand_subword_force (operands[0], WORDS_BIG_ENDIAN != 0,
				       TImode);
  if (GET_CODE (operands[1]) == CONST_DOUBLE)
    {
      operands[4] = GEN_INT (CONST_DOUBLE_HIGH (operands[1]));
      operands[5] = GEN_INT (CONST_DOUBLE_LOW (operands[1]));
    }
  else if (GET_CODE (operands[1]) == CONST_INT)
    {
      operands[4] = GEN_INT (- (INTVAL (operands[1]) < 0));
      operands[5] = operands[1];
    }
  else
    FAIL;
}")

(define_insn "*movdi_internal64"
  [(set (match_operand:DI 0 "nonimmediate_operand" "=Y,r,b,r,r,r,r,r,??f,f,m,r,*h,*h")
	(match_operand:DI 1 "input_operand" "r,Y,m,r,I,L,nF,R,f,m,f,*h,r,0"))]
  "TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], DImode)
       || gpc_reg_operand (operands[1], DImode))"
  "@
   std%U0%X0 %1,%0
   ld%U1%X1 %0,%1
   #
   mr %0,%1
   li %0,%1
   lis %0,%v1
   #
   {cal|la} %0,%a1
   fmr %0,%1
   lfd%U1%X1 %0,%1
   stfd%U0%X0 %1,%0
   mf%1 %0
   mt%0 %1
   {cror 0,0,0|nop}"
  [(set_attr "type" "store,load,load,*,*,*,*,*,fp,fpload,fpstore,mfjmpr,mtjmpr,*")
   (set_attr "length" "4,4,8,4,4,4,20,4,4,4,4,4,4,4")])

(define_split
  [(set (match_operand:DI 0 "base_reg_operand" "")
	(match_operand:DI 1 "invalid_gpr_mem" ""))]
  "TARGET_POWERPC64 && no_new_pseudos"
  [(set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (match_dup 4))]
  "
{
  operands[2] = operands[0];
  if (!TARGET_64BIT)
    operands[2] = gen_rtx_REG (SImode, REGNO (operands[0]));
  operands[3] = XEXP (operands[1], 0);
  operands[4] = replace_equiv_address (operands[1], operands[2]);
}")

(define_expand "reload_outdi"
  [(parallel [(match_operand:DI 0 "invalid_gpr_mem" "")
              (match_operand:DI 1 "register_operand" "")
              (match_operand:DI 2 "register_operand" "=&b")])]
  "TARGET_POWERPC64"
{
  if (!TARGET_64BIT)
    operands[2] = gen_rtx_REG (SImode, REGNO (operands[2]));
  emit_move_insn (operands[2], XEXP (operands[0], 0));
  operands[0] = replace_equiv_address (operands[0], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

(define_expand "reload_indi"
  [(parallel [(match_operand:DI 0 "register_operand" "")
	      (match_operand:DI 1 "invalid_gpr_mem" "")
	      (match_operand:DI 2 "register_operand" "=&b")])]
  "TARGET_POWERPC64"
{
  if (!TARGET_64BIT)
    operands[2] = gen_rtx_REG (SImode, REGNO (operands[2]));
  emit_move_insn (operands[2], XEXP (operands[1], 0));
  operands[1] = replace_equiv_address (operands[1], operands[2]);
  emit_move_insn (operands[0], operands[1]);
  DONE;
})

;; immediate value valid for a single instruction hiding in a const_double
(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operand:DI 1 "const_double_operand" "F"))]
  "HOST_BITS_PER_WIDE_INT == 32 && TARGET_POWERPC64
   && GET_CODE (operands[1]) == CONST_DOUBLE
   && num_insns_constant (operands[1], DImode) == 1"
  "*
{
  return ((unsigned HOST_WIDE_INT)
	  (CONST_DOUBLE_LOW (operands[1]) + 0x8000) < 0x10000)
	 ? \"li %0,%1\" : \"lis %0,%v1\";
}")

;; Generate all one-bits and clear left or right.
;; Use (and:DI (rotate:DI ...)) to avoid anddi3 unnecessary clobber.
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "mask64_operand" ""))]
  "TARGET_POWERPC64 && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0) (const_int -1))
   (set (match_dup 0)
	(and:DI (rotate:DI (match_dup 0)
			   (const_int 0))
		(match_dup 1)))]
  "")

;; Split a load of a large constant into the appropriate five-instruction
;; sequence.  Handle anything in a constant number of insns.
;; When non-easy constants can go in the TOC, this should use
;; easy_fp_constant predicate.
(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_int_operand" ""))]
  "TARGET_POWERPC64 && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0) (match_dup 2))
   (set (match_dup 0) (plus:DI (match_dup 0) (match_dup 3)))]
  "
{ rtx tem = rs6000_emit_set_const (operands[0], DImode, operands[1], 5);

  if (tem == operands[0])
    DONE;
  else
    FAIL;
}")

(define_split
  [(set (match_operand:DI 0 "gpc_reg_operand" "")
	(match_operand:DI 1 "const_double_operand" ""))]
  "TARGET_POWERPC64 && num_insns_constant (operands[1], DImode) > 1"
  [(set (match_dup 0) (match_dup 2))
   (set (match_dup 0) (plus:DI (match_dup 0) (match_dup 3)))]
  "
{ rtx tem = rs6000_emit_set_const (operands[0], DImode, operands[1], 5);

  if (tem == operands[0])
    DONE;
  else
    FAIL;
}")

(define_insn "*movdi_internal2"
  [(set (match_operand:CC 2 "cc_reg_operand" "=y,x,?y")
	(compare:CC (match_operand:DI 1 "gpc_reg_operand" "0,r,r")
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r") (match_dup 1))]
  "TARGET_64BIT"
  "@
   cmpdi %2,%0,0
   mr. %0,%1
   #"
  [(set_attr "type" "cmp,compare,cmp")
   (set_attr "length" "4,4,8")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operand:DI 1 "gpc_reg_operand" "")
		    (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "") (match_dup 1))]
  "TARGET_POWERPC64 && reload_completed"
  [(set (match_dup 0) (match_dup 1))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; TImode is similar, except that we usually want to compute the address into
;; a register and use lsi/stsi (the exception is during reload).  MQ is also
;; clobbered in stsi for POWER, so we need a SCRATCH for it.
(define_expand "movti"
  [(parallel [(set (match_operand:TI 0 "general_operand" "")
		   (match_operand:TI 1 "general_operand" ""))
	      (clobber (scratch:SI))])]
  ""
  "{ rs6000_emit_move (operands[0], operands[1], TImode); DONE; }")

;; We say that MQ is clobbered in the last alternative because the first
;; alternative would never get used otherwise since it would need a reload
;; while the 2nd alternative would not.  We put memory cases first so they
;; are preferred.  Otherwise, we'd try to reload the output instead of
;; giving the SCRATCH mq.

(define_insn "*movti_power"
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=Q,m,????r,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,r,Q,m"))
   (clobber (match_scratch:SI 2 "=q,q#X,X,X,X"))]
  "TARGET_POWER && ! TARGET_POWERPC64 
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();

    case 0:
      if (TARGET_STRING)
        return \"{stsi|stswi} %1,%P0,16\";
    case 1:
    case 2:
      return \"#\";
    case 3:
      /* If the address is not used in the output, we can use lsi.  Otherwise,
	 fall through to generating four loads.  */
      if (TARGET_STRING
	  && ! reg_overlap_mentioned_p (operands[0], operands[1]))
	return \"{lsi|lswi} %0,%P1,16\";
      /* ... fall through ...  */
    case 4:
      return \"#\";
    }
}"
  [(set_attr "type" "store,store,*,load,load")])

(define_insn "*movti_string"
  [(set (match_operand:TI 0 "reg_or_mem_operand" "=Q,m,????r,????r,????r")
	(match_operand:TI 1 "reg_or_mem_operand" "r,r,r,Q,m"))]
  "! TARGET_POWER && ! TARGET_POWERPC64
   && (gpc_reg_operand (operands[0], TImode) || gpc_reg_operand (operands[1], TImode))"
  "*
{
  switch (which_alternative)
    {
    default:
      abort ();
    case 0:
      if (TARGET_STRING)
        return \"{stsi|stswi} %1,%P0,16\";
    case 1:
    case 2:
      return \"#\";
    case 3:
      /* If the address is not used in the output, we can use lsi.  Otherwise,
	 fall through to generating four loads.  */
      if (TARGET_STRING  
          && ! reg_overlap_mentioned_p (operands[0], operands[1]))
	return \"{lsi|lswi} %0,%P1,16\";
      /* ... fall through ...  */
    case 4:
      return \"#\";
    }
}"
  [(set_attr "type" "store,store,*,load,load")])

(define_insn "*movti_ppc64"
  [(set (match_operand:TI 0 "nonimmediate_operand" "=r,m,r")
	(match_operand:TI 1 "input_operand" "r,r,o"))]
  "TARGET_POWERPC64 && (gpc_reg_operand (operands[0], TImode)
   || gpc_reg_operand (operands[1], TImode))"
  "@
   #	
   #	
   #"
  [(set_attr "type" "*,load,store")])

(define_split
  [(set (match_operand:TI 0 "nonimmediate_operand" "")
        (match_operand:TI 1 "input_operand" ""))]
  "reload_completed
   && gpr_or_gpr_p (operands[0], operands[1])"
  [(pc)]
{ rs6000_split_multireg_move (operands[0], operands[1]); DONE; })

(define_expand "load_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING && !TARGET_POWERPC64"
  "
{
  int regno;
  int count;
  rtx op1;
  int i;

  /* Support only loading a constant number of fixed-point registers from
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[1]) != MEM
      || GET_CODE (operands[0]) != REG
      || REGNO (operands[0]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[0]);

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count));
  op1 = replace_equiv_address (operands[1],
			       force_reg (SImode, XEXP (operands[1], 0)));

  for (i = 0; i < count; i++)
    XVECEXP (operands[3], 0, i)
      = gen_rtx_SET (VOIDmode, gen_rtx_REG (SImode, regno + i),
		     adjust_address_nv (op1, SImode, i * 4));
}")

(define_insn "*ldmsi8"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))
     (set (match_operand:SI 5 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 12))))
     (set (match_operand:SI 6 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 16))))
     (set (match_operand:SI 7 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 20))))
     (set (match_operand:SI 8 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 24))))
     (set (match_operand:SI 9 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 28))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 8"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_insn "*ldmsi7"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))
     (set (match_operand:SI 5 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 12))))
     (set (match_operand:SI 6 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 16))))
     (set (match_operand:SI 7 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 20))))
     (set (match_operand:SI 8 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 24))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 7"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_insn "*ldmsi6"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))
     (set (match_operand:SI 5 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 12))))
     (set (match_operand:SI 6 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 16))))
     (set (match_operand:SI 7 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 20))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 6"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_insn "*ldmsi5"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))
     (set (match_operand:SI 5 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 12))))
     (set (match_operand:SI 6 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 16))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 5"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_insn "*ldmsi4"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))
     (set (match_operand:SI 5 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 12))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 4"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_insn "*ldmsi3"
  [(match_parallel 0 "load_multiple_operation"
    [(set (match_operand:SI 2 "gpc_reg_operand" "")
          (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b")))
     (set (match_operand:SI 3 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 4))))
     (set (match_operand:SI 4 "gpc_reg_operand" "")
          (mem:SI (plus:SI (match_dup 1) (const_int 8))))])]
  "TARGET_STRING && XVECLEN (operands[0], 0) == 3"
  "*
{ return rs6000_output_load_multiple (operands); }"
  [(set_attr "type" "load")
   (set_attr "length" "32")])

(define_expand "store_multiple"
  [(match_par_dup 3 [(set (match_operand:SI 0 "" "")
			  (match_operand:SI 1 "" ""))
		     (clobber (scratch:SI))
		     (use (match_operand:SI 2 "" ""))])]
  "TARGET_STRING && !TARGET_POWERPC64"
  "
{
  int regno;
  int count;
  rtx to;
  rtx op0;
  int i;

  /* Support only storing a constant number of fixed-point registers to
     memory and only bother with this if more than two; the machine
     doesn't support more than eight.  */
  if (GET_CODE (operands[2]) != CONST_INT
      || INTVAL (operands[2]) <= 2
      || INTVAL (operands[2]) > 8
      || GET_CODE (operands[0]) != MEM
      || GET_CODE (operands[1]) != REG
      || REGNO (operands[1]) >= 32)
    FAIL;

  count = INTVAL (operands[2]);
  regno = REGNO (operands[1]);

  operands[3] = gen_rtx_PARALLEL (VOIDmode, rtvec_alloc (count + 1));
  to = force_reg (SImode, XEXP (operands[0], 0));
  op0 = replace_equiv_address (operands[0], to);

  XVECEXP (operands[3], 0, 0)
    = gen_rtx_SET (VOIDmode, adjust_address_nv (op0, SImode, 0), operands[1]);
  XVECEXP (operands[3], 0, 1) = gen_rtx_CLOBBER (VOIDmode,
						 gen_rtx_SCRATCH (SImode));

  for (i = 1; i < count; i++)
    XVECEXP (operands[3], 0, i + 1)
      = gen_rtx_SET (VOIDmode,
		     adjust_address_nv (op0, SImode, i * 4),
		     gen_rtx_REG (SImode, regno + i));
}")

(define_insn "*store_multiple_power"
  [(match_parallel 0 "store_multiple_operation"
		   [(set (match_operand:SI 1 "indirect_operand" "=Q")
			 (match_operand:SI 2 "gpc_reg_operand" "r"))
		    (clobber (match_scratch:SI 3 "=q"))])]
  "TARGET_STRING && TARGET_POWER"
  "{stsi|stswi} %2,%P1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi8"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 12)))
	  (match_operand:SI 6 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 16)))
	  (match_operand:SI 7 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 20)))
	  (match_operand:SI 8 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 24)))
	  (match_operand:SI 9 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 28)))
	  (match_operand:SI 10 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 9"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi7"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 12)))
	  (match_operand:SI 6 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 16)))
	  (match_operand:SI 7 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 20)))
	  (match_operand:SI 8 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 24)))
	  (match_operand:SI 9 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 8"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi6"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 12)))
	  (match_operand:SI 6 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 16)))
	  (match_operand:SI 7 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 20)))
	  (match_operand:SI 8 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 7"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi5"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 12)))
	  (match_operand:SI 6 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 16)))
	  (match_operand:SI 7 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 6"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi4"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 12)))
	  (match_operand:SI 6 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 5"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

(define_insn "*stmsi3"
  [(match_parallel 0 "store_multiple_operation"
    [(set (mem:SI (match_operand:SI 1 "gpc_reg_operand" "b"))
	  (match_operand:SI 2 "gpc_reg_operand" "r"))
     (clobber (match_scratch:SI 3 "X"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 4)))
	  (match_operand:SI 4 "gpc_reg_operand" "r"))
     (set (mem:SI (plus:SI (match_dup 1) (const_int 8)))
	  (match_operand:SI 5 "gpc_reg_operand" "r"))])]
  "TARGET_STRING && !TARGET_POWER && XVECLEN (operands[0], 0) == 4"
  "{stsi|stswi} %2,%1,%O0"
  [(set_attr "type" "store")])

;; String/block move insn.
;; Argument 0 is the destination
;; Argument 1 is the source
;; Argument 2 is the length
;; Argument 3 is the alignment

(define_expand "movstrsi"
  [(parallel [(set (match_operand:BLK 0 "" "")
		   (match_operand:BLK 1 "" ""))
	      (use (match_operand:SI 2 "" ""))
	      (use (match_operand:SI 3 "" ""))])]
  ""
  "
{
  if (expand_block_move (operands))
    DONE;
  else
    FAIL;
}")

;; Move up to 32 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 8 word registers.
;; rD/rS = r5 is preferred, efficient form.
(define_expand "movstrsi_8reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI  5))
	      (clobber (reg:SI  6))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (reg:SI 11))
	      (clobber (reg:SI 12))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32)
       || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && ! TARGET_POWER
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32)
       || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:DI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:DI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (reg:SI 11))
   (clobber (reg:SI 12))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && TARGET_POWERPC64
   && ((INTVAL (operands[2]) > 24 && INTVAL (operands[2]) < 32)
       || INTVAL (operands[2]) == 0)
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 12)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 12)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 24 bytes at a time.  The fixed registers are needed because the
;; register allocator doesn't have a clue about allocating 6 word registers.
;; rD/rS = r5 is preferred, efficient form.
(define_expand "movstrsi_6reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI  5))
	      (clobber (reg:SI  6))
	      (clobber (reg:SI  7))
	      (clobber (reg:SI  8))
	      (clobber (reg:SI  9))
	      (clobber (reg:SI 10))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 24
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 10)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 10)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && ! TARGET_POWER
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 32
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 10)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 10)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:DI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:DI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI  6))
   (clobber (reg:SI  7))
   (clobber (reg:SI  8))
   (clobber (reg:SI  9))
   (clobber (reg:SI 10))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && TARGET_POWERPC64
   && INTVAL (operands[2]) > 16 && INTVAL (operands[2]) <= 32
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 10)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 10)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 16 bytes at a time, using 4 fixed registers to avoid spill
;; problems with TImode.
;; rD/rS = r5 is preferred, efficient form.
(define_expand "movstrsi_4reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (reg:SI 5))
	      (clobber (reg:SI 6))
	      (clobber (reg:SI 7))
	      (clobber (reg:SI 8))
	      (clobber (match_scratch:SI 4 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI 6))
   (clobber (reg:SI 7))
   (clobber (reg:SI 8))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 8)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 8)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI 6))
   (clobber (reg:SI 7))
   (clobber (reg:SI 8))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && ! TARGET_POWER
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 8)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 8)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:DI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:DI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_operand:SI 4 "gpc_reg_operand" "=r"))
   (clobber (reg:SI 6))
   (clobber (reg:SI 7))
   (clobber (reg:SI 8))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && TARGET_POWERPC64
   && INTVAL (operands[2]) > 8 && INTVAL (operands[2]) <= 16
   && (REGNO (operands[0]) < 5 || REGNO (operands[0]) > 8)
   && (REGNO (operands[1]) < 5 || REGNO (operands[1]) > 8)
   && REGNO (operands[4]) == 5"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 8 bytes at a time.
(define_expand "movstrsi_2reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (match_scratch:DI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING && ! TARGET_POWERPC64"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER && ! TARGET_POWERPC64
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:DI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && ! TARGET_POWER && ! TARGET_POWERPC64
   && INTVAL (operands[2]) > 4 && INTVAL (operands[2]) <= 8"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

;; Move up to 4 bytes at a time.
(define_expand "movstrsi_1reg"
  [(parallel [(set (match_operand 0 "" "")
		   (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (clobber (match_scratch:SI 4 ""))
	      (clobber (match_scratch:SI 5 ""))])]
  "TARGET_STRING"
  "")

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "=q"))]
  "TARGET_STRING && TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:SI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:SI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && ! TARGET_POWER
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])

(define_insn ""
  [(set (mem:BLK (match_operand:DI 0 "gpc_reg_operand" "b"))
	(mem:BLK (match_operand:DI 1 "gpc_reg_operand" "b")))
   (use (match_operand:SI 2 "immediate_operand" "i"))
   (use (match_operand:SI 3 "immediate_operand" "i"))
   (clobber (match_scratch:SI 4 "=&r"))
   (clobber (match_scratch:SI 5 "X"))]
  "TARGET_STRING && TARGET_POWERPC64
   && INTVAL (operands[2]) > 0 && INTVAL (operands[2]) <= 4"
  "{lsi|lswi} %4,%1,%2\;{stsi|stswi} %4,%0,%2"
  [(set_attr "type" "load")
   (set_attr "length" "8")])


;; Define insns that do load or store with update.  Some of these we can
;; get by using pre-decrement or pre-increment, but the hardware can also
;; do cases where the increment is not the size of the object.
;;
;; In all these cases, we use operands 0 and 1 for the register being
;; incremented because those are the operands that local-alloc will
;; tie and these are the pair most likely to be tieable (and the ones
;; that will benefit the most).

(define_insn "*movdi_update1"
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r,r")
	(mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_aligned_short_operand" "r,I"))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && TARGET_UPDATE"
  "@
   ldux %3,%0,%2
   ldu %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "movdi_update"
  [(set (mem:DI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0,0")
			 (match_operand:DI 2 "reg_or_aligned_short_operand" "r,I")))
	(match_operand:DI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b,b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64 && TARGET_UPDATE"
  "@
   stdux %3,%0,%2
   stdu %3,%2(%0)"
  [(set_attr "type" "store_ux,store_u")])

(define_insn "*movsi_update1"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   {lux|lwzux} %3,%0,%2
   {lu|lwzu} %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movsi_update2"
  [(set (match_operand:DI 3 "gpc_reg_operand" "=r")
	(sign_extend:DI
	 (mem:SI (plus:DI (match_operand:DI 1 "gpc_reg_operand" "0")
			  (match_operand:DI 2 "gpc_reg_operand" "r")))))
   (set (match_operand:DI 0 "gpc_reg_operand" "=b")
	(plus:DI (match_dup 1) (match_dup 2)))]
  "TARGET_POWERPC64"
  "lwaux %3,%0,%2"
  [(set_attr "type" "load_ext_ux")])

(define_insn "movsi_update"
  [(set (mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   {stux|stwux} %3,%0,%2
   {stu|stwu} %3,%2(%0)"
  [(set_attr "type" "store_ux,store_u")])

(define_insn "*movhi_update1"
  [(set (match_operand:HI 3 "gpc_reg_operand" "=r,r")
	(mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movhi_update2"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhzux %3,%0,%2
   lhzu %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movhi_update3"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(sign_extend:SI
	 (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lhaux %3,%0,%2
   lhau %3,%2(%0)"
  [(set_attr "type" "load_ext_ux,load_ext_u")])

(define_insn "*movhi_update4"
  [(set (mem:HI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:HI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   sthux %3,%0,%2
   sthu %3,%2(%0)"
  [(set_attr "type" "store_ux,store_u")])

(define_insn "*movqi_update1"
  [(set (match_operand:QI 3 "gpc_reg_operand" "=r,r")
	(mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movqi_update2"
  [(set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(zero_extend:SI
	 (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			  (match_operand:SI 2 "reg_or_short_operand" "r,I")))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   lbzux %3,%0,%2
   lbzu %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movqi_update3"
  [(set (mem:QI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:QI 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_UPDATE"
  "@
   stbux %3,%0,%2
   stbu %3,%2(%0)"
  [(set_attr "type" "store_ux,store_u")])

(define_insn "*movsf_update1"
  [(set (match_operand:SF 3 "gpc_reg_operand" "=f,f")
	(mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_UPDATE"
  "@
   lfsux %3,%0,%2
   lfsu %3,%2(%0)"
  [(set_attr "type" "fpload_ux,fpload_u")])

(define_insn "*movsf_update2"
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_UPDATE"
  "@
   stfsux %3,%0,%2
   stfsu %3,%2(%0)"
  [(set_attr "type" "fpstore_ux,fpstore_u")])

(define_insn "*movsf_update3"
  [(set (match_operand:SF 3 "gpc_reg_operand" "=r,r")
	(mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "(TARGET_SOFT_FLOAT || !TARGET_FPRS) && TARGET_UPDATE"
  "@
   {lux|lwzux} %3,%0,%2
   {lu|lwzu} %3,%2(%0)"
  [(set_attr "type" "load_ux,load_u")])

(define_insn "*movsf_update4"
  [(set (mem:SF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:SF 3 "gpc_reg_operand" "r,r"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "(TARGET_SOFT_FLOAT || !TARGET_FPRS) && TARGET_UPDATE"
  "@
   {stux|stwux} %3,%0,%2
   {stu|stwu} %3,%2(%0)"
  [(set_attr "type" "store_ux,store_u")])

(define_insn "*movdf_update1"
  [(set (match_operand:DF 3 "gpc_reg_operand" "=f,f")
	(mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I"))))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_UPDATE"
  "@
   lfdux %3,%0,%2
   lfdu %3,%2(%0)"
  [(set_attr "type" "fpload_ux,fpload_u")])

(define_insn "*movdf_update2"
  [(set (mem:DF (plus:SI (match_operand:SI 1 "gpc_reg_operand" "0,0")
			 (match_operand:SI 2 "reg_or_short_operand" "r,I")))
	(match_operand:DF 3 "gpc_reg_operand" "f,f"))
   (set (match_operand:SI 0 "gpc_reg_operand" "=b,b")
	(plus:SI (match_dup 1) (match_dup 2)))]
  "TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_UPDATE"
  "@
   stfdux %3,%0,%2
   stfdu %3,%2(%0)"
  [(set_attr "type" "fpstore_ux,fpstore_u")])

;; Peephole to convert two consecutive FP loads or stores into lfq/stfq.

(define_peephole
  [(set (match_operand:DF 0 "gpc_reg_operand" "=f")
	(match_operand:DF 1 "memory_operand" ""))
   (set (match_operand:DF 2 "gpc_reg_operand" "=f")
	(match_operand:DF 3 "memory_operand" ""))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT && TARGET_FPRS
   && registers_ok_for_quad_peep (operands[0], operands[2])
   && ! MEM_VOLATILE_P (operands[1]) && ! MEM_VOLATILE_P (operands[3])
   && addrs_ok_for_quad_peep (XEXP (operands[1], 0), XEXP (operands[3], 0))"
  "lfq%U1%X1 %0,%1")

(define_peephole
  [(set (match_operand:DF 0 "memory_operand" "")
	(match_operand:DF 1 "gpc_reg_operand" "f"))
   (set (match_operand:DF 2 "memory_operand" "")
	(match_operand:DF 3 "gpc_reg_operand" "f"))]
  "TARGET_POWER2
   && TARGET_HARD_FLOAT && TARGET_FPRS
   && registers_ok_for_quad_peep (operands[1], operands[3])
   && ! MEM_VOLATILE_P (operands[0]) && ! MEM_VOLATILE_P (operands[2])
   && addrs_ok_for_quad_peep (XEXP (operands[0], 0), XEXP (operands[2], 0))"
  "stfq%U0%X0 %1,%0")

;; TLS support.

;; "b" output constraint here and on tls_ld to support tls linker optimization.
(define_insn "tls_gd_32"
  [(set (match_operand:SI 0 "register_operand" "=b")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGD))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%2@got@tlsgd")

(define_insn "tls_gd_64"
  [(set (match_operand:DI 0 "register_operand" "=b")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGD))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%2@got@tlsgd")

(define_insn "tls_ld_32"
  [(set (match_operand:SI 0 "register_operand" "=b")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")]
		   UNSPEC_TLSLD))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%&@got@tlsld")

(define_insn "tls_ld_64"
  [(set (match_operand:DI 0 "register_operand" "=b")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")]
		   UNSPEC_TLSLD))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%&@got@tlsld")

(define_insn "tls_dtprel_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPREL))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%2@dtprel")

(define_insn "tls_dtprel_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPREL))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%2@dtprel")

(define_insn "tls_dtprel_ha_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPRELHA))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addis %0,%1,%2@dtprel@ha")

(define_insn "tls_dtprel_ha_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPRELHA))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addis %0,%1,%2@dtprel@ha")

(define_insn "tls_dtprel_lo_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPRELLO))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%2@dtprel@l")

(define_insn "tls_dtprel_lo_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSDTPRELLO))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%2@dtprel@l")

(define_insn "tls_got_dtprel_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGOTDTPREL))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "lwz %0,%2@got@dtprel(%1)")

(define_insn "tls_got_dtprel_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGOTDTPREL))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "ld %0,%2@got@dtprel(%1)")

(define_insn "tls_tprel_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPREL))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%2@tprel")

(define_insn "tls_tprel_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPREL))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%2@tprel")

(define_insn "tls_tprel_ha_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPRELHA))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addis %0,%1,%2@tprel@ha")

(define_insn "tls_tprel_ha_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPRELHA))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addis %0,%1,%2@tprel@ha")

(define_insn "tls_tprel_lo_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPRELLO))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "addi %0,%1,%2@tprel@l")

(define_insn "tls_tprel_lo_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTPRELLO))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "addi %0,%1,%2@tprel@l")

;; "b" output constraint here and on tls_tls input to support linker tls
;; optimization.  The linker may edit the instructions emitted by a
;; tls_got_tprel/tls_tls pair to addis,addi.
(define_insn "tls_got_tprel_32"
  [(set (match_operand:SI 0 "register_operand" "=b")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGOTTPREL))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "lwz %0,%2@got@tprel(%1)")

(define_insn "tls_got_tprel_64"
  [(set (match_operand:DI 0 "register_operand" "=b")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSGOTTPREL))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "ld %0,%2@got@tprel(%1)")

(define_insn "tls_tls_32"
  [(set (match_operand:SI 0 "register_operand" "=r")
	(unspec:SI [(match_operand:SI 1 "register_operand" "b")
		    (match_operand:SI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTLS))]
  "HAVE_AS_TLS && !TARGET_64BIT"
  "add %0,%1,%2@tls")

(define_insn "tls_tls_64"
  [(set (match_operand:DI 0 "register_operand" "=r")
	(unspec:DI [(match_operand:DI 1 "register_operand" "b")
		    (match_operand:DI 2 "rs6000_tls_symbol_ref" "")]
		   UNSPEC_TLSTLS))]
  "HAVE_AS_TLS && TARGET_64BIT"
  "add %0,%1,%2@tls")

;; Next come insns related to the calling sequence.
;;
;; First, an insn to allocate new stack space for dynamic use (e.g., alloca).
;; We move the back-chain and decrement the stack pointer.

(define_expand "allocate_stack"
  [(set (match_operand 0 "gpc_reg_operand" "=r")
	(minus (reg 1) (match_operand 1 "reg_or_short_operand" "")))
   (set (reg 1)
	(minus (reg 1) (match_dup 1)))]
  ""
  "
{ rtx chain = gen_reg_rtx (Pmode);
  rtx stack_bot = gen_rtx_MEM (Pmode, stack_pointer_rtx);
  rtx neg_op0;

  emit_move_insn (chain, stack_bot);

  /* Check stack bounds if necessary.  */
  if (current_function_limit_stack)
    {
      rtx available;
      available = expand_binop (Pmode, sub_optab, 
				stack_pointer_rtx, stack_limit_rtx,
				NULL_RTX, 1, OPTAB_WIDEN);
      emit_insn (gen_cond_trap (LTU, available, operands[1], const0_rtx));
    }

  if (GET_CODE (operands[1]) != CONST_INT
      || INTVAL (operands[1]) < -32767
      || INTVAL (operands[1]) > 32768)
    {
      neg_op0 = gen_reg_rtx (Pmode);
      if (TARGET_32BIT)
	emit_insn (gen_negsi2 (neg_op0, operands[1]));
      else
	emit_insn (gen_negdi2 (neg_op0, operands[1]));
    }
  else
    neg_op0 = GEN_INT (- INTVAL (operands[1]));

  if (TARGET_UPDATE)
    emit_insn ((* ((TARGET_32BIT) ? gen_movsi_update : gen_movdi_update))
		(stack_pointer_rtx, stack_pointer_rtx, neg_op0, chain));

  else
    {
      emit_insn ((* ((TARGET_32BIT) ? gen_addsi3 : gen_adddi3))
		 (stack_pointer_rtx, stack_pointer_rtx, neg_op0));
      emit_move_insn (gen_rtx_MEM (Pmode, stack_pointer_rtx), chain);
    }

  emit_move_insn (operands[0], virtual_stack_dynamic_rtx);
  DONE;
}")

;; These patterns say how to save and restore the stack pointer.  We need not
;; save the stack pointer at function level since we are careful to
;; preserve the backchain.  At block level, we have to restore the backchain
;; when we restore the stack pointer.
;;
;; For nonlocal gotos, we must save both the stack pointer and its
;; backchain and restore both.  Note that in the nonlocal case, the
;; save area is a memory location.

(define_expand "save_stack_function"
  [(match_operand 0 "any_operand" "")
   (match_operand 1 "any_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_function"
  [(match_operand 0 "any_operand" "")
   (match_operand 1 "any_operand" "")]
  ""
  "DONE;")

(define_expand "restore_stack_block"
  [(use (match_operand 0 "register_operand" ""))
   (set (match_dup 2) (match_dup 3))
   (set (match_dup 0) (match_operand 1 "register_operand" ""))
   (set (match_dup 3) (match_dup 2))]
  ""
  "
{
  operands[2] = gen_reg_rtx (Pmode);
  operands[3] = gen_rtx_MEM (Pmode, operands[0]);
}")

(define_expand "save_stack_nonlocal"
  [(match_operand 0 "memory_operand" "")
   (match_operand 1 "register_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (Pmode);

  /* Copy the backchain to the first word, sp to the second.  */
  emit_move_insn (temp, gen_rtx_MEM (Pmode, operands[1]));
  emit_move_insn (operand_subword (operands[0], 0, 0,
				   (TARGET_32BIT ? DImode : TImode)),
		  temp);
  emit_move_insn (operand_subword (operands[0], 1, 0, (TARGET_32BIT ? DImode : TImode)),
		  operands[1]);
  DONE;
}")

(define_expand "restore_stack_nonlocal"
  [(match_operand 0 "register_operand" "")
   (match_operand 1 "memory_operand" "")]
  ""
  "
{
  rtx temp = gen_reg_rtx (Pmode);

  /* Restore the backchain from the first word, sp from the second.  */
  emit_move_insn (temp,
		  operand_subword (operands[1], 0, 0, (TARGET_32BIT ? DImode : TImode)));
  emit_move_insn (operands[0],
		  operand_subword (operands[1], 1, 0,
				   (TARGET_32BIT ? DImode : TImode)));
  emit_move_insn (gen_rtx_MEM (Pmode, operands[0]), temp);
  DONE;
}")

;; TOC register handling.

;; Code to initialize the TOC register...

(define_insn "load_toc_aix_si"
  [(parallel [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
		   (unspec:SI [(const_int 0)] UNSPEC_TOC))
	      (use (reg:SI 2))])]
  "DEFAULT_ABI == ABI_AIX && TARGET_32BIT"
  "*
{
  char buf[30];
  ASM_GENERATE_INTERNAL_LABEL (buf, \"LCTOC\", 1);
  operands[1] = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (buf));
  operands[2] = gen_rtx_REG (Pmode, 2);
  return \"{l|lwz} %0,%1(%2)\";
}"
  [(set_attr "type" "load")])

(define_insn "load_toc_aix_di"
  [(parallel [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
		   (unspec:DI [(const_int 0)] UNSPEC_TOC))
	      (use (reg:DI 2))])]
  "DEFAULT_ABI == ABI_AIX && TARGET_64BIT"
  "*
{
  char buf[30];
#ifdef TARGET_RELOCATABLE
  ASM_GENERATE_INTERNAL_LABEL (buf, \"LCTOC\",
			       !TARGET_MINIMAL_TOC || TARGET_RELOCATABLE);
#else
  ASM_GENERATE_INTERNAL_LABEL (buf, \"LCTOC\", 1);
#endif
  if (TARGET_ELF)
    strcat (buf, \"@toc\");
  operands[1] = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (buf));
  operands[2] = gen_rtx_REG (Pmode, 2);
  return \"ld %0,%1(%2)\";
}"
  [(set_attr "type" "load")])

(define_insn "load_toc_v4_pic_si"
  [(set (match_operand:SI 0 "register_operand" "=l")
	(unspec:SI [(const_int 0)] UNSPEC_TOC))]
  "DEFAULT_ABI == ABI_V4 && flag_pic == 1 && TARGET_32BIT"
  "bl _GLOBAL_OFFSET_TABLE_@local-4"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "load_toc_v4_PIC_1"
  [(set (match_operand:SI 0 "register_operand" "=l")
	(match_operand:SI 1 "immediate_operand" "s"))
   (use (unspec [(match_dup 1)] UNSPEC_TOC))]
  "TARGET_ELF && DEFAULT_ABI != ABI_AIX && flag_pic == 2"
  "bcl 20,31,%1\\n%1:"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "load_toc_v4_PIC_1b"
  [(set (match_operand:SI 0 "register_operand" "=l")
	(unspec:SI [(match_operand:SI 1 "immediate_operand" "s")]
		UNSPEC_TOCPTR))]
  "TARGET_ELF && DEFAULT_ABI != ABI_AIX && flag_pic == 2"
  "bcl 20,31,$+8\\n\\t.long %1-$"
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

(define_insn "load_toc_v4_PIC_2"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(mem:SI (plus:SI (match_operand:SI 1 "gpc_reg_operand" "b")
		   (minus:SI (match_operand:SI 2 "immediate_operand" "s")
			     (match_operand:SI 3 "immediate_operand" "s")))))]
  "TARGET_ELF && DEFAULT_ABI != ABI_AIX && flag_pic == 2"
  "{l|lwz} %0,%2-%3(%1)"
  [(set_attr "type" "load")])

(define_insn "load_macho_picbase"
  [(set (match_operand:SI 0 "register_operand" "=l")
	(unspec:SI [(match_operand:SI 1 "immediate_operand" "s")]
		   UNSPEC_LD_MPIC))]
  "(DEFAULT_ABI == ABI_DARWIN) && flag_pic"
  "bcl 20,31,%1\\n%1:"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "macho_correct_pic"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		 (unspec:SI [(match_operand:SI 2 "immediate_operand" "s")
			     (match_operand:SI 3 "immediate_operand" "s")]
			    UNSPEC_MPIC_CORRECT)))]
  "DEFAULT_ABI == ABI_DARWIN"
  "addis %0,%1,ha16(%2-%3)\n\taddi %0,%0,lo16(%2-%3)"
  [(set_attr "length" "8")])

;; If the TOC is shared over a translation unit, as happens with all
;; the kinds of PIC that we support, we need to restore the TOC
;; pointer only when jumping over units of translation.
;; On Darwin, we need to reload the picbase.

(define_expand "builtin_setjmp_receiver"
  [(use (label_ref (match_operand 0 "" "")))]
  "(DEFAULT_ABI == ABI_V4 && flag_pic == 1)
   || (TARGET_TOC && TARGET_MINIMAL_TOC)
   || (DEFAULT_ABI == ABI_DARWIN && flag_pic)"
  "
{
#if TARGET_MACHO
  if (DEFAULT_ABI == ABI_DARWIN)
    {
      const char *picbase = machopic_function_base_name ();
      rtx picrtx = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (picbase));
      rtx picreg = gen_rtx_REG (Pmode, RS6000_PIC_OFFSET_TABLE_REGNUM);
      rtx tmplabrtx;
      char tmplab[20];

      ASM_GENERATE_INTERNAL_LABEL(tmplab, \"LSJR\",
				  CODE_LABEL_NUMBER (operands[0]));
      tmplabrtx = gen_rtx_SYMBOL_REF (Pmode, ggc_strdup (tmplab));

      emit_insn (gen_load_macho_picbase (picreg, tmplabrtx));
      emit_insn (gen_macho_correct_pic (picreg, picreg, picrtx, tmplabrtx));
    }
  else
#endif
    rs6000_emit_load_toc_table (FALSE);
  DONE;
}")

;; A function pointer under AIX is a pointer to a data area whose first word
;; contains the actual address of the function, whose second word contains a
;; pointer to its TOC, and whose third word contains a value to place in the
;; static chain register (r11).  Note that if we load the static chain, our
;; "trampoline" need not have any executable code.

(define_expand "call_indirect_aix32"
  [(set (match_dup 2)
	(mem:SI (match_operand:SI 0 "gpc_reg_operand" "")))
   (set (mem:SI (plus:SI (reg:SI 1) (const_int 20)))
	(reg:SI 2))
   (set (reg:SI 2)
	(mem:SI (plus:SI (match_dup 0)
			 (const_int 4))))
   (set (reg:SI 11)
	(mem:SI (plus:SI (match_dup 0)
			 (const_int 8))))
   (parallel [(call (mem:SI (match_dup 2))
		    (match_operand 1 "" ""))
	      (use (reg:SI 2))
	      (use (reg:SI 11))
	      (set (reg:SI 2)
		   (mem:SI (plus:SI (reg:SI 1) (const_int 20))))
	      (clobber (scratch:SI))])]
  "TARGET_32BIT"
  "
{ operands[2] = gen_reg_rtx (SImode); }")

(define_expand "call_indirect_aix64"
  [(set (match_dup 2)
	(mem:DI (match_operand:DI 0 "gpc_reg_operand" "")))
   (set (mem:DI (plus:DI (reg:DI 1) (const_int 40)))
	(reg:DI 2))
   (set (reg:DI 2)
	(mem:DI (plus:DI (match_dup 0)
			 (const_int 8))))
   (set (reg:DI 11)
	(mem:DI (plus:DI (match_dup 0)
			 (const_int 16))))
   (parallel [(call (mem:SI (match_dup 2))
		    (match_operand 1 "" ""))
	      (use (reg:DI 2))
	      (use (reg:DI 11))
	      (set (reg:DI 2)
		   (mem:DI (plus:DI (reg:DI 1) (const_int 40))))
	      (clobber (scratch:SI))])]
  "TARGET_64BIT"
  "
{ operands[2] = gen_reg_rtx (DImode); }")

(define_expand "call_value_indirect_aix32"
  [(set (match_dup 3)
	(mem:SI (match_operand:SI 1 "gpc_reg_operand" "")))
   (set (mem:SI (plus:SI (reg:SI 1) (const_int 20)))
	(reg:SI 2))
   (set (reg:SI 2)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 4))))
   (set (reg:SI 11)
	(mem:SI (plus:SI (match_dup 1)
			 (const_int 8))))
   (parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_dup 3))
			 (match_operand 2 "" "")))
	      (use (reg:SI 2))
	      (use (reg:SI 11))
	      (set (reg:SI 2)
		   (mem:SI (plus:SI (reg:SI 1) (const_int 20))))
	      (clobber (scratch:SI))])]
  "TARGET_32BIT"
  "
{ operands[3] = gen_reg_rtx (SImode); }")

(define_expand "call_value_indirect_aix64"
  [(set (match_dup 3)
	(mem:DI (match_operand:DI 1 "gpc_reg_operand" "")))
   (set (mem:DI (plus:DI (reg:DI 1) (const_int 40)))
	(reg:DI 2))
   (set (reg:DI 2)
	(mem:DI (plus:DI (match_dup 1)
			 (const_int 8))))
   (set (reg:DI 11)
	(mem:DI (plus:DI (match_dup 1)
			 (const_int 16))))
   (parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_dup 3))
			 (match_operand 2 "" "")))
	      (use (reg:DI 2))
	      (use (reg:DI 11))
	      (set (reg:DI 2)
		   (mem:DI (plus:DI (reg:DI 1) (const_int 40))))
	      (clobber (scratch:SI))])]
  "TARGET_64BIT"
  "
{ operands[3] = gen_reg_rtx (DImode); }")

;; Now the definitions for the call and call_value insns
(define_expand "call"
  [(parallel [(call (mem:SI (match_operand 0 "address_operand" ""))
		    (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
#if TARGET_MACHO
  if (MACHOPIC_INDIRECT)
    operands[0] = machopic_indirect_call_target (operands[0]);
#endif

  if (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != CONST_INT)
    abort ();

  operands[0] = XEXP (operands[0], 0);

  if (GET_CODE (operands[0]) != SYMBOL_REF
      || (DEFAULT_ABI == ABI_AIX && !SYMBOL_REF_FUNCTION_P (operands[0]))
      || (DEFAULT_ABI != ABI_DARWIN && (INTVAL (operands[2]) & CALL_LONG) != 0))
    {
      if (INTVAL (operands[2]) & CALL_LONG)
	operands[0] = rs6000_longcall_ref (operands[0]);

      if (DEFAULT_ABI == ABI_V4
	  || DEFAULT_ABI == ABI_DARWIN)
	operands[0] = force_reg (Pmode, operands[0]);

      else if (DEFAULT_ABI == ABI_AIX)
	{
	  /* AIX function pointers are really pointers to a three word
	     area.  */
	  emit_call_insn (TARGET_32BIT
			  ? gen_call_indirect_aix32 (force_reg (SImode,
							        operands[0]),
						     operands[1])
			  : gen_call_indirect_aix64 (force_reg (DImode,
							        operands[0]),
						     operands[1]));
	  DONE;
	}
      else
	abort ();
    }
}")

(define_expand "call_value"
  [(parallel [(set (match_operand 0 "" "")
		   (call (mem:SI (match_operand 1 "address_operand" ""))
			 (match_operand 2 "" "")))
	      (use (match_operand 3 "" ""))
	      (clobber (scratch:SI))])]
  ""
  "
{
#if TARGET_MACHO
  if (MACHOPIC_INDIRECT)
    operands[1] = machopic_indirect_call_target (operands[1]);
#endif

  if (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != CONST_INT)
    abort ();

  operands[1] = XEXP (operands[1], 0);

  if (GET_CODE (operands[1]) != SYMBOL_REF
      || (DEFAULT_ABI == ABI_AIX && !SYMBOL_REF_FUNCTION_P (operands[1]))
      || (DEFAULT_ABI != ABI_DARWIN && (INTVAL (operands[3]) & CALL_LONG) != 0))
    {
      if (INTVAL (operands[3]) & CALL_LONG)
	operands[1] = rs6000_longcall_ref (operands[1]);

      if (DEFAULT_ABI == ABI_V4
	  || DEFAULT_ABI == ABI_DARWIN)
	operands[1] = force_reg (Pmode, operands[1]);

      else if (DEFAULT_ABI == ABI_AIX)
	{
	  /* AIX function pointers are really pointers to a three word
	     area.  */
	  emit_call_insn (TARGET_32BIT
			  ? gen_call_value_indirect_aix32 (operands[0],
							   force_reg (SImode,
								      operands[1]),
							   operands[2])
			  : gen_call_value_indirect_aix64 (operands[0],
							   force_reg (DImode,
								      operands[1]),
							   operands[2]));
	  DONE;
	}
      else
	abort ();
    }
}")

;; Call to function in current module.  No TOC pointer reload needed.
;; Operand2 is nonzero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn "*call_local32"
  [(call (mem:SI (match_operand:SI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "(INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z0@local\" : \"bl %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*call_local64"
  [(call (mem:SI (match_operand:DI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "TARGET_64BIT && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z0@local\" : \"bl %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*call_value_local32"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "(INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z1@local\" : \"bl %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])


(define_insn "*call_value_local64"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:DI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "TARGET_64BIT && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"bl %z1@local\" : \"bl %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

;; Call to function which may be in another module.  Restore the TOC
;; pointer (r2) after the call unless this is System V.
;; Operand2 is nonzero if we are using the V.4 calling sequence and
;; either the function was not prototyped, or it was prototyped as a
;; variable argument function.  It is > 0 if FP registers were passed
;; and < 0 if they were not.

(define_insn "*call_indirect_nonlocal_aix32"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "cl"))
	 (match_operand 1 "" "g"))
   (use (reg:SI 2))
   (use (reg:SI 11))
   (set (reg:SI 2)
	(mem:SI (plus:SI (reg:SI 1) (const_int 20))))
   (clobber (match_scratch:SI 2 "=l"))]
  "TARGET_32BIT && DEFAULT_ABI == ABI_AIX"
  "b%T0l\;{l|lwz} 2,20(1)"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "8")])

(define_insn "*call_nonlocal_aix32"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" "s"))
	 (match_operand 1 "" "g"))
   (use (match_operand:SI 2 "immediate_operand" "O"))
   (clobber (match_scratch:SI 3 "=l"))]
  "TARGET_32BIT
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "bl %z0\;%."
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

(define_insn "*call_indirect_nonlocal_aix64"
  [(call (mem:SI (match_operand:DI 0 "register_operand" "cl"))
	 (match_operand 1 "" "g"))
   (use (reg:DI 2))
   (use (reg:DI 11))
   (set (reg:DI 2)
	(mem:DI (plus:DI (reg:DI 1) (const_int 40))))
   (clobber (match_scratch:SI 2 "=l"))]
  "TARGET_64BIT && DEFAULT_ABI == ABI_AIX"
  "b%T0l\;ld 2,40(1)"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "8")])

(define_insn "*call_nonlocal_aix64"
  [(call (mem:SI (match_operand:DI 0 "symbol_ref_operand" "s"))
	 (match_operand 1 "" "g"))
   (use (match_operand:SI 2 "immediate_operand" "O"))
   (clobber (match_scratch:SI 3 "=l"))]
  "TARGET_64BIT 
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "bl %z0\;%."
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

(define_insn "*call_value_indirect_nonlocal_aix32"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "register_operand" "cl"))
	      (match_operand 2 "" "g")))
   (use (reg:SI 2))
   (use (reg:SI 11))
   (set (reg:SI 2)
	(mem:SI (plus:SI (reg:SI 1) (const_int 20))))
   (clobber (match_scratch:SI 3 "=l"))]
  "TARGET_32BIT && DEFAULT_ABI == ABI_AIX"
  "b%T1l\;{l|lwz} 2,20(1)"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "8")])

(define_insn "*call_value_nonlocal_aix32"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "symbol_ref_operand" "s"))
	      (match_operand 2 "" "g")))
   (use (match_operand:SI 3 "immediate_operand" "O"))
   (clobber (match_scratch:SI 4 "=l"))]
  "TARGET_32BIT
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "bl %z1\;%."
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

(define_insn "*call_value_indirect_nonlocal_aix64"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:DI 1 "register_operand" "cl"))
	      (match_operand 2 "" "g")))
   (use (reg:DI 2))
   (use (reg:DI 11))
   (set (reg:DI 2)
	(mem:DI (plus:DI (reg:DI 1) (const_int 40))))
   (clobber (match_scratch:SI 3 "=l"))]
  "TARGET_64BIT && DEFAULT_ABI == ABI_AIX"
  "b%T1l\;ld 2,40(1)"
  [(set_attr "type" "jmpreg")
   (set_attr "length" "8")])

(define_insn "*call_value_nonlocal_aix64"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:DI 1 "symbol_ref_operand" "s"))
	      (match_operand 2 "" "g")))
   (use (match_operand:SI 3 "immediate_operand" "O"))
   (clobber (match_scratch:SI 4 "=l"))]
  "TARGET_64BIT 
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "bl %z1\;%."
  [(set_attr "type" "branch")
   (set_attr "length" "8")])

;; A function pointer under System V is just a normal pointer
;; operands[0] is the function pointer
;; operands[1] is the stack size to clean up
;; operands[2] is the value FUNCTION_ARG returns for the VOID argument
;; which indicates how to set cr1

(define_insn "*call_indirect_nonlocal_sysv"
  [(call (mem:SI (match_operand:SI 0 "register_operand" "cl,cl"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "DEFAULT_ABI == ABI_V4
   || DEFAULT_ABI == ABI_DARWIN"
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn ("crxor 6,6,6", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn ("creqv 6,6,6", operands);

  return "b%T0l";
}
  [(set_attr "type" "jmpreg,jmpreg")
   (set_attr "length" "4,8")])

(define_insn "*call_nonlocal_sysv"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 3 "=l,l"))]
  "(DEFAULT_ABI == ABI_DARWIN
   || (DEFAULT_ABI == ABI_V4
       && (INTVAL (operands[2]) & CALL_LONG) == 0))"
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn ("crxor 6,6,6", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn ("creqv 6,6,6", operands);

#if TARGET_MACHO
  return output_call(insn, operands, 0, 2);
#else
  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? "bl %z0@plt" : "bl %z0";
#endif     
}
  [(set_attr "type" "branch,branch")
   (set_attr "length" "4,8")])

(define_insn "*call_value_indirect_nonlocal_sysv"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "register_operand" "cl,cl"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "DEFAULT_ABI == ABI_V4
   || DEFAULT_ABI == ABI_DARWIN"
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn ("crxor 6,6,6", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn ("creqv 6,6,6", operands);

  return "b%T1l";
}
  [(set_attr "type" "jmpreg,jmpreg")
   (set_attr "length" "4,8")])

(define_insn "*call_value_nonlocal_sysv"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "symbol_ref_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (clobber (match_scratch:SI 4 "=l,l"))]
  "(DEFAULT_ABI == ABI_DARWIN
   || (DEFAULT_ABI == ABI_V4
       && (INTVAL (operands[3]) & CALL_LONG) == 0))"
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn ("crxor 6,6,6", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn ("creqv 6,6,6", operands);

#if TARGET_MACHO
  return output_call(insn, operands, 1, 3);
#else
  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? "bl %z1@plt" : "bl %z1";
#endif     
}
  [(set_attr "type" "branch,branch")
   (set_attr "length" "4,8")])

;; Call subroutine returning any type.
(define_expand "untyped_call"
  [(parallel [(call (match_operand 0 "" "")
		    (const_int 0))
	      (match_operand 1 "" "")
	      (match_operand 2 "" "")])]
  ""
  "
{
  int i;

  emit_call_insn (GEN_CALL (operands[0], const0_rtx, const0_rtx, const0_rtx));

  for (i = 0; i < XVECLEN (operands[2], 0); i++)
    {
      rtx set = XVECEXP (operands[2], 0, i);
      emit_move_insn (SET_DEST (set), SET_SRC (set));
    }

  /* The optimizer does not know that the call sets the function value
     registers we stored in the result block.  We avoid problems by
     claiming that all hard registers are used and clobbered at this
     point.  */
  emit_insn (gen_blockage ());

  DONE;
}")

;; sibling call patterns
(define_expand "sibcall"
  [(parallel [(call (mem:SI (match_operand 0 "address_operand" ""))
		    (match_operand 1 "" ""))
	      (use (match_operand 2 "" ""))
	      (use (match_operand 3 "" ""))
	      (return)])]
  ""
  "
{
#if TARGET_MACHO
  if (MACHOPIC_INDIRECT)
    operands[0] = machopic_indirect_call_target (operands[0]);
#endif

  if (GET_CODE (operands[0]) != MEM || GET_CODE (operands[1]) != CONST_INT)
    abort ();

  operands[0] = XEXP (operands[0], 0);
  operands[3] = gen_reg_rtx (SImode);

}")

;; this and similar patterns must be marked as using LR, otherwise
;; dataflow will try to delete the store into it.  This is true
;; even when the actual reg to jump to is in CTR, when LR was
;; saved and restored around the PIC-setting BCL.
(define_insn "*sibcall_local32"
  [(call (mem:SI (match_operand:SI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (use (match_operand:SI 3 "register_operand" "l,l"))
   (return)]
  "(INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z0@local\" : \"b %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*sibcall_local64"
  [(call (mem:SI (match_operand:DI 0 "current_file_function_operand" "s,s"))
	 (match_operand 1 "" "g,g"))
   (use (match_operand:SI 2 "immediate_operand" "O,n"))
   (use (match_operand:SI 3 "register_operand" "l,l"))
   (return)]
  "TARGET_64BIT && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z0@local\" : \"b %z0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*sibcall_value_local32"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (use (match_operand:SI 4 "register_operand" "l,l"))
   (return)]
  "(INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z1@local\" : \"b %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])


(define_insn "*sibcall_value_local64"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:DI 1 "current_file_function_operand" "s,s"))
	      (match_operand 2 "" "g,g")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (use (match_operand:SI 4 "register_operand" "l,l"))
   (return)]
  "TARGET_64BIT && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[3]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[3]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z1@local\" : \"b %z1\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4,8")])

(define_insn "*sibcall_nonlocal_aix32"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" "s"))
	 (match_operand 1 "" "g"))
   (use (match_operand:SI 2 "immediate_operand" "O"))
   (use (match_operand:SI 3 "register_operand" "l"))
   (return)]
  "TARGET_32BIT
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "b %z0"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "*sibcall_nonlocal_aix64"
  [(call (mem:SI (match_operand:DI 0 "symbol_ref_operand" "s"))
	 (match_operand 1 "" "g"))
   (use (match_operand:SI 2 "immediate_operand" "O"))
   (use (match_operand:SI 3 "register_operand" "l"))
   (return)]
  "TARGET_64BIT 
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "b %z0"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "*sibcall_value_nonlocal_aix32"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "symbol_ref_operand" "s"))
	      (match_operand 2 "" "g")))
   (use (match_operand:SI 3 "immediate_operand" "O"))
   (use (match_operand:SI 4 "register_operand" "l"))
   (return)]
  "TARGET_32BIT
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "b %z1"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "*sibcall_value_nonlocal_aix64"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:DI 1 "symbol_ref_operand" "s"))
	      (match_operand 2 "" "g")))
   (use (match_operand:SI 3 "immediate_operand" "O"))
   (use (match_operand:SI 4 "register_operand" "l"))
   (return)]
  "TARGET_64BIT 
   && DEFAULT_ABI == ABI_AIX
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "b %z1"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "*sibcall_nonlocal_sysv"
  [(call (mem:SI (match_operand:SI 0 "symbol_ref_operand" "s,s"))
	 (match_operand 1 "" ""))
   (use (match_operand 2 "immediate_operand" "O,n"))
   (use (match_operand:SI 3 "register_operand" "l,l"))
   (return)]
  "(DEFAULT_ABI == ABI_DARWIN
     || DEFAULT_ABI == ABI_V4)
   && (INTVAL (operands[2]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z0@plt\" : \"b %z0\";
}"
  [(set_attr "type" "branch,branch")
   (set_attr "length" "4,8")])

(define_expand "sibcall_value"
  [(parallel [(set (match_operand 0 "register_operand" "")
		(call (mem:SI (match_operand 1 "address_operand" ""))
		      (match_operand 2 "" "")))
	      (use (match_operand 3 "" ""))
	      (use (match_operand 4 "" ""))
	      (return)])]
  ""
  "
{
#if TARGET_MACHO
  if (MACHOPIC_INDIRECT)
    operands[1] = machopic_indirect_call_target (operands[1]);
#endif

  if (GET_CODE (operands[1]) != MEM || GET_CODE (operands[2]) != CONST_INT)
    abort ();

  operands[1] = XEXP (operands[1], 0);
  operands[4] = gen_reg_rtx (SImode);

}")

(define_insn "*sibcall_value_nonlocal_sysv"
  [(set (match_operand 0 "" "")
	(call (mem:SI (match_operand:SI 1 "symbol_ref_operand" "s,s"))
	      (match_operand 2 "" "")))
   (use (match_operand:SI 3 "immediate_operand" "O,n"))
   (use (match_operand:SI 4 "register_operand" "l,l"))
   (return)]
  "(DEFAULT_ABI == ABI_DARWIN
       || DEFAULT_ABI == ABI_V4)
   && (INTVAL (operands[3]) & CALL_LONG) == 0"
  "*
{
  if (INTVAL (operands[2]) & CALL_V4_SET_FP_ARGS)
    output_asm_insn (\"crxor 6,6,6\", operands);

  else if (INTVAL (operands[2]) & CALL_V4_CLEAR_FP_ARGS)
    output_asm_insn (\"creqv 6,6,6\", operands);

  return (DEFAULT_ABI == ABI_V4 && flag_pic) ? \"b %z1@plt\" : \"b %z1\";
}"
  [(set_attr "type" "branch,branch")
   (set_attr "length" "4,8")])

(define_expand "sibcall_epilogue"
  [(use (const_int 0))]
  "TARGET_SCHED_PROLOG"
  "
{
      rs6000_emit_epilogue (TRUE);
      DONE;
}")

;; UNSPEC_VOLATILE is considered to use and clobber all hard registers and
;; all of memory.  This blocks insns from being moved across this point.

(define_insn "blockage"
  [(unspec_volatile [(const_int 0)] UNSPECV_BLOCK)]
  ""
  "")

;; Compare insns are next.  Note that the RS/6000 has two types of compares,
;; signed & unsigned, and one type of branch.
;;
;; Start with the DEFINE_EXPANDs to generate the rtl for compares, scc
;; insns, and branches.  We store the operands of compares until we see
;; how it is used.
(define_expand "cmpsi"
  [(set (cc0)
        (compare (match_operand:SI 0 "gpc_reg_operand" "")
  		 (match_operand:SI 1 "reg_or_short_operand" "")))]
  ""
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (SImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpdi"
  [(set (cc0)
        (compare (match_operand:DI 0 "gpc_reg_operand" "")
  		 (match_operand:DI 1 "reg_or_short_operand" "")))]
  "TARGET_POWERPC64"
  "
{
  /* Take care of the possibility that operands[1] might be negative but
     this might be a logical operation.  That insn doesn't exist.  */
  if (GET_CODE (operands[1]) == CONST_INT
      && INTVAL (operands[1]) < 0)
    operands[1] = force_reg (DImode, operands[1]);

  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 0;
  DONE;
}")

(define_expand "cmpsf"
  [(set (cc0) (compare (match_operand:SF 0 "gpc_reg_operand" "")
		       (match_operand:SF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "cmpdf"
  [(set (cc0) (compare (match_operand:DF 0 "gpc_reg_operand" "")
		       (match_operand:DF 1 "gpc_reg_operand" "")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "cmptf"
  [(set (cc0) (compare (match_operand:TF 0 "gpc_reg_operand" "")
		       (match_operand:TF 1 "gpc_reg_operand" "")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN)
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "
{
  rs6000_compare_op0 = operands[0];
  rs6000_compare_op1 = operands[1];
  rs6000_compare_fp_p = 1;
  DONE;
}")

(define_expand "beq"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (EQ, operands[0]); DONE; }")

(define_expand "bne"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (NE, operands[0]); DONE; }")

(define_expand "bge"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (GE, operands[0]); DONE; }")

(define_expand "bgt"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (GT, operands[0]); DONE; }")

(define_expand "ble"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (LE, operands[0]); DONE; }")

(define_expand "blt"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (LT, operands[0]); DONE; }")

(define_expand "bgeu"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (GEU, operands[0]); DONE; }")

(define_expand "bgtu"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (GTU, operands[0]); DONE; }")

(define_expand "bleu"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (LEU, operands[0]); DONE; }")

(define_expand "bltu"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (LTU, operands[0]); DONE; }")

(define_expand "bunordered"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNORDERED, operands[0]); DONE; }")

(define_expand "bordered"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (ORDERED, operands[0]); DONE; }")

(define_expand "buneq"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNEQ, operands[0]); DONE; }")

(define_expand "bunge"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNGE, operands[0]); DONE; }")

(define_expand "bungt"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNGT, operands[0]); DONE; }")

(define_expand "bunle"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNLE, operands[0]); DONE; }")

(define_expand "bunlt"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (UNLT, operands[0]); DONE; }")

(define_expand "bltgt"
  [(use (match_operand 0 "" ""))]
  ""
  "{ rs6000_emit_cbranch (LTGT, operands[0]); DONE; }")

;; For SNE, we would prefer that the xor/abs sequence be used for integers.
;; For SEQ, likewise, except that comparisons with zero should be done
;; with an scc insns.  However, due to the order that combine see the
;; resulting insns, we must, in fact, allow SEQ for integers.  Fail in
;; the cases we don't want to handle.
(define_expand "seq"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (EQ, operands[0]); DONE; }")

(define_expand "sne"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "
{ 
  if (! rs6000_compare_fp_p)
    FAIL;

  rs6000_emit_sCOND (NE, operands[0]); 
  DONE;
}")

;; A >= 0 is best done the portable way for A an integer.
(define_expand "sge"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "
{
  if (! rs6000_compare_fp_p
      && (! TARGET_POWER || rs6000_compare_op1 == const0_rtx))
    FAIL;

  rs6000_emit_sCOND (GE, operands[0]);
  DONE;
}")

;; A > 0 is best done using the portable sequence, so fail in that case.
(define_expand "sgt"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "
{
  if (! rs6000_compare_fp_p
      && (! TARGET_POWER || rs6000_compare_op1 == const0_rtx))
    FAIL;

  rs6000_emit_sCOND (GT, operands[0]); 
  DONE;
}")

;; A <= 0 is best done the portable way for A an integer.
(define_expand "sle"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "
{
  if (! rs6000_compare_fp_p
      && (! TARGET_POWER || rs6000_compare_op1 == const0_rtx))
    FAIL;

  rs6000_emit_sCOND (LE, operands[0]); 
  DONE;
}")

;; A < 0 is best done in the portable way for A an integer.
(define_expand "slt"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "
{
  if (! rs6000_compare_fp_p 
      && (! TARGET_POWER || rs6000_compare_op1 == const0_rtx))
    FAIL;

  rs6000_emit_sCOND (LT, operands[0]); 
  DONE;
}")

(define_expand "sgeu"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (GEU, operands[0]); DONE; }")

(define_expand "sgtu"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (GTU, operands[0]); DONE; }")

(define_expand "sleu"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (LEU, operands[0]); DONE; }")

(define_expand "sltu"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (LTU, operands[0]); DONE; }")

(define_expand "sunordered"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNORDERED, operands[0]); DONE; }")

(define_expand "sordered"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (ORDERED, operands[0]); DONE; }")

(define_expand "suneq"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNEQ, operands[0]); DONE; }")

(define_expand "sunge"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNGE, operands[0]); DONE; }")

(define_expand "sungt"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNGT, operands[0]); DONE; }")

(define_expand "sunle"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNLE, operands[0]); DONE; }")

(define_expand "sunlt"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (UNLT, operands[0]); DONE; }")

(define_expand "sltgt"
  [(clobber (match_operand:SI 0 "gpc_reg_operand" ""))]
  ""
  "{ rs6000_emit_sCOND (LTGT, operands[0]); DONE; }")


;; Here are the actual compare insns.
(define_insn "*cmpsi_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  ""
  "{cmp%I2|cmpw%I2} %0,%1,%2"
  [(set_attr "type" "cmp")])

(define_insn "*cmpdi_internal1"
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
	(compare:CC (match_operand:DI 1 "gpc_reg_operand" "r")
		    (match_operand:DI 2 "reg_or_short_operand" "rI")))]
  "TARGET_POWERPC64"
  "cmpd%I2 %0,%1,%2"
  [(set_attr "type" "cmp")])

;; If we are comparing a register for equality with a large constant,
;; we can do this with an XOR followed by a compare.  But we need a scratch
;; register for the result of the XOR.

(define_split
  [(set (match_operand:CC 0 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "non_short_cint_operand" "")))
   (clobber (match_operand:SI 3 "gpc_reg_operand" ""))]
  "find_single_use (operands[0], insn, 0)
   && (GET_CODE (*find_single_use (operands[0], insn, 0)) == EQ
       || GET_CODE (*find_single_use (operands[0], insn, 0)) == NE)"
  [(set (match_dup 3) (xor:SI (match_dup 1) (match_dup 4)))
   (set (match_dup 0) (compare:CC (match_dup 3) (match_dup 5)))]
  "
{
  /* Get the constant we are comparing against, C,  and see what it looks like
     sign-extended to 16 bits.  Then see what constant could be XOR'ed
     with C to get the sign-extended value.  */

  HOST_WIDE_INT c = INTVAL (operands[2]);
  HOST_WIDE_INT sextc = ((c & 0xffff) ^ 0x8000) - 0x8000;
  HOST_WIDE_INT xorv = c ^ sextc;

  operands[4] = GEN_INT (xorv);
  operands[5] = GEN_INT (sextc);
}")

(define_insn "*cmpsi_internal2"
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_u_short_operand" "rK")))]
  ""
  "{cmpl%I2|cmplw%I2} %0,%1,%b2"
  [(set_attr "type" "cmp")])

(define_insn "*cmpdi_internal2"
  [(set (match_operand:CCUNS 0 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:DI 1 "gpc_reg_operand" "r")
		       (match_operand:DI 2 "reg_or_u_short_operand" "rK")))]
  ""
  "cmpld%I2 %0,%1,%b2"
  [(set_attr "type" "cmp")])

;; The following two insns don't exist as single insns, but if we provide
;; them, we can swap an add and compare, which will enable us to overlap more
;; of the required delay between a compare and branch.  We generate code for
;; them by splitting.

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=y")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand:SI 2 "short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "=y")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "u_short_cint_operand" "i")))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "i")))]
  ""
  "#"
  [(set_attr "length" "8")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_operand" "")
	(compare:CC (match_operand:SI 1 "gpc_reg_operand" "")
		    (match_operand:SI 2 "short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CC (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_split
  [(set (match_operand:CCUNS 3 "cc_reg_operand" "")
	(compare:CCUNS (match_operand:SI 1 "gpc_reg_operand" "")
		       (match_operand:SI 2 "u_short_cint_operand" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1) (match_operand:SI 4 "short_cint_operand" "")))]
  ""
  [(set (match_dup 3) (compare:CCUNS (match_dup 1) (match_dup 2)))
   (set (match_dup 0) (plus:SI (match_dup 1) (match_dup 4)))])

(define_insn "*cmpsf_internal1"
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:SF 1 "gpc_reg_operand" "f")
		      (match_operand:SF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

(define_insn "*cmpdf_internal1"
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:DF 1 "gpc_reg_operand" "f")
		      (match_operand:DF 2 "gpc_reg_operand" "f")))]
  "TARGET_HARD_FLOAT && TARGET_FPRS"
  "fcmpu %0,%1,%2"
  [(set_attr "type" "fpcompare")])

;; Only need to compare second words if first words equal
(define_insn "*cmptf_internal1"
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:TF 1 "gpc_reg_operand" "f")
		      (match_operand:TF 2 "gpc_reg_operand" "f")))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN) && !TARGET_XL_COMPAT
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "fcmpu %0,%1,%2\;bne %0,$+8\;fcmpu %0,%L1,%L2"
  [(set_attr "type" "fpcompare")
   (set_attr "length" "12")])

(define_insn_and_split "*cmptf_internal2"
  [(set (match_operand:CCFP 0 "cc_reg_operand" "=y")
	(compare:CCFP (match_operand:TF 1 "gpc_reg_operand" "f")
		      (match_operand:TF 2 "gpc_reg_operand" "f")))
    (clobber (match_scratch:DF 3 "=f"))
    (clobber (match_scratch:DF 4 "=f"))
    (clobber (match_scratch:DF 5 "=f"))
    (clobber (match_scratch:DF 6 "=f"))
    (clobber (match_scratch:DF 7 "=f"))
    (clobber (match_scratch:DF 8 "=f"))
    (clobber (match_scratch:DF 9 "=f"))
    (clobber (match_scratch:DF 10 "=f"))]
  "(DEFAULT_ABI == ABI_AIX || DEFAULT_ABI == ABI_DARWIN) && TARGET_XL_COMPAT
   && TARGET_HARD_FLOAT && TARGET_FPRS && TARGET_LONG_DOUBLE_128"
  "#"
  "&& reload_completed"
  [(set (match_dup 3) (match_dup 13))
   (set (match_dup 4) (match_dup 14))
   (set (match_dup 9) (abs:DF (match_dup 5)))
   (set (match_dup 0) (compare:CCFP (match_dup 9) (match_dup 3)))
   (set (pc) (if_then_else (ne (match_dup 0) (const_int 0))
			   (label_ref (match_dup 11))
			   (pc)))
   (set (match_dup 0) (compare:CCFP (match_dup 5) (match_dup 7)))
   (set (pc) (label_ref (match_dup 12)))
   (match_dup 11)
   (set (match_dup 10) (minus:DF (match_dup 5) (match_dup 7)))
   (set (match_dup 9) (minus:DF (match_dup 6) (match_dup 8)))
   (set (match_dup 9) (plus:DF (match_dup 10) (match_dup 9)))
   (set (match_dup 0) (compare:CCFP (match_dup 7) (match_dup 4)))
   (match_dup 12)]
{
  REAL_VALUE_TYPE rv;
  const int lo_word = FLOAT_WORDS_BIG_ENDIAN ? GET_MODE_SIZE (DFmode) : 0;
  const int hi_word = FLOAT_WORDS_BIG_ENDIAN ? 0 : GET_MODE_SIZE (DFmode);

  operands[5] = simplify_gen_subreg (DFmode, operands[1], TFmode, hi_word);
  operands[6] = simplify_gen_subreg (DFmode, operands[1], TFmode, lo_word);
  operands[7] = simplify_gen_subreg (DFmode, operands[2], TFmode, hi_word);
  operands[8] = simplify_gen_subreg (DFmode, operands[2], TFmode, lo_word);
  operands[11] = gen_label_rtx ();
  operands[12] = gen_label_rtx ();
  real_inf (&rv);
  operands[13] = force_const_mem (DFmode,
				  CONST_DOUBLE_FROM_REAL_VALUE (rv, DFmode));
  operands[14] = force_const_mem (DFmode,
				  CONST_DOUBLE_FROM_REAL_VALUE (dconst0,
								DFmode));
  if (TARGET_TOC)
    {
      operands[13] = gen_rtx_MEM (DFmode,
				  create_TOC_reference (XEXP (operands[13], 0)));
      operands[14] = gen_rtx_MEM (DFmode,
				  create_TOC_reference (XEXP (operands[14], 0)));
      set_mem_alias_set (operands[13], get_TOC_alias_set ());
      set_mem_alias_set (operands[14], get_TOC_alias_set ());
      RTX_UNCHANGING_P (operands[13]) = 1;
      RTX_UNCHANGING_P (operands[14]) = 1;
    }
})

;; Now we have the scc insns.  We can do some combinations because of the
;; way the machine works.
;;
;; Note that this is probably faster if we can put an insn between the
;; mfcr and rlinm, but this is tricky.  Let's leave it for now.  In most
;; cases the insns below which don't use an intermediate CR field will
;; be used instead.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))]
  ""
  "mfcr %0%Q2\;{rlinm|rlwinm} %0,%0,%J1,1"
  [(set (attr "type")
     (cond [(ne (symbol_ref "TARGET_MFCRF") (const_int 0))
		(const_string "mfcrf")
	   ]
	(const_string "mfcr")))
   (set_attr "length" "12")])

;; Same as above, but get the EQ bit.
(define_insn "move_from_CR_eq_bit"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
       (unspec:SI [(match_operand 1 "cc_reg_operand" "y")] UNSPEC_MV_CR_EQ))]
  "TARGET_E500"
  "mfcr %0\;{rlinm|rlwinm} %0,%0,%D1,1"
  [(set_attr "type" "mfcr")
   (set_attr "length" "12")])

;; Same as above, but get the OV/ORDERED bit.
(define_insn "move_from_CR_ov_bit"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(unspec:SI [(match_operand 1 "cc_reg_operand" "y")] UNSPEC_MV_CR_OV))]
  "TARGET_ISEL"
  "mfcr %0\;{rlinm|rlwinm} %0,%0,%t1,1"
  [(set_attr "type" "mfcr")
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operator:DI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))]
  "TARGET_POWERPC64"
  "mfcr %0%Q2\;{rlinm|rlwinm} %0,%0,%J1,1"
  [(set (attr "type")
     (cond [(ne (symbol_ref "TARGET_MFCRF") (const_int 0))
		(const_string "mfcrf")
	   ]
	(const_string "mfcr")))
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y,y")
					(const_int 0)])
		    (const_int 0)))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r,r")
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))]
  "TARGET_32BIT"
  "@
   mfcr %3%Q2\;{rlinm.|rlwinm.} %3,%3,%J1,1
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "")
					(const_int 0)])
		    (const_int 0)))
   (set (match_operand:SI 3 "gpc_reg_operand" "")
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(match_op_dup 1 [(match_dup 2) (const_int 0)]))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				      [(match_operand 2 "cc_reg_operand" "y")
				       (const_int 0)])
		   (match_operand:SI 3 "const_int_operand" "n")))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[4] = GEN_INT (count);
  operands[5] = GEN_INT (put_bit);

  return \"mfcr %0%Q2\;{rlinm|rlwinm} %0,%0,%4,%5,%5\";
}"
  [(set (attr "type")
     (cond [(ne (symbol_ref "TARGET_MFCRF") (const_int 0))
		(const_string "mfcrf")
	   ]
	(const_string "mfcr")))
   (set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "y,y")
					(const_int 0)])
		    (match_operand:SI 3 "const_int_operand" "n,n"))
	 (const_int 0)))
   (set (match_operand:SI 4 "gpc_reg_operand" "=r,r")
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))]
  ""
  "*
{
  int is_bit = ccr_bit (operands[1], 1);
  int put_bit = 31 - (INTVAL (operands[3]) & 31);
  int count;

  /* Force split for non-cc0 compare.  */
  if (which_alternative == 1)
     return \"#\";

  if (is_bit >= put_bit)
    count = is_bit - put_bit;
  else
    count = 32 - (put_bit - is_bit);

  operands[5] = GEN_INT (count);
  operands[6] = GEN_INT (put_bit);

  return \"mfcr %4%Q2\;{rlinm.|rlwinm.} %4,%4,%5,%6,%6\";
}"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ashift:SI (match_operator:SI 1 "scc_comparison_operator"
				       [(match_operand 2 "cc_reg_operand" "")
					(const_int 0)])
		    (match_operand:SI 3 "const_int_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 4 "gpc_reg_operand" "")
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))]
  "reload_completed"
  [(set (match_dup 4)
	(ashift:SI (match_op_dup 1 [(match_dup 2) (const_int 0)])
		   (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

;; There is a 3 cycle delay between consecutive mfcr instructions
;; so it is useful to combine 2 scc instructions to use only one mfcr.

(define_peephole
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(match_operator:SI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))
   (set (match_operand:SI 3 "gpc_reg_operand" "=r")
	(match_operator:SI 4 "scc_comparison_operator"
			   [(match_operand 5 "cc_reg_operand" "y")
			    (const_int 0)]))]
  "REGNO (operands[2]) != REGNO (operands[5])"
  "mfcr %3\;{rlinm|rlwinm} %0,%3,%J1,1\;{rlinm|rlwinm} %3,%3,%J4,1"
  [(set_attr "type" "mfcr")
   (set_attr "length" "20")])

(define_peephole
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(match_operator:DI 1 "scc_comparison_operator"
			   [(match_operand 2 "cc_reg_operand" "y")
			    (const_int 0)]))
   (set (match_operand:DI 3 "gpc_reg_operand" "=r")
	(match_operator:DI 4 "scc_comparison_operator"
			   [(match_operand 5 "cc_reg_operand" "y")
			    (const_int 0)]))]
  "TARGET_POWERPC64 && REGNO (operands[2]) != REGNO (operands[5])"
  "mfcr %3\;{rlinm|rlwinm} %0,%3,%J1,1\;{rlinm|rlwinm} %3,%3,%J4,1"
  [(set_attr "type" "mfcr")
   (set_attr "length" "20")])

;; There are some scc insns that can be done directly, without a compare.
;; These are faster because they don't involve the communications between
;; the FXU and branch units.   In fact, we will be replacing all of the
;; integer scc insns here or in the portable methods in emit_store_flag.
;;
;; Also support (neg (scc ..)) since that construct is used to replace
;; branches, (plus (scc ..) ..) since that construct is common and
;; takes no more insns than scc, and (and (neg (scc ..)) ..) in the
;; cases where it is no more expensive than (neg (scc ..)).

;; Have reload force a constant into a register for the simple insns that
;; otherwise won't accept constants.  We do this because it is faster than
;; the cmp/mfcr sequence we would otherwise generate.

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I")))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r"))]
  "TARGET_32BIT"
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae|adde} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae|adde} %0,%3,%0"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(eq:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r")
	       (match_operand:DI 2 "reg_or_cint_operand" "r,O,K,J,I")))
   (clobber (match_scratch:DI 3 "=r,&r,r,r,r"))]
  "TARGET_64BIT"
  "@
   xor %0,%1,%2\;subfic %3,%0,0\;adde %0,%3,%0
   subfic %3,%1,0\;adde %0,%3,%1
   xori %0,%1,%b2\;subfic %3,%0,0\;adde %0,%3,%0
   xoris %0,%1,%u2\;subfic %3,%0,0\;adde %0,%3,%0
   subfic %0,%1,%2\;subfic %3,%0,0\;adde %0,%3,%0"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x,?y,?y,?y,?y,?y")
	(compare:CC
	 (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
		(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I,r,O,K,L,I"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r,r,r,r,r,r")
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,&r,r,r,r,r,&r,r,r,r"))]
  "TARGET_32BIT"
  "@
   xor %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %3,%1,0\;{ae.|adde.} %0,%3,%1
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %3,%0,0\;{ae.|adde.} %0,%3,%0
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12,16,12,16,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (eq:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_cint_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(parallel [(set (match_dup 0)
	(eq:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x,?y,?y,?y,?y,?y")
	(compare:CC
	 (eq:DI (match_operand:DI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
		(match_operand:DI 2 "reg_or_cint_operand" "r,O,K,J,I,r,O,K,J,I"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r,r,r,r,r,r,r")
	(eq:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:DI 3 "=r,&r,r,r,r,r,&r,r,r,r"))]
  "TARGET_64BIT"
  "@
   xor %0,%1,%2\;subfic %3,%0,0\;adde. %0,%3,%0
   subfic %3,%1,0\;adde. %0,%3,%1
   xori %0,%1,%b2\;subfic %3,%0,0\;adde. %0,%3,%0
   xoris %0,%1,%u2\;subfic %3,%0,0\;adde. %0,%3,%0
   subfic %0,%1,%2\;subfic %3,%0,0\;adde. %0,%3,%0
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12,16,12,16,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (eq:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(match_operand:DI 2 "reg_or_cint_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(eq:DI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_64BIT && reload_completed"
  [(parallel [(set (match_dup 0)
	(eq:DI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

;; We have insns of the form shown by the first define_insn below.  If
;; there is something inside the comparison operation, we must split it.
(define_split
  [(set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_operator 1 "comparison_operator"
				 [(match_operand:SI 2 "" "")
				  (match_operand:SI 3
						    "reg_or_cint_operand" "")])
		 (match_operand:SI 4 "gpc_reg_operand" "")))
   (clobber (match_operand:SI 5 "register_operand" ""))]
  "! gpc_reg_operand (operands[2], SImode)"
  [(set (match_dup 5) (match_dup 2))
   (set (match_dup 2) (plus:SI (match_op_dup 1 [(match_dup 2) (match_dup 3)])
			       (match_dup 4)))])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r,&r")
	(plus:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
			(match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r")))]
  "TARGET_32BIT"
  "@
   xor %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3
   {sfi|subfic} %0,%1,0\;{aze|addze} %0,%3
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12,8,12,12,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,x,x,x,?y,?y,?y,?y,?y")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I,r,O,K,L,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r,r,r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r,&r,&r,&r,&r,&r,&r"))]
  "TARGET_32BIT"
  "@
   xor %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,0\;{aze.|addze.} %4,%3
   {xoril|xori} %4,%1,%b2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {xoriu|xoris} %4,%1,%u2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {sfi|subfic} %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12,16,12,16,16,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_cint_operand" ""))
	  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(plus:SI (eq:SI (match_dup 1)
		 (match_dup 2))
	  (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,x,x,x,?y,?y,?y,?y,?y")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r,r,r,r,r,r")
		 (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I,r,O,K,L,I"))
	  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r,r,r,r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r,&r,&r,&r,&r,&r,&r")
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   xor %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %0,%1,0\;{aze.|addze.} %0,%3
   {xoril|xori} %0,%1,%b2\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   {xoriu|xoris} %0,%1,%u2\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   {sfi|subfic} %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   #
   #
   #
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,8,12,12,12,16,12,16,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI
	  (eq:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_cint_operand" ""))
	  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (eq:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r,r")
	(neg:SI (eq:SI (match_operand:SI 1 "gpc_reg_operand" "%r,r,r,r,r")
		       (match_operand:SI 2 "reg_or_cint_operand" "r,O,K,L,I"))))]
  "TARGET_32BIT"
  "@
   xor %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{sfe|subfe} %0,%0,%0
   {xoril|xori} %0,%1,%b2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {xoriu|xoris} %0,%1,%u2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {sfi|subfic} %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
   [(set_attr "length" "12,8,12,12,12")])

;; Simplify (ne X (const_int 0)) on the PowerPC.  No need to on the Power,
;; since it nabs/sr is just as fast.
(define_insn "*ne0"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(lshiftrt:SI (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		     (const_int 31)))
   (clobber (match_scratch:SI 2 "=&r"))]
  "! TARGET_POWER && TARGET_32BIT && !TARGET_ISEL"
  "{ai|addic} %2,%1,-1\;{sfe|subfe} %0,%2,%1"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(lshiftrt:DI (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		     (const_int 63)))
   (clobber (match_scratch:DI 2 "=&r"))]
  "TARGET_64BIT"
  "addic %2,%1,-1\;subfe %0,%2,%1"
  [(set_attr "length" "8")])

;; This is what (plus (ne X (const_int 0)) Y) looks like.
(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(plus:SI (lshiftrt:SI
		  (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r")))
		  (const_int 31))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:SI 3 "=&r"))]
  "TARGET_32BIT"
  "{ai|addic} %3,%1,-1\;{aze|addze} %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(plus:DI (lshiftrt:DI
		  (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r")))
		  (const_int 63))
		 (match_operand:DI 2 "gpc_reg_operand" "r")))
   (clobber (match_scratch:DI 3 "=&r"))]
  "TARGET_64BIT"
  "addic %3,%1,-1\;addze %0,%2"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r,&r"))
   (clobber (match_scratch:SI 4 "=X,&r"))]
  "TARGET_32BIT"
  "@
   {ai|addic} %3,%1,-1\;{aze.|addze.} %3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(parallel [(set (match_dup 3)
		   (plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1)))
					 (const_int 31))
			    (match_dup 2)))
              (clobber (match_dup 4))])
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=&r,&r"))]
  "TARGET_64BIT"
  "@
   addic %3,%1,-1\;addze. %3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 3)
	(plus:DI (lshiftrt:DI (neg:DI (abs:DI (match_dup 1)))
		   (const_int 63))
		  (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_scratch:SI 3 "=&r,&r"))]
  "TARGET_32BIT"
  "@
   {ai|addic} %3,%1,-1\;{aze.|addze.} %0,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (lshiftrt:SI
		   (neg:SI (abs:SI (match_operand:SI 1 "gpc_reg_operand" "")))
		   (const_int 31))
		  (match_operand:SI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(parallel [(set (match_dup 0)
	(plus:SI (lshiftrt:SI (neg:SI (abs:SI (match_dup 1))) (const_int 31))
		 (match_dup 2)))
   (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(plus:DI (lshiftrt:DI (neg:DI (abs:DI (match_dup 1))) (const_int 63))
		 (match_dup 2)))
   (clobber (match_scratch:DI 3 "=&r,&r"))]
  "TARGET_64BIT"
  "@
   addic %3,%1,-1\;addze. %0,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (lshiftrt:DI
		   (neg:DI (abs:DI (match_operand:DI 1 "gpc_reg_operand" "")))
		   (const_int 63))
		  (match_operand:DI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (lshiftrt:DI (neg:DI (abs:DI (match_dup 1))) (const_int 63))
		 (match_dup 2)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_64BIT && reload_completed"
  [(parallel [(set (match_dup 0)
	(plus:DI (lshiftrt:DI (neg:DI (abs:DI (match_dup 1))) (const_int 63))
		 (match_dup 2)))
   (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
	       (match_operand:SI 2 "reg_or_short_operand" "r,O")))
   (clobber (match_scratch:SI 3 "=r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
		(match_operand:SI 2 "reg_or_short_operand" "r,O,r,O"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,X,r,X"))]
  "TARGET_POWER"
  "@
   doz %3,%2,%1\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{sri.|srwi.} %0,%0,31
   #
   #"
  [(set_attr "type" "compare,delayed_compare,compare,delayed_compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (le:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
	(le:SI (match_dup 1) (match_dup 2)))
   (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,O"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3
   {srai|srawi} %0,%1,31\;{sf|subfc} %0,%1,%0\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O,r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   {srai|srawi} %4,%1,31\;{sf|subfc} %4,%1,%4\;{aze.|addze.} %4,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 4)
	(plus:SI (le:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,O,r,O"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   {srai|srawi} %0,%1,31\;{sf|subfc} %0,%1,%0\;{aze.|addze.} %0,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(plus:SI (le:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (le:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		       (match_operand:SI 2 "reg_or_short_operand" "r,O"))))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,-1\;{aze|addze} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(leu:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		(match_operand:DI 2 "reg_or_short_operand" "rI")))]
  "TARGET_64BIT"
  "subf%I2c %0,%1,%2\;li %0,0\;adde %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (leu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		 (match_operand:DI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(leu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   subf%I2c %0,%1,%2\;li %0,0\;adde. %0,%0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (leu:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(leu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(leu:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(leu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %0,%1,%2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(leu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(leu:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %4,%1,%2\;{aze.|addze.} %4,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(plus:SI (leu:SI (match_dup 1) (match_dup 2))
		  (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %0,%1,%2\;{aze.|addze.} %0,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (leu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(and:SI (neg:SI
		 (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI")))
		(match_operand:SI 3 "gpc_reg_operand" "r")))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;andc %0,%3,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI,rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" "")))
		 (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2)))
		(match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "rI,rI")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;andc. %0,%3,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (neg:SI
		  (leu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" "")))
		 (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(and:SI (neg:SI (leu:SI (match_dup 1) (match_dup 2)))
		(match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{sri|srwi} %0,%0,31"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(lt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "@
   doz%I2 %0,%1,%2\;nabs %0,%0\;{sri.|srwi.} %0,%0,31
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (lt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(lt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(lt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;{ai|addic} %0,%0,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz%I2 %4,%1,%2\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 4)
	(plus:SI (lt:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER"
  "@
   doz%I2 %0,%1,%2\;{ai|addic} %0,%0,-1\;{aze.|addze.} %0,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(plus:SI (lt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (lt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(ltu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;neg. %0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_neg_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ltu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(ltu:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		 (match_operand:SI 3 "reg_or_short_operand" "rI,rI")))]
  "TARGET_32BIT"
  "@
  {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;{sf%I3|subf%I3c} %0,%0,%3
  {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;{sf%I3|subf%I3c} %0,%0,%3"
 [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r"))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;{sf.|subfc.} %0,%0,%3
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;{sf.|subfc.} %0,%0,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (ltu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (ltu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "rI")))
   (clobber (match_scratch:SI 3 "=r"))]
  "TARGET_POWER"
  "doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae|adde} %0,%0,%3"
   [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(ge:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 "=r,r"))]
  "TARGET_POWER"
  "@
   doz%I2 %3,%1,%2\;{sfi|subfic} %0,%3,0\;{ae.|adde.} %0,%0,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (ge:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(ge:SI (match_dup 1) (match_dup 2)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_POWER && reload_completed"
  [(parallel [(set (match_dup 0)
		   (ge:SI (match_dup 1) (match_dup 2)))
	      (clobber (match_dup 3))])
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz%I2 %4,%1,%2\;{sfi|subfic} %4,%4,0\;{aze.|addze.} %4,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 4)
	(plus:SI (ge:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER"
  "@
   doz%I2 %0,%1,%2\;{sfi|subfic} %0,%0,0\;{aze.|addze.} %0,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(plus:SI (ge:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (ge:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_POWER"
  "doz%I2 %0,%1,%2\;{ai|addic} %0,%0,-1\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae|adde} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(geu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		(match_operand:DI 2 "reg_or_neg_short_operand" "r,P")))]
  "TARGET_64BIT"
  "@
   subfc %0,%2,%1\;li %0,0\;adde %0,%0,%0
   addic %0,%1,%n2\;li %0,0\;adde %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
		 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r,r,r")
	(geu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0
   {ai|addic} %0,%1,%n2\;{cal %0,0(0)|li %0,0}\;{ae.|adde.} %0,%0,%0
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_neg_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(geu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(geu:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (geu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,r,r")
		 (match_operand:DI 2 "reg_or_neg_short_operand" "r,P,r,P"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r,r,r")
	(geu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   subfc %0,%2,%1\;li %0,0\;adde. %0,%0,%0
   addic %0,%1,%n2\;li %0,0\;adde. %0,%0,%0
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (geu:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_neg_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(geu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(geu:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P"))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r")))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{aze|addze} %0,%3
   {ai|addic} %0,%1,%n2\;{aze|addze} %0,%3"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r"))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %4,%2,%1\;{aze.|addze.} %4,%3
   {ai|addic} %4,%1,%n2\;{aze.|addze.} %4,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,8,12,12")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(plus:SI (geu:SI (match_dup 1) (match_dup 2))
		  (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{aze.|addze.} %0,%3
   {ai|addic} %0,%1,%n2\;{aze.|addze.} %0,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,8,12,12")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (geu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(neg:SI (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			(match_operand:SI 2 "reg_or_short_operand" "r,I"))))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;nand %0,%0,%0
   {sfi|subfic} %0,%1,-1\;{a%I2|add%I2c} %0,%0,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(and:SI (neg:SI
		 (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_neg_short_operand" "r,P")))
		(match_operand:SI 3 "gpc_reg_operand" "r,r")))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;andc %0,%3,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;andc %0,%3,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r"))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %4,%2,%1\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4
   {ai|addic} %4,%1,%n2\;{sfe|subfe} %4,%4,%4\;andc. %4,%3,%4
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "")))
		 (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2)))
		(match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "r,P,r,P")))
		 (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {sf|subfc} %0,%2,%1\;{sfe|subfe} %0,%0,%0\;andc. %0,%3,%0
   {ai|addic} %0,%1,%n2\;{sfe|subfe} %0,%0,%0\;andc. %0,%3,%0
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,12,16,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (and:SI (neg:SI
		  (geu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_neg_short_operand" "")))
		 (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(and:SI (neg:SI (geu:SI (match_dup 1) (match_dup 2))) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (const_int 0)))]
  "TARGET_32BIT"
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(gt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
	       (const_int 0)))]
  "TARGET_64BIT"
  "subfic %0,%1,0\;addme %0,%0\;srdi %0,%0,63"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(gt:SI (match_dup 1) (const_int 0)))]
  "TARGET_32BIT"
  "@
   {sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{sri.|srwi.} %0,%0,31
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gt:SI (match_dup 1) (const_int 0)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(gt:SI (match_dup 1) (const_int 0)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 2 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (gt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(gt:DI (match_dup 1) (const_int 0)))]
  "TARGET_64BIT"
  "@
   subfic %0,%1,0\;addme %0,%0\;srdi. %0,%0,63
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 2 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (gt:DI (match_operand:DI 1 "gpc_reg_operand" "")
		(const_int 0))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(gt:DI (match_dup 1) (const_int 0)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(gt:DI (match_dup 1) (const_int 0)))
   (set (match_dup 2)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
	       (match_operand:SI 2 "reg_or_short_operand" "r")))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{sri|srwi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		(match_operand:SI 2 "reg_or_short_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(gt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;nabs %0,%0\;{sri.|srwi.} %0,%0,31
   #"
  [(set_attr "type" "delayed_compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
		(match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gt:SI (match_dup 1) (match_dup 2)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(gt:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(const_int 0))
		 (match_operand:SI 2 "gpc_reg_operand" "r")))]
  "TARGET_32BIT"
  "{a|addc} %0,%1,%1\;{sfe|subfe} %0,%1,%0\;{aze|addze} %0,%2"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r")
	(plus:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			(const_int 0))
		 (match_operand:DI 2 "gpc_reg_operand" "r")))]
  "TARGET_64BIT"
  "addc %0,%1,%1\;subfe %0,%1,%0\;addze %0,%2"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 "=&r,&r"))]
  "TARGET_32BIT"
  "@
   {a|addc} %3,%1,%1\;{sfe|subfe} %3,%1,%3\;{aze.|addze.} %3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 3 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 3)
	(plus:SI (gt:SI (match_dup 1) (const_int 0))
		  (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			 (const_int 0))
		  (match_operand:DI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:DI 3 "=&r,&r"))]
  "TARGET_64BIT"
  "@
   addc %3,%1,%1\;subfe %3,%1,%3\;addze. %3,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "")
			 (const_int 0))
		  (match_operand:DI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:DI 3 ""))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 3)
	(plus:DI (gt:DI (match_dup 1) (const_int 0))
		 (match_dup 2)))
   (set (match_dup 0)
	(compare:CC (match_dup 3)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {a|addc} %0,%1,%1\;{sfe|subfe} %0,%1,%0\;{aze.|addze.} %0,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (const_int 0))
		  (match_operand:SI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (gt:SI (match_dup 1) (const_int 0)) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			 (const_int 0))
		  (match_operand:DI 2 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r")
	(plus:DI (gt:DI (match_dup 1) (const_int 0)) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   addc %0,%1,%1\;subfe %0,%1,%0\;addze. %0,%2
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "")
			 (const_int 0))
		  (match_operand:DI 2 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (gt:DI (match_dup 1) (const_int 0)) (match_dup 2)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(plus:DI (gt:DI (match_dup 1) (const_int 0)) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r")
	(plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "r"))
		 (match_operand:SI 3 "gpc_reg_operand" "r")))]
  "TARGET_POWER"
  "doz %0,%2,%1\;{ai|addic} %0,%0,-1\;{aze|addze} %0,%3"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r"))]
  "TARGET_POWER"
  "@
   doz %4,%2,%1\;{ai|addic} %4,%4,-1\;{aze.|addze.} %4,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 4)
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "r,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER"
  "@
   doz %0,%2,%1\;{ai|addic} %0,%0,-1\;{aze.|addze.} %0,%3
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "")
			 (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_POWER && reload_completed"
  [(set (match_dup 0)
	(plus:SI (gt:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (const_int 0))))]
  "TARGET_32BIT"
  "{sfi|subfic} %0,%1,0\;{ame|addme} %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (gt:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		       (const_int 0))))]
  "TARGET_64BIT"
  "subfic %0,%1,0\;addme %0,%0\;sradi %0,%0,63"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gt:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		       (match_operand:SI 2 "reg_or_short_operand" "r"))))]
  "TARGET_POWER"
  "doz %0,%2,%1\;nabs %0,%0\;{srai|srawi} %0,%0,31"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
		(match_operand:SI 2 "reg_or_short_operand" "rI")))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r")
		(match_operand:DI 2 "reg_or_short_operand" "rI")))]
  "TARGET_64BIT"
  "subf%I2c %0,%1,%2\;subfe %0,%0,%0\;neg %0,%0"
  [(set_attr "length" "12")])

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
		 (match_operand:SI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=r,r")
	(gtu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT"
  "@
   {sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;neg. %0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "")
		 (match_operand:SI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(gtu:SI (match_dup 1) (match_dup 2)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(gtu:SI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 3 "cc_reg_operand" "=x,?y")
	(compare:CC
	 (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
		 (match_operand:DI 2 "reg_or_short_operand" "rI,rI"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=r,r")
	(gtu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT"
  "@
   subf%I2c %0,%1,%2\;subfe %0,%0,%0\;neg. %0,%0
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "12,16")])

(define_split
  [(set (match_operand:CC 3 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "")
		 (match_operand:DI 2 "reg_or_short_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(gtu:DI (match_dup 1) (match_dup 2)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(gtu:DI (match_dup 1) (match_dup 2)))
   (set (match_dup 3)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r")
	(plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r")
			 (match_operand:SI 2 "reg_or_short_operand" "I,rI"))
		 (match_operand:SI 3 "reg_or_short_operand" "r,rI")))]
  "TARGET_32BIT"
  "@
   {ai|addic} %0,%1,%k2\;{aze|addze} %0,%3
   {sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;{sf%I3|subf%I3c} %0,%0,%3"
  [(set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r")
	(plus:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r")
			 (match_operand:DI 2 "reg_or_short_operand" "I,rI"))
		 (match_operand:DI 3 "reg_or_short_operand" "r,rI")))]
  "TARGET_64BIT"
  "@
   addic %0,%1,%k2\;addze %0,%3
   subf%I2c %0,%1,%2\;subfe %0,%0,%0\;subf%I3c %0,%0,%3"
  [(set_attr "length" "8,12")])

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r,I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 "=&r,&r,&r,&r"))]
  "TARGET_32BIT"
  "@
   {ai|addic} %4,%1,%k2\;{aze.|addze.} %4,%3
   {sf%I2|subf%I2c} %4,%1,%2\;{sfe|subfe} %4,%4,%4\;{sf.|subfc.} %4,%4,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12,12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 4)
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2))
		 (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 0 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:DI 2 "reg_or_short_operand" "I,r,I,r"))
		  (match_operand:DI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 "=&r,&r,&r,&r"))]
  "TARGET_64BIT"
  "@
   addic %4,%1,%k2\;addze. %4,%3
   subf%I2c %4,%1,%2\;subfe %4,%4,%4\;subfc. %4,%4,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12,12,16")])

(define_split
  [(set (match_operand:CC 0 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "")
			  (match_operand:DI 2 "reg_or_short_operand" ""))
		  (match_operand:DI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 4)
	(plus:DI (gtu:DI (match_dup 1) (match_dup 2))
		  (match_dup 3)))
   (set (match_dup 0)
	(compare:CC (match_dup 4)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:SI 2 "reg_or_short_operand" "I,r,I,r"))
		  (match_operand:SI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT"
  "@
   {ai|addic} %0,%1,%k2\;{aze.|addze.} %0,%3
   {sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0\;{sf.|subfc.} %0,%0,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12,12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "")
			  (match_operand:SI 2 "reg_or_short_operand" ""))
		  (match_operand:SI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_32BIT && reload_completed"
  [(set (match_dup 0)
	(plus:SI (gtu:SI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:CC 4 "cc_reg_operand" "=x,x,?y,?y")
	(compare:CC
	 (plus:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r,r,r,r")
			  (match_operand:DI 2 "reg_or_short_operand" "I,r,I,r"))
		  (match_operand:DI 3 "gpc_reg_operand" "r,r,r,r"))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "=&r,&r,&r,&r")
	(plus:DI (gtu:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_64BIT"
  "@
   addic %0,%1,%k2\;addze. %0,%3
   subf%I2c %0,%1,%2\;subfe %0,%0,%0\;subfc. %0,%0,%3
   #
   #"
  [(set_attr "type" "compare")
   (set_attr "length" "8,12,12,16")])

(define_split
  [(set (match_operand:CC 4 "cc_reg_not_cr0_operand" "")
	(compare:CC
	 (plus:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "")
			  (match_operand:DI 2 "reg_or_short_operand" ""))
		  (match_operand:DI 3 "gpc_reg_operand" ""))
	 (const_int 0)))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (gtu:DI (match_dup 1) (match_dup 2)) (match_dup 3)))]
  "TARGET_64BIT && reload_completed"
  [(set (match_dup 0)
	(plus:DI (gtu:DI (match_dup 1) (match_dup 2)) (match_dup 3)))
   (set (match_dup 4)
	(compare:CC (match_dup 0)
		    (const_int 0)))]
  "")

(define_insn ""
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
	(neg:SI (gtu:SI (match_operand:SI 1 "gpc_reg_operand" "r")
			(match_operand:SI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_32BIT"
  "{sf%I2|subf%I2c} %0,%1,%2\;{sfe|subfe} %0,%0,%0"
  [(set_attr "length" "8")])

(define_insn ""
  [(set (match_operand:DI 0 "gpc_reg_operand" "=r")
	(neg:DI (gtu:DI (match_operand:DI 1 "gpc_reg_operand" "r")
			(match_operand:DI 2 "reg_or_short_operand" "rI"))))]
  "TARGET_64BIT"
  "subf%I2c %0,%1,%2\;subfe %0,%0,%0"
  [(set_attr "length" "8")])

;; Define both directions of branch and return.  If we need a reload
;; register, we'd rather use CR0 since it is much easier to copy a
;; register CC value to there.

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "y")
				       (const_int 0)])
		      (label_ref (match_operand 0 "" ""))
		      (pc)))]
  ""
  "*
{
  return output_cbranch (operands[1], \"%l0\", 0, insn);
}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "y")
				       (const_int 0)])
		      (return)
		      (pc)))]
  "direct_return ()"
  "*
{
  return output_cbranch (operands[0], NULL, 0, insn);
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 1 "branch_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "y")
				       (const_int 0)])
		      (pc)
		      (label_ref (match_operand 0 "" ""))))]
  ""
  "*
{
  return output_cbranch (operands[1], \"%l0\", 1, insn);
}"
  [(set_attr "type" "branch")])

(define_insn ""
  [(set (pc)
	(if_then_else (match_operator 0 "branch_comparison_operator"
				      [(match_operand 1
						      "cc_reg_operand" "y")
				       (const_int 0)])
		      (pc)
		      (return)))]
  "direct_return ()"
  "*
{
  return output_cbranch (operands[0], NULL, 1, insn);
}"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

;; Logic on condition register values.

; This pattern matches things like
; (set (reg:CCEQ 68) (compare:CCEQ (ior:SI (gt:SI (reg:CCFP 68) (const_int 0))
;					   (eq:SI (reg:CCFP 68) (const_int 0)))
;				   (const_int 1)))
; which are generated by the branch logic.
; Prefer destructive operations where BT = BB (for crXX BT,BA,BB)

(define_insn "*cceq_ior_compare"
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y,?y")
        (compare:CCEQ (match_operator:SI 1 "boolean_operator"
	                [(match_operator:SI 2
				      "branch_positive_comparison_operator"
				      [(match_operand 3
						      "cc_reg_operand" "y,y")
				       (const_int 0)])
	                 (match_operator:SI 4
				      "branch_positive_comparison_operator"
				      [(match_operand 5
						      "cc_reg_operand" "0,y")
				       (const_int 0)])])
		      (const_int 1)))]
  ""
  "cr%q1 %E0,%j2,%j4"
  [(set_attr "type" "cr_logical,delayed_cr")])

; Why is the constant -1 here, but 1 in the previous pattern?
; Because ~1 has all but the low bit set.
(define_insn ""
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y,?y")
        (compare:CCEQ (match_operator:SI 1 "boolean_or_operator"
	                [(not:SI (match_operator:SI 2
				      "branch_positive_comparison_operator"
				      [(match_operand 3
						      "cc_reg_operand" "y,y")
				       (const_int 0)]))
	                 (match_operator:SI 4
				"branch_positive_comparison_operator"
				[(match_operand 5
						"cc_reg_operand" "0,y")
				 (const_int 0)])])
		      (const_int -1)))]
  ""
  "cr%q1 %E0,%j2,%j4"
  [(set_attr "type" "cr_logical,delayed_cr")])

(define_insn "*cceq_rev_compare"
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y,?y")
	(compare:CCEQ (match_operator:SI 1
				      "branch_positive_comparison_operator"
				      [(match_operand 2
						      "cc_reg_operand" "0,y")
				       (const_int 0)])
		      (const_int 0)))]
  ""
  "{crnor %E0,%j1,%j1|crnot %E0,%j1}"
  [(set_attr "type" "cr_logical,delayed_cr")])

;; If we are comparing the result of two comparisons, this can be done
;; using creqv or crxor.

(define_insn_and_split ""
  [(set (match_operand:CCEQ 0 "cc_reg_operand" "=y")
	(compare:CCEQ (match_operator 1 "branch_comparison_operator"
			      [(match_operand 2 "cc_reg_operand" "y")
			       (const_int 0)])
		      (match_operator 3 "branch_comparison_operator"
			      [(match_operand 4 "cc_reg_operand" "y")
			       (const_int 0)])))]
  ""
  "#"
  ""
  [(set (match_dup 0) (compare:CCEQ (xor:SI (match_dup 1) (match_dup 3))
				    (match_dup 5)))]
  "
{
  int positive_1, positive_2;

  positive_1 = branch_positive_comparison_operator (operands[1], CCEQmode);
  positive_2 = branch_positive_comparison_operator (operands[3], CCEQmode);

  if (! positive_1)
    operands[1] = gen_rtx (rs6000_reverse_condition (GET_MODE (operands[2]),
						     GET_CODE (operands[1])),
			   SImode,
			   operands[2], const0_rtx);
  else if (GET_MODE (operands[1]) != SImode)
    operands[1] = gen_rtx (GET_CODE (operands[1]),
			   SImode,
			   operands[2], const0_rtx);

  if (! positive_2)
    operands[3] = gen_rtx (rs6000_reverse_condition (GET_MODE (operands[4]),
						     GET_CODE (operands[3])),
			   SImode,
			   operands[4], const0_rtx);
  else if (GET_MODE (operands[3]) != SImode)
    operands[3] = gen_rtx (GET_CODE (operands[3]),
			   SImode,
			   operands[4], const0_rtx);

  if (positive_1 == positive_2)
    {
      operands[1] = gen_rtx_NOT (SImode, operands[1]);
      operands[5] = constm1_rtx;
    }
  else
    {
      operands[5] = const1_rtx;
    }
}")

;; Unconditional branch and return.

(define_insn "jump"
  [(set (pc)
	(label_ref (match_operand 0 "" "")))]
  ""
  "b %l0"
  [(set_attr "type" "branch")])

(define_insn "return"
  [(return)]
  "direct_return ()"
  "{br|blr}"
  [(set_attr "type" "jmpreg")])

(define_expand "indirect_jump"
  [(set (pc) (match_operand 0 "register_operand" ""))]
  ""
  "
{
  if (TARGET_32BIT)
    emit_jump_insn (gen_indirect_jumpsi (operands[0]));
  else
    emit_jump_insn (gen_indirect_jumpdi (operands[0]));
  DONE;
}")

(define_insn "indirect_jumpsi"
  [(set (pc) (match_operand:SI 0 "register_operand" "c,*l"))]
  "TARGET_32BIT"
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn "indirect_jumpdi"
  [(set (pc) (match_operand:DI 0 "register_operand" "c,*l"))]
  "TARGET_64BIT"
  "@
   bctr
   blr"
  [(set_attr "type" "jmpreg")])

;; Table jump for switch statements:
(define_expand "tablejump"
  [(use (match_operand 0 "" ""))
   (use (label_ref (match_operand 1 "" "")))]
  ""
  "
{
  if (TARGET_32BIT)
    emit_jump_insn (gen_tablejumpsi (operands[0], operands[1]));
  else
    emit_jump_insn (gen_tablejumpdi (operands[0], operands[1]));
  DONE;
}")

(define_expand "tablejumpsi"
  [(set (match_dup 3)
	(plus:SI (match_operand:SI 0 "" "")
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  "TARGET_32BIT"
  "
{ operands[0] = force_reg (SImode, operands[0]);
  operands[2] = force_reg (SImode, gen_rtx_LABEL_REF (SImode, operands[1]));
  operands[3] = gen_reg_rtx (SImode);
}")

(define_expand "tablejumpdi"
  [(set (match_dup 4) 
        (sign_extend:DI (match_operand:SI 0 "lwa_operand" "rm")))
   (set (match_dup 3)
	(plus:DI (match_dup 4)
		 (match_dup 2)))
   (parallel [(set (pc) (match_dup 3))
	      (use (label_ref (match_operand 1 "" "")))])]
  "TARGET_64BIT"
  "
{ operands[2] = force_reg (DImode, gen_rtx_LABEL_REF (DImode, operands[1]));
  operands[3] = gen_reg_rtx (DImode);
  operands[4] = gen_reg_rtx (DImode);
}")

(define_insn ""
  [(set (pc)
	(match_operand:SI 0 "register_operand" "c,*l"))
   (use (label_ref (match_operand 1 "" "")))]
  "TARGET_32BIT"
  "@
   bctr
   {br|blr}"
  [(set_attr "type" "jmpreg")])

(define_insn ""
  [(set (pc)
	(match_operand:DI 0 "register_operand" "c,*l"))
   (use (label_ref (match_operand 1 "" "")))]
  "TARGET_64BIT"
  "@
   bctr
   blr"
  [(set_attr "type" "jmpreg")])

(define_insn "nop"
  [(const_int 0)]
  ""
  "{cror 0,0,0|nop}")

;; Define the subtract-one-and-jump insns, starting with the template
;; so loop.c knows what to generate.

(define_expand "doloop_end"
  [(use (match_operand 0 "" ""))	; loop pseudo
   (use (match_operand 1 "" ""))	; iterations; zero if unknown
   (use (match_operand 2 "" ""))	; max iterations
   (use (match_operand 3 "" ""))	; loop level
   (use (match_operand 4 "" ""))]	; label
  ""
  "
{
  /* Only use this on innermost loops.  */
  if (INTVAL (operands[3]) > 1)
    FAIL;
  if (TARGET_64BIT)
    {
      if (GET_MODE (operands[0]) != DImode)
	FAIL;
      emit_jump_insn (gen_ctrdi (operands[0], operands[4]));
    }
  else
    {
      if (GET_MODE (operands[0]) != SImode)
	FAIL;
      emit_jump_insn (gen_ctrsi (operands[0], operands[4]));
    }
  DONE;
}")

(define_expand "ctrsi"
  [(parallel [(set (pc)
		   (if_then_else (ne (match_operand:SI 0 "register_operand" "")
				     (const_int 1))
				 (label_ref (match_operand 1 "" ""))
				 (pc)))
	      (set (match_dup 0)
		   (plus:SI (match_dup 0)
			    (const_int -1)))
	      (clobber (match_scratch:CC 2 ""))
	      (clobber (match_scratch:SI 3 ""))])]
  "TARGET_32BIT"
  "")

(define_expand "ctrdi"
  [(parallel [(set (pc)
		   (if_then_else (ne (match_operand:DI 0 "register_operand" "")
				     (const_int 1))
				 (label_ref (match_operand 1 "" ""))
				 (pc)))
	      (set (match_dup 0)
		   (plus:DI (match_dup 0)
			    (const_int -1)))
	      (clobber (match_scratch:CC 2 ""))
	      (clobber (match_scratch:DI 3 ""))])]
  "TARGET_64BIT"
  "")

;; We need to be able to do this for any operand, including MEM, or we
;; will cause reload to blow up since we don't allow output reloads on
;; JUMP_INSNs.
;; For the length attribute to be calculated correctly, the
;; label MUST be operand 0.

(define_insn "*ctrsi_internal1"
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrsi_internal2"
  [(set (pc)
	(if_then_else (ne (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal1"
  [(set (pc)
	(if_then_else (ne (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal2"
  [(set (pc)
	(if_then_else (ne (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

;; Similar, but we can use GE since we have a REG_NONNEG.

(define_insn "*ctrsi_internal3"
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT && find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrsi_internal4"
  [(set (pc)
	(if_then_else (ge (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT && find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal3"
  [(set (pc)
	(if_then_else (ge (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 0))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT && find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal4"
  [(set (pc)
	(if_then_else (ge (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 0))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT && find_reg_note (insn, REG_NONNEG, 0)"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

;; Similar but use EQ

(define_insn "*ctrsi_internal5"
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrsi_internal6"
  [(set (pc)
	(if_then_else (eq (match_operand:SI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:SI 2 "register_operand" "=1,*r,m,*q*c*l")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:SI 4 "=X,X,&r,r"))]
  "TARGET_32BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal5"
  [(set (pc)
	(if_then_else (eq (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (label_ref (match_operand 0 "" ""))
		      (pc)))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"bdz %l0\";
  else
    return \"{bdn|bdnz} $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

(define_insn "*ctrdi_internal6"
  [(set (pc)
	(if_then_else (eq (match_operand:DI 1 "register_operand" "c,*r,*r,*r")
			  (const_int 1))
		      (pc)
		      (label_ref (match_operand 0 "" ""))))
   (set (match_operand:DI 2 "register_operand" "=1,*r,m,*c*l")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 "=X,&x,&x,&x"))
   (clobber (match_scratch:DI 4 "=X,X,&r,r"))]
  "TARGET_64BIT"
  "*
{
  if (which_alternative != 0)
    return \"#\";
  else if (get_attr_length (insn) == 4)
    return \"{bdn|bdnz} %l0\";
  else
    return \"bdz $+8\;b %l0\";
}"
  [(set_attr "type" "branch")
   (set_attr "length" "*,12,16,16")])

;; Now the splitters if we could not allocate the CTR register

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "gpc_reg_operand" "")
	(plus:SI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 0)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:SI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:SI 0 "nonimmediate_operand" "")
	(plus:SI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:SI 4 ""))]
  "TARGET_32BIT && reload_completed
   && ! gpc_reg_operand (operands[0], SImode)"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:SI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 4)
		   (plus:SI (match_dup 1)
			    (const_int -1)))])
   (set (match_dup 0)
	(match_dup 4))
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")
(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:DI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:DI 0 "gpc_reg_operand" "")
	(plus:DI (match_dup 1)
		 (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_64BIT && reload_completed"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:DI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 0)
		   (plus:DI (match_dup 1)
			    (const_int -1)))])
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_split
  [(set (pc)
	(if_then_else (match_operator 2 "comparison_operator"
				      [(match_operand:DI 1 "gpc_reg_operand" "")
				       (const_int 1)])
		      (match_operand 5 "" "")
		      (match_operand 6 "" "")))
   (set (match_operand:DI 0 "nonimmediate_operand" "")
	(plus:DI (match_dup 1) (const_int -1)))
   (clobber (match_scratch:CC 3 ""))
   (clobber (match_scratch:DI 4 ""))]
  "TARGET_64BIT && reload_completed
   && ! gpc_reg_operand (operands[0], DImode)"
  [(parallel [(set (match_dup 3)
		   (compare:CC (plus:DI (match_dup 1)
					(const_int -1))
			       (const_int 0)))
	      (set (match_dup 4)
		   (plus:DI (match_dup 1)
			    (const_int -1)))])
   (set (match_dup 0)
	(match_dup 4))
   (set (pc) (if_then_else (match_dup 7)
			   (match_dup 5)
			   (match_dup 6)))]
  "
{ operands[7] = gen_rtx (GET_CODE (operands[2]), VOIDmode, operands[3],
			 const0_rtx); }")

(define_insn "trap"
  [(trap_if (const_int 1) (const_int 0))]
  ""
  "{t 31,0,0|trap}")

(define_expand "conditional_trap"
  [(trap_if (match_operator 0 "trap_comparison_operator"
			    [(match_dup 2) (match_dup 3)])
	    (match_operand 1 "const_int_operand" ""))]
  ""
  "if (rs6000_compare_fp_p || operands[1] != const0_rtx) FAIL;
   operands[2] = rs6000_compare_op0;
   operands[3] = rs6000_compare_op1;")

(define_insn ""
  [(trap_if (match_operator 0 "trap_comparison_operator"
                            [(match_operand:SI 1 "register_operand" "r")
                             (match_operand:SI 2 "reg_or_short_operand" "rI")])
	    (const_int 0))]
  ""
  "{t|tw}%V0%I2 %1,%2")

(define_insn ""
  [(trap_if (match_operator 0 "trap_comparison_operator"
                            [(match_operand:DI 1 "register_operand" "r")
                             (match_operand:DI 2 "reg_or_short_operand" "rI")])
	    (const_int 0))]
  "TARGET_POWERPC64"
  "td%V0%I2 %1,%2")

;; Insns related to generating the function prologue and epilogue.

(define_expand "prologue"
  [(use (const_int 0))]
  "TARGET_SCHED_PROLOG"
  "
{
      rs6000_emit_prologue ();
      DONE;
}")

(define_insn "*movesi_from_cr_one"
  [(match_parallel 0 "mfcr_operation"
		   [(set (match_operand:SI 1 "gpc_reg_operand" "=r")
			 (unspec:SI [(match_operand:CC 2 "cc_reg_operand" "y")
				     (match_operand 3 "immediate_operand" "n")]
			  UNSPEC_MOVESI_FROM_CR))])]
  "TARGET_MFCRF"
  "*
{
  int mask = 0;
  int i;
  for (i = 0; i < XVECLEN (operands[0], 0); i++)
  {
    mask = INTVAL (XVECEXP (SET_SRC (XVECEXP (operands[0], 0, i)), 0, 1));
    operands[4] = GEN_INT (mask);
    output_asm_insn (\"mfcr %1,%4\", operands);
  }
  return \"\";
}"
  [(set_attr "type" "mfcrf")])

(define_insn "movesi_from_cr"
  [(set (match_operand:SI 0 "gpc_reg_operand" "=r")
        (unspec:SI [(reg:CC 68) (reg:CC 69) (reg:CC 70) (reg:CC 71) 
		    (reg:CC 72)	(reg:CC 73) (reg:CC 74) (reg:CC 75)]
		   UNSPEC_MOVESI_FROM_CR))]
  ""
  "mfcr %0"
  [(set_attr "type" "mfcr")])

(define_insn "*stmw"
  [(match_parallel 0 "stmw_operation"
		   [(set (match_operand:SI 1 "memory_operand" "=m")
       			 (match_operand:SI 2 "gpc_reg_operand" "r"))])]
  "TARGET_MULTIPLE"
  "{stm|stmw} %2,%1")
 
(define_insn "*save_fpregs_si"
  [(match_parallel 0 "any_operand"
		   [(clobber (match_operand:SI 1 "register_operand" "=l"))
		    (use (match_operand:SI 2 "call_operand" "s"))
		    (set (match_operand:DF 3 "memory_operand" "=m")
			 (match_operand:DF 4 "gpc_reg_operand" "f"))])]
  "TARGET_32BIT"
  "bl %z2"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

(define_insn "*save_fpregs_di"
  [(match_parallel 0 "any_operand"
		   [(clobber (match_operand:DI 1 "register_operand" "=l"))
		    (use (match_operand:DI 2 "call_operand" "s"))
		    (set (match_operand:DF 3 "memory_operand" "=m")
			 (match_operand:DF 4 "gpc_reg_operand" "f"))])]
  "TARGET_64BIT"
  "bl %z2"
  [(set_attr "type" "branch")
   (set_attr "length" "4")])

; These are to explain that changes to the stack pointer should
; not be moved over stores to stack memory.
(define_insn "stack_tie"
  [(set (match_operand:BLK 0 "memory_operand" "+m")
        (unspec:BLK [(match_dup 0)] UNSPEC_TIE))]
  ""
  ""
  [(set_attr "length" "0")])


(define_expand "epilogue"
  [(use (const_int 0))]
  "TARGET_SCHED_PROLOG"
  "
{
      rs6000_emit_epilogue (FALSE);
      DONE;
}")

; On some processors, doing the mtcrf one CC register at a time is
; faster (like on the 604e).  On others, doing them all at once is
; faster; for instance, on the 601 and 750.

(define_expand "movsi_to_cr_one"
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
        (unspec:CC [(match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_dup 2)] UNSPEC_MOVESI_TO_CR))]
  ""
  "operands[2] = GEN_INT (1 << (75 - REGNO (operands[0])));")

(define_insn "*movsi_to_cr"
  [(match_parallel 0 "mtcrf_operation"
		   [(set (match_operand:CC 1 "cc_reg_operand" "=y")
			 (unspec:CC [(match_operand:SI 2 "gpc_reg_operand" "r")
				     (match_operand 3 "immediate_operand" "n")]
				    UNSPEC_MOVESI_TO_CR))])]
 ""
 "*
{
  int mask = 0;
  int i;
  for (i = 0; i < XVECLEN (operands[0], 0); i++)
    mask |= INTVAL (XVECEXP (SET_SRC (XVECEXP (operands[0], 0, i)), 0, 1));
  operands[4] = GEN_INT (mask);
  return \"mtcrf %4,%2\";
}"
  [(set_attr "type" "mtcr")])

(define_insn "*mtcrfsi"
  [(set (match_operand:CC 0 "cc_reg_operand" "=y")
        (unspec:CC [(match_operand:SI 1 "gpc_reg_operand" "r")
		    (match_operand 2 "immediate_operand" "n")]
		   UNSPEC_MOVESI_TO_CR))]
  "GET_CODE (operands[0]) == REG 
   && CR_REGNO_P (REGNO (operands[0]))
   && GET_CODE (operands[2]) == CONST_INT
   && INTVAL (operands[2]) == 1 << (75 - REGNO (operands[0]))"
  "mtcrf %R0,%1"
  [(set_attr "type" "mtcr")])

; The load-multiple instructions have similar properties.
; Note that "load_multiple" is a name known to the machine-independent
; code that actually corresponds to the powerpc load-string.

(define_insn "*lmw"
  [(match_parallel 0 "lmw_operation"
		   [(set (match_operand:SI 1 "gpc_reg_operand" "=r")
       			 (match_operand:SI 2 "memory_operand" "m"))])]
  "TARGET_MULTIPLE"
  "{lm|lmw} %1,%2")
 
(define_insn "*return_internal_si"
  [(return)
   (use (match_operand:SI 0 "register_operand" "lc"))]
  "TARGET_32BIT"
  "b%T0"
  [(set_attr "type" "jmpreg")])

(define_insn "*return_internal_di"
  [(return)
   (use (match_operand:DI 0 "register_operand" "lc"))]
  "TARGET_64BIT"
  "b%T0"
  [(set_attr "type" "jmpreg")])

; FIXME: This would probably be somewhat simpler if the Cygnus sibcall
; stuff was in GCC.  Oh, and "any_operand" is a bit flexible...

(define_insn "*return_and_restore_fpregs_si"
 [(match_parallel 0 "any_operand"
                  [(return)
		   (use (match_operand:SI 1 "register_operand" "l"))
		   (use (match_operand:SI 2 "call_operand" "s"))
		   (set (match_operand:DF 3 "gpc_reg_operand" "=f")
			(match_operand:DF 4 "memory_operand" "m"))])]
 "TARGET_32BIT"
 "b %z2")

(define_insn "*return_and_restore_fpregs_di"
 [(match_parallel 0 "any_operand"
                  [(return)
		   (use (match_operand:DI 1 "register_operand" "l"))
		   (use (match_operand:DI 2 "call_operand" "s"))
		   (set (match_operand:DF 3 "gpc_reg_operand" "=f")
			(match_operand:DF 4 "memory_operand" "m"))])]
 "TARGET_64BIT"
 "b %z2")

; This is used in compiling the unwind routines.
(define_expand "eh_return"
  [(use (match_operand 0 "general_operand" ""))]
  ""
  "
{
  if (TARGET_32BIT)
    emit_insn (gen_eh_set_lr_si (operands[0]));
  else
    emit_insn (gen_eh_set_lr_di (operands[0]));
  DONE;
}")

; We can't expand this before we know where the link register is stored.
(define_insn "eh_set_lr_si"
  [(unspec_volatile [(match_operand:SI 0 "register_operand" "r")]
  		    UNSPECV_EH_RR)
   (clobber (match_scratch:SI 1 "=&b"))]
  "TARGET_32BIT"
  "#")

(define_insn "eh_set_lr_di"
  [(unspec_volatile [(match_operand:DI 0 "register_operand" "r")]
  		    UNSPECV_EH_RR)
   (clobber (match_scratch:DI 1 "=&b"))]
  "TARGET_64BIT"
  "#")

(define_split
  [(unspec_volatile [(match_operand 0 "register_operand" "")] UNSPECV_EH_RR)
   (clobber (match_scratch 1 ""))]
  "reload_completed"
  [(const_int 0)]
  "
{
  rs6000_emit_eh_reg_restore (operands[0], operands[1]);
  DONE;
}")

(define_insn "prefetch"
  [(prefetch (match_operand:V4SI 0 "address_operand" "p")
	     (match_operand:SI 1 "const_int_operand" "n")
	     (match_operand:SI 2 "const_int_operand" "n"))]
  "TARGET_POWERPC"
  "*
{
  if (GET_CODE (operands[0]) == REG)
    return INTVAL (operands[1]) ? \"dcbtst 0,%0\" : \"dcbt 0,%0\";
  return INTVAL (operands[1]) ? \"dcbtst %a0\" : \"dcbt %a0\";
}"
  [(set_attr "type" "load")])

(include "altivec.md")
(include "spe.md")
