%define name		gcompris
%define version      	7.2
%define RELEASE 	1
%define rel     	%{?CUSTOM_RELEASE} %{!?CUSTOM_RELEASE:%RELEASE}
%define prefix		/usr
%define canvaspackage	%(if rpm -q redhat-release &> /dev/null; then echo gdk-pixbuf-gnome; elif rpm -q mandrake-release &> /dev/null; then echo gdk-pixbuf-gnomecanvas; else echo; fi)
%define canvaslib	%(if rpm -q mandriva-release &> /dev/null; then echo libgnomecanvas2; else echo libgnomecanvas; fi)

Summary: Educational suite for kids 2-10 years old
Name: 		%name
Version: 	%version
Release: 	%rel
License: 	GPL
Group: 		Games/Other
Source:		ftp://gcompris.sourceforge.net/gcompris-%{PACKAGE_VERSION}.tar.gz
BuildRoot: 	%_tmppath/%name-%version-buildroot
Buildrequires: gnuchess
Buildrequires: libxml2-devel libgnomeui2-devel libsqlite3_0-devel
Buildrequires: texinfo 
# (misc) needed for python support
Buildrequires: gnome-python python-devel pygtk2.0-devel 
Requires:	gnome-libs libxml2 gdk-pixbuf %canvaspackage %canvaslib
Requires:       gnuchess >= 5.02
Requires:       python gnome-python gnome-python-canvas pygtk2.0 python-sqlite2
Requires:	assetml-flags
Requires:	libSDL_mixer1.2
Requires:	libsqlite3_0
Packager:       Bruno Coudoin <bcoudoin.coudoin@free.fr>
URL: 		http://gcompris.net

%description
GCompris / I Have Understood is an educationnal game for children starting at 2.
More than 60 different activities are proposed:
* Click on the animals => learn the mouse/click usage
* Type the falling letters => learn the keyboard usage
* Falling Dices
* Falling words
* Basic algebra
* Time learning with an analog clock
* Puzzle game with famous paintings
* Drive Plane to catch clouds in increasing number
* Balance the scales
* And much more ...

The Game is included in the Main desktop menu in 'Games'.

You should install it only if you have children using this computer.

%description -l fr
GCompris / J'ai Compris est un logiciel ducatif pour les enfants 
 partir de 2 ans.

Plus de 50 activits sont proposes :
* Cliquer sur les animaux => apprentissage du click et de la souris
* Entrer les lettres qui tombent => Apprentissage du clavier
* Les ds qui tombent
* Les mots qui tombent
* Algbre simple
* Apprentissage de la lecture de l'heure sur une horloge analogique
* Puzzle avec des tableaux clbres
* Pilote un avion pour attraper les nuages dans l'ordre
* Equilibre la balance
* ...

Le jeu est inclus dans les icones sous le menu Jeux.

A installer si vous avez des enfants utilisant cet ordinateur.

%package devel
Summary:        Development package for gcompris
Group: 		Amusements/Games
Version: %version

%description devel
Development package for gcompris

%package -n assetml-voices-alphabet-da
Summary:        Danish voices in Danish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-da
Alphabet voices in Danish

%package -n assetml-voices-colors-da
Summary:        Colors voices in Danish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-da
Colors voices in Danish

%package -n assetml-voices-geography-da
Summary:        Country name voices in Danish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-geography-da
Country name voices in Danish

%package -n assetml-voices-misc-da
Summary:        Miscelaneous voices in Danish
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-misc-da
Miscelaneous voices in Danish



%package -n assetml-voices-alphabet-de
Summary:        Alphabet voices in German
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-de
Alphabet voices in German

%package -n assetml-voices-colors-de
Summary:        Colors voices in German
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-de
Colors voices in German

%package -n assetml-voices-geography-de
Summary:        Country name voices in German
Group: 		Amusements/Games
Version: 0.0

%description -n assetml-voices-geography-de
Country name voices in German

%package -n assetml-voices-misc-de
Summary:        Miscelaneous voices in German
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-de
Miscelaneous voices in German


%package -n assetml-voices-alphabet-en
Summary:        Alphabet voices in English
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-alphabet-en
Alphabet voices in English

%package -n assetml-voices-colors-en
Summary:        Colors voices in English
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-colors-en
Colors voices in English

%package -n assetml-voices-geography-en
Summary:        Country name voices in English
Group: 		Amusements/Games
Version: 1.2

%description -n assetml-voices-geography-en
Country name voices in English

%package -n assetml-voices-misc-en
Summary:        Miscelaneous voices in English
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-misc-en
Miscelaneous voices in English


%package -n assetml-voices-alphabet-es
Summary:        Alphabet voices in Spanish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-es
Alphabet voices in Spanish

%package -n assetml-voices-colors-es
Summary:        Colors voices in Spanish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-es
Colors voices in Spanish

%package -n assetml-voices-geography-es
Summary:        Country name voices in Spanish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-geography-es
Country name voices in Spanish

%package -n assetml-voices-misc-es
Summary:        Miscelaneous voices in Spanish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-es
Miscelaneous voices in Spanish


%package -n assetml-voices-alphabet-fr
Summary:        Alphabet voices in French
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-alphabet-fr
Alphabet voices in French

%package -n assetml-voices-colors-fr
Summary:        Colors voices in French
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-fr
Colors voices in French

%package -n assetml-voices-geography-fr
Summary:        Country name voices in French
Group: 		Amusements/Games
Version: 1.2

%description -n assetml-voices-geography-fr
Country name voices in French

%package -n assetml-voices-misc-fr
Summary:        Miscelaneous voices in French
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-misc-fr
Miscelaneous voices in French

%package -n assetml-voices-france-regions-fr
Summary:        Voices of names of the French Regions in French
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-france-regions-fr
Voices of names of the French Regions in French


%package -n assetml-voices-alphabet-hu
Summary:        Alphabet voices in Hungarian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-hu
Alphabet voices in Hungarian

%package -n assetml-voices-colors-hu
Summary:        Colors voices in Hungarian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-hu
Colors voices in Hungarian

%package -n assetml-voices-geography-hu
Summary:        Country name voices in Hungarian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-geography-hu
Country name voices in Hungarian

%package -n assetml-voices-misc-hu
Summary:        Miscelaneous voices in Hungarian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-hu
Miscelaneous voices in Hungarian


%package -n assetml-voices-alphabet-it
Summary:        Alphabet voices in Italian
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-alphabet-it
Alphabet voices in Italian

%package -n assetml-voices-colors-it
Summary:        Colors voices in Italian
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-colors-it
Colors voices in Italian

%package -n assetml-voices-geography-it
Summary:        Country name voices in Italian
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-geography-it
Country name voices in Italian

%package -n assetml-voices-misc-it
Summary:        Miscelaneous voices in Italian
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-misc-it
Miscelaneous voices in Italian


%package -n assetml-voices-alphabet-pt
Summary:        Alphabet voices in Portuguese
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-pt
Alphabet voices in Portuguese

%package -n assetml-voices-colors-pt
Summary:        Colors voices in Portuguese
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-pt
Colors voices in Portuguese

%package -n assetml-voices-geography-pt
Summary:        Country name voices in Portuguese
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-geography-pt
Country name voices in Portuguese

%package -n assetml-voices-misc-pt
Summary:        Miscelaneous voices in Portuguese
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-misc-pt
Miscelaneous voices in Portuguese


%package -n assetml-voices-alphabet-ru
Summary:        Alphabet voices in Russian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-ru
Alphabet voices in Russian

%package -n assetml-voices-colors-ru
Summary:        Colors voices in Russian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-ru
Colors voices in Russian

%package -n assetml-voices-geography-ru
Summary:        Country name voices in Russian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-geography-ru
Country name voices in Russian

%package -n assetml-voices-misc-ru
Summary:        Miscelaneous voices in Russian
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-ru
Miscelaneous voices in Russian


%package -n assetml-voices-alphabet-sv
Summary:        Alphabet voices in Swedish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-sv
Alphabet voices in Swedish

%package -n assetml-voices-colors-sv
Summary:        Colors voices in Swedish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-sv
Colors voices in Swedish

%package -n assetml-voices-geography-sv
Summary:        Country name voices in Swedish
Group: 		Amusements/Games
Version: 1.1

%description -n assetml-voices-geography-sv
Country name voices in Swedish

%package -n assetml-voices-misc-sv
Summary:        Miscelaneous voices in Swedish
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-sv
Miscelaneous voices in Swedish

%package -n assetml-voices-alphabet-eu
Summary:        Alphabet voices in Basque
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-alphabet-eu
Alphabet voices in Basque

%package -n assetml-voices-colors-eu
Summary:        Colors voices in Basque
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-colors-eu
Colors voices in Basque

%package -n assetml-voices-geography-eu
Summary:        Country name voices in Basque
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-geography-eu
Country name voices in Basque

%package -n assetml-voices-misc-eu
Summary:        Miscelaneous voices in Basque
Group: 		Amusements/Games
Version: 1.0

%description -n assetml-voices-misc-eu
Miscelaneous voices in Basque


%package -n assetml-flags
Summary:        Contains png 60x40 country flags and an assetml description file
Group: 		Pixmaps
Version: 1.10

%description -n assetml-flags
Contains png 60x40 country flags and an assetml description file

%prep
%setup -q

%build
%ifarch alpha
  MYARCH_FLAGS="--host=alpha-redhat-linux"
%endif
%configure 

%make


%install
rm -rf $RPM_BUILD_ROOT
%makeinstall_std


%clean
rm -rf $RPM_BUILD_ROOT

%post 

%update_menus

%_install_info %{name}.info

%postun 

%clean_menus

%preun

%_remove_install_info %{name}.info

%files
%defattr(-, root, root)
%doc AUTHORS COPYING ChangeLog NEWS README
%_bindir/*

%dir %_libdir/%{name}/
%_libdir/%{name}/*
%_libdir/libgcompris-1.so.0.0.0
%_libdir/libgcompris-1.so.0

%_menudir/*
%dir %{prefix}/share/gcompris
%dir %{prefix}/share/gcompris/boards
%dir %{prefix}/share/gcompris/boards/skins
%{prefix}/share/gcompris/boards/skins/*
%{prefix}/share/gcompris/boards/[^fs]*
%{prefix}/share/gcompris/boards/f[iuo]*
%{prefix}/share/gcompris/boards/s[cemu]*
%dir %{prefix}/share/gcompris/boards/sounds
%{prefix}/share/gcompris/boards/sounds/*.ogg
%{prefix}/share/gcompris/boards/sounds/melody/*/*.ogg
%{prefix}/share/gcompris/boards/sounds/memory/*.ogg
%{prefix}/share/gcompris/boards/sounds/chronos/space/*.ogg
%{prefix}/share/gcompris/boards/sounds/LuneRouge/*
%{prefix}/share/gcompris/boards/sounds/HOWTO_ENCODE
%dir %{prefix}/share/gcompris/python
%{prefix}/share/gcompris/python/*
%{prefix}/share/applications/*
%{prefix}/share/gnome/help/*
%{prefix}/share/locale/*/*/*
%{prefix}/share/pixmaps/*.png
%_infodir/*

%files devel
%dir %_includedir/libgcompris-1.0/libgcompris
%_includedir/libgcompris-1.0/libgcompris/*
%dir %_libdir
%_libdir/libgcompris-1.la
%_libdir/libgcompris-1.so
%_libdir/pkgconfig/libgcompris-1.0.pc

%files -n assetml-voices-alphabet-da
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/da/alphabet
%{prefix}/share/assetml/gcompris_alphabet_da.assetml

%files -n assetml-voices-colors-da
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/da/colors
%{prefix}/share/assetml/gcompris_colors_da.assetml

%files -n assetml-voices-geography-da
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/da/geography
%{prefix}/share/assetml/gcompris_geography_da.assetml

%files -n assetml-voices-misc-da
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/da/misc
%{prefix}/share/assetml/gcompris_misc_da.assetml


%files -n assetml-voices-alphabet-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de/alphabet
%{prefix}/share/assetml/gcompris_alphabet_de.assetml

%files -n assetml-voices-colors-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de/colors
%{prefix}/share/assetml/gcompris_colors_de.assetml

%files -n assetml-voices-geography-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de/geography
%{prefix}/share/assetml/gcompris_geography_de.assetml

%files -n assetml-voices-misc-de
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/de/misc
%{prefix}/share/assetml/gcompris_misc_de.assetml


%files -n assetml-voices-alphabet-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en/alphabet
%{prefix}/share/assetml/gcompris_alphabet_en.assetml

%files -n assetml-voices-colors-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en/colors
%{prefix}/share/assetml/gcompris_colors_en.assetml

%files -n assetml-voices-geography-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en/geography
%{prefix}/share/assetml/gcompris_geography_en.assetml

%files -n assetml-voices-misc-en
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/en/misc
%{prefix}/share/assetml/gcompris_misc_en.assetml


%files -n assetml-voices-alphabet-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es/alphabet
%{prefix}/share/assetml/gcompris_alphabet_es.assetml

%files -n assetml-voices-colors-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es/colors
%{prefix}/share/assetml/gcompris_colors_es.assetml

%files -n assetml-voices-geography-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es/geography
%{prefix}/share/assetml/gcompris_geography_es.assetml

%files -n assetml-voices-misc-es
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/es/misc
%{prefix}/share/assetml/gcompris_misc_es.assetml


%files -n assetml-voices-alphabet-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr/alphabet
%{prefix}/share/assetml/gcompris_alphabet_fr.assetml

%files -n assetml-voices-colors-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr/colors
%{prefix}/share/assetml/gcompris_colors_fr.assetml

%files -n assetml-voices-geography-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr/geography
%{prefix}/share/assetml/gcompris_geography_fr.assetml

%files -n assetml-voices-misc-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr/misc
%{prefix}/share/assetml/gcompris_misc_fr.assetml

%files -n assetml-voices-france-regions-fr
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/fr/france_region
%{prefix}/share/assetml/gcompris_franceregion_fr.assetml


%files -n assetml-voices-alphabet-hu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/hu/alphabet
%{prefix}/share/assetml/gcompris_alphabet_hu.assetml

%files -n assetml-voices-colors-hu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/hu/colors
%{prefix}/share/assetml/gcompris_colors_hu.assetml

%files -n assetml-voices-geography-hu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/hu/geography
%{prefix}/share/assetml/gcompris_geography_hu.assetml

%files -n assetml-voices-misc-hu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/hu/misc
%{prefix}/share/assetml/gcompris_misc_hu.assetml


%files -n assetml-voices-alphabet-it
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/it/alphabet
%{prefix}/share/assetml/gcompris_alphabet_it.assetml

%files -n assetml-voices-colors-it
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/it/colors
%{prefix}/share/assetml/gcompris_colors_it.assetml

%files -n assetml-voices-geography-it
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/it/geography
%{prefix}/share/assetml/gcompris_geography_it.assetml

%files -n assetml-voices-misc-it
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/it/misc
%{prefix}/share/assetml/gcompris_misc_it.assetml


%files -n assetml-voices-alphabet-pt
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt/alphabet
%{prefix}/share/assetml/gcompris_alphabet_pt.assetml

%files -n assetml-voices-colors-pt
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt/colors
%{prefix}/share/assetml/gcompris_colors_pt.assetml

%files -n assetml-voices-geography-pt
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt/geography
%{prefix}/share/assetml/gcompris_geography_pt.assetml

%files -n assetml-voices-misc-pt
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/pt/misc
%{prefix}/share/assetml/gcompris_misc_pt.assetml


%files -n assetml-voices-alphabet-ru
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/ru/alphabet
%{prefix}/share/assetml/gcompris_alphabet_ru.assetml

%files -n assetml-voices-colors-ru
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/ru/colors
%{prefix}/share/assetml/gcompris_colors_ru.assetml

%files -n assetml-voices-geography-ru
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/ru/geography
%{prefix}/share/assetml/gcompris_geography_ru.assetml

%files -n assetml-voices-misc-ru
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/ru/misc
%{prefix}/share/assetml/gcompris_misc_ru.assetml


%files -n assetml-voices-alphabet-sv
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/sv/alphabet
%{prefix}/share/assetml/gcompris_alphabet_sv.assetml

%files -n assetml-voices-colors-sv
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/sv/colors
%{prefix}/share/assetml/gcompris_colors_sv.assetml

%files -n assetml-voices-geography-sv
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/sv/geography
%{prefix}/share/assetml/gcompris_geography_sv.assetml

%files -n assetml-voices-misc-sv
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/sv/misc
%{prefix}/share/assetml/gcompris_misc_sv.assetml


%files -n assetml-voices-alphabet-eu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/eu/alphabet
%{prefix}/share/assetml/gcompris_alphabet_eu.assetml

%files -n assetml-voices-colors-eu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/eu/colors
%{prefix}/share/assetml/gcompris_colors_eu.assetml

%files -n assetml-voices-geography-eu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/eu/geography
%{prefix}/share/assetml/gcompris_geography_eu.assetml

%files -n assetml-voices-misc-eu
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/sounds/eu/misc
%{prefix}/share/assetml/gcompris_misc_eu.assetml


%files -n assetml-flags
%defattr(-, root, root)
%{prefix}/share/gcompris/boards/flags/*
%{prefix}/share/assetml/gcompris_flags.assetml

