#  gcompris - board_list.py
#
# Copyright (C) 2005 Yves Combe
#
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
#

import gnomecanvas
import gcompris
import gcompris.utils
import gcompris.skin
import gcompris.admin
import gtk
import gtk.gdk
import gobject
from gettext import gettext as _

import glob

class Words_list:
  """GCompris Words  List Tool"""


  # area is the drawing area for the list
  def __init__(self, db_connect, db_cursor, profile):

    self.cur = db_cursor
    self.con = db_connect
    self.active_profile = profile

    print "Words_list __init__"

    files = glob.glob('wordlist_*.xml')

    print "Matching files :", files

    self.main_vbox = gcompris.configuration_window ( \
      _('<b>%s</b> configuration\n for profile <b>%s</b>') % ('Wordlist', self.active_profile.name ),
      self.wordlist_callback
      )

    self.prop = gcompris.get_properties()

    self.wordlist_dir = self.prop.shared_dir +'/wordlist'

    print self.wordlist_dir

    gcompris.textview('Words list',
                      'wordlist',
                      'Enter the words, comma, space, return separated. Then click on th check button.',
                      '',
                      self.wordlist_validate)

  def wordlist_callback(self, table):
    print "wordlist_callback"
    for k, v in table.iteritems():
      print k, v


  def wordlist_validate( self, key, text, label):
    print "wordlist_validate"
    print key, text
    label.set_markup(text)
    return True



