/* gLife - An Artificial Life implementation using GNOME
 *
 * Copyright (C) 1999 Ali Abdin <aliabdin@aucegypt.edu>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307, USA.
 */
#include "config.h"

#include <gnome.h>
#include <glade/glade.h>

#include "simulation.h"
#include "data.h"
#include "glife.h"
#include "move.h"
#include "feedback.h"
#include "drawing.h"
#include "reproduction.h"

ConfigOptions ruleset;

/* Function Prototypes */
gint do_update (gpointer);
void kill_old (void);
void age_animal (AnimalType *);
void start_simulation (GtkWidget *, gpointer);
/* End Prototypes */


void 
age_animal (AnimalType *anim) {
	if (anim)
		anim->age++;
	else
		g_warning (_("Can not age animal"));
}

void
kill_old () {
	GList *temp;
	
	temp = animal;
	while (temp) {
		gboolean deloccured;
		AnimalType *anim;
		
		deloccured = FALSE;
		anim = temp->data;
		
		g_assert (anim != NULL);
		if (anim->age > anim->maxage) {
			gchar *message;
		
			message = g_strdup_printf (_("Animal at %d,%d died of old age\n"),anim->posx,anim->posy);

			del_animal (anim->posx, anim->posy);
			glife_log (message);
			g_free (message);
			deloccured = TRUE;
		}
		if (deloccured)
			temp = g_list_first (animal);
		else
			temp = g_list_next (temp);
	}
}

gint
do_update(gpointer data) {
	GList *tmp;
	GtkWidget *w;
	gchar *message;
	gint x;

	glife.timeout_on = TRUE;
	glife.updatecounter++;
	
	message = g_strdup_printf (_("Update %d:\n"), glife.updatecounter);
	glife_log (message);
	g_free (message);

	w = glade_xml_get_widget (glife.xml, "textbox");
	gtk_text_freeze (GTK_TEXT (w));
	if (ruleset.enforceage)
		kill_old ();
	tmp = animal;
	while (tmp) {
		AnimalType *anim;

		anim = tmp->data;
		age_animal (anim);
		for (x = 0; x < anim->speed; x++)
			random_movement (anim);
		if (ruleset.enforcerep)
			if (is_fertile (anim))
				reproduce (anim);
		tmp = g_list_next (tmp);
	}
	gtk_text_thaw (GTK_TEXT (w));

	render();
	
	w = GTK_WIDGET(glade_xml_get_widget (glife.xml, "drawingarea"));
	gtk_widget_draw (w, NULL);
	
	glife.timeout_on = FALSE;
	return TRUE; /* Keep timeout */
}


void
start_simulation (GtkWidget *widget, gpointer data) {	
	GtkWidget *w;
	
	terrain_setup(); 
	animal_setup(); /* Draw animals and terrain */
	
	glife.updatecounter = 0;
	while (gtk_events_pending())
		gtk_main_iteration();
	
	w = glade_xml_get_widget (glife.xml, "pausebutton");
	gtk_widget_set_sensitive (GTK_WIDGET (w), TRUE);
	gtk_widget_set_sensitive (GTK_WIDGET (widget), FALSE);

	w = glade_xml_get_widget (glife.xml, "end_menu");
	gtk_widget_set_sensitive (GTK_WIDGET (w), TRUE);

	glife.timeoutid = gtk_timeout_add (ruleset.timeout, do_update, widget);
}

