
#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include <stdio.h>
#include <glib.h>

#include <gmyth-upnp/gmyth_upnp.h>

#include "gmyth_backendinfo.h"
#include "gmyth_file_transfer.h"
#include "gmyth_livetv.h"
#include "gmyth_util.h"
#include "gmyth_common.h"

typedef struct {
    GMythBackendInfo *b_info;
    gchar          *mythtv_id;
} gupnp_options_t;

static gupnp_options_t *
_gupnp_options_new()
{
    gupnp_options_t *options = g_new0(gupnp_options_t, 1);
    options->b_info = gmyth_backend_info_new();

    return options;
}

static void
_gupnp_options_free(gupnp_options_t * options)
{
    g_return_if_fail(options != NULL);

    if (options->b_info)
        g_object_unref(options->b_info);
    g_free(options->mythtv_id);
}

static          gboolean
_parse_args(int argc, char *argv[], gupnp_options_t * options)
{
    GError         *error = NULL;
    GOptionContext *context;

    gchar          *mythtv_id = NULL;

    GOptionEntry    entries[] = {
        {"mythtvid", 'm', 0, G_OPTION_ARG_STRING, &mythtv_id,
         "MythTV UPnP service " "identifigupnpion", "UPNP_ID"},

        {NULL}
    };

    g_return_val_if_fail(options != NULL, FALSE);

    context =
        g_option_context_new
        ("- searches for a list of connected mythtv backend recorded "
         "file and prints it on the standard output\n");
    g_option_context_add_main_entries(context, entries, NULL);
    g_option_context_parse(context, &argc, &argv, &error);
    g_option_context_set_help_enabled(context, TRUE);

    g_option_context_free(context);

    g_free(mythtv_id);

    return TRUE;
}


static void
_got_upnp_device(GMythUPnP * gupnp, GMythUPnPDeviceStatus status,
                 gchar * udn)
{
    g_debug("Got Device !!! [%s, %s]",
            gmyth_upnp_device_status_to_string(status), udn);
}

static          gboolean
_gupnp_search_devices(gupnp_options_t * options)
{
    GList          *upnp_servers = NULL;
    GMythUPnP      *gupnp;
    GMythBackendInfo *backend_info = gmyth_backend_info_new();

    g_return_val_if_fail(options != NULL, FALSE);
    g_return_val_if_fail(options->b_info != NULL, FALSE);

    gupnp = gmyth_upnp_new(backend_info, _got_upnp_device);
    upnp_servers = gmyth_upnp_do_search_sync(gupnp);

    g_list_free(upnp_servers);
    g_object_unref(gupnp);

    return TRUE;
}

int
main(int argc, char *argv[])
{
    gboolean        res = FALSE;
    gupnp_options_t *options;

    g_type_init();
    if (!g_thread_supported())
        g_thread_init(NULL);

    options = _gupnp_options_new();
    res = _parse_args(argc, argv, options);
    if (!res) {
        g_printerr("Argument invalid. Type --help\n");
        return 1;
    }

    res = _gupnp_search_devices(options);

    _gupnp_options_free(options);

    return 0;
}
