/* minefield-view.c generated by valac 0.24.0, the Vala compiler
 * generated from minefield-view.vala, do not modify */

/*
 * Copyright (C) 2011-2012 Robert Ancell
 *
 * This program is free software: you can redistribute it and/or modify it under
 * the terms of the GNU General Public License as published by the Free Software
 * Foundation, either version 2 of the License, or (at your option) any later
 * version. See http://www.gnu.org/copyleft/gpl.html the full text of the
 * license.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <cairo.h>
#include <gdk/gdk.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <librsvg/rsvg.h>
#include <pango/pango.h>
#include <pango/pangocairo.h>
#include <glib/gi18n-lib.h>


#define TYPE_POSITION (position_get_type ())
#define POSITION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_POSITION, Position))
#define POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_POSITION, PositionClass))
#define IS_POSITION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_POSITION))
#define IS_POSITION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_POSITION))
#define POSITION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_POSITION, PositionClass))

typedef struct _Position Position;
typedef struct _PositionClass PositionClass;
typedef struct _PositionPrivate PositionPrivate;

#define TYPE_MINEFIELD_VIEW (minefield_view_get_type ())
#define MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD_VIEW, MinefieldView))
#define MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD_VIEW, MinefieldViewClass))
#define IS_MINEFIELD_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD_VIEW))
#define IS_MINEFIELD_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD_VIEW))
#define MINEFIELD_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD_VIEW, MinefieldViewClass))

typedef struct _MinefieldView MinefieldView;
typedef struct _MinefieldViewClass MinefieldViewClass;
typedef struct _MinefieldViewPrivate MinefieldViewPrivate;

#define TYPE_MINEFIELD (minefield_get_type ())
#define MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_MINEFIELD, Minefield))
#define MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_MINEFIELD, MinefieldClass))
#define IS_MINEFIELD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_MINEFIELD))
#define IS_MINEFIELD_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_MINEFIELD))
#define MINEFIELD_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_MINEFIELD, MinefieldClass))

typedef struct _Minefield Minefield;
typedef struct _MinefieldClass MinefieldClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))
#define _minefield_unref0(var) ((var == NULL) ? NULL : (var = (minefield_unref (var), NULL)))
typedef struct _MinefieldPrivate MinefieldPrivate;

#define TYPE_FLAG_TYPE (flag_type_get_type ())
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _cairo_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_destroy (var), NULL)))
#define _cairo_surface_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_surface_destroy (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _pango_attribute_destroy0(var) ((var == NULL) ? NULL : (var = (pango_attribute_destroy (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))
#define _pango_attr_list_unref0(var) ((var == NULL) ? NULL : (var = (pango_attr_list_unref (var), NULL)))

#define TYPE_NEIGHBOUR (neighbour_get_type ())
typedef struct _Neighbour Neighbour;

struct _Position {
	GObject parent_instance;
	PositionPrivate * priv;
};

struct _PositionClass {
	GObjectClass parent_class;
};

struct _PositionPrivate {
	gboolean _is_set;
	gint _x;
	gint _y;
};

struct _MinefieldView {
	GtkDrawingArea parent_instance;
	MinefieldViewPrivate * priv;
};

struct _MinefieldViewClass {
	GtkDrawingAreaClass parent_class;
};

struct _MinefieldViewPrivate {
	gboolean use_question_marks;
	gboolean use_overmine_warning;
	gboolean use_autoflag;
	Position* keyboard_cursor;
	Position* selected;
	guint render_size;
	cairo_pattern_t* flag_pattern;
	cairo_pattern_t* mine_pattern;
	cairo_pattern_t* question_pattern;
	cairo_pattern_t* bang_pattern;
	cairo_pattern_t* warning_pattern;
	cairo_pattern_t** number_patterns;
	gint number_patterns_length1;
	gint _number_patterns_size_;
	Minefield* _minefield;
};

struct _Minefield {
	GTypeInstance parent_instance;
	volatile int ref_count;
	MinefieldPrivate * priv;
	guint width;
	guint height;
	guint n_mines;
	gboolean exploded;
};

struct _MinefieldClass {
	GTypeClass parent_class;
	void (*finalize) (Minefield *self);
};

typedef enum  {
	FLAG_TYPE_NONE,
	FLAG_TYPE_FLAG,
	FLAG_TYPE_MAYBE
} FlagType;

struct _Neighbour {
	gint x;
	gint y;
};


static gpointer position_parent_class = NULL;
static gpointer minefield_view_parent_class = NULL;

GType position_get_type (void) G_GNUC_CONST;
#define POSITION_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_POSITION, PositionPrivate))
enum  {
	POSITION_DUMMY_PROPERTY,
	POSITION_IS_SET,
	POSITION_IS_VALID,
	POSITION_X,
	POSITION_Y
};
Position* position_new (void);
Position* position_construct (GType object_type);
gboolean position_get_is_set (Position* self);
void position_set_is_set (Position* self, gboolean value);
gboolean position_get_is_valid (Position* self);
gint position_get_x (Position* self);
gint position_get_y (Position* self);
void position_set_x (Position* self, gint value);
void position_set_y (Position* self, gint value);
void position_set_position (Position* self, gint* value, int value_length1);
static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void position_finalize (GObject* obj);
static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
GType minefield_view_get_type (void) G_GNUC_CONST;
gpointer minefield_ref (gpointer instance);
void minefield_unref (gpointer instance);
GParamSpec* param_spec_minefield (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void value_set_minefield (GValue* value, gpointer v_object);
void value_take_minefield (GValue* value, gpointer v_object);
gpointer value_get_minefield (const GValue* value);
GType minefield_get_type (void) G_GNUC_CONST;
#define MINEFIELD_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_MINEFIELD_VIEW, MinefieldViewPrivate))
enum  {
	MINEFIELD_VIEW_DUMMY_PROPERTY,
	MINEFIELD_VIEW_MINEFIELD
};
MinefieldView* minefield_view_new (void);
MinefieldView* minefield_view_construct (GType object_type);
void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks);
void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning);
void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag);
static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield);
gboolean minefield_has_mine (Minefield* self, guint x, guint y);
GType flag_type_get_type (void) G_GNUC_CONST;
FlagType minefield_get_flag (Minefield* self, guint x, guint y);
static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y);
static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename);
static guint minefield_view_get_mine_size (MinefieldView* self);
static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n);
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural);
Minefield* minefield_view_get_minefield (MinefieldView* self);
static guint minefield_view_get_minimum_size (MinefieldView* self);
static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural);
static guint minefield_view_get_x_offset (MinefieldView* self);
static guint minefield_view_get_y_offset (MinefieldView* self);
static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y);
gboolean minefield_is_cleared (Minefield* self, guint x, guint y);
GType neighbour_get_type (void) G_GNUC_CONST;
Neighbour* neighbour_dup (const Neighbour* self);
void neighbour_free (Neighbour* self);
gboolean minefield_is_location (Minefield* self, gint x, gint y);
gboolean minefield_get_paused (Minefield* self);
gboolean minefield_has_flag_warning (Minefield* self, guint x, guint y);
guint minefield_get_n_adjacent_mines (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr);
static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y);
guint minefield_get_n_flags (Minefield* self);
void minefield_set_flag (Minefield* self, guint x, guint y, FlagType flag);
static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y);
static void minefield_view_multi_release (MinefieldView* self, guint x, guint y);
void minefield_clear_mine (Minefield* self, guint x, guint y);
static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event);
gboolean minefield_get_is_complete (Minefield* self);
static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event);
static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event);
static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event);
static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event);
void minefield_view_set_minefield (MinefieldView* self, Minefield* value);
static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self);
static void _minefield_view_minefield___lambda3_ (MinefieldView* self, guint x, guint y);
static void __minefield_view_minefield___lambda3__position_redraw (Position* _sender, guint x, guint y, gpointer self);
static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda4__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda5__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self);
static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint x);
static gint __minefield_view_minefield___lambda6__position_set_x (Position* _sender, gint x, gpointer self);
static gint _minefield_view_minefield___lambda7_ (MinefieldView* self, gint y);
static gint __minefield_view_minefield___lambda7__position_set_y (Position* _sender, gint y, gpointer self);
static gboolean _minefield_view_minefield___lambda8_ (MinefieldView* self, gint x, gint y);
static gboolean __minefield_view_minefield___lambda8__position_validate (Position* _sender, gint x, gint y, gpointer self);
static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self);
static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self);
static void _minefield_view_minefield___lambda9_ (MinefieldView* self);
static void __minefield_view_minefield___lambda9__minefield_paused_changed (Minefield* _sender, gpointer self);
static void minefield_view_finalize (GObject* obj);
static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

extern const Neighbour neighbour_map[8];

Position* position_construct (GType object_type) {
	Position * self = NULL;
	self = (Position*) g_object_new (object_type, NULL);
	return self;
}


Position* position_new (void) {
	return position_construct (TYPE_POSITION);
}


gboolean position_get_is_set (Position* self) {
	gboolean result;
	gboolean _tmp0_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->_is_set;
	result = _tmp0_;
	return result;
}


void position_set_is_set (Position* self, gboolean value) {
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_is_set;
	_tmp2_ = value;
	if (_tmp1_ != _tmp2_) {
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp3_ = position_get_is_valid (self);
		_tmp4_ = _tmp3_;
		_tmp0_ = _tmp4_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gint _tmp5_ = 0;
		gint _tmp6_ = 0;
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		_tmp5_ = position_get_x (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = position_get_y (self);
		_tmp8_ = _tmp7_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp6_, (guint) _tmp8_);
	}
	_tmp9_ = value;
	self->priv->_is_set = _tmp9_;
	g_object_notify ((GObject *) self, "is-set");
}


gboolean position_get_is_valid (Position* self) {
	gboolean result;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gint _tmp2_ = 0;
	gint _tmp3_ = 0;
	gboolean _tmp4_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = position_get_x (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = position_get_y (self);
	_tmp3_ = _tmp2_;
	g_signal_emit_by_name (self, "validate", _tmp1_, _tmp3_, &_tmp4_);
	result = _tmp4_;
	return result;
}


gint position_get_x (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_x;
	result = _tmp0_;
	return result;
}


void position_set_x (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_x;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = position_get_x (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = position_get_y (self);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp8_, (guint) _tmp10_);
	}
	_tmp11_ = value;
	g_signal_emit_by_name (self, "set-x", _tmp11_, &_tmp12_);
	self->priv->_x = _tmp12_;
	_tmp14_ = position_get_is_set (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = position_get_is_valid (self);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp18_ = position_get_x (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = position_get_y (self);
		_tmp21_ = _tmp20_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp19_, (guint) _tmp21_);
	}
	g_object_notify ((GObject *) self, "x");
}


gint position_get_y (Position* self) {
	gint result;
	gint _tmp0_ = 0;
	g_return_val_if_fail (self != NULL, 0);
	_tmp0_ = self->priv->_y;
	result = _tmp0_;
	return result;
}


void position_set_y (Position* self, gint value) {
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	gint _tmp11_ = 0;
	gint _tmp12_ = 0;
	gboolean _tmp13_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_y;
	_tmp1_ = value;
	if (_tmp0_ == _tmp1_) {
		return;
	}
	_tmp3_ = position_get_is_set (self);
	_tmp4_ = _tmp3_;
	if (_tmp4_) {
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp5_ = position_get_is_valid (self);
		_tmp6_ = _tmp5_;
		_tmp2_ = _tmp6_;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		gint _tmp7_ = 0;
		gint _tmp8_ = 0;
		gint _tmp9_ = 0;
		gint _tmp10_ = 0;
		_tmp7_ = position_get_x (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = position_get_y (self);
		_tmp10_ = _tmp9_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp8_, (guint) _tmp10_);
	}
	_tmp11_ = value;
	g_signal_emit_by_name (self, "set-y", _tmp11_, &_tmp12_);
	self->priv->_y = _tmp12_;
	_tmp14_ = position_get_is_set (self);
	_tmp15_ = _tmp14_;
	if (_tmp15_) {
		gboolean _tmp16_ = FALSE;
		gboolean _tmp17_ = FALSE;
		_tmp16_ = position_get_is_valid (self);
		_tmp17_ = _tmp16_;
		_tmp13_ = _tmp17_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		gint _tmp18_ = 0;
		gint _tmp19_ = 0;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp18_ = position_get_x (self);
		_tmp19_ = _tmp18_;
		_tmp20_ = position_get_y (self);
		_tmp21_ = _tmp20_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp19_, (guint) _tmp21_);
	}
	g_object_notify ((GObject *) self, "y");
}


void position_set_position (Position* self, gint* value, int value_length1) {
	gboolean _tmp0_ = FALSE;
	gint _tmp1_ = 0;
	gint* _tmp2_ = NULL;
	gint _tmp2__length1 = 0;
	gint _tmp3_ = 0;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gint* _tmp16_ = NULL;
	gint _tmp16__length1 = 0;
	gint _tmp17_ = 0;
	gint _tmp18_ = 0;
	gint* _tmp19_ = NULL;
	gint _tmp19__length1 = 0;
	gint _tmp20_ = 0;
	gint _tmp21_ = 0;
	gboolean _tmp22_ = FALSE;
	gboolean _tmp23_ = FALSE;
	gboolean _tmp24_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->priv->_x;
	_tmp2_ = value;
	_tmp2__length1 = value_length1;
	_tmp3_ = _tmp2_[0];
	if (_tmp1_ == _tmp3_) {
		gint _tmp4_ = 0;
		gint* _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		gint _tmp6_ = 0;
		_tmp4_ = self->priv->_y;
		_tmp5_ = value;
		_tmp5__length1 = value_length1;
		_tmp6_ = _tmp5_[1];
		_tmp0_ = _tmp4_ == _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		return;
	}
	_tmp8_ = position_get_is_set (self);
	_tmp9_ = _tmp8_;
	if (_tmp9_) {
		gboolean _tmp10_ = FALSE;
		gboolean _tmp11_ = FALSE;
		_tmp10_ = position_get_is_valid (self);
		_tmp11_ = _tmp10_;
		_tmp7_ = _tmp11_;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		_tmp12_ = position_get_x (self);
		_tmp13_ = _tmp12_;
		_tmp14_ = position_get_y (self);
		_tmp15_ = _tmp14_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp13_, (guint) _tmp15_);
	}
	_tmp16_ = value;
	_tmp16__length1 = value_length1;
	_tmp17_ = _tmp16_[0];
	g_signal_emit_by_name (self, "set-x", _tmp17_, &_tmp18_);
	self->priv->_x = _tmp18_;
	_tmp19_ = value;
	_tmp19__length1 = value_length1;
	_tmp20_ = _tmp19_[1];
	g_signal_emit_by_name (self, "set-y", _tmp20_, &_tmp21_);
	self->priv->_y = _tmp21_;
	_tmp23_ = position_get_is_set (self);
	_tmp24_ = _tmp23_;
	if (_tmp24_) {
		gboolean _tmp25_ = FALSE;
		gboolean _tmp26_ = FALSE;
		_tmp25_ = position_get_is_valid (self);
		_tmp26_ = _tmp25_;
		_tmp22_ = _tmp26_;
	} else {
		_tmp22_ = FALSE;
	}
	if (_tmp22_) {
		gint _tmp27_ = 0;
		gint _tmp28_ = 0;
		gint _tmp29_ = 0;
		gint _tmp30_ = 0;
		_tmp27_ = position_get_x (self);
		_tmp28_ = _tmp27_;
		_tmp29_ = position_get_y (self);
		_tmp30_ = _tmp29_;
		g_signal_emit_by_name (self, "redraw", (guint) _tmp28_, (guint) _tmp30_);
	}
}


static void g_cclosure_user_marshal_VOID__UINT_UINT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_UINT) (gpointer data1, guint arg_1, guint arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_UINT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_UINT) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_uint (param_values + 2), data2);
}


static void g_cclosure_user_marshal_BOOLEAN__INT_INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gboolean (*GMarshalFunc_BOOLEAN__INT_INT) (gpointer data1, gint arg_1, gint arg_2, gpointer data2);
	register GMarshalFunc_BOOLEAN__INT_INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gboolean v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_BOOLEAN__INT_INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), g_value_get_int (param_values + 2), data2);
	g_value_set_boolean (return_value, v_return);
}


static void g_cclosure_user_marshal_INT__INT (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef gint (*GMarshalFunc_INT__INT) (gpointer data1, gint arg_1, gpointer data2);
	register GMarshalFunc_INT__INT callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	gint v_return;
	cc = (GCClosure *) closure;
	g_return_if_fail (return_value != NULL);
	g_return_if_fail (n_param_values == 2);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_INT__INT) (marshal_data ? marshal_data : cc->callback);
	v_return = callback (data1, g_value_get_int (param_values + 1), data2);
	g_value_set_int (return_value, v_return);
}


static void position_class_init (PositionClass * klass) {
	position_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PositionPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_position_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_position_set_property;
	G_OBJECT_CLASS (klass)->finalize = position_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_SET, g_param_spec_boolean ("is-set", "is-set", "is-set", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_IS_VALID, g_param_spec_boolean ("is-valid", "is-valid", "is-valid", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_X, g_param_spec_int ("x", "x", "x", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_object_class_install_property (G_OBJECT_CLASS (klass), POSITION_Y, g_param_spec_int ("y", "y", "y", G_MININT, G_MAXINT, 0, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("redraw", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_UINT, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_UINT);
	g_signal_new ("validate", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_BOOLEAN__INT_INT, G_TYPE_BOOLEAN, 2, G_TYPE_INT, G_TYPE_INT);
	g_signal_new ("set_x", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
	g_signal_new ("set_y", TYPE_POSITION, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_INT__INT, G_TYPE_INT, 1, G_TYPE_INT);
}


static void position_instance_init (Position * self) {
	self->priv = POSITION_GET_PRIVATE (self);
	self->priv->_is_set = FALSE;
	self->priv->_x = 0;
	self->priv->_y = 0;
}


static void position_finalize (GObject* obj) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_POSITION, Position);
	G_OBJECT_CLASS (position_parent_class)->finalize (obj);
}


GType position_get_type (void) {
	static volatile gsize position_type_id__volatile = 0;
	if (g_once_init_enter (&position_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (PositionClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) position_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (Position), 0, (GInstanceInitFunc) position_instance_init, NULL };
		GType position_type_id;
		position_type_id = g_type_register_static (G_TYPE_OBJECT, "Position", &g_define_type_info, 0);
		g_once_init_leave (&position_type_id__volatile, position_type_id);
	}
	return position_type_id__volatile;
}


static void _vala_position_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		g_value_set_boolean (value, position_get_is_set (self));
		break;
		case POSITION_IS_VALID:
		g_value_set_boolean (value, position_get_is_valid (self));
		break;
		case POSITION_X:
		g_value_set_int (value, position_get_x (self));
		break;
		case POSITION_Y:
		g_value_set_int (value, position_get_y (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_position_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	Position * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_POSITION, Position);
	switch (property_id) {
		case POSITION_IS_SET:
		position_set_is_set (self, g_value_get_boolean (value));
		break;
		case POSITION_X:
		position_set_x (self, g_value_get_int (value));
		break;
		case POSITION_Y:
		position_set_y (self, g_value_get_int (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


MinefieldView* minefield_view_construct (GType object_type) {
	MinefieldView * self = NULL;
	Position* _tmp0_ = NULL;
	Position* _tmp1_ = NULL;
	cairo_pattern_t** _tmp2_ = NULL;
	self = (MinefieldView*) g_object_new (object_type, NULL);
	gtk_widget_set_events ((GtkWidget*) self, (gint) (((((GDK_EXPOSURE_MASK | GDK_BUTTON_PRESS_MASK) | GDK_POINTER_MOTION_MASK) | GDK_BUTTON_RELEASE_MASK) | GDK_KEY_PRESS_MASK) | GDK_KEY_RELEASE_MASK));
	g_object_set ((GtkWidget*) self, "can-focus", TRUE, NULL);
	_tmp0_ = position_new ();
	_g_object_unref0 (self->priv->selected);
	self->priv->selected = _tmp0_;
	_tmp1_ = position_new ();
	_g_object_unref0 (self->priv->keyboard_cursor);
	self->priv->keyboard_cursor = _tmp1_;
	_tmp2_ = g_new0 (cairo_pattern_t*, 8 + 1);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	self->priv->number_patterns = _tmp2_;
	self->priv->number_patterns_length1 = 8;
	self->priv->_number_patterns_size_ = self->priv->number_patterns_length1;
	return self;
}


MinefieldView* minefield_view_new (void) {
	return minefield_view_construct (TYPE_MINEFIELD_VIEW);
}


void minefield_view_set_use_question_marks (MinefieldView* self, gboolean use_question_marks) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_question_marks;
	self->priv->use_question_marks = _tmp0_;
}


void minefield_view_set_use_overmine_warning (MinefieldView* self, gboolean use_overmine_warning) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_overmine_warning;
	self->priv->use_overmine_warning = _tmp0_;
	gtk_widget_queue_draw ((GtkWidget*) self);
}


void minefield_view_set_use_autoflag (MinefieldView* self, gboolean use_autoflag) {
	gboolean _tmp0_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = use_autoflag;
	self->priv->use_autoflag = _tmp0_;
}


static void minefield_view_explode_cb (MinefieldView* self, Minefield* minefield) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (minefield != NULL);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp0_ = FALSE;
			_tmp0_ = TRUE;
			while (TRUE) {
				gint _tmp2_ = 0;
				Minefield* _tmp3_ = NULL;
				guint _tmp4_ = 0U;
				if (!_tmp0_) {
					gint _tmp1_ = 0;
					_tmp1_ = x;
					x = _tmp1_ + 1;
				}
				_tmp0_ = FALSE;
				_tmp2_ = x;
				_tmp3_ = minefield;
				_tmp4_ = _tmp3_->width;
				if (!(((guint) _tmp2_) < _tmp4_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp5_ = FALSE;
						_tmp5_ = TRUE;
						while (TRUE) {
							gint _tmp7_ = 0;
							Minefield* _tmp8_ = NULL;
							guint _tmp9_ = 0U;
							gboolean _tmp10_ = FALSE;
							Minefield* _tmp11_ = NULL;
							gint _tmp12_ = 0;
							gint _tmp13_ = 0;
							gboolean _tmp14_ = FALSE;
							if (!_tmp5_) {
								gint _tmp6_ = 0;
								_tmp6_ = y;
								y = _tmp6_ + 1;
							}
							_tmp5_ = FALSE;
							_tmp7_ = y;
							_tmp8_ = minefield;
							_tmp9_ = _tmp8_->height;
							if (!(((guint) _tmp7_) < _tmp9_)) {
								break;
							}
							_tmp11_ = minefield;
							_tmp12_ = x;
							_tmp13_ = y;
							_tmp14_ = minefield_has_mine (_tmp11_, (guint) _tmp12_, (guint) _tmp13_);
							if (_tmp14_) {
								_tmp10_ = TRUE;
							} else {
								gboolean _tmp15_ = FALSE;
								Minefield* _tmp16_ = NULL;
								gint _tmp17_ = 0;
								gint _tmp18_ = 0;
								gboolean _tmp19_ = FALSE;
								_tmp16_ = minefield;
								_tmp17_ = x;
								_tmp18_ = y;
								_tmp19_ = minefield_has_mine (_tmp16_, (guint) _tmp17_, (guint) _tmp18_);
								if (!_tmp19_) {
									Minefield* _tmp20_ = NULL;
									gint _tmp21_ = 0;
									gint _tmp22_ = 0;
									FlagType _tmp23_ = 0;
									_tmp20_ = minefield;
									_tmp21_ = x;
									_tmp22_ = y;
									_tmp23_ = minefield_get_flag (_tmp20_, (guint) _tmp21_, (guint) _tmp22_);
									_tmp15_ = _tmp23_ == FLAG_TYPE_FLAG;
								} else {
									_tmp15_ = FALSE;
								}
								_tmp10_ = _tmp15_;
							}
							if (_tmp10_) {
								gint _tmp24_ = 0;
								gint _tmp25_ = 0;
								_tmp24_ = x;
								_tmp25_ = y;
								minefield_view_redraw_sector_cb (self, (guint) _tmp24_, (guint) _tmp25_);
							}
						}
					}
				}
			}
		}
	}
}


static cairo_pattern_t* minefield_view_render_svg_pattern (MinefieldView* self, cairo_t* cr, const gchar* filename) {
	cairo_pattern_t* result = NULL;
	cairo_surface_t* surface = NULL;
	cairo_t* _tmp0_ = NULL;
	cairo_surface_t* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	cairo_surface_t* _tmp6_ = NULL;
	cairo_t* c = NULL;
	cairo_t* _tmp7_ = NULL;
	gdouble size = 0.0;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	cairo_pattern_t* pattern = NULL;
	cairo_pattern_t* _tmp20_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (cr != NULL, NULL);
	g_return_val_if_fail (filename != NULL, NULL);
	_tmp0_ = cr;
	_tmp1_ = cairo_get_target (_tmp0_);
	_tmp2_ = minefield_view_get_mine_size (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = cairo_surface_create_similar (_tmp1_, CAIRO_CONTENT_COLOR_ALPHA, (gint) _tmp3_, (gint) _tmp5_);
	surface = _tmp6_;
	_tmp7_ = cairo_create (surface);
	c = _tmp7_;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	size = ((gdouble) _tmp9_) - 2;
	{
		RsvgHandle* h = NULL;
		const gchar* _tmp10_ = NULL;
		RsvgHandle* _tmp11_ = NULL;
		cairo_matrix_t m = {0};
		gint _tmp12_ = 0;
		gint _tmp13_ = 0;
		gint _tmp14_ = 0;
		gint _tmp15_ = 0;
		cairo_matrix_t _tmp16_ = {0};
		_tmp10_ = filename;
		_tmp11_ = rsvg_handle_new_from_file (_tmp10_, &_inner_error_);
		h = _tmp11_;
		if (_inner_error_ != NULL) {
			goto __catch4_g_error;
		}
		cairo_matrix_init_identity (&m);
		cairo_matrix_translate (&m, 1.0, 1.0);
		g_object_get (h, "width", &_tmp12_, NULL);
		_tmp13_ = _tmp12_;
		g_object_get (h, "height", &_tmp14_, NULL);
		_tmp15_ = _tmp14_;
		cairo_matrix_scale (&m, size / _tmp13_, size / _tmp15_);
		_tmp16_ = m;
		cairo_set_matrix (c, &_tmp16_);
		rsvg_handle_render_cairo (h, c);
		_g_object_unref0 (h);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp17_ = NULL;
		GError* _tmp18_ = NULL;
		const gchar* _tmp19_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp17_ = filename;
		_tmp18_ = e;
		_tmp19_ = _tmp18_->message;
		g_warning ("minefield-view.vala:239: Failed to load texture %s: %s", _tmp17_, _tmp19_);
		_g_error_free0 (e);
	}
	__finally4:
	if (_inner_error_ != NULL) {
		_cairo_destroy0 (c);
		_cairo_surface_destroy0 (surface);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp20_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp20_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	return result;
}


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static cairo_pattern_t* minefield_view_render_number_pattern (MinefieldView* self, guint n) {
	cairo_pattern_t* result = NULL;
	PangoLayout* layout = NULL;
	guint _tmp0_ = 0U;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	PangoLayout* _tmp3_ = NULL;
	PangoLayout* _tmp4_ = NULL;
	PangoLayout* _tmp5_ = NULL;
	PangoAttrList* attributes = NULL;
	PangoAttrList* _tmp6_ = NULL;
	PangoAttribute* color_attribute = NULL;
	gdouble color_outline[3] = {0};
	guint _tmp7_ = 0U;
	PangoAttribute* _tmp24_ = NULL;
	PangoAttribute* _tmp25_ = NULL;
	guint _tmp26_ = 0U;
	PangoAttrList* _tmp27_ = NULL;
	PangoAttribute* _tmp28_ = NULL;
	PangoFontDescription* font_desc = NULL;
	PangoFontDescription* _tmp29_ = NULL;
	gdouble font_size = 0.0;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	PangoAttrFontDesc* font_attribute = NULL;
	PangoAttrFontDesc* _tmp32_ = NULL;
	PangoAttrFontDesc* _tmp33_ = NULL;
	PangoAttrFontDesc* _tmp34_ = NULL;
	guint _tmp35_ = 0U;
	PangoAttrList* _tmp36_ = NULL;
	PangoAttrFontDesc* _tmp37_ = NULL;
	PangoLayout* _tmp38_ = NULL;
	PangoAttrList* _tmp39_ = NULL;
	cairo_surface_t* surface = NULL;
	guint _tmp40_ = 0U;
	guint _tmp41_ = 0U;
	guint _tmp42_ = 0U;
	guint _tmp43_ = 0U;
	cairo_surface_t* _tmp44_ = NULL;
	cairo_t* c = NULL;
	cairo_t* _tmp45_ = NULL;
	PangoRectangle extent = {0};
	PangoLayout* _tmp46_ = NULL;
	PangoRectangle _tmp47_ = {0};
	gint dx = 0;
	guint _tmp48_ = 0U;
	guint _tmp49_ = 0U;
	PangoRectangle _tmp50_ = {0};
	gint _tmp51_ = 0;
	gint dy = 0;
	guint _tmp52_ = 0U;
	guint _tmp53_ = 0U;
	PangoRectangle _tmp54_ = {0};
	gint _tmp55_ = 0;
	PangoLayout* _tmp56_ = NULL;
	cairo_pattern_t* pattern = NULL;
	cairo_pattern_t* _tmp57_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = n;
	_tmp1_ = g_strdup_printf ("%u", _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = gtk_widget_create_pango_layout ((GtkWidget*) self, _tmp2_);
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp2_);
	layout = _tmp4_;
	_tmp5_ = layout;
	pango_layout_set_alignment (_tmp5_, PANGO_ALIGN_CENTER);
	_tmp6_ = pango_attr_list_new ();
	attributes = _tmp6_;
	_tmp7_ = n;
	switch (_tmp7_) {
		case 1:
		{
			PangoAttribute* _tmp8_ = NULL;
			gdouble _tmp9_[3] = {0};
			_tmp8_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp8_;
			_tmp9_[0] = 0.0;
			_tmp9_[1] = 0.0;
			_tmp9_[2] = 0.5;
			memcpy (color_outline, _tmp9_, 3 * sizeof (gdouble));
			break;
		}
		case 2:
		{
			PangoAttribute* _tmp10_ = NULL;
			gdouble _tmp11_[3] = {0};
			_tmp10_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xa0a0, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp10_;
			_tmp11_[0] = 0.0;
			_tmp11_[1] = 0.5 * 0.62745098039;
			_tmp11_[2] = 0.0;
			memcpy (color_outline, _tmp11_, 3 * sizeof (gdouble));
			break;
		}
		case 3:
		{
			PangoAttribute* _tmp12_ = NULL;
			gdouble _tmp13_[3] = {0};
			_tmp12_ = pango_attr_foreground_new ((guint16) 0xffff, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp12_;
			_tmp13_[0] = 0.5;
			_tmp13_[1] = 0.0;
			_tmp13_[2] = 0.0;
			memcpy (color_outline, _tmp13_, 3 * sizeof (gdouble));
			break;
		}
		case 4:
		{
			PangoAttribute* _tmp14_ = NULL;
			gdouble _tmp15_[3] = {0};
			_tmp14_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x7fff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp14_;
			_tmp15_[0] = 0.0;
			_tmp15_[1] = 0.0;
			_tmp15_[2] = 0.5 * 0.49999237048;
			memcpy (color_outline, _tmp15_, 3 * sizeof (gdouble));
			break;
		}
		case 5:
		{
			PangoAttribute* _tmp16_ = NULL;
			gdouble _tmp17_[3] = {0};
			_tmp16_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp16_;
			_tmp17_[0] = 0.5 * 0.62745098039;
			_tmp17_[1] = 0.0;
			_tmp17_[2] = 0.0;
			memcpy (color_outline, _tmp17_, 3 * sizeof (gdouble));
			break;
		}
		case 6:
		{
			PangoAttribute* _tmp18_ = NULL;
			gdouble _tmp19_[3] = {0};
			_tmp18_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0xffff, (guint16) 0xffff);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp18_;
			_tmp19_[0] = 0.0;
			_tmp19_[1] = 0.5;
			_tmp19_[2] = 0.5;
			memcpy (color_outline, _tmp19_, 3 * sizeof (gdouble));
			break;
		}
		case 7:
		{
			PangoAttribute* _tmp20_ = NULL;
			gdouble _tmp21_[3] = {0};
			_tmp20_ = pango_attr_foreground_new ((guint16) 0xa0a0, (guint16) 0x0000, (guint16) 0xa0a0);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp20_;
			_tmp21_[0] = 0.5 * 0.62745098039;
			_tmp21_[1] = 0.0;
			_tmp21_[2] = 0.5 * 0.62745098039;
			memcpy (color_outline, _tmp21_, 3 * sizeof (gdouble));
			break;
		}
		default:
		case 8:
		{
			PangoAttribute* _tmp22_ = NULL;
			gdouble _tmp23_[3] = {0};
			_tmp22_ = pango_attr_foreground_new ((guint16) 0x0000, (guint16) 0x0000, (guint16) 0x0000);
			_pango_attribute_destroy0 (color_attribute);
			color_attribute = _tmp22_;
			_tmp23_[0] = 0.0;
			_tmp23_[1] = 0.0;
			_tmp23_[2] = 0.0;
			memcpy (color_outline, _tmp23_, 3 * sizeof (gdouble));
			break;
		}
	}
	_tmp24_ = color_attribute;
	_tmp24_->start_index = (guint) 0;
	_tmp25_ = color_attribute;
	_tmp26_ = G_MAXUINT;
	_tmp25_->end_index = _tmp26_;
	_tmp27_ = attributes;
	_tmp28_ = color_attribute;
	color_attribute = NULL;
	pango_attr_list_insert (_tmp27_, _tmp28_);
	_tmp29_ = pango_font_description_new ();
	font_desc = _tmp29_;
	pango_font_description_set_family (font_desc, "Sans");
	_tmp30_ = minefield_view_get_mine_size (self);
	_tmp31_ = _tmp30_;
	font_size = ((_tmp31_ - 2) * PANGO_SCALE) * 0.85;
	pango_font_description_set_absolute_size (font_desc, font_size);
	pango_font_description_set_weight (font_desc, PANGO_WEIGHT_BOLD);
	_tmp32_ = (PangoAttrFontDesc*) pango_attr_font_desc_new (font_desc);
	font_attribute = _tmp32_;
	_tmp33_ = font_attribute;
	((PangoAttribute*) _tmp33_)->start_index = (guint) 0;
	_tmp34_ = font_attribute;
	_tmp35_ = G_MAXUINT;
	((PangoAttribute*) _tmp34_)->end_index = _tmp35_;
	_tmp36_ = attributes;
	_tmp37_ = font_attribute;
	font_attribute = NULL;
	pango_attr_list_insert (_tmp36_, (PangoAttribute*) _tmp37_);
	_tmp38_ = layout;
	_tmp39_ = attributes;
	pango_layout_set_attributes (_tmp38_, _tmp39_);
	_tmp40_ = minefield_view_get_mine_size (self);
	_tmp41_ = _tmp40_;
	_tmp42_ = minefield_view_get_mine_size (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = cairo_image_surface_create (CAIRO_FORMAT_ARGB32, (gint) _tmp41_, (gint) _tmp43_);
	surface = _tmp44_;
	_tmp45_ = cairo_create (surface);
	c = _tmp45_;
	_tmp46_ = layout;
	pango_layout_get_extents (_tmp46_, NULL, &_tmp47_);
	extent = _tmp47_;
	_tmp48_ = minefield_view_get_mine_size (self);
	_tmp49_ = _tmp48_;
	_tmp50_ = extent;
	_tmp51_ = _tmp50_.width;
	dx = (((((gint) _tmp49_) - 2) - (_tmp51_ / PANGO_SCALE)) / 2) + 1;
	_tmp52_ = minefield_view_get_mine_size (self);
	_tmp53_ = _tmp52_;
	_tmp54_ = extent;
	_tmp55_ = _tmp54_.height;
	dy = (((((gint) _tmp53_) - 2) - (_tmp55_ / PANGO_SCALE)) / 2) + 1;
	cairo_move_to (c, (gdouble) dx, (gdouble) dy);
	_tmp56_ = layout;
	pango_cairo_show_layout (c, _tmp56_);
	_tmp57_ = cairo_pattern_create_for_surface (surface);
	pattern = _tmp57_;
	cairo_pattern_set_extend (pattern, CAIRO_EXTEND_REPEAT);
	result = pattern;
	_cairo_destroy0 (c);
	_cairo_surface_destroy0 (surface);
	_pango_attribute_destroy0 (font_attribute);
	__vala_PangoFontDescription_free0 (font_desc);
	_pango_attribute_destroy0 (color_attribute);
	_pango_attr_list_unref0 (attributes);
	_g_object_unref0 (layout);
	return result;
}


static void minefield_view_real_get_preferred_width (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_real_get_preferred_height (GtkWidget* base, gint* minimum, gint* natural) {
	MinefieldView * self;
	gint _vala_minimum = 0;
	gint _vala_natural = 0;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	self = (MinefieldView*) base;
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->height;
	_tmp3_ = minefield_view_get_minimum_size (self);
	_tmp4_ = _tmp3_;
	_vala_natural = (gint) (_tmp2_ * _tmp4_);
	_vala_minimum = _vala_natural;
	if (minimum) {
		*minimum = _vala_minimum;
	}
	if (natural) {
		*natural = _vala_natural;
	}
}


static void minefield_view_redraw_sector_cb (MinefieldView* self, guint x, guint y) {
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	guint _tmp11_ = 0U;
	guint _tmp12_ = 0U;
	guint _tmp13_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_x_offset (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = minefield_view_get_mine_size (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = minefield_view_get_y_offset (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = y;
	_tmp8_ = minefield_view_get_mine_size (self);
	_tmp9_ = _tmp8_;
	_tmp10_ = minefield_view_get_mine_size (self);
	_tmp11_ = _tmp10_;
	_tmp12_ = minefield_view_get_mine_size (self);
	_tmp13_ = _tmp12_;
	gtk_widget_queue_draw_area ((GtkWidget*) self, (gint) (_tmp1_ + (_tmp2_ * _tmp4_)), (gint) (_tmp6_ + (_tmp7_ * _tmp9_)), (gint) _tmp11_, (gint) _tmp13_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void minefield_view_draw_square (MinefieldView* self, cairo_t* cr, guint x, guint y) {
	gboolean is_down = FALSE;
	gboolean _tmp0_ = FALSE;
	Position* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp59_ = NULL;
	Minefield* _tmp60_ = NULL;
	guint _tmp61_ = 0U;
	guint _tmp62_ = 0U;
	gboolean _tmp63_ = FALSE;
	g_return_if_fail (self != NULL);
	g_return_if_fail (cr != NULL);
	is_down = FALSE;
	_tmp1_ = self->priv->selected;
	_tmp2_ = position_get_is_valid (_tmp1_);
	_tmp3_ = _tmp2_;
	if (_tmp3_) {
		Position* _tmp4_ = NULL;
		gboolean _tmp5_ = FALSE;
		gboolean _tmp6_ = FALSE;
		_tmp4_ = self->priv->selected;
		_tmp5_ = position_get_is_set (_tmp4_);
		_tmp6_ = _tmp5_;
		_tmp0_ = _tmp6_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		guint _tmp9_ = 0U;
		Position* _tmp10_ = NULL;
		gint _tmp11_ = 0;
		gint _tmp12_ = 0;
		gboolean _tmp22_ = FALSE;
		gboolean _tmp23_ = FALSE;
		_tmp9_ = x;
		_tmp10_ = self->priv->selected;
		_tmp11_ = position_get_x (_tmp10_);
		_tmp12_ = _tmp11_;
		if (_tmp9_ == ((guint) _tmp12_)) {
			guint _tmp13_ = 0U;
			Position* _tmp14_ = NULL;
			gint _tmp15_ = 0;
			gint _tmp16_ = 0;
			_tmp13_ = y;
			_tmp14_ = self->priv->selected;
			_tmp15_ = position_get_y (_tmp14_);
			_tmp16_ = _tmp15_;
			_tmp8_ = _tmp13_ == ((guint) _tmp16_);
		} else {
			_tmp8_ = FALSE;
		}
		if (_tmp8_) {
			Minefield* _tmp17_ = NULL;
			Minefield* _tmp18_ = NULL;
			guint _tmp19_ = 0U;
			guint _tmp20_ = 0U;
			FlagType _tmp21_ = 0;
			_tmp17_ = minefield_view_get_minefield (self);
			_tmp18_ = _tmp17_;
			_tmp19_ = x;
			_tmp20_ = y;
			_tmp21_ = minefield_get_flag (_tmp18_, _tmp19_, _tmp20_);
			_tmp7_ = _tmp21_ != FLAG_TYPE_FLAG;
		} else {
			_tmp7_ = FALSE;
		}
		is_down = _tmp7_;
		_tmp23_ = is_down;
		if (!_tmp23_) {
			Minefield* _tmp24_ = NULL;
			Minefield* _tmp25_ = NULL;
			Position* _tmp26_ = NULL;
			gint _tmp27_ = 0;
			gint _tmp28_ = 0;
			Position* _tmp29_ = NULL;
			gint _tmp30_ = 0;
			gint _tmp31_ = 0;
			gboolean _tmp32_ = FALSE;
			_tmp24_ = minefield_view_get_minefield (self);
			_tmp25_ = _tmp24_;
			_tmp26_ = self->priv->selected;
			_tmp27_ = position_get_x (_tmp26_);
			_tmp28_ = _tmp27_;
			_tmp29_ = self->priv->selected;
			_tmp30_ = position_get_y (_tmp29_);
			_tmp31_ = _tmp30_;
			_tmp32_ = minefield_is_cleared (_tmp25_, (guint) _tmp28_, (guint) _tmp31_);
			_tmp22_ = _tmp32_;
		} else {
			_tmp22_ = FALSE;
		}
		if (_tmp22_) {
			{
				Neighbour* neighbour_collection = NULL;
				gint neighbour_collection_length1 = 0;
				gint _neighbour_collection_size_ = 0;
				gint neighbour_it = 0;
				neighbour_collection = neighbour_map;
				neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
				for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
					Neighbour neighbour = {0};
					neighbour = neighbour_collection[neighbour_it];
					{
						gint nx = 0;
						Position* _tmp33_ = NULL;
						gint _tmp34_ = 0;
						gint _tmp35_ = 0;
						Neighbour _tmp36_ = {0};
						gint _tmp37_ = 0;
						gint ny = 0;
						Position* _tmp38_ = NULL;
						gint _tmp39_ = 0;
						gint _tmp40_ = 0;
						Neighbour _tmp41_ = {0};
						gint _tmp42_ = 0;
						Minefield* _tmp43_ = NULL;
						Minefield* _tmp44_ = NULL;
						gint _tmp45_ = 0;
						gint _tmp46_ = 0;
						gboolean _tmp47_ = FALSE;
						gboolean _tmp48_ = FALSE;
						gboolean _tmp49_ = FALSE;
						guint _tmp50_ = 0U;
						gint _tmp51_ = 0;
						_tmp33_ = self->priv->selected;
						_tmp34_ = position_get_x (_tmp33_);
						_tmp35_ = _tmp34_;
						_tmp36_ = neighbour;
						_tmp37_ = _tmp36_.x;
						nx = ((gint) _tmp35_) + _tmp37_;
						_tmp38_ = self->priv->selected;
						_tmp39_ = position_get_y (_tmp38_);
						_tmp40_ = _tmp39_;
						_tmp41_ = neighbour;
						_tmp42_ = _tmp41_.y;
						ny = ((gint) _tmp40_) + _tmp42_;
						_tmp43_ = minefield_view_get_minefield (self);
						_tmp44_ = _tmp43_;
						_tmp45_ = nx;
						_tmp46_ = ny;
						_tmp47_ = minefield_is_location (_tmp44_, _tmp45_, _tmp46_);
						if (!_tmp47_) {
							continue;
						}
						_tmp50_ = x;
						_tmp51_ = nx;
						if (_tmp50_ == ((guint) _tmp51_)) {
							guint _tmp52_ = 0U;
							gint _tmp53_ = 0;
							_tmp52_ = y;
							_tmp53_ = ny;
							_tmp49_ = _tmp52_ == ((guint) _tmp53_);
						} else {
							_tmp49_ = FALSE;
						}
						if (_tmp49_) {
							Minefield* _tmp54_ = NULL;
							Minefield* _tmp55_ = NULL;
							gint _tmp56_ = 0;
							gint _tmp57_ = 0;
							FlagType _tmp58_ = 0;
							_tmp54_ = minefield_view_get_minefield (self);
							_tmp55_ = _tmp54_;
							_tmp56_ = nx;
							_tmp57_ = ny;
							_tmp58_ = minefield_get_flag (_tmp55_, (guint) _tmp56_, (guint) _tmp57_);
							_tmp48_ = _tmp58_ != FLAG_TYPE_FLAG;
						} else {
							_tmp48_ = FALSE;
						}
						if (_tmp48_) {
							is_down = TRUE;
						}
					}
				}
			}
		}
	}
	_tmp59_ = minefield_view_get_minefield (self);
	_tmp60_ = _tmp59_;
	_tmp61_ = x;
	_tmp62_ = y;
	_tmp63_ = minefield_is_cleared (_tmp60_, _tmp61_, _tmp62_);
	if (_tmp63_) {
		Minefield* _tmp64_ = NULL;
		Minefield* _tmp65_ = NULL;
		gboolean _tmp66_ = FALSE;
		gboolean _tmp67_ = FALSE;
		Minefield* _tmp68_ = NULL;
		Minefield* _tmp69_ = NULL;
		guint _tmp70_ = 0U;
		guint _tmp71_ = 0U;
		gboolean _tmp72_ = FALSE;
		_tmp64_ = minefield_view_get_minefield (self);
		_tmp65_ = _tmp64_;
		_tmp66_ = minefield_get_paused (_tmp65_);
		_tmp67_ = _tmp66_;
		if (_tmp67_) {
			return;
		}
		_tmp68_ = minefield_view_get_minefield (self);
		_tmp69_ = _tmp68_;
		_tmp70_ = x;
		_tmp71_ = y;
		_tmp72_ = minefield_has_mine (_tmp69_, _tmp70_, _tmp71_);
		if (_tmp72_) {
			cairo_pattern_t* _tmp73_ = NULL;
			cairo_t* _tmp78_ = NULL;
			cairo_pattern_t* _tmp79_ = NULL;
			cairo_t* _tmp80_ = NULL;
			guint _tmp81_ = 0U;
			guint _tmp82_ = 0U;
			guint _tmp83_ = 0U;
			guint _tmp84_ = 0U;
			cairo_t* _tmp85_ = NULL;
			_tmp73_ = self->priv->bang_pattern;
			if (_tmp73_ == NULL) {
				cairo_t* _tmp74_ = NULL;
				gchar* _tmp75_ = NULL;
				gchar* _tmp76_ = NULL;
				cairo_pattern_t* _tmp77_ = NULL;
				_tmp74_ = cr;
				_tmp75_ = g_build_filename (DATA_DIRECTORY, "bang.svg", NULL);
				_tmp76_ = _tmp75_;
				_tmp77_ = minefield_view_render_svg_pattern (self, _tmp74_, _tmp76_);
				_cairo_pattern_destroy0 (self->priv->bang_pattern);
				self->priv->bang_pattern = _tmp77_;
				_g_free0 (_tmp76_);
			}
			_tmp78_ = cr;
			_tmp79_ = self->priv->bang_pattern;
			cairo_set_source (_tmp78_, _tmp79_);
			_tmp80_ = cr;
			_tmp81_ = minefield_view_get_mine_size (self);
			_tmp82_ = _tmp81_;
			_tmp83_ = minefield_view_get_mine_size (self);
			_tmp84_ = _tmp83_;
			cairo_rectangle (_tmp80_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp82_, (gdouble) _tmp84_);
			_tmp85_ = cr;
			cairo_fill (_tmp85_);
		} else {
			gboolean _tmp86_ = FALSE;
			gboolean _tmp87_ = FALSE;
			guint n = 0U;
			Minefield* _tmp106_ = NULL;
			Minefield* _tmp107_ = NULL;
			guint _tmp108_ = 0U;
			guint _tmp109_ = 0U;
			guint _tmp110_ = 0U;
			guint _tmp111_ = 0U;
			_tmp87_ = self->priv->use_overmine_warning;
			if (_tmp87_) {
				Minefield* _tmp88_ = NULL;
				Minefield* _tmp89_ = NULL;
				guint _tmp90_ = 0U;
				guint _tmp91_ = 0U;
				gboolean _tmp92_ = FALSE;
				_tmp88_ = minefield_view_get_minefield (self);
				_tmp89_ = _tmp88_;
				_tmp90_ = x;
				_tmp91_ = y;
				_tmp92_ = minefield_has_flag_warning (_tmp89_, _tmp90_, _tmp91_);
				_tmp86_ = _tmp92_;
			} else {
				_tmp86_ = FALSE;
			}
			if (_tmp86_) {
				cairo_pattern_t* _tmp93_ = NULL;
				cairo_t* _tmp98_ = NULL;
				cairo_pattern_t* _tmp99_ = NULL;
				cairo_t* _tmp100_ = NULL;
				guint _tmp101_ = 0U;
				guint _tmp102_ = 0U;
				guint _tmp103_ = 0U;
				guint _tmp104_ = 0U;
				cairo_t* _tmp105_ = NULL;
				_tmp93_ = self->priv->warning_pattern;
				if (_tmp93_ == NULL) {
					cairo_t* _tmp94_ = NULL;
					gchar* _tmp95_ = NULL;
					gchar* _tmp96_ = NULL;
					cairo_pattern_t* _tmp97_ = NULL;
					_tmp94_ = cr;
					_tmp95_ = g_build_filename (DATA_DIRECTORY, "warning.svg", NULL);
					_tmp96_ = _tmp95_;
					_tmp97_ = minefield_view_render_svg_pattern (self, _tmp94_, _tmp96_);
					_cairo_pattern_destroy0 (self->priv->warning_pattern);
					self->priv->warning_pattern = _tmp97_;
					_g_free0 (_tmp96_);
				}
				_tmp98_ = cr;
				_tmp99_ = self->priv->warning_pattern;
				cairo_set_source (_tmp98_, _tmp99_);
				_tmp100_ = cr;
				_tmp101_ = minefield_view_get_mine_size (self);
				_tmp102_ = _tmp101_;
				_tmp103_ = minefield_view_get_mine_size (self);
				_tmp104_ = _tmp103_;
				cairo_rectangle (_tmp100_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp102_, (gdouble) _tmp104_);
				_tmp105_ = cr;
				cairo_fill (_tmp105_);
			}
			_tmp106_ = minefield_view_get_minefield (self);
			_tmp107_ = _tmp106_;
			_tmp108_ = x;
			_tmp109_ = y;
			_tmp110_ = minefield_get_n_adjacent_mines (_tmp107_, _tmp108_, _tmp109_);
			n = _tmp110_;
			_tmp111_ = n;
			if (_tmp111_ != ((guint) 0)) {
				cairo_pattern_t** _tmp112_ = NULL;
				gint _tmp112__length1 = 0;
				guint _tmp113_ = 0U;
				cairo_pattern_t* _tmp114_ = NULL;
				cairo_t* _tmp120_ = NULL;
				cairo_pattern_t** _tmp121_ = NULL;
				gint _tmp121__length1 = 0;
				guint _tmp122_ = 0U;
				cairo_pattern_t* _tmp123_ = NULL;
				cairo_t* _tmp124_ = NULL;
				guint _tmp125_ = 0U;
				guint _tmp126_ = 0U;
				guint _tmp127_ = 0U;
				guint _tmp128_ = 0U;
				cairo_t* _tmp129_ = NULL;
				_tmp112_ = self->priv->number_patterns;
				_tmp112__length1 = self->priv->number_patterns_length1;
				_tmp113_ = n;
				_tmp114_ = _tmp112_[_tmp113_ - 1];
				if (_tmp114_ == NULL) {
					cairo_pattern_t** _tmp115_ = NULL;
					gint _tmp115__length1 = 0;
					guint _tmp116_ = 0U;
					guint _tmp117_ = 0U;
					cairo_pattern_t* _tmp118_ = NULL;
					cairo_pattern_t* _tmp119_ = NULL;
					_tmp115_ = self->priv->number_patterns;
					_tmp115__length1 = self->priv->number_patterns_length1;
					_tmp116_ = n;
					_tmp117_ = n;
					_tmp118_ = minefield_view_render_number_pattern (self, _tmp117_);
					_cairo_pattern_destroy0 (_tmp115_[_tmp116_ - 1]);
					_tmp115_[_tmp116_ - 1] = _tmp118_;
					_tmp119_ = _tmp115_[_tmp116_ - 1];
				}
				_tmp120_ = cr;
				_tmp121_ = self->priv->number_patterns;
				_tmp121__length1 = self->priv->number_patterns_length1;
				_tmp122_ = n;
				_tmp123_ = _tmp121_[_tmp122_ - 1];
				cairo_set_source (_tmp120_, _tmp123_);
				_tmp124_ = cr;
				_tmp125_ = minefield_view_get_mine_size (self);
				_tmp126_ = _tmp125_;
				_tmp127_ = minefield_view_get_mine_size (self);
				_tmp128_ = _tmp127_;
				cairo_rectangle (_tmp124_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp126_, (gdouble) _tmp128_);
				_tmp129_ = cr;
				cairo_fill (_tmp129_);
			}
		}
	} else {
		GtkStyleContext* style_context = NULL;
		GtkStyleContext* _tmp130_ = NULL;
		GtkStyleContext* _tmp131_ = NULL;
		GtkStyleContext* _tmp132_ = NULL;
		GtkStyleContext* _tmp133_ = NULL;
		GtkStateFlags _tmp134_ = 0;
		gboolean _tmp135_ = FALSE;
		GtkStyleContext* _tmp136_ = NULL;
		GtkStyleContext* _tmp137_ = NULL;
		cairo_t* _tmp138_ = NULL;
		guint _tmp139_ = 0U;
		guint _tmp140_ = 0U;
		guint _tmp141_ = 0U;
		guint _tmp142_ = 0U;
		GtkStyleContext* _tmp143_ = NULL;
		cairo_t* _tmp144_ = NULL;
		guint _tmp145_ = 0U;
		guint _tmp146_ = 0U;
		guint _tmp147_ = 0U;
		guint _tmp148_ = 0U;
		GtkStyleContext* _tmp149_ = NULL;
		Minefield* _tmp150_ = NULL;
		Minefield* _tmp151_ = NULL;
		gboolean _tmp152_ = FALSE;
		gboolean _tmp153_ = FALSE;
		Minefield* _tmp154_ = NULL;
		Minefield* _tmp155_ = NULL;
		guint _tmp156_ = 0U;
		guint _tmp157_ = 0U;
		FlagType _tmp158_ = 0;
		_tmp130_ = gtk_widget_get_style_context ((GtkWidget*) self);
		_tmp131_ = _g_object_ref0 (_tmp130_);
		style_context = _tmp131_;
		_tmp132_ = style_context;
		gtk_style_context_save (_tmp132_);
		_tmp133_ = style_context;
		gtk_style_context_add_class (_tmp133_, GTK_STYLE_CLASS_BUTTON);
		_tmp135_ = is_down;
		if (_tmp135_) {
			_tmp134_ = GTK_STATE_FLAG_ACTIVE;
		} else {
			_tmp134_ = GTK_STATE_FLAG_NORMAL;
		}
		_tmp136_ = style_context;
		gtk_style_context_set_state (_tmp136_, _tmp134_);
		_tmp137_ = style_context;
		_tmp138_ = cr;
		_tmp139_ = minefield_view_get_mine_size (self);
		_tmp140_ = _tmp139_;
		_tmp141_ = minefield_view_get_mine_size (self);
		_tmp142_ = _tmp141_;
		gtk_render_frame (_tmp137_, _tmp138_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp140_), (gdouble) ((gint) _tmp142_));
		_tmp143_ = style_context;
		_tmp144_ = cr;
		_tmp145_ = minefield_view_get_mine_size (self);
		_tmp146_ = _tmp145_;
		_tmp147_ = minefield_view_get_mine_size (self);
		_tmp148_ = _tmp147_;
		gtk_render_background (_tmp143_, _tmp144_, (gdouble) 0, (gdouble) 0, (gdouble) ((gint) _tmp146_), (gdouble) ((gint) _tmp148_));
		_tmp149_ = style_context;
		gtk_style_context_restore (_tmp149_);
		_tmp150_ = minefield_view_get_minefield (self);
		_tmp151_ = _tmp150_;
		_tmp152_ = minefield_get_paused (_tmp151_);
		_tmp153_ = _tmp152_;
		if (_tmp153_) {
			_g_object_unref0 (style_context);
			return;
		}
		_tmp154_ = minefield_view_get_minefield (self);
		_tmp155_ = _tmp154_;
		_tmp156_ = x;
		_tmp157_ = y;
		_tmp158_ = minefield_get_flag (_tmp155_, _tmp156_, _tmp157_);
		if (_tmp158_ == FLAG_TYPE_FLAG) {
			cairo_pattern_t* _tmp159_ = NULL;
			cairo_t* _tmp164_ = NULL;
			cairo_pattern_t* _tmp165_ = NULL;
			cairo_t* _tmp166_ = NULL;
			guint _tmp167_ = 0U;
			guint _tmp168_ = 0U;
			guint _tmp169_ = 0U;
			guint _tmp170_ = 0U;
			cairo_t* _tmp171_ = NULL;
			gboolean _tmp172_ = FALSE;
			Minefield* _tmp173_ = NULL;
			Minefield* _tmp174_ = NULL;
			gboolean _tmp175_ = FALSE;
			_tmp159_ = self->priv->flag_pattern;
			if (_tmp159_ == NULL) {
				cairo_t* _tmp160_ = NULL;
				gchar* _tmp161_ = NULL;
				gchar* _tmp162_ = NULL;
				cairo_pattern_t* _tmp163_ = NULL;
				_tmp160_ = cr;
				_tmp161_ = g_build_filename (DATA_DIRECTORY, "flag.svg", NULL);
				_tmp162_ = _tmp161_;
				_tmp163_ = minefield_view_render_svg_pattern (self, _tmp160_, _tmp162_);
				_cairo_pattern_destroy0 (self->priv->flag_pattern);
				self->priv->flag_pattern = _tmp163_;
				_g_free0 (_tmp162_);
			}
			_tmp164_ = cr;
			_tmp165_ = self->priv->flag_pattern;
			cairo_set_source (_tmp164_, _tmp165_);
			_tmp166_ = cr;
			_tmp167_ = minefield_view_get_mine_size (self);
			_tmp168_ = _tmp167_;
			_tmp169_ = minefield_view_get_mine_size (self);
			_tmp170_ = _tmp169_;
			cairo_rectangle (_tmp166_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp168_, (gdouble) _tmp170_);
			_tmp171_ = cr;
			cairo_fill (_tmp171_);
			_tmp173_ = minefield_view_get_minefield (self);
			_tmp174_ = _tmp173_;
			_tmp175_ = _tmp174_->exploded;
			if (_tmp175_) {
				Minefield* _tmp176_ = NULL;
				Minefield* _tmp177_ = NULL;
				guint _tmp178_ = 0U;
				guint _tmp179_ = 0U;
				gboolean _tmp180_ = FALSE;
				_tmp176_ = minefield_view_get_minefield (self);
				_tmp177_ = _tmp176_;
				_tmp178_ = x;
				_tmp179_ = y;
				_tmp180_ = minefield_has_mine (_tmp177_, _tmp178_, _tmp179_);
				_tmp172_ = !_tmp180_;
			} else {
				_tmp172_ = FALSE;
			}
			if (_tmp172_) {
				gdouble x1 = 0.0;
				guint _tmp181_ = 0U;
				guint _tmp182_ = 0U;
				gdouble y1 = 0.0;
				guint _tmp183_ = 0U;
				guint _tmp184_ = 0U;
				gdouble x2 = 0.0;
				guint _tmp185_ = 0U;
				guint _tmp186_ = 0U;
				gdouble y2 = 0.0;
				guint _tmp187_ = 0U;
				guint _tmp188_ = 0U;
				cairo_t* _tmp189_ = NULL;
				gdouble _tmp190_ = 0.0;
				gdouble _tmp191_ = 0.0;
				cairo_t* _tmp192_ = NULL;
				gdouble _tmp193_ = 0.0;
				gdouble _tmp194_ = 0.0;
				cairo_t* _tmp195_ = NULL;
				gdouble _tmp196_ = 0.0;
				gdouble _tmp197_ = 0.0;
				cairo_t* _tmp198_ = NULL;
				gdouble _tmp199_ = 0.0;
				gdouble _tmp200_ = 0.0;
				cairo_t* _tmp201_ = NULL;
				cairo_t* _tmp202_ = NULL;
				cairo_t* _tmp203_ = NULL;
				guint _tmp204_ = 0U;
				guint _tmp205_ = 0U;
				gdouble _tmp206_ = 0.0;
				cairo_t* _tmp207_ = NULL;
				cairo_t* _tmp208_ = NULL;
				cairo_t* _tmp209_ = NULL;
				cairo_t* _tmp210_ = NULL;
				_tmp181_ = minefield_view_get_mine_size (self);
				_tmp182_ = _tmp181_;
				x1 = 0.1 * _tmp182_;
				_tmp183_ = minefield_view_get_mine_size (self);
				_tmp184_ = _tmp183_;
				y1 = 0.1 * _tmp184_;
				_tmp185_ = minefield_view_get_mine_size (self);
				_tmp186_ = _tmp185_;
				x2 = 0.9 * _tmp186_;
				_tmp187_ = minefield_view_get_mine_size (self);
				_tmp188_ = _tmp187_;
				y2 = 0.9 * _tmp188_;
				_tmp189_ = cr;
				_tmp190_ = x1;
				_tmp191_ = y1;
				cairo_move_to (_tmp189_, _tmp190_, _tmp191_);
				_tmp192_ = cr;
				_tmp193_ = x2;
				_tmp194_ = y2;
				cairo_line_to (_tmp192_, _tmp193_, _tmp194_);
				_tmp195_ = cr;
				_tmp196_ = x1;
				_tmp197_ = y2;
				cairo_move_to (_tmp195_, _tmp196_, _tmp197_);
				_tmp198_ = cr;
				_tmp199_ = x2;
				_tmp200_ = y1;
				cairo_line_to (_tmp198_, _tmp199_, _tmp200_);
				_tmp201_ = cr;
				cairo_save (_tmp201_);
				_tmp202_ = cr;
				cairo_set_source_rgba (_tmp202_, 0.0, 0.0, 0.0, 1.0);
				_tmp203_ = cr;
				_tmp204_ = minefield_view_get_mine_size (self);
				_tmp205_ = _tmp204_;
				_tmp206_ = MAX ((gdouble) 1, 0.1 * _tmp205_);
				cairo_set_line_width (_tmp203_, _tmp206_);
				_tmp207_ = cr;
				cairo_set_line_join (_tmp207_, CAIRO_LINE_JOIN_ROUND);
				_tmp208_ = cr;
				cairo_set_line_cap (_tmp208_, CAIRO_LINE_CAP_ROUND);
				_tmp209_ = cr;
				cairo_stroke (_tmp209_);
				_tmp210_ = cr;
				cairo_restore (_tmp210_);
			}
		} else {
			gboolean _tmp211_ = FALSE;
			Minefield* _tmp212_ = NULL;
			Minefield* _tmp213_ = NULL;
			gboolean _tmp214_ = FALSE;
			_tmp212_ = minefield_view_get_minefield (self);
			_tmp213_ = _tmp212_;
			_tmp214_ = _tmp213_->exploded;
			if (_tmp214_) {
				Minefield* _tmp215_ = NULL;
				Minefield* _tmp216_ = NULL;
				guint _tmp217_ = 0U;
				guint _tmp218_ = 0U;
				gboolean _tmp219_ = FALSE;
				_tmp215_ = minefield_view_get_minefield (self);
				_tmp216_ = _tmp215_;
				_tmp217_ = x;
				_tmp218_ = y;
				_tmp219_ = minefield_has_mine (_tmp216_, _tmp217_, _tmp218_);
				_tmp211_ = _tmp219_;
			} else {
				_tmp211_ = FALSE;
			}
			if (_tmp211_) {
				cairo_pattern_t* _tmp220_ = NULL;
				cairo_t* _tmp225_ = NULL;
				cairo_pattern_t* _tmp226_ = NULL;
				cairo_t* _tmp227_ = NULL;
				guint _tmp228_ = 0U;
				guint _tmp229_ = 0U;
				guint _tmp230_ = 0U;
				guint _tmp231_ = 0U;
				cairo_t* _tmp232_ = NULL;
				_tmp220_ = self->priv->mine_pattern;
				if (_tmp220_ == NULL) {
					cairo_t* _tmp221_ = NULL;
					gchar* _tmp222_ = NULL;
					gchar* _tmp223_ = NULL;
					cairo_pattern_t* _tmp224_ = NULL;
					_tmp221_ = cr;
					_tmp222_ = g_build_filename (DATA_DIRECTORY, "mine.svg", NULL);
					_tmp223_ = _tmp222_;
					_tmp224_ = minefield_view_render_svg_pattern (self, _tmp221_, _tmp223_);
					_cairo_pattern_destroy0 (self->priv->mine_pattern);
					self->priv->mine_pattern = _tmp224_;
					_g_free0 (_tmp223_);
				}
				_tmp225_ = cr;
				_tmp226_ = self->priv->mine_pattern;
				cairo_set_source (_tmp225_, _tmp226_);
				_tmp227_ = cr;
				_tmp228_ = minefield_view_get_mine_size (self);
				_tmp229_ = _tmp228_;
				_tmp230_ = minefield_view_get_mine_size (self);
				_tmp231_ = _tmp230_;
				cairo_rectangle (_tmp227_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp229_, (gdouble) _tmp231_);
				_tmp232_ = cr;
				cairo_fill (_tmp232_);
			} else {
				Minefield* _tmp233_ = NULL;
				Minefield* _tmp234_ = NULL;
				guint _tmp235_ = 0U;
				guint _tmp236_ = 0U;
				FlagType _tmp237_ = 0;
				_tmp233_ = minefield_view_get_minefield (self);
				_tmp234_ = _tmp233_;
				_tmp235_ = x;
				_tmp236_ = y;
				_tmp237_ = minefield_get_flag (_tmp234_, _tmp235_, _tmp236_);
				if (_tmp237_ == FLAG_TYPE_MAYBE) {
					cairo_pattern_t* _tmp238_ = NULL;
					cairo_t* _tmp243_ = NULL;
					cairo_pattern_t* _tmp244_ = NULL;
					cairo_t* _tmp245_ = NULL;
					guint _tmp246_ = 0U;
					guint _tmp247_ = 0U;
					guint _tmp248_ = 0U;
					guint _tmp249_ = 0U;
					cairo_t* _tmp250_ = NULL;
					_tmp238_ = self->priv->question_pattern;
					if (_tmp238_ == NULL) {
						cairo_t* _tmp239_ = NULL;
						gchar* _tmp240_ = NULL;
						gchar* _tmp241_ = NULL;
						cairo_pattern_t* _tmp242_ = NULL;
						_tmp239_ = cr;
						_tmp240_ = g_build_filename (DATA_DIRECTORY, "flag-question.svg", NULL);
						_tmp241_ = _tmp240_;
						_tmp242_ = minefield_view_render_svg_pattern (self, _tmp239_, _tmp241_);
						_cairo_pattern_destroy0 (self->priv->question_pattern);
						self->priv->question_pattern = _tmp242_;
						_g_free0 (_tmp241_);
					}
					_tmp243_ = cr;
					_tmp244_ = self->priv->question_pattern;
					cairo_set_source (_tmp243_, _tmp244_);
					_tmp245_ = cr;
					_tmp246_ = minefield_view_get_mine_size (self);
					_tmp247_ = _tmp246_;
					_tmp248_ = minefield_view_get_mine_size (self);
					_tmp249_ = _tmp248_;
					cairo_rectangle (_tmp245_, (gdouble) 0, (gdouble) 0, (gdouble) _tmp247_, (gdouble) _tmp249_);
					_tmp250_ = cr;
					cairo_fill (_tmp250_);
				}
			}
		}
		_g_object_unref0 (style_context);
	}
}


static gboolean minefield_view_real_draw (GtkWidget* base, cairo_t* cr) {
	MinefieldView * self;
	gboolean result = FALSE;
	guint _tmp0_ = 0U;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gdouble dimensions[2] = {0};
	Minefield* _tmp12_ = NULL;
	Minefield* _tmp13_ = NULL;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint _tmp16_ = 0U;
	Minefield* _tmp17_ = NULL;
	Minefield* _tmp18_ = NULL;
	guint _tmp19_ = 0U;
	guint _tmp20_ = 0U;
	guint _tmp21_ = 0U;
	gdouble _tmp22_[2] = {0};
	gdouble centre[2] = {0};
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	gdouble _tmp25_ = 0.0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	gdouble _tmp28_ = 0.0;
	gdouble _tmp29_[2] = {0};
	gdouble radius = 0.0;
	gdouble _tmp30_ = 0.0;
	gdouble _tmp31_ = 0.0;
	gdouble _tmp32_ = 0.0;
	cairo_pattern_t* pattern = NULL;
	gdouble _tmp33_ = 0.0;
	gdouble _tmp34_ = 0.0;
	gdouble _tmp35_ = 0.0;
	gdouble _tmp36_ = 0.0;
	gdouble _tmp37_ = 0.0;
	cairo_pattern_t* _tmp38_ = NULL;
	cairo_pattern_t* _tmp39_ = NULL;
	cairo_pattern_t* _tmp40_ = NULL;
	cairo_t* _tmp41_ = NULL;
	guint _tmp42_ = 0U;
	guint _tmp43_ = 0U;
	guint _tmp44_ = 0U;
	guint _tmp45_ = 0U;
	gdouble _tmp46_ = 0.0;
	gdouble _tmp47_ = 0.0;
	cairo_t* _tmp48_ = NULL;
	cairo_t* _tmp49_ = NULL;
	cairo_pattern_t* _tmp50_ = NULL;
	cairo_t* _tmp51_ = NULL;
	cairo_t* _tmp52_ = NULL;
	cairo_t* _tmp53_ = NULL;
	cairo_t* _tmp54_ = NULL;
	cairo_t* _tmp55_ = NULL;
	cairo_t* _tmp56_ = NULL;
	cairo_t* _tmp57_ = NULL;
	cairo_t* _tmp58_ = NULL;
	gdouble* dots = NULL;
	gdouble* _tmp59_ = NULL;
	gint dots_length1 = 0;
	gint _dots_size_ = 0;
	cairo_t* _tmp60_ = NULL;
	gdouble* _tmp61_ = NULL;
	gint _tmp61__length1 = 0;
	cairo_t* _tmp110_ = NULL;
	Position* _tmp139_ = NULL;
	gboolean _tmp140_ = FALSE;
	gboolean _tmp141_ = FALSE;
	Minefield* _tmp185_ = NULL;
	Minefield* _tmp186_ = NULL;
	gboolean _tmp187_ = FALSE;
	gboolean _tmp188_ = FALSE;
	self = (MinefieldView*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->render_size;
	_tmp1_ = minefield_view_get_mine_size (self);
	_tmp2_ = _tmp1_;
	if (_tmp0_ != _tmp2_) {
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		_tmp3_ = minefield_view_get_mine_size (self);
		_tmp4_ = _tmp3_;
		self->priv->render_size = _tmp4_;
		_cairo_pattern_destroy0 (self->priv->flag_pattern);
		self->priv->flag_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->mine_pattern);
		self->priv->mine_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->question_pattern);
		self->priv->question_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->bang_pattern);
		self->priv->bang_pattern = NULL;
		_cairo_pattern_destroy0 (self->priv->warning_pattern);
		self->priv->warning_pattern = NULL;
		{
			gint i = 0;
			i = 0;
			{
				gboolean _tmp5_ = FALSE;
				_tmp5_ = TRUE;
				while (TRUE) {
					gint _tmp7_ = 0;
					cairo_pattern_t** _tmp8_ = NULL;
					gint _tmp8__length1 = 0;
					cairo_pattern_t** _tmp9_ = NULL;
					gint _tmp9__length1 = 0;
					gint _tmp10_ = 0;
					cairo_pattern_t* _tmp11_ = NULL;
					if (!_tmp5_) {
						gint _tmp6_ = 0;
						_tmp6_ = i;
						i = _tmp6_ + 1;
					}
					_tmp5_ = FALSE;
					_tmp7_ = i;
					_tmp8_ = self->priv->number_patterns;
					_tmp8__length1 = self->priv->number_patterns_length1;
					if (!(_tmp7_ < _tmp8__length1)) {
						break;
					}
					_tmp9_ = self->priv->number_patterns;
					_tmp9__length1 = self->priv->number_patterns_length1;
					_tmp10_ = i;
					_cairo_pattern_destroy0 (_tmp9_[_tmp10_]);
					_tmp9_[_tmp10_] = NULL;
					_tmp11_ = _tmp9_[_tmp10_];
				}
			}
		}
	}
	_tmp12_ = minefield_view_get_minefield (self);
	_tmp13_ = _tmp12_;
	_tmp14_ = _tmp13_->width;
	_tmp15_ = minefield_view_get_mine_size (self);
	_tmp16_ = _tmp15_;
	_tmp17_ = minefield_view_get_minefield (self);
	_tmp18_ = _tmp17_;
	_tmp19_ = _tmp18_->height;
	_tmp20_ = minefield_view_get_mine_size (self);
	_tmp21_ = _tmp20_;
	_tmp22_[0] = (gdouble) (_tmp14_ * _tmp16_);
	_tmp22_[1] = (gdouble) (_tmp19_ * _tmp21_);
	memcpy (dimensions, _tmp22_, 2 * sizeof (gdouble));
	_tmp23_ = minefield_view_get_x_offset (self);
	_tmp24_ = _tmp23_;
	_tmp25_ = dimensions[0];
	_tmp26_ = minefield_view_get_y_offset (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = dimensions[1];
	_tmp29_[0] = _tmp24_ + (0.5 * _tmp25_);
	_tmp29_[1] = _tmp27_ + (0.5 * _tmp28_);
	memcpy (centre, _tmp29_, 2 * sizeof (gdouble));
	_tmp30_ = dimensions[0];
	_tmp31_ = dimensions[1];
	_tmp32_ = fmax (_tmp30_, _tmp31_);
	radius = _tmp32_;
	_tmp33_ = centre[0];
	_tmp34_ = centre[1];
	_tmp35_ = centre[0];
	_tmp36_ = centre[1];
	_tmp37_ = radius;
	_tmp38_ = cairo_pattern_create_radial (_tmp33_, _tmp34_, 0.0, _tmp35_, _tmp36_, _tmp37_);
	pattern = _tmp38_;
	_tmp39_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp39_, 0.0, 0.0, 0.0, 0.0, 0.1);
	_tmp40_ = pattern;
	cairo_pattern_add_color_stop_rgba (_tmp40_, 1.0, 0.0, 0.0, 0.0, 0.4);
	_tmp41_ = cr;
	_tmp42_ = minefield_view_get_x_offset (self);
	_tmp43_ = _tmp42_;
	_tmp44_ = minefield_view_get_y_offset (self);
	_tmp45_ = _tmp44_;
	_tmp46_ = dimensions[0];
	_tmp47_ = dimensions[1];
	cairo_rectangle (_tmp41_, _tmp43_ - 0.5, _tmp45_ - 0.5, _tmp46_ + 0.5, _tmp47_ + 0.5);
	_tmp48_ = cr;
	cairo_save (_tmp48_);
	_tmp49_ = cr;
	_tmp50_ = pattern;
	cairo_set_source (_tmp49_, _tmp50_);
	_tmp51_ = cr;
	cairo_fill_preserve (_tmp51_);
	_tmp52_ = cr;
	cairo_set_line_width (_tmp52_, 0.5);
	_tmp53_ = cr;
	cairo_set_source_rgba (_tmp53_, 0.0, 0.0, 0.0, 1.0);
	_tmp54_ = cr;
	cairo_stroke (_tmp54_);
	_tmp55_ = cr;
	cairo_restore (_tmp55_);
	_tmp56_ = cr;
	cairo_save (_tmp56_);
	_tmp57_ = cr;
	cairo_set_line_width (_tmp57_, 0.5);
	_tmp58_ = cr;
	cairo_set_source_rgba (_tmp58_, 0.0, 0.0, 0.0, 1.0);
	_tmp59_ = g_new0 (gdouble, 2);
	_tmp59_[0] = (gdouble) 2;
	_tmp59_[1] = (gdouble) 2;
	dots = _tmp59_;
	dots_length1 = 2;
	_dots_size_ = dots_length1;
	_tmp60_ = cr;
	_tmp61_ = dots;
	_tmp61__length1 = dots_length1;
	cairo_set_dash (_tmp60_, _tmp61_, _tmp61__length1, (gdouble) 0);
	{
		gint x = 0;
		x = 1;
		{
			gboolean _tmp62_ = FALSE;
			_tmp62_ = TRUE;
			while (TRUE) {
				gint _tmp64_ = 0;
				Minefield* _tmp65_ = NULL;
				Minefield* _tmp66_ = NULL;
				guint _tmp67_ = 0U;
				cairo_t* _tmp68_ = NULL;
				guint _tmp69_ = 0U;
				guint _tmp70_ = 0U;
				gint _tmp71_ = 0;
				guint _tmp72_ = 0U;
				guint _tmp73_ = 0U;
				guint _tmp74_ = 0U;
				guint _tmp75_ = 0U;
				cairo_t* _tmp76_ = NULL;
				guint _tmp77_ = 0U;
				guint _tmp78_ = 0U;
				gint _tmp79_ = 0;
				guint _tmp80_ = 0U;
				guint _tmp81_ = 0U;
				guint _tmp82_ = 0U;
				guint _tmp83_ = 0U;
				gdouble _tmp84_ = 0.0;
				cairo_t* _tmp85_ = NULL;
				if (!_tmp62_) {
					gint _tmp63_ = 0;
					_tmp63_ = x;
					x = _tmp63_ + 1;
				}
				_tmp62_ = FALSE;
				_tmp64_ = x;
				_tmp65_ = minefield_view_get_minefield (self);
				_tmp66_ = _tmp65_;
				_tmp67_ = _tmp66_->width;
				if (!(((guint) _tmp64_) < _tmp67_)) {
					break;
				}
				_tmp68_ = cr;
				_tmp69_ = minefield_view_get_x_offset (self);
				_tmp70_ = _tmp69_;
				_tmp71_ = x;
				_tmp72_ = minefield_view_get_mine_size (self);
				_tmp73_ = _tmp72_;
				_tmp74_ = minefield_view_get_y_offset (self);
				_tmp75_ = _tmp74_;
				cairo_move_to (_tmp68_, (gdouble) (_tmp70_ + (_tmp71_ * _tmp73_)), (gdouble) _tmp75_);
				_tmp76_ = cr;
				_tmp77_ = minefield_view_get_x_offset (self);
				_tmp78_ = _tmp77_;
				_tmp79_ = x;
				_tmp80_ = minefield_view_get_mine_size (self);
				_tmp81_ = _tmp80_;
				_tmp82_ = minefield_view_get_y_offset (self);
				_tmp83_ = _tmp82_;
				_tmp84_ = dimensions[1];
				cairo_line_to (_tmp76_, (gdouble) (_tmp78_ + (_tmp79_ * _tmp81_)), _tmp83_ + _tmp84_);
				_tmp85_ = cr;
				cairo_stroke (_tmp85_);
			}
		}
	}
	{
		gint y = 0;
		y = 1;
		{
			gboolean _tmp86_ = FALSE;
			_tmp86_ = TRUE;
			while (TRUE) {
				gint _tmp88_ = 0;
				Minefield* _tmp89_ = NULL;
				Minefield* _tmp90_ = NULL;
				guint _tmp91_ = 0U;
				cairo_t* _tmp92_ = NULL;
				guint _tmp93_ = 0U;
				guint _tmp94_ = 0U;
				guint _tmp95_ = 0U;
				guint _tmp96_ = 0U;
				gint _tmp97_ = 0;
				guint _tmp98_ = 0U;
				guint _tmp99_ = 0U;
				cairo_t* _tmp100_ = NULL;
				guint _tmp101_ = 0U;
				guint _tmp102_ = 0U;
				gdouble _tmp103_ = 0.0;
				guint _tmp104_ = 0U;
				guint _tmp105_ = 0U;
				gint _tmp106_ = 0;
				guint _tmp107_ = 0U;
				guint _tmp108_ = 0U;
				cairo_t* _tmp109_ = NULL;
				if (!_tmp86_) {
					gint _tmp87_ = 0;
					_tmp87_ = y;
					y = _tmp87_ + 1;
				}
				_tmp86_ = FALSE;
				_tmp88_ = y;
				_tmp89_ = minefield_view_get_minefield (self);
				_tmp90_ = _tmp89_;
				_tmp91_ = _tmp90_->height;
				if (!(((guint) _tmp88_) < _tmp91_)) {
					break;
				}
				_tmp92_ = cr;
				_tmp93_ = minefield_view_get_x_offset (self);
				_tmp94_ = _tmp93_;
				_tmp95_ = minefield_view_get_y_offset (self);
				_tmp96_ = _tmp95_;
				_tmp97_ = y;
				_tmp98_ = minefield_view_get_mine_size (self);
				_tmp99_ = _tmp98_;
				cairo_move_to (_tmp92_, (gdouble) _tmp94_, (gdouble) (_tmp96_ + (_tmp97_ * _tmp99_)));
				_tmp100_ = cr;
				_tmp101_ = minefield_view_get_x_offset (self);
				_tmp102_ = _tmp101_;
				_tmp103_ = dimensions[0];
				_tmp104_ = minefield_view_get_y_offset (self);
				_tmp105_ = _tmp104_;
				_tmp106_ = y;
				_tmp107_ = minefield_view_get_mine_size (self);
				_tmp108_ = _tmp107_;
				cairo_line_to (_tmp100_, _tmp102_ + _tmp103_, (gdouble) (_tmp105_ + (_tmp106_ * _tmp108_)));
				_tmp109_ = cr;
				cairo_stroke (_tmp109_);
			}
		}
	}
	_tmp110_ = cr;
	cairo_restore (_tmp110_);
	{
		gint x = 0;
		x = 0;
		{
			gboolean _tmp111_ = FALSE;
			_tmp111_ = TRUE;
			while (TRUE) {
				gint _tmp113_ = 0;
				Minefield* _tmp114_ = NULL;
				Minefield* _tmp115_ = NULL;
				guint _tmp116_ = 0U;
				if (!_tmp111_) {
					gint _tmp112_ = 0;
					_tmp112_ = x;
					x = _tmp112_ + 1;
				}
				_tmp111_ = FALSE;
				_tmp113_ = x;
				_tmp114_ = minefield_view_get_minefield (self);
				_tmp115_ = _tmp114_;
				_tmp116_ = _tmp115_->width;
				if (!(((guint) _tmp113_) < _tmp116_)) {
					break;
				}
				{
					gint y = 0;
					y = 0;
					{
						gboolean _tmp117_ = FALSE;
						_tmp117_ = TRUE;
						while (TRUE) {
							gint _tmp119_ = 0;
							Minefield* _tmp120_ = NULL;
							Minefield* _tmp121_ = NULL;
							guint _tmp122_ = 0U;
							cairo_t* _tmp123_ = NULL;
							cairo_t* _tmp124_ = NULL;
							guint _tmp125_ = 0U;
							guint _tmp126_ = 0U;
							gint _tmp127_ = 0;
							guint _tmp128_ = 0U;
							guint _tmp129_ = 0U;
							guint _tmp130_ = 0U;
							guint _tmp131_ = 0U;
							gint _tmp132_ = 0;
							guint _tmp133_ = 0U;
							guint _tmp134_ = 0U;
							cairo_t* _tmp135_ = NULL;
							gint _tmp136_ = 0;
							gint _tmp137_ = 0;
							cairo_t* _tmp138_ = NULL;
							if (!_tmp117_) {
								gint _tmp118_ = 0;
								_tmp118_ = y;
								y = _tmp118_ + 1;
							}
							_tmp117_ = FALSE;
							_tmp119_ = y;
							_tmp120_ = minefield_view_get_minefield (self);
							_tmp121_ = _tmp120_;
							_tmp122_ = _tmp121_->height;
							if (!(((guint) _tmp119_) < _tmp122_)) {
								break;
							}
							_tmp123_ = cr;
							cairo_save (_tmp123_);
							_tmp124_ = cr;
							_tmp125_ = minefield_view_get_x_offset (self);
							_tmp126_ = _tmp125_;
							_tmp127_ = x;
							_tmp128_ = minefield_view_get_mine_size (self);
							_tmp129_ = _tmp128_;
							_tmp130_ = minefield_view_get_y_offset (self);
							_tmp131_ = _tmp130_;
							_tmp132_ = y;
							_tmp133_ = minefield_view_get_mine_size (self);
							_tmp134_ = _tmp133_;
							cairo_translate (_tmp124_, (gdouble) (_tmp126_ + (_tmp127_ * _tmp129_)), (gdouble) (_tmp131_ + (_tmp132_ * _tmp134_)));
							_tmp135_ = cr;
							_tmp136_ = x;
							_tmp137_ = y;
							minefield_view_draw_square (self, _tmp135_, (guint) _tmp136_, (guint) _tmp137_);
							_tmp138_ = cr;
							cairo_restore (_tmp138_);
						}
					}
				}
			}
		}
	}
	_tmp139_ = self->priv->keyboard_cursor;
	_tmp140_ = position_get_is_set (_tmp139_);
	_tmp141_ = _tmp140_;
	if (_tmp141_) {
		gdouble key_centre[2] = {0};
		guint _tmp142_ = 0U;
		guint _tmp143_ = 0U;
		Position* _tmp144_ = NULL;
		gint _tmp145_ = 0;
		gint _tmp146_ = 0;
		guint _tmp147_ = 0U;
		guint _tmp148_ = 0U;
		guint _tmp149_ = 0U;
		guint _tmp150_ = 0U;
		Position* _tmp151_ = NULL;
		gint _tmp152_ = 0;
		gint _tmp153_ = 0;
		guint _tmp154_ = 0U;
		guint _tmp155_ = 0U;
		gdouble _tmp156_[2] = {0};
		cairo_pattern_t* key_cursor = NULL;
		gdouble _tmp157_ = 0.0;
		gdouble _tmp158_ = 0.0;
		gdouble _tmp159_ = 0.0;
		gdouble _tmp160_ = 0.0;
		guint _tmp161_ = 0U;
		guint _tmp162_ = 0U;
		cairo_pattern_t* _tmp163_ = NULL;
		cairo_pattern_t* _tmp164_ = NULL;
		cairo_pattern_t* _tmp165_ = NULL;
		cairo_pattern_t* _tmp166_ = NULL;
		cairo_pattern_t* _tmp167_ = NULL;
		cairo_pattern_t* _tmp168_ = NULL;
		cairo_t* _tmp169_ = NULL;
		cairo_t* _tmp170_ = NULL;
		gdouble _tmp171_ = 0.0;
		guint _tmp172_ = 0U;
		guint _tmp173_ = 0U;
		gdouble _tmp174_ = 0.0;
		guint _tmp175_ = 0U;
		guint _tmp176_ = 0U;
		guint _tmp177_ = 0U;
		guint _tmp178_ = 0U;
		guint _tmp179_ = 0U;
		guint _tmp180_ = 0U;
		cairo_t* _tmp181_ = NULL;
		cairo_pattern_t* _tmp182_ = NULL;
		cairo_t* _tmp183_ = NULL;
		cairo_t* _tmp184_ = NULL;
		_tmp142_ = minefield_view_get_x_offset (self);
		_tmp143_ = _tmp142_;
		_tmp144_ = self->priv->keyboard_cursor;
		_tmp145_ = position_get_x (_tmp144_);
		_tmp146_ = _tmp145_;
		_tmp147_ = minefield_view_get_mine_size (self);
		_tmp148_ = _tmp147_;
		_tmp149_ = minefield_view_get_y_offset (self);
		_tmp150_ = _tmp149_;
		_tmp151_ = self->priv->keyboard_cursor;
		_tmp152_ = position_get_y (_tmp151_);
		_tmp153_ = _tmp152_;
		_tmp154_ = minefield_view_get_mine_size (self);
		_tmp155_ = _tmp154_;
		_tmp156_[0] = _tmp143_ + ((_tmp146_ + 0.5) * _tmp148_);
		_tmp156_[1] = _tmp150_ + ((_tmp153_ + 0.5) * _tmp155_);
		memcpy (key_centre, _tmp156_, 2 * sizeof (gdouble));
		_tmp157_ = key_centre[0];
		_tmp158_ = key_centre[1];
		_tmp159_ = key_centre[0];
		_tmp160_ = key_centre[1];
		_tmp161_ = minefield_view_get_mine_size (self);
		_tmp162_ = _tmp161_;
		_tmp163_ = cairo_pattern_create_radial (_tmp157_, _tmp158_, 0.0, _tmp159_, _tmp160_, 0.25 * _tmp162_);
		key_cursor = _tmp163_;
		_tmp164_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp164_, 0.0, 1.0, 1.0, 1.0, 1.0);
		_tmp165_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp165_, 0.8, 1.0, 1.0, 1.0, 0.1);
		_tmp166_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp166_, 0.9, 0.0, 0.0, 0.0, 0.5);
		_tmp167_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp167_, 1.0, 0.0, 0.0, 0.0, 0.2);
		_tmp168_ = key_cursor;
		cairo_pattern_add_color_stop_rgba (_tmp168_, 1.0, 0.0, 0.0, 0.0, 0.0);
		_tmp169_ = cr;
		cairo_save (_tmp169_);
		_tmp170_ = cr;
		_tmp171_ = key_centre[0];
		_tmp172_ = minefield_view_get_mine_size (self);
		_tmp173_ = _tmp172_;
		_tmp174_ = key_centre[1];
		_tmp175_ = minefield_view_get_mine_size (self);
		_tmp176_ = _tmp175_;
		_tmp177_ = minefield_view_get_mine_size (self);
		_tmp178_ = _tmp177_;
		_tmp179_ = minefield_view_get_mine_size (self);
		_tmp180_ = _tmp179_;
		cairo_rectangle (_tmp170_, _tmp171_ - (0.45 * _tmp173_), _tmp174_ - (0.45 * _tmp176_), 0.9 * _tmp178_, 0.9 * _tmp180_);
		_tmp181_ = cr;
		_tmp182_ = key_cursor;
		cairo_set_source (_tmp181_, _tmp182_);
		_tmp183_ = cr;
		cairo_fill (_tmp183_);
		_tmp184_ = cr;
		cairo_restore (_tmp184_);
		_cairo_pattern_destroy0 (key_cursor);
	}
	_tmp185_ = minefield_view_get_minefield (self);
	_tmp186_ = _tmp185_;
	_tmp187_ = minefield_get_paused (_tmp186_);
	_tmp188_ = _tmp187_;
	if (_tmp188_) {
		cairo_t* _tmp189_ = NULL;
		cairo_t* _tmp190_ = NULL;
		cairo_t* _tmp191_ = NULL;
		cairo_t* _tmp192_ = NULL;
		gint _tmp193_ = 0;
		gchar* text = NULL;
		const gchar* _tmp194_ = NULL;
		gchar* _tmp195_ = NULL;
		cairo_text_extents_t extents = {0};
		cairo_t* _tmp196_ = NULL;
		const gchar* _tmp197_ = NULL;
		cairo_text_extents_t _tmp198_ = {0};
		cairo_t* _tmp199_ = NULL;
		gint _tmp200_ = 0;
		cairo_text_extents_t _tmp201_ = {0};
		gdouble _tmp202_ = 0.0;
		gint _tmp203_ = 0;
		cairo_text_extents_t _tmp204_ = {0};
		gdouble _tmp205_ = 0.0;
		cairo_t* _tmp206_ = NULL;
		cairo_t* _tmp207_ = NULL;
		const gchar* _tmp208_ = NULL;
		_tmp189_ = cr;
		cairo_set_source_rgba (_tmp189_, (gdouble) 0, (gdouble) 0, (gdouble) 0, 0.75);
		_tmp190_ = cr;
		cairo_paint (_tmp190_);
		_tmp191_ = cr;
		cairo_select_font_face (_tmp191_, "Sans", CAIRO_FONT_SLANT_NORMAL, CAIRO_FONT_WEIGHT_BOLD);
		_tmp192_ = cr;
		_tmp193_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		cairo_set_font_size (_tmp192_, _tmp193_ * 0.125);
		_tmp194_ = _ ("Paused");
		_tmp195_ = g_strdup (_tmp194_);
		text = _tmp195_;
		_tmp196_ = cr;
		_tmp197_ = text;
		cairo_text_extents (_tmp196_, _tmp197_, &_tmp198_);
		extents = _tmp198_;
		_tmp199_ = cr;
		_tmp200_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
		_tmp201_ = extents;
		_tmp202_ = _tmp201_.width;
		_tmp203_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
		_tmp204_ = extents;
		_tmp205_ = _tmp204_.height;
		cairo_move_to (_tmp199_, (_tmp200_ - _tmp202_) / 2.0, (_tmp203_ + _tmp205_) / 2.0);
		_tmp206_ = cr;
		cairo_set_source_rgb (_tmp206_, (gdouble) 1, (gdouble) 1, (gdouble) 1);
		_tmp207_ = cr;
		_tmp208_ = text;
		cairo_show_text (_tmp207_, _tmp208_);
		_g_free0 (text);
	}
	result = FALSE;
	dots = (g_free (dots), NULL);
	_cairo_pattern_destroy0 (pattern);
	return result;
}


static void minefield_view_toggle_mark (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	gboolean _tmp4_ = FALSE;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	FlagType _tmp9_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = x;
	_tmp3_ = y;
	_tmp4_ = minefield_is_cleared (_tmp1_, _tmp2_, _tmp3_);
	if (_tmp4_) {
		return;
	}
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = x;
	_tmp8_ = y;
	_tmp9_ = minefield_get_flag (_tmp6_, _tmp7_, _tmp8_);
	switch (_tmp9_) {
		case FLAG_TYPE_NONE:
		{
			gboolean _tmp10_ = FALSE;
			Minefield* _tmp11_ = NULL;
			Minefield* _tmp12_ = NULL;
			guint _tmp13_ = 0U;
			guint _tmp14_ = 0U;
			Minefield* _tmp15_ = NULL;
			Minefield* _tmp16_ = NULL;
			guint _tmp17_ = 0U;
			_tmp11_ = minefield_view_get_minefield (self);
			_tmp12_ = _tmp11_;
			_tmp13_ = minefield_get_n_flags (_tmp12_);
			_tmp14_ = _tmp13_;
			_tmp15_ = minefield_view_get_minefield (self);
			_tmp16_ = _tmp15_;
			_tmp17_ = _tmp16_->n_mines;
			if (_tmp14_ >= _tmp17_) {
				gboolean _tmp18_ = FALSE;
				_tmp18_ = self->priv->use_question_marks;
				_tmp10_ = _tmp18_;
			} else {
				_tmp10_ = FALSE;
			}
			if (_tmp10_) {
				Minefield* _tmp19_ = NULL;
				Minefield* _tmp20_ = NULL;
				guint _tmp21_ = 0U;
				guint _tmp22_ = 0U;
				_tmp19_ = minefield_view_get_minefield (self);
				_tmp20_ = _tmp19_;
				_tmp21_ = x;
				_tmp22_ = y;
				minefield_set_flag (_tmp20_, _tmp21_, _tmp22_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp23_ = NULL;
				Minefield* _tmp24_ = NULL;
				guint _tmp25_ = 0U;
				guint _tmp26_ = 0U;
				_tmp23_ = minefield_view_get_minefield (self);
				_tmp24_ = _tmp23_;
				_tmp25_ = x;
				_tmp26_ = y;
				minefield_set_flag (_tmp24_, _tmp25_, _tmp26_, FLAG_TYPE_FLAG);
			}
			break;
		}
		case FLAG_TYPE_MAYBE:
		{
			Minefield* _tmp27_ = NULL;
			Minefield* _tmp28_ = NULL;
			guint _tmp29_ = 0U;
			guint _tmp30_ = 0U;
			_tmp27_ = minefield_view_get_minefield (self);
			_tmp28_ = _tmp27_;
			_tmp29_ = x;
			_tmp30_ = y;
			minefield_set_flag (_tmp28_, _tmp29_, _tmp30_, FLAG_TYPE_NONE);
			break;
		}
		case FLAG_TYPE_FLAG:
		{
			gboolean _tmp31_ = FALSE;
			_tmp31_ = self->priv->use_question_marks;
			if (_tmp31_) {
				Minefield* _tmp32_ = NULL;
				Minefield* _tmp33_ = NULL;
				guint _tmp34_ = 0U;
				guint _tmp35_ = 0U;
				_tmp32_ = minefield_view_get_minefield (self);
				_tmp33_ = _tmp32_;
				_tmp34_ = x;
				_tmp35_ = y;
				minefield_set_flag (_tmp33_, _tmp34_, _tmp35_, FLAG_TYPE_MAYBE);
			} else {
				Minefield* _tmp36_ = NULL;
				Minefield* _tmp37_ = NULL;
				guint _tmp38_ = 0U;
				guint _tmp39_ = 0U;
				_tmp36_ = minefield_view_get_minefield (self);
				_tmp37_ = _tmp36_;
				_tmp38_ = x;
				_tmp39_ = y;
				minefield_set_flag (_tmp37_, _tmp38_, _tmp39_, FLAG_TYPE_NONE);
			}
			break;
		}
		default:
		break;
	}
}


static void minefield_view_redraw_adjacent (MinefieldView* self, guint x, guint y) {
	g_return_if_fail (self != NULL);
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp0_ = 0U;
				Neighbour _tmp1_ = {0};
				gint _tmp2_ = 0;
				gint ny = 0;
				guint _tmp3_ = 0U;
				Neighbour _tmp4_ = {0};
				gint _tmp5_ = 0;
				Minefield* _tmp6_ = NULL;
				Minefield* _tmp7_ = NULL;
				gint _tmp8_ = 0;
				gint _tmp9_ = 0;
				gboolean _tmp10_ = FALSE;
				_tmp0_ = x;
				_tmp1_ = neighbour;
				_tmp2_ = _tmp1_.x;
				nx = ((gint) _tmp0_) + _tmp2_;
				_tmp3_ = y;
				_tmp4_ = neighbour;
				_tmp5_ = _tmp4_.y;
				ny = ((gint) _tmp3_) + _tmp5_;
				_tmp6_ = minefield_view_get_minefield (self);
				_tmp7_ = _tmp6_;
				_tmp8_ = nx;
				_tmp9_ = ny;
				_tmp10_ = minefield_is_location (_tmp7_, _tmp8_, _tmp9_);
				if (_tmp10_) {
					gint _tmp11_ = 0;
					gint _tmp12_ = 0;
					_tmp11_ = nx;
					_tmp12_ = ny;
					minefield_view_redraw_sector_cb (self, (guint) _tmp11_, (guint) _tmp12_);
				}
			}
		}
	}
}


static gpointer _minefield_ref0 (gpointer self) {
	return self ? minefield_ref (self) : NULL;
}


static void minefield_view_multi_release (MinefieldView* self, guint x, guint y) {
	gboolean _tmp0_ = FALSE;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	gboolean _tmp5_ = FALSE;
	guint n_mines = 0U;
	Minefield* _tmp11_ = NULL;
	Minefield* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	guint _tmp14_ = 0U;
	guint _tmp15_ = 0U;
	guint n_flags = 0U;
	guint n_unknown = 0U;
	gboolean do_clear = FALSE;
	guint _tmp39_ = 0U;
	guint _tmp40_ = 0U;
	Minefield* m = NULL;
	Minefield* _tmp45_ = NULL;
	Minefield* _tmp46_ = NULL;
	Minefield* _tmp47_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = x;
	_tmp4_ = y;
	_tmp5_ = minefield_is_cleared (_tmp2_, _tmp3_, _tmp4_);
	if (!_tmp5_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp6_ = NULL;
		Minefield* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		guint _tmp9_ = 0U;
		FlagType _tmp10_ = 0;
		_tmp6_ = minefield_view_get_minefield (self);
		_tmp7_ = _tmp6_;
		_tmp8_ = x;
		_tmp9_ = y;
		_tmp10_ = minefield_get_flag (_tmp7_, _tmp8_, _tmp9_);
		_tmp0_ = _tmp10_ == FLAG_TYPE_FLAG;
	}
	if (_tmp0_) {
		return;
	}
	_tmp11_ = minefield_view_get_minefield (self);
	_tmp12_ = _tmp11_;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = minefield_get_n_adjacent_mines (_tmp12_, _tmp13_, _tmp14_);
	n_mines = _tmp15_;
	n_flags = (guint) 0;
	n_unknown = (guint) 0;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp16_ = 0U;
				Neighbour _tmp17_ = {0};
				gint _tmp18_ = 0;
				gint ny = 0;
				guint _tmp19_ = 0U;
				Neighbour _tmp20_ = {0};
				gint _tmp21_ = 0;
				Minefield* _tmp22_ = NULL;
				Minefield* _tmp23_ = NULL;
				gint _tmp24_ = 0;
				gint _tmp25_ = 0;
				gboolean _tmp26_ = FALSE;
				Minefield* _tmp27_ = NULL;
				Minefield* _tmp28_ = NULL;
				gint _tmp29_ = 0;
				gint _tmp30_ = 0;
				FlagType _tmp31_ = 0;
				Minefield* _tmp33_ = NULL;
				Minefield* _tmp34_ = NULL;
				gint _tmp35_ = 0;
				gint _tmp36_ = 0;
				gboolean _tmp37_ = FALSE;
				_tmp16_ = x;
				_tmp17_ = neighbour;
				_tmp18_ = _tmp17_.x;
				nx = ((gint) _tmp16_) + _tmp18_;
				_tmp19_ = y;
				_tmp20_ = neighbour;
				_tmp21_ = _tmp20_.y;
				ny = ((gint) _tmp19_) + _tmp21_;
				_tmp22_ = minefield_view_get_minefield (self);
				_tmp23_ = _tmp22_;
				_tmp24_ = nx;
				_tmp25_ = ny;
				_tmp26_ = minefield_is_location (_tmp23_, _tmp24_, _tmp25_);
				if (!_tmp26_) {
					continue;
				}
				_tmp27_ = minefield_view_get_minefield (self);
				_tmp28_ = _tmp27_;
				_tmp29_ = nx;
				_tmp30_ = ny;
				_tmp31_ = minefield_get_flag (_tmp28_, (guint) _tmp29_, (guint) _tmp30_);
				if (_tmp31_ == FLAG_TYPE_FLAG) {
					guint _tmp32_ = 0U;
					_tmp32_ = n_flags;
					n_flags = _tmp32_ + 1;
				}
				_tmp33_ = minefield_view_get_minefield (self);
				_tmp34_ = _tmp33_;
				_tmp35_ = nx;
				_tmp36_ = ny;
				_tmp37_ = minefield_is_cleared (_tmp34_, (guint) _tmp35_, (guint) _tmp36_);
				if (!_tmp37_) {
					guint _tmp38_ = 0U;
					_tmp38_ = n_unknown;
					n_unknown = _tmp38_ + 1;
				}
			}
		}
	}
	do_clear = FALSE;
	_tmp39_ = n_mines;
	_tmp40_ = n_flags;
	if (_tmp39_ == _tmp40_) {
		do_clear = TRUE;
	} else {
		gboolean _tmp41_ = FALSE;
		gboolean _tmp42_ = FALSE;
		_tmp42_ = self->priv->use_autoflag;
		if (_tmp42_) {
			guint _tmp43_ = 0U;
			guint _tmp44_ = 0U;
			_tmp43_ = n_unknown;
			_tmp44_ = n_mines;
			_tmp41_ = _tmp43_ == _tmp44_;
		} else {
			_tmp41_ = FALSE;
		}
		if (_tmp41_) {
			do_clear = FALSE;
		} else {
			return;
		}
	}
	_tmp45_ = minefield_view_get_minefield (self);
	_tmp46_ = _tmp45_;
	_tmp47_ = _minefield_ref0 (_tmp46_);
	m = _tmp47_;
	{
		Neighbour* neighbour_collection = NULL;
		gint neighbour_collection_length1 = 0;
		gint _neighbour_collection_size_ = 0;
		gint neighbour_it = 0;
		neighbour_collection = neighbour_map;
		neighbour_collection_length1 = G_N_ELEMENTS (neighbour_map);
		for (neighbour_it = 0; neighbour_it < G_N_ELEMENTS (neighbour_map); neighbour_it = neighbour_it + 1) {
			Neighbour neighbour = {0};
			neighbour = neighbour_collection[neighbour_it];
			{
				gint nx = 0;
				guint _tmp48_ = 0U;
				Neighbour _tmp49_ = {0};
				gint _tmp50_ = 0;
				gint ny = 0;
				guint _tmp51_ = 0U;
				Neighbour _tmp52_ = {0};
				gint _tmp53_ = 0;
				Minefield* _tmp54_ = NULL;
				gint _tmp55_ = 0;
				gint _tmp56_ = 0;
				gboolean _tmp57_ = FALSE;
				gboolean _tmp58_ = FALSE;
				gboolean _tmp59_ = FALSE;
				_tmp48_ = x;
				_tmp49_ = neighbour;
				_tmp50_ = _tmp49_.x;
				nx = ((gint) _tmp48_) + _tmp50_;
				_tmp51_ = y;
				_tmp52_ = neighbour;
				_tmp53_ = _tmp52_.y;
				ny = ((gint) _tmp51_) + _tmp53_;
				_tmp54_ = m;
				_tmp55_ = nx;
				_tmp56_ = ny;
				_tmp57_ = minefield_is_location (_tmp54_, _tmp55_, _tmp56_);
				if (!_tmp57_) {
					continue;
				}
				_tmp59_ = do_clear;
				if (_tmp59_) {
					Minefield* _tmp60_ = NULL;
					gint _tmp61_ = 0;
					gint _tmp62_ = 0;
					FlagType _tmp63_ = 0;
					_tmp60_ = m;
					_tmp61_ = nx;
					_tmp62_ = ny;
					_tmp63_ = minefield_get_flag (_tmp60_, (guint) _tmp61_, (guint) _tmp62_);
					_tmp58_ = _tmp63_ != FLAG_TYPE_FLAG;
				} else {
					_tmp58_ = FALSE;
				}
				if (_tmp58_) {
					Minefield* _tmp64_ = NULL;
					gint _tmp65_ = 0;
					gint _tmp66_ = 0;
					_tmp64_ = m;
					_tmp65_ = nx;
					_tmp66_ = ny;
					minefield_clear_mine (_tmp64_, (guint) _tmp65_, (guint) _tmp66_);
				} else {
					Minefield* _tmp67_ = NULL;
					gint _tmp68_ = 0;
					gint _tmp69_ = 0;
					_tmp67_ = m;
					_tmp68_ = nx;
					_tmp69_ = ny;
					minefield_set_flag (_tmp67_, (guint) _tmp68_, (guint) _tmp69_, FLAG_TYPE_FLAG);
				}
			}
		}
	}
	_minefield_unref0 (m);
}


static gboolean minefield_view_real_button_press_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	GdkEventType _tmp1_ = 0;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Position* _tmp22_ = NULL;
	Position* _tmp23_ = NULL;
	GdkEventButton* _tmp24_ = NULL;
	gdouble _tmp25_ = 0.0;
	guint _tmp26_ = 0U;
	guint _tmp27_ = 0U;
	guint _tmp28_ = 0U;
	guint _tmp29_ = 0U;
	gdouble _tmp30_ = 0.0;
	Position* _tmp31_ = NULL;
	GdkEventButton* _tmp32_ = NULL;
	gdouble _tmp33_ = 0.0;
	guint _tmp34_ = 0U;
	guint _tmp35_ = 0U;
	guint _tmp36_ = 0U;
	guint _tmp37_ = 0U;
	gdouble _tmp38_ = 0.0;
	Position* _tmp39_ = NULL;
	gboolean _tmp40_ = FALSE;
	gboolean _tmp41_ = FALSE;
	gboolean _tmp42_ = FALSE;
	GdkEventButton* _tmp43_ = NULL;
	guint _tmp44_ = 0U;
	Position* _tmp59_ = NULL;
	Position* _tmp60_ = NULL;
	Position* _tmp61_ = NULL;
	gint _tmp62_ = 0;
	gint _tmp63_ = 0;
	Position* _tmp64_ = NULL;
	gint _tmp65_ = 0;
	gint _tmp66_ = 0;
	gint* _tmp67_ = NULL;
	gint* _tmp68_ = NULL;
	gint _tmp68__length1 = 0;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->type;
	if (_tmp1_ != GDK_BUTTON_PRESS) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (_tmp18_) {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	} else {
		_tmp15_ = FALSE;
	}
	if (_tmp15_) {
		result = FALSE;
		return result;
	}
	_tmp22_ = self->priv->selected;
	position_set_is_set (_tmp22_, FALSE);
	_tmp23_ = self->priv->selected;
	_tmp24_ = event;
	_tmp25_ = _tmp24_->x;
	_tmp26_ = minefield_view_get_x_offset (self);
	_tmp27_ = _tmp26_;
	_tmp28_ = minefield_view_get_mine_size (self);
	_tmp29_ = _tmp28_;
	_tmp30_ = floor ((_tmp25_ - _tmp27_) / _tmp29_);
	position_set_x (_tmp23_, (gint) _tmp30_);
	_tmp31_ = self->priv->selected;
	_tmp32_ = event;
	_tmp33_ = _tmp32_->y;
	_tmp34_ = minefield_view_get_y_offset (self);
	_tmp35_ = _tmp34_;
	_tmp36_ = minefield_view_get_mine_size (self);
	_tmp37_ = _tmp36_;
	_tmp38_ = floor ((_tmp33_ - _tmp35_) / _tmp37_);
	position_set_y (_tmp31_, (gint) _tmp38_);
	_tmp39_ = self->priv->selected;
	_tmp40_ = position_get_is_valid (_tmp39_);
	_tmp41_ = _tmp40_;
	if (!_tmp41_) {
		result = FALSE;
		return result;
	}
	_tmp43_ = event;
	_tmp44_ = _tmp43_->button;
	if (_tmp44_ == ((guint) 3)) {
		_tmp42_ = TRUE;
	} else {
		gboolean _tmp45_ = FALSE;
		GdkEventButton* _tmp46_ = NULL;
		guint _tmp47_ = 0U;
		_tmp46_ = event;
		_tmp47_ = _tmp46_->button;
		if (_tmp47_ == ((guint) 1)) {
			GdkEventButton* _tmp48_ = NULL;
			GdkModifierType _tmp49_ = 0;
			_tmp48_ = event;
			_tmp49_ = _tmp48_->state;
			_tmp45_ = (_tmp49_ & GDK_CONTROL_MASK) != 0;
		} else {
			_tmp45_ = FALSE;
		}
		_tmp42_ = _tmp45_;
	}
	if (_tmp42_) {
		Position* _tmp50_ = NULL;
		gint _tmp51_ = 0;
		gint _tmp52_ = 0;
		Position* _tmp53_ = NULL;
		gint _tmp54_ = 0;
		gint _tmp55_ = 0;
		_tmp50_ = self->priv->selected;
		_tmp51_ = position_get_x (_tmp50_);
		_tmp52_ = _tmp51_;
		_tmp53_ = self->priv->selected;
		_tmp54_ = position_get_y (_tmp53_);
		_tmp55_ = _tmp54_;
		minefield_view_toggle_mark (self, (guint) _tmp52_, (guint) _tmp55_);
		g_signal_emit_by_name (self, "unlook");
	} else {
		GdkEventButton* _tmp56_ = NULL;
		guint _tmp57_ = 0U;
		_tmp56_ = event;
		_tmp57_ = _tmp56_->button;
		if (_tmp57_ == ((guint) 1)) {
			Position* _tmp58_ = NULL;
			_tmp58_ = self->priv->selected;
			position_set_is_set (_tmp58_, TRUE);
			g_signal_emit_by_name (self, "look");
		}
	}
	_tmp59_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp59_, FALSE);
	_tmp60_ = self->priv->keyboard_cursor;
	_tmp61_ = self->priv->selected;
	_tmp62_ = position_get_x (_tmp61_);
	_tmp63_ = _tmp62_;
	_tmp64_ = self->priv->selected;
	_tmp65_ = position_get_y (_tmp64_);
	_tmp66_ = _tmp65_;
	_tmp67_ = g_new0 (gint, 2);
	_tmp67_[0] = _tmp63_;
	_tmp67_[1] = _tmp66_;
	_tmp68_ = _tmp67_;
	_tmp68__length1 = 2;
	position_set_position (_tmp60_, _tmp68_, 2);
	_tmp68_ = (g_free (_tmp68_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_motion_notify_event (GtkWidget* base, GdkEventMotion* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Position* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gint x = 0;
	GdkEventMotion* _tmp20_ = NULL;
	gdouble _tmp21_ = 0.0;
	guint _tmp22_ = 0U;
	guint _tmp23_ = 0U;
	guint _tmp24_ = 0U;
	guint _tmp25_ = 0U;
	gdouble _tmp26_ = 0.0;
	gint y = 0;
	GdkEventMotion* _tmp27_ = NULL;
	gdouble _tmp28_ = 0.0;
	guint _tmp29_ = 0U;
	guint _tmp30_ = 0U;
	guint _tmp31_ = 0U;
	guint _tmp32_ = 0U;
	gdouble _tmp33_ = 0.0;
	Position* _tmp34_ = NULL;
	gint _tmp35_ = 0;
	gint _tmp36_ = 0;
	gint* _tmp37_ = NULL;
	gint* _tmp38_ = NULL;
	gint _tmp38__length1 = 0;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp9_ = NULL;
		Minefield* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = minefield_view_get_minefield (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = minefield_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->priv->selected;
	_tmp15_ = position_get_is_set (_tmp14_);
	_tmp16_ = _tmp15_;
	if (!_tmp16_) {
		_tmp13_ = TRUE;
	} else {
		Position* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->keyboard_cursor;
		_tmp18_ = position_get_is_set (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = _tmp19_;
	}
	if (_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = event;
	_tmp21_ = _tmp20_->x;
	_tmp22_ = minefield_view_get_x_offset (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = minefield_view_get_mine_size (self);
	_tmp25_ = _tmp24_;
	_tmp26_ = floor ((_tmp21_ - _tmp23_) / _tmp25_);
	x = (gint) _tmp26_;
	_tmp27_ = event;
	_tmp28_ = _tmp27_->y;
	_tmp29_ = minefield_view_get_y_offset (self);
	_tmp30_ = _tmp29_;
	_tmp31_ = minefield_view_get_mine_size (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = floor ((_tmp28_ - _tmp30_) / _tmp32_);
	y = (gint) _tmp33_;
	_tmp34_ = self->priv->selected;
	_tmp35_ = x;
	_tmp36_ = y;
	_tmp37_ = g_new0 (gint, 2);
	_tmp37_[0] = _tmp35_;
	_tmp37_[1] = _tmp36_;
	_tmp38_ = _tmp37_;
	_tmp38__length1 = 2;
	position_set_position (_tmp34_, _tmp38_, 2);
	_tmp38_ = (g_free (_tmp38_), NULL);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_button_release_event (GtkWidget* base, GdkEventButton* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventButton* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Minefield* _tmp22_ = NULL;
	Minefield* _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	Minefield* _tmp31_ = NULL;
	Minefield* _tmp32_ = NULL;
	Position* _tmp33_ = NULL;
	gint _tmp34_ = 0;
	gint _tmp35_ = 0;
	Position* _tmp36_ = NULL;
	gint _tmp37_ = 0;
	gint _tmp38_ = 0;
	gboolean _tmp39_ = FALSE;
	Position* _tmp69_ = NULL;
	Position* _tmp70_ = NULL;
	gint _tmp71_ = 0;
	gint _tmp72_ = 0;
	Position* _tmp73_ = NULL;
	gint _tmp74_ = 0;
	gint _tmp75_ = 0;
	gint* _tmp76_ = NULL;
	gint* _tmp77_ = NULL;
	gint _tmp77__length1 = 0;
	Position* _tmp78_ = NULL;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->button;
	if (_tmp1_ != ((guint) 1)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = _tmp21_;
	}
	if (_tmp15_) {
		result = FALSE;
		return result;
	}
	_tmp22_ = minefield_view_get_minefield (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected;
	_tmp25_ = position_get_x (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_y (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = minefield_is_location (_tmp23_, _tmp26_, _tmp29_);
	if (!_tmp30_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp31_ = minefield_view_get_minefield (self);
	_tmp32_ = _tmp31_;
	_tmp33_ = self->priv->selected;
	_tmp34_ = position_get_x (_tmp33_);
	_tmp35_ = _tmp34_;
	_tmp36_ = self->priv->selected;
	_tmp37_ = position_get_y (_tmp36_);
	_tmp38_ = _tmp37_;
	_tmp39_ = minefield_is_cleared (_tmp32_, (guint) _tmp35_, (guint) _tmp38_);
	if (_tmp39_) {
		Position* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		Position* _tmp43_ = NULL;
		gint _tmp44_ = 0;
		gint _tmp45_ = 0;
		Position* _tmp46_ = NULL;
		gint _tmp47_ = 0;
		gint _tmp48_ = 0;
		Position* _tmp49_ = NULL;
		gint _tmp50_ = 0;
		gint _tmp51_ = 0;
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_x (_tmp40_);
		_tmp42_ = _tmp41_;
		_tmp43_ = self->priv->selected;
		_tmp44_ = position_get_y (_tmp43_);
		_tmp45_ = _tmp44_;
		minefield_view_multi_release (self, (guint) _tmp42_, (guint) _tmp45_);
		_tmp46_ = self->priv->selected;
		_tmp47_ = position_get_x (_tmp46_);
		_tmp48_ = _tmp47_;
		_tmp49_ = self->priv->selected;
		_tmp50_ = position_get_y (_tmp49_);
		_tmp51_ = _tmp50_;
		minefield_view_redraw_adjacent (self, (guint) _tmp48_, (guint) _tmp51_);
	} else {
		Minefield* _tmp52_ = NULL;
		Minefield* _tmp53_ = NULL;
		Position* _tmp54_ = NULL;
		gint _tmp55_ = 0;
		gint _tmp56_ = 0;
		Position* _tmp57_ = NULL;
		gint _tmp58_ = 0;
		gint _tmp59_ = 0;
		FlagType _tmp60_ = 0;
		_tmp52_ = minefield_view_get_minefield (self);
		_tmp53_ = _tmp52_;
		_tmp54_ = self->priv->selected;
		_tmp55_ = position_get_x (_tmp54_);
		_tmp56_ = _tmp55_;
		_tmp57_ = self->priv->selected;
		_tmp58_ = position_get_y (_tmp57_);
		_tmp59_ = _tmp58_;
		_tmp60_ = minefield_get_flag (_tmp53_, (guint) _tmp56_, (guint) _tmp59_);
		if (_tmp60_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp61_ = NULL;
			Minefield* _tmp62_ = NULL;
			Position* _tmp63_ = NULL;
			gint _tmp64_ = 0;
			gint _tmp65_ = 0;
			Position* _tmp66_ = NULL;
			gint _tmp67_ = 0;
			gint _tmp68_ = 0;
			_tmp61_ = minefield_view_get_minefield (self);
			_tmp62_ = _tmp61_;
			_tmp63_ = self->priv->selected;
			_tmp64_ = position_get_x (_tmp63_);
			_tmp65_ = _tmp64_;
			_tmp66_ = self->priv->selected;
			_tmp67_ = position_get_y (_tmp66_);
			_tmp68_ = _tmp67_;
			minefield_clear_mine (_tmp62_, (guint) _tmp65_, (guint) _tmp68_);
		}
	}
	_tmp69_ = self->priv->keyboard_cursor;
	_tmp70_ = self->priv->selected;
	_tmp71_ = position_get_x (_tmp70_);
	_tmp72_ = _tmp71_;
	_tmp73_ = self->priv->selected;
	_tmp74_ = position_get_y (_tmp73_);
	_tmp75_ = _tmp74_;
	_tmp76_ = g_new0 (gint, 2);
	_tmp76_[0] = _tmp72_;
	_tmp76_[1] = _tmp75_;
	_tmp77_ = _tmp76_;
	_tmp77__length1 = 2;
	position_set_position (_tmp69_, _tmp77_, 2);
	_tmp77_ = (g_free (_tmp77_), NULL);
	_tmp78_ = self->priv->selected;
	position_set_is_set (_tmp78_, FALSE);
	result = FALSE;
	return result;
}


static gboolean minefield_view_real_key_press_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	gboolean _tmp4_ = FALSE;
	gboolean _tmp13_ = FALSE;
	Position* _tmp14_ = NULL;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gint x = 0;
	Position* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint y = 0;
	Position* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	gint _tmp25_ = 0;
	GdkEventKey* _tmp26_ = NULL;
	guint _tmp27_ = 0U;
	gboolean _tmp50_ = FALSE;
	gint _tmp51_ = 0;
	Position* _tmp52_ = NULL;
	gint _tmp53_ = 0;
	gint _tmp54_ = 0;
	Position* _tmp59_ = NULL;
	gboolean _tmp60_ = FALSE;
	gboolean _tmp61_ = FALSE;
	Position* _tmp63_ = NULL;
	gint _tmp64_ = 0;
	gint _tmp65_ = 0;
	gint* _tmp66_ = NULL;
	gint* _tmp67_ = NULL;
	gint _tmp67__length1 = 0;
	Position* _tmp68_ = NULL;
	gboolean _tmp69_ = FALSE;
	gboolean _tmp70_ = FALSE;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp2_ = minefield_view_get_minefield (self);
	_tmp3_ = _tmp2_;
	_tmp4_ = _tmp3_->exploded;
	if (_tmp4_) {
		_tmp1_ = TRUE;
	} else {
		Minefield* _tmp5_ = NULL;
		Minefield* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		gboolean _tmp8_ = FALSE;
		_tmp5_ = minefield_view_get_minefield (self);
		_tmp6_ = _tmp5_;
		_tmp7_ = minefield_get_is_complete (_tmp6_);
		_tmp8_ = _tmp7_;
		_tmp1_ = _tmp8_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		Minefield* _tmp9_ = NULL;
		Minefield* _tmp10_ = NULL;
		gboolean _tmp11_ = FALSE;
		gboolean _tmp12_ = FALSE;
		_tmp9_ = minefield_view_get_minefield (self);
		_tmp10_ = _tmp9_;
		_tmp11_ = minefield_get_paused (_tmp10_);
		_tmp12_ = _tmp11_;
		_tmp0_ = _tmp12_;
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp14_ = self->priv->selected;
	_tmp15_ = position_get_is_set (_tmp14_);
	_tmp16_ = _tmp15_;
	if (_tmp16_) {
		Position* _tmp17_ = NULL;
		gboolean _tmp18_ = FALSE;
		gboolean _tmp19_ = FALSE;
		_tmp17_ = self->priv->keyboard_cursor;
		_tmp18_ = position_get_is_set (_tmp17_);
		_tmp19_ = _tmp18_;
		_tmp13_ = !_tmp19_;
	} else {
		_tmp13_ = FALSE;
	}
	if (_tmp13_) {
		result = FALSE;
		return result;
	}
	_tmp20_ = self->priv->keyboard_cursor;
	_tmp21_ = position_get_x (_tmp20_);
	_tmp22_ = _tmp21_;
	x = _tmp22_;
	_tmp23_ = self->priv->keyboard_cursor;
	_tmp24_ = position_get_y (_tmp23_);
	_tmp25_ = _tmp24_;
	y = _tmp25_;
	_tmp26_ = event;
	_tmp27_ = _tmp26_->keyval;
	switch (_tmp27_) {
		case GDK_KEY_Left:
		case GDK_KEY_h:
		{
			gint _tmp28_ = 0;
			_tmp28_ = x;
			x = _tmp28_ - 1;
			break;
		}
		case GDK_KEY_Right:
		case GDK_KEY_l:
		{
			gint _tmp29_ = 0;
			_tmp29_ = x;
			x = _tmp29_ + 1;
			break;
		}
		case GDK_KEY_Up:
		case GDK_KEY_k:
		{
			gint _tmp30_ = 0;
			_tmp30_ = y;
			y = _tmp30_ - 1;
			break;
		}
		case GDK_KEY_Down:
		case GDK_KEY_j:
		{
			gint _tmp31_ = 0;
			_tmp31_ = y;
			y = _tmp31_ + 1;
			break;
		}
		case GDK_KEY_space:
		case GDK_KEY_Return:
		{
			Position* _tmp32_ = NULL;
			gboolean _tmp33_ = FALSE;
			gboolean _tmp34_ = FALSE;
			_tmp32_ = self->priv->keyboard_cursor;
			_tmp33_ = position_get_is_set (_tmp32_);
			_tmp34_ = _tmp33_;
			if (_tmp34_) {
				Position* _tmp35_ = NULL;
				GdkEventKey* _tmp36_ = NULL;
				GdkModifierType _tmp37_ = 0;
				_tmp35_ = self->priv->selected;
				position_set_is_set (_tmp35_, FALSE);
				_tmp36_ = event;
				_tmp37_ = _tmp36_->state;
				if ((_tmp37_ & GDK_CONTROL_MASK) != 0) {
					Position* _tmp38_ = NULL;
					gint _tmp39_ = 0;
					gint _tmp40_ = 0;
					Position* _tmp41_ = NULL;
					gint _tmp42_ = 0;
					gint _tmp43_ = 0;
					_tmp38_ = self->priv->keyboard_cursor;
					_tmp39_ = position_get_x (_tmp38_);
					_tmp40_ = _tmp39_;
					_tmp41_ = self->priv->keyboard_cursor;
					_tmp42_ = position_get_y (_tmp41_);
					_tmp43_ = _tmp42_;
					minefield_view_toggle_mark (self, (guint) _tmp40_, (guint) _tmp43_);
				} else {
					Position* _tmp44_ = NULL;
					gint _tmp45_ = 0;
					gint _tmp46_ = 0;
					gint* _tmp47_ = NULL;
					gint* _tmp48_ = NULL;
					gint _tmp48__length1 = 0;
					Position* _tmp49_ = NULL;
					_tmp44_ = self->priv->selected;
					_tmp45_ = x;
					_tmp46_ = y;
					_tmp47_ = g_new0 (gint, 2);
					_tmp47_[0] = _tmp45_;
					_tmp47_[1] = _tmp46_;
					_tmp48_ = _tmp47_;
					_tmp48__length1 = 2;
					position_set_position (_tmp44_, _tmp48_, 2);
					_tmp48_ = (g_free (_tmp48_), NULL);
					_tmp49_ = self->priv->selected;
					position_set_is_set (_tmp49_, TRUE);
					g_signal_emit_by_name (self, "look");
				}
			}
			break;
		}
		default:
		{
			result = FALSE;
			return result;
		}
	}
	_tmp51_ = x;
	_tmp52_ = self->priv->keyboard_cursor;
	_tmp53_ = position_get_x (_tmp52_);
	_tmp54_ = _tmp53_;
	if (_tmp51_ == _tmp54_) {
		gint _tmp55_ = 0;
		Position* _tmp56_ = NULL;
		gint _tmp57_ = 0;
		gint _tmp58_ = 0;
		_tmp55_ = y;
		_tmp56_ = self->priv->keyboard_cursor;
		_tmp57_ = position_get_y (_tmp56_);
		_tmp58_ = _tmp57_;
		_tmp50_ = _tmp55_ == _tmp58_;
	} else {
		_tmp50_ = FALSE;
	}
	if (_tmp50_) {
		result = TRUE;
		return result;
	}
	_tmp59_ = self->priv->keyboard_cursor;
	_tmp60_ = position_get_is_set (_tmp59_);
	_tmp61_ = _tmp60_;
	if (!_tmp61_) {
		Position* _tmp62_ = NULL;
		_tmp62_ = self->priv->keyboard_cursor;
		position_set_is_set (_tmp62_, TRUE);
		result = TRUE;
		return result;
	}
	_tmp63_ = self->priv->keyboard_cursor;
	_tmp64_ = x;
	_tmp65_ = y;
	_tmp66_ = g_new0 (gint, 2);
	_tmp66_[0] = _tmp64_;
	_tmp66_[1] = _tmp65_;
	_tmp67_ = _tmp66_;
	_tmp67__length1 = 2;
	position_set_position (_tmp63_, _tmp67_, 2);
	_tmp67_ = (g_free (_tmp67_), NULL);
	_tmp68_ = self->priv->selected;
	_tmp69_ = position_get_is_set (_tmp68_);
	_tmp70_ = _tmp69_;
	if (_tmp70_) {
		Position* _tmp71_ = NULL;
		Position* _tmp72_ = NULL;
		gint _tmp73_ = 0;
		gint _tmp74_ = 0;
		Position* _tmp75_ = NULL;
		gint _tmp76_ = 0;
		gint _tmp77_ = 0;
		gint* _tmp78_ = NULL;
		gint* _tmp79_ = NULL;
		gint _tmp79__length1 = 0;
		_tmp71_ = self->priv->selected;
		_tmp72_ = self->priv->keyboard_cursor;
		_tmp73_ = position_get_x (_tmp72_);
		_tmp74_ = _tmp73_;
		_tmp75_ = self->priv->keyboard_cursor;
		_tmp76_ = position_get_y (_tmp75_);
		_tmp77_ = _tmp76_;
		_tmp78_ = g_new0 (gint, 2);
		_tmp78_[0] = _tmp74_;
		_tmp78_[1] = _tmp77_;
		_tmp79_ = _tmp78_;
		_tmp79__length1 = 2;
		position_set_position (_tmp71_, _tmp79_, 2);
		_tmp79_ = (g_free (_tmp79_), NULL);
	}
	result = TRUE;
	return result;
}


static gboolean minefield_view_real_key_release_event (GtkWidget* base, GdkEventKey* event) {
	MinefieldView * self;
	gboolean result = FALSE;
	GdkEventKey* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	Minefield* _tmp4_ = NULL;
	Minefield* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp15_ = FALSE;
	Position* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	Minefield* _tmp22_ = NULL;
	Minefield* _tmp23_ = NULL;
	Position* _tmp24_ = NULL;
	gint _tmp25_ = 0;
	gint _tmp26_ = 0;
	Position* _tmp27_ = NULL;
	gint _tmp28_ = 0;
	gint _tmp29_ = 0;
	gboolean _tmp30_ = FALSE;
	Position* _tmp60_ = NULL;
	self = (MinefieldView*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = event;
	_tmp1_ = _tmp0_->keyval;
	if (_tmp1_ != ((guint) GDK_KEY_space)) {
		result = FALSE;
		return result;
	}
	_tmp4_ = minefield_view_get_minefield (self);
	_tmp5_ = _tmp4_;
	_tmp6_ = _tmp5_->exploded;
	if (_tmp6_) {
		_tmp3_ = TRUE;
	} else {
		Minefield* _tmp7_ = NULL;
		Minefield* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		gboolean _tmp10_ = FALSE;
		_tmp7_ = minefield_view_get_minefield (self);
		_tmp8_ = _tmp7_;
		_tmp9_ = minefield_get_is_complete (_tmp8_);
		_tmp10_ = _tmp9_;
		_tmp3_ = _tmp10_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		Minefield* _tmp11_ = NULL;
		Minefield* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		gboolean _tmp14_ = FALSE;
		_tmp11_ = minefield_view_get_minefield (self);
		_tmp12_ = _tmp11_;
		_tmp13_ = minefield_get_paused (_tmp12_);
		_tmp14_ = _tmp13_;
		_tmp2_ = _tmp14_;
	}
	if (_tmp2_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = self->priv->selected;
	_tmp17_ = position_get_is_set (_tmp16_);
	_tmp18_ = _tmp17_;
	if (!_tmp18_) {
		_tmp15_ = TRUE;
	} else {
		Position* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		gboolean _tmp21_ = FALSE;
		_tmp19_ = self->priv->keyboard_cursor;
		_tmp20_ = position_get_is_set (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp15_ = !_tmp21_;
	}
	if (_tmp15_) {
		result = FALSE;
		return result;
	}
	g_signal_emit_by_name (self, "unlook");
	_tmp22_ = minefield_view_get_minefield (self);
	_tmp23_ = _tmp22_;
	_tmp24_ = self->priv->selected;
	_tmp25_ = position_get_x (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = self->priv->selected;
	_tmp28_ = position_get_y (_tmp27_);
	_tmp29_ = _tmp28_;
	_tmp30_ = minefield_is_cleared (_tmp23_, (guint) _tmp26_, (guint) _tmp29_);
	if (_tmp30_) {
		Position* _tmp31_ = NULL;
		gint _tmp32_ = 0;
		gint _tmp33_ = 0;
		Position* _tmp34_ = NULL;
		gint _tmp35_ = 0;
		gint _tmp36_ = 0;
		Position* _tmp37_ = NULL;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		Position* _tmp40_ = NULL;
		gint _tmp41_ = 0;
		gint _tmp42_ = 0;
		_tmp31_ = self->priv->selected;
		_tmp32_ = position_get_x (_tmp31_);
		_tmp33_ = _tmp32_;
		_tmp34_ = self->priv->selected;
		_tmp35_ = position_get_y (_tmp34_);
		_tmp36_ = _tmp35_;
		minefield_view_multi_release (self, (guint) _tmp33_, (guint) _tmp36_);
		_tmp37_ = self->priv->selected;
		_tmp38_ = position_get_x (_tmp37_);
		_tmp39_ = _tmp38_;
		_tmp40_ = self->priv->selected;
		_tmp41_ = position_get_y (_tmp40_);
		_tmp42_ = _tmp41_;
		minefield_view_redraw_adjacent (self, (guint) _tmp39_, (guint) _tmp42_);
	} else {
		Minefield* _tmp43_ = NULL;
		Minefield* _tmp44_ = NULL;
		Position* _tmp45_ = NULL;
		gint _tmp46_ = 0;
		gint _tmp47_ = 0;
		Position* _tmp48_ = NULL;
		gint _tmp49_ = 0;
		gint _tmp50_ = 0;
		FlagType _tmp51_ = 0;
		_tmp43_ = minefield_view_get_minefield (self);
		_tmp44_ = _tmp43_;
		_tmp45_ = self->priv->selected;
		_tmp46_ = position_get_x (_tmp45_);
		_tmp47_ = _tmp46_;
		_tmp48_ = self->priv->selected;
		_tmp49_ = position_get_y (_tmp48_);
		_tmp50_ = _tmp49_;
		_tmp51_ = minefield_get_flag (_tmp44_, (guint) _tmp47_, (guint) _tmp50_);
		if (_tmp51_ != FLAG_TYPE_FLAG) {
			Minefield* _tmp52_ = NULL;
			Minefield* _tmp53_ = NULL;
			Position* _tmp54_ = NULL;
			gint _tmp55_ = 0;
			gint _tmp56_ = 0;
			Position* _tmp57_ = NULL;
			gint _tmp58_ = 0;
			gint _tmp59_ = 0;
			_tmp52_ = minefield_view_get_minefield (self);
			_tmp53_ = _tmp52_;
			_tmp54_ = self->priv->selected;
			_tmp55_ = position_get_x (_tmp54_);
			_tmp56_ = _tmp55_;
			_tmp57_ = self->priv->selected;
			_tmp58_ = position_get_y (_tmp57_);
			_tmp59_ = _tmp58_;
			minefield_clear_mine (_tmp53_, (guint) _tmp56_, (guint) _tmp59_);
		}
	}
	_tmp60_ = self->priv->selected;
	position_set_is_set (_tmp60_, FALSE);
	result = FALSE;
	return result;
}


static guint minefield_view_get_mine_size (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	gint _tmp4_ = 0;
	Minefield* _tmp5_ = NULL;
	Minefield* _tmp6_ = NULL;
	guint _tmp7_ = 0U;
	gint _tmp8_ = 0;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp5_ = minefield_view_get_minefield (self);
	_tmp6_ = _tmp5_;
	_tmp7_ = _tmp6_->height;
	_tmp8_ = MIN (_tmp0_ / ((gint) _tmp3_), _tmp4_ / ((gint) _tmp7_));
	result = (guint) _tmp8_;
	return result;
}


static guint minefield_view_get_x_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_width ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->width;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_y_offset (MinefieldView* self) {
	guint result;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	Minefield* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	guint _tmp4_ = 0U;
	guint _tmp5_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = gtk_widget_get_allocated_height ((GtkWidget*) self);
	_tmp1_ = minefield_view_get_minefield (self);
	_tmp2_ = _tmp1_;
	_tmp3_ = _tmp2_->height;
	_tmp4_ = minefield_view_get_mine_size (self);
	_tmp5_ = _tmp4_;
	result = (_tmp0_ - (_tmp3_ * _tmp5_)) / 2;
	return result;
}


static guint minefield_view_get_minimum_size (MinefieldView* self) {
	guint result;
	guint w = 0U;
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint h = 0U;
	Minefield* _tmp3_ = NULL;
	Minefield* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint s = 0U;
	guint _tmp6_ = 0U;
	guint _tmp7_ = 0U;
	guint _tmp8_ = 0U;
	guint _tmp9_ = 0U;
	guint _tmp10_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	_tmp0_ = minefield_view_get_minefield (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = _tmp1_->width;
	w = 320 / _tmp2_;
	_tmp3_ = minefield_view_get_minefield (self);
	_tmp4_ = _tmp3_;
	_tmp5_ = _tmp4_->height;
	h = 200 / _tmp5_;
	_tmp6_ = w;
	_tmp7_ = h;
	_tmp8_ = MIN (_tmp6_, _tmp7_);
	s = _tmp8_;
	_tmp9_ = s;
	if (_tmp9_ < ((guint) 30)) {
		s = (guint) 30;
	}
	_tmp10_ = s;
	result = _tmp10_;
	return result;
}


Minefield* minefield_view_get_minefield (MinefieldView* self) {
	Minefield* result;
	Minefield* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_minefield;
	result = _tmp0_;
	return result;
}


static void _minefield_view_redraw_sector_cb_position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}


static void _minefield_view_minefield___lambda3_ (MinefieldView* self, guint x, guint y) {
	Minefield* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	guint _tmp2_ = 0U;
	gboolean _tmp3_ = FALSE;
	_tmp0_ = self->priv->_minefield;
	_tmp1_ = x;
	_tmp2_ = y;
	_tmp3_ = minefield_is_cleared (_tmp0_, _tmp1_, _tmp2_);
	if (_tmp3_) {
		guint _tmp4_ = 0U;
		guint _tmp5_ = 0U;
		_tmp4_ = x;
		_tmp5_ = y;
		minefield_view_redraw_adjacent (self, _tmp4_, _tmp5_);
	}
}


static void __minefield_view_minefield___lambda3__position_redraw (Position* _sender, guint x, guint y, gpointer self) {
	_minefield_view_minefield___lambda3_ ((MinefieldView*) self, x, y);
}


static gint _minefield_view_minefield___lambda4_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = x;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda4__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda4_ ((MinefieldView*) self, x);
	return result;
}


static gint _minefield_view_minefield___lambda5_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	_tmp0_ = y;
	result = _tmp0_;
	return result;
}


static gint __minefield_view_minefield___lambda5__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda5_ ((MinefieldView*) self, y);
	return result;
}


static gboolean _minefield_is_location_position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = minefield_is_location ((Minefield*) self, x, y);
	return result;
}


static gint _minefield_view_minefield___lambda6_ (MinefieldView* self, gint x) {
	gint result = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	_tmp0_ = x;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->width;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda6__position_set_x (Position* _sender, gint x, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda6_ ((MinefieldView*) self, x);
	return result;
}


static gint _minefield_view_minefield___lambda7_ (MinefieldView* self, gint y) {
	gint result = 0;
	gint _tmp0_ = 0;
	Minefield* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	_tmp0_ = y;
	_tmp1_ = self->priv->_minefield;
	_tmp2_ = _tmp1_->height;
	result = (gint) (_tmp0_ % _tmp2_);
	return result;
}


static gint __minefield_view_minefield___lambda7__position_set_y (Position* _sender, gint y, gpointer self) {
	gint result;
	result = _minefield_view_minefield___lambda7_ ((MinefieldView*) self, y);
	return result;
}


static gboolean _minefield_view_minefield___lambda8_ (MinefieldView* self, gint x, gint y) {
	gboolean result = FALSE;
	result = TRUE;
	return result;
}


static gboolean __minefield_view_minefield___lambda8__position_validate (Position* _sender, gint x, gint y, gpointer self) {
	gboolean result;
	result = _minefield_view_minefield___lambda8_ ((MinefieldView*) self, x, y);
	return result;
}


static void _minefield_view_redraw_sector_cb_minefield_redraw_sector (Minefield* _sender, guint x, guint y, gpointer self) {
	minefield_view_redraw_sector_cb ((MinefieldView*) self, x, y);
}


static void _minefield_view_explode_cb_minefield_explode (Minefield* _sender, gpointer self) {
	minefield_view_explode_cb ((MinefieldView*) self, _sender);
}


static void _minefield_view_minefield___lambda9_ (MinefieldView* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __minefield_view_minefield___lambda9__minefield_paused_changed (Minefield* _sender, gpointer self) {
	_minefield_view_minefield___lambda9_ ((MinefieldView*) self);
}


void minefield_view_set_minefield (MinefieldView* self, Minefield* value) {
	Minefield* _tmp0_ = NULL;
	Minefield* _tmp2_ = NULL;
	Minefield* _tmp3_ = NULL;
	Position* _tmp4_ = NULL;
	Position* _tmp5_ = NULL;
	Position* _tmp6_ = NULL;
	Position* _tmp7_ = NULL;
	Position* _tmp8_ = NULL;
	Position* _tmp9_ = NULL;
	Minefield* _tmp10_ = NULL;
	Position* _tmp11_ = NULL;
	Position* _tmp12_ = NULL;
	gint* _tmp13_ = NULL;
	gint* _tmp14_ = NULL;
	gint _tmp14__length1 = 0;
	Position* _tmp15_ = NULL;
	Position* _tmp16_ = NULL;
	Position* _tmp17_ = NULL;
	Position* _tmp18_ = NULL;
	Minefield* _tmp19_ = NULL;
	Minefield* _tmp20_ = NULL;
	Minefield* _tmp21_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_minefield;
	if (_tmp0_ != NULL) {
		Minefield* _tmp1_ = NULL;
		_tmp1_ = self->priv->_minefield;
		g_signal_handlers_disconnect_by_func (_tmp1_, NULL, self);
	}
	_tmp2_ = value;
	_tmp3_ = _minefield_ref0 (_tmp2_);
	_minefield_unref0 (self->priv->_minefield);
	self->priv->_minefield = _tmp3_;
	_tmp4_ = self->priv->selected;
	position_set_is_set (_tmp4_, FALSE);
	_tmp5_ = self->priv->selected;
	g_signal_connect_object (_tmp5_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp6_ = self->priv->selected;
	g_signal_connect_object (_tmp6_, "redraw", (GCallback) __minefield_view_minefield___lambda3__position_redraw, self, 0);
	_tmp7_ = self->priv->selected;
	g_signal_connect_object (_tmp7_, "set-x", (GCallback) __minefield_view_minefield___lambda4__position_set_x, self, 0);
	_tmp8_ = self->priv->selected;
	g_signal_connect_object (_tmp8_, "set-y", (GCallback) __minefield_view_minefield___lambda5__position_set_y, self, 0);
	_tmp9_ = self->priv->selected;
	_tmp10_ = self->priv->_minefield;
	g_signal_connect (_tmp9_, "validate", (GCallback) _minefield_is_location_position_validate, _tmp10_);
	_tmp11_ = self->priv->keyboard_cursor;
	position_set_is_set (_tmp11_, FALSE);
	_tmp12_ = self->priv->keyboard_cursor;
	_tmp13_ = g_new0 (gint, 2);
	_tmp13_[0] = 0;
	_tmp13_[1] = 0;
	_tmp14_ = _tmp13_;
	_tmp14__length1 = 2;
	position_set_position (_tmp12_, _tmp14_, 2);
	_tmp14_ = (g_free (_tmp14_), NULL);
	_tmp15_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp15_, "redraw", (GCallback) _minefield_view_redraw_sector_cb_position_redraw, self, 0);
	_tmp16_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp16_, "set-x", (GCallback) __minefield_view_minefield___lambda6__position_set_x, self, 0);
	_tmp17_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp17_, "set-y", (GCallback) __minefield_view_minefield___lambda7__position_set_y, self, 0);
	_tmp18_ = self->priv->keyboard_cursor;
	g_signal_connect_object (_tmp18_, "validate", (GCallback) __minefield_view_minefield___lambda8__position_validate, self, 0);
	_tmp19_ = self->priv->_minefield;
	g_signal_connect_object (_tmp19_, "redraw-sector", (GCallback) _minefield_view_redraw_sector_cb_minefield_redraw_sector, self, 0);
	_tmp20_ = self->priv->_minefield;
	g_signal_connect_object (_tmp20_, "explode", (GCallback) _minefield_view_explode_cb_minefield_explode, self, 0);
	_tmp21_ = self->priv->_minefield;
	g_signal_connect_object (_tmp21_, "paused-changed", (GCallback) __minefield_view_minefield___lambda9__minefield_paused_changed, self, 0);
	gtk_widget_queue_resize ((GtkWidget*) self);
	g_object_notify ((GObject *) self, "minefield");
}


static void minefield_view_class_init (MinefieldViewClass * klass) {
	minefield_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (MinefieldViewPrivate));
	GTK_WIDGET_CLASS (klass)->get_preferred_width = minefield_view_real_get_preferred_width;
	GTK_WIDGET_CLASS (klass)->get_preferred_height = minefield_view_real_get_preferred_height;
	GTK_WIDGET_CLASS (klass)->draw = minefield_view_real_draw;
	GTK_WIDGET_CLASS (klass)->button_press_event = minefield_view_real_button_press_event;
	GTK_WIDGET_CLASS (klass)->motion_notify_event = minefield_view_real_motion_notify_event;
	GTK_WIDGET_CLASS (klass)->button_release_event = minefield_view_real_button_release_event;
	GTK_WIDGET_CLASS (klass)->key_press_event = minefield_view_real_key_press_event;
	GTK_WIDGET_CLASS (klass)->key_release_event = minefield_view_real_key_release_event;
	G_OBJECT_CLASS (klass)->get_property = _vala_minefield_view_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_minefield_view_set_property;
	G_OBJECT_CLASS (klass)->finalize = minefield_view_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), MINEFIELD_VIEW_MINEFIELD, param_spec_minefield ("minefield", "minefield", "minefield", TYPE_MINEFIELD, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
	g_signal_new ("look", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("unlook", TYPE_MINEFIELD_VIEW, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void minefield_view_instance_init (MinefieldView * self) {
	self->priv = MINEFIELD_VIEW_GET_PRIVATE (self);
	self->priv->render_size = (guint) 0;
}


static void minefield_view_finalize (GObject* obj) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_MINEFIELD_VIEW, MinefieldView);
	_g_object_unref0 (self->priv->keyboard_cursor);
	_g_object_unref0 (self->priv->selected);
	_cairo_pattern_destroy0 (self->priv->flag_pattern);
	_cairo_pattern_destroy0 (self->priv->mine_pattern);
	_cairo_pattern_destroy0 (self->priv->question_pattern);
	_cairo_pattern_destroy0 (self->priv->bang_pattern);
	_cairo_pattern_destroy0 (self->priv->warning_pattern);
	self->priv->number_patterns = (_vala_array_free (self->priv->number_patterns, self->priv->number_patterns_length1, (GDestroyNotify) cairo_pattern_destroy), NULL);
	_minefield_unref0 (self->priv->_minefield);
	G_OBJECT_CLASS (minefield_view_parent_class)->finalize (obj);
}


GType minefield_view_get_type (void) {
	static volatile gsize minefield_view_type_id__volatile = 0;
	if (g_once_init_enter (&minefield_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (MinefieldViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) minefield_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (MinefieldView), 0, (GInstanceInitFunc) minefield_view_instance_init, NULL };
		GType minefield_view_type_id;
		minefield_view_type_id = g_type_register_static (GTK_TYPE_DRAWING_AREA, "MinefieldView", &g_define_type_info, 0);
		g_once_init_leave (&minefield_view_type_id__volatile, minefield_view_type_id);
	}
	return minefield_view_type_id__volatile;
}


static void _vala_minefield_view_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		value_set_minefield (value, minefield_view_get_minefield (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_minefield_view_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	MinefieldView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, TYPE_MINEFIELD_VIEW, MinefieldView);
	switch (property_id) {
		case MINEFIELD_VIEW_MINEFIELD:
		minefield_view_set_minefield (self, value_get_minefield (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



