#include "frame_mock.h"

/*****************************************************************************
 * Event
 *****************************************************************************/

UFEventType frame_event_get_type(UFEvent self)
{
  return self->type;
}

UFStatus frame_event_get_property(UFEvent self, UFEventProperty property,
                                  void *value)
{
  UFStatus status = UFStatusErrorUnknownProperty;

  if (property == UFEventPropertyFrame && self->frame_ptr)
  {
    *((UFFrame*)value) = self->frame_ptr.get();
    status = UFStatusSuccess;
  }
  else if (property == UFEventPropertyDevice && self->device_ptr)
  {
    *((UFDevice*)value) = self->device_ptr.get();
    status = UFStatusSuccess;
  }

  return status;
}

uint64_t frame_event_get_time(UFEvent self)
{
  return self->time;
}

void frame_event_ref(UFEvent self)
{
  ++self->ref_count;
}

void frame_event_unref(UFEvent self)
{
  --self->ref_count;

  if (self->ref_count == 0)
    delete self;
}

/*****************************************************************************
 * Frame
 *****************************************************************************/

UFStatus frame_frame_get_touch_by_index(UFFrame self, unsigned int index,
                                        UFTouch *touch)
{
  UFStatus status;

  if (index < self->touches.size())
  {
    *touch = &(self->touches[index]);
    status = UFStatusSuccess;
  }
  else
  {
    status = UFStatusErrorInvalidTouch;
  }

  return status;
}

UFStatus frame_frame_get_touch_by_id(UFFrame self, UFTouchId touch_id,
                                     UFTouch* touch_pointer)
{
  UFStatus status = UFStatusErrorInvalidTouch;

  for (struct UFTouch_ &touch : self->touches)
  {
    if (touch.id == touch_id)
    {
      *touch_pointer = &touch;
      status = UFStatusSuccess;
      break;
    }
  }

  return status;
}

uint32_t frame_frame_get_num_touches(UFFrame self)
{
  return self->touches.size();
}

UFDevice frame_frame_get_device(UFFrame self)
{
  return self->device_ptr.get();
}

UFWindowId frame_frame_get_window_id(UFFrame self)
{
  return self->window_id;
}

/*****************************************************************************
 * Touch
 *****************************************************************************/

UFStatus frame_touch_get_property(UFTouch self, UFTouchProperty property,
                                  void *value)
{
  UFStatus status;

  switch (property)
  {
    case UFTouchPropertyOwned:
      *((int*)value) = self->owned;
      status = UFStatusSuccess;
      break;

    case UFTouchPropertyPendingEnd:
      *((int*)value) = self->pending_end;
      status = UFStatusSuccess;
      break;

    default:
      status = UFStatusErrorUnknownProperty;
  }

  return status;
}

UFTouchId frame_touch_get_id(UFTouch self)
{
  return self->id;
}

UFTouchState frame_touch_get_state(UFTouch self)
{
  return self->state;
}

float frame_touch_get_window_x(UFTouch self)
{
  return self->window_x;
}

float frame_touch_get_window_y(UFTouch self)
{
  return self->window_y;
}

float frame_touch_get_device_x(UFTouch self)
{
  return self->device_x;
}

float frame_touch_get_device_y(UFTouch self)
{
  return self->device_y;
}

uint64_t frame_touch_get_time(UFTouch self)
{
  return self->time;
}

uint64_t frame_touch_get_start_time(UFTouch self)
{
  return self->start_time;
}

/*****************************************************************************
 * Device
 *****************************************************************************/

UFStatus frame_device_get_property(UFDevice self, UFDeviceProperty property,
                                   void *value)
{
  UFStatus status;

  switch (property)
  {
    case UFDevicePropertyDirect:
      *((int*)value) = self->direct;
      status = UFStatusSuccess;
      break;

    default:
      status = UFStatusErrorUnknownProperty;
  }

  return status;
}

UFStatus frame_device_get_axis_by_type(UFDevice self, UFAxisType axis_type,
                                       UFAxis *axis_pointer)
{
  UFStatus status = UFStatusErrorInvalidAxis;

  for (struct UFAxis_ &axis : self->axes)
  {
    if (axis.type == axis_type)
    {
      *axis_pointer = &axis;
      status = UFStatusSuccess;
      break;
    }
  }

  return status;
}

float frame_device_get_window_resolution_x(UFDevice self)
{
  return self->window_resolution_x;
}

float frame_device_get_window_resolution_y(UFDevice self)
{
  return self->window_resolution_y;
}

/*****************************************************************************
 * Axis
 *****************************************************************************/

float frame_axis_get_resolution(UFAxis self)
{
  return self->resolution;
}

/*****************************************************************************
 * Frame X11
 *****************************************************************************/

UFStatus frame_x11_accept_touch(UFDevice device, UFWindowId window,
                                UFTouchId touch_id)
{
  device->x11_touch_acceptance[window][touch_id] = true;
  return UFStatusSuccess;
}

UFStatus frame_x11_reject_touch(UFDevice device, UFWindowId window,
                                UFTouchId touch_id)
{
  device->x11_touch_acceptance[window][touch_id] = false;
  return UFStatusSuccess;
}
