/* $Id: site.h,v 1.8 2004/12/11 19:26:09 ellson Exp $ $Revision: 1.8 $ */
/* vim:set shiftwidth=4 ts=8: */

/**********************************************************
*      This software is part of the graphviz package      *
*                http://www.graphviz.org/                 *
*                                                         *
*            Copyright (c) 1994-2004 AT&T Corp.           *
*                and is licensed under the                *
*            Common Public License, Version 1.0           *
*                      by AT&T Corp.                      *
*                                                         *
*        Information and Software Systems Research        *
*              AT&T Research, Florham Park NJ             *
**********************************************************/


#ifndef SITE_H
#define SITE_H

#include "common/Geometry.h"
#include "common/freelist.h"

namespace Voronoi {

    struct Site {
	Coord coord;
	int sitenbr;
	int refcnt;
	 Site():sitenbr(-1), refcnt(0) {
    }};

    struct Sites {
	Freelist < Site > fsites;
	int nvertices;
	Site *getsite();
	void makevertex(Site *);	/* Transform a site into a vertex */
	void deref(Site *);
	void ref(Site *);

	 Sites(int N):fsites(ROUND(sqrt((double) N))), nvertices(0) {
    }};

}				// namespace Voronoi
#endif				// SITE_H
