/*
 *  PGFontColorTableView.m
 *  graphviz
 *
 *  Created by Glen Low on Tue May 04 2004.
 *  Copyright (c) 2004, Pixelglow Software. All rights reserved.
 *  http://www.pixelglow.com/graphviz/
 *  graphviz@pixelglow.com
 *
 *  Redistribution and use in source and binary forms, with or without modification, are permitted
 *  provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright notice, this list of conditions
 *    and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright notice, this list of conditions
 *    and the following disclaimer in the documentation and/or other materials provided with the distribution.
 *  * Neither the name of Pixelglow Software nor the names of its contributors may be used to endorse or
 *    promote products derived from this software without specific prior written permission.
 *
 *  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND ANY EXPRESS OR IMPLIED WARRANTIES,
 *  INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 *  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 *  SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *  LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 *  WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 *  THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */


#import "PGFontColorTableView.h"
#import "PGNilColor.h"

@interface PGChangeColorRedirect: NSObject
	{
	}
- (void) changeTableColor: (id) sender;
@end

@implementation PGChangeColorRedirect

- (void) changeTableColor: (id) sender
	{
		// redirect the changeTableColor message to the responder chain
		[NSApp sendAction: @selector (changeTableColor:) to: nil from: sender];
	}

@end

static PGChangeColorRedirect* redirect_;

@implementation PGFontColorTableView

+ (void) initialize
	{
		[[NSFontManager sharedFontManager] setAction: @selector (changeTableFont:)];
		
		// cause the color panel to send a changeTableColor: message up the responder chain
		// NOTE: NSColorPanel usually either sends changeColor: up the responder chain OR any other action to a specific target
		// whereas we really want our custom, non-interceptable message to be received by the appropriate table...
		redirect_ = [[PGChangeColorRedirect alloc] init];
		NSColorPanel* panel = [NSColorPanel sharedColorPanel];
		[panel setAction: @selector (changeTableColor:)];
		[panel setTarget: redirect_];
	}
	
- (void) updateFontColor
	{
		id delegate = [self delegate];
		if ([delegate respondsToSelector: @selector (tableView:updateColor:)])
			[delegate tableView: self updateColor: [NSColorPanel sharedColorPanel]];	
		if ([delegate respondsToSelector: @selector (tableView:updateFont:)])
			[delegate tableView: self updateFont: [NSFontPanel sharedFontPanel]];
	}
	
- (BOOL) becomeFirstResponder
	{
		// call delegate to update panel selections
		[self updateFontColor];
		return [super becomeFirstResponder];
	}
	
- (void) becomeMainWindow
	{
		[self updateFontColor];
	}

		
- (void) selectRowIndexes: (NSIndexSet*) indexes byExtendingSelection: (BOOL) extend
	{
		[super selectRowIndexes: indexes byExtendingSelection: extend];
		
		// if we are on top, call delegate to update panel selections
		if ([[self window] firstResponder] == self)
			[self updateFontColor];
	}
	
- (void) changeTableColor: (id) sender
	{
		id delegate = [self delegate];
		if ([delegate respondsToSelector: @selector (tableView:changeColor:)])
			[delegate tableView: self changeColor: sender];
	}
	
- (void) changeTableFont: (id) sender
	{
		id delegate = [self delegate];
		if ([delegate respondsToSelector: @selector (tableView:changeFont:)])
			[delegate tableView: self changeFont: sender];
	}

- (unsigned int) validModesForFontPanel: (NSFontPanel*) fontPanel
	{
		id delegate = [self delegate];
		if ([delegate respondsToSelector: @selector (tableView:validModesForFontPanel:)])
			return [delegate tableView: self validModesForFontPanel: fontPanel];
		else
			return NSFontPanelAllModesMask;
	}
	
@end


