package groovy.bugs

class Groovy3339 extends GroovyTestCase {
    void testConstantCachingInClosureClasses() {
        // In all the cases below, the OptimizerVisitor replaces number 10 by
        // the cached constant in the closure class, which it is not supposed
        // to do as the current implementation does not add synthetic fields
        // for constant caching in closure classes. So the closure invocation currently
        // fails in these cases with errors like "java.lang.NoSuchFieldError: $const$0"
        for(myVal in evaluate('[10,11,12]', 2, 'foo') { [10,11,12] }) { 
        	println myVal
        }

        while(evaluate2({10})){
            // do nothing
        }

        synchronized(evaluate({10})){
            // do nothing
        }
    }
    
    def evaluate(closure) {
        def res = closure.call()
        assert res == 10
        return res
    }
    
    def evaluate(text, num, thing, closure) {
    	closure.call()
    }

    def evaluate2(closure) {
        def res = closure.call()
        assert res == 10
        return null
    }
}