// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
  "CMBXTI",
  0xea,
  "TeX text",
  0x00a00000,
  0x460d4396,
  7,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x0006a18d },
  { 0x03, "space_stretch", 0x0002d39e },
  { 0x04, "space_shrink", 0x0001e26a },
  { 0x05, "x_height", 0x00071c72 },
  { 0x06, "quad", 0x0012ea56 },
  { 0x07, "extra_space", 0x0001e26a }
};


static TFM::Kerning C_0b_Kerning[] = {
  { 0x21, 0x0001b4e8 },
  { 0x27, 0x0001b4e8 },
  { 0x29, 0x0001b4e8 },
  { 0x3f, 0x0001b4e8 },
  { 0x5d, 0x0001b4e8 }
};

static TFM::Kerning C_20_Kerning[] = {
  { 0x4c, 0xfff9da76 },
  { 0x6c, 0xfffb40dd }
};

static TFM::Kerning C_27_Kerning[] = {
  { 0x21, 0x0001e26a },
  { 0x3f, 0x0001e26a }
};

static TFM::Kerning C_41_Kerning[] = {
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 },
  { 0x54, 0xfffe9630 },
  { 0x55, 0xffff8765 },
  { 0x56, 0xfffe1d96 },
  { 0x57, 0xfffe1d96 },
  { 0x59, 0xfffe9630 },
  { 0x61, 0xffff0ecb },
  { 0x62, 0xffff8765 },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x68, 0xffff8765 },
  { 0x69, 0xffff8765 },
  { 0x6b, 0xffff8765 },
  { 0x6c, 0xffff8765 },
  { 0x6d, 0xffff8765 },
  { 0x6e, 0xffff8765 },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb },
  { 0x72, 0xffff8765 },
  { 0x74, 0xffff8765 },
  { 0x75, 0xffff8765 },
  { 0x76, 0xffff8765 },
  { 0x77, 0xffff8765 }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x41, 0xffff8765 },
  { 0x56, 0xffff8765 },
  { 0x57, 0xffff8765 },
  { 0x58, 0xffff8765 },
  { 0x59, 0xffff8765 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x41, 0xfffe1d96 },
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 },
  { 0x61, 0xfffe9630 },
  { 0x65, 0xfffe9630 },
  { 0x6f, 0xfffe9630 },
  { 0x72, 0xfffe9630 },
  { 0x75, 0xfffe9630 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x54, 0xfffe9630 },
  { 0x56, 0xfffe1d96 },
  { 0x57, 0xfffe1d96 },
  { 0x59, 0xfffe9630 },
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x41, 0xffff8765 },
  { 0x56, 0xffff8765 },
  { 0x57, 0xffff8765 },
  { 0x58, 0xffff8765 },
  { 0x59, 0xffff8765 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x41, 0xfffe9630 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 },
  { 0x54, 0xfffe9630 },
  { 0x55, 0xffff8765 },
  { 0x56, 0xfffe1d96 },
  { 0x57, 0xfffe1d96 },
  { 0x59, 0xfffe9630 },
  { 0x61, 0xffff0ecb },
  { 0x62, 0xffff8765 },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x68, 0xffff8765 },
  { 0x69, 0xffff8765 },
  { 0x6b, 0xffff8765 },
  { 0x6c, 0xffff8765 },
  { 0x6d, 0xffff8765 },
  { 0x6e, 0xffff8765 },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb },
  { 0x72, 0xffff8765 },
  { 0x74, 0xffff8765 },
  { 0x75, 0xffff8765 },
  { 0x76, 0xffff8765 },
  { 0x77, 0xffff8765 }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x41, 0xfffe9630 },
  { 0x61, 0xfffe9630 },
  { 0x65, 0xfffe9630 },
  { 0x6f, 0xfffe9630 },
  { 0x72, 0xfffe9630 },
  { 0x75, 0xfffe9630 },
  { 0x79, 0xfffe9630 }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x41, 0xfffe1d96 },
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 },
  { 0x61, 0xfffe9630 },
  { 0x65, 0xfffe9630 },
  { 0x6f, 0xfffe9630 },
  { 0x72, 0xfffe9630 },
  { 0x75, 0xfffe9630 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x41, 0xfffe9630 }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x43, 0xffff8765 },
  { 0x47, 0xffff8765 },
  { 0x4f, 0xffff8765 },
  { 0x51, 0xffff8765 }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x41, 0xfffe9630 },
  { 0x61, 0xfffe9630 },
  { 0x65, 0xfffe9630 },
  { 0x6f, 0xfffe9630 },
  { 0x72, 0xfffe9630 },
  { 0x75, 0xfffe9630 }
};

static TFM::Kerning C_62_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_63_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_64_Kerning[] = {
  { 0x6c, 0x0000f135 }
};

static TFM::Kerning C_65_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_66_Kerning[] = {
  { 0x21, 0x0001b4e8 },
  { 0x27, 0x0001b4e8 },
  { 0x29, 0x0001b4e8 },
  { 0x3f, 0x0001b4e8 },
  { 0x5d, 0x0001b4e8 }
};

static TFM::Kerning C_6c_Kerning[] = {
  { 0x6c, 0x0000f135 }
};

static TFM::Kerning C_6e_Kerning[] = {
  { 0x27, 0xfffe1d96 }
};

static TFM::Kerning C_6f_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_70_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_72_Kerning[] = {
  { 0x61, 0xffff0ecb },
  { 0x63, 0xffff0ecb },
  { 0x64, 0xffff0ecb },
  { 0x65, 0xffff0ecb },
  { 0x67, 0xffff0ecb },
  { 0x6f, 0xffff0ecb },
  { 0x71, 0xffff0ecb }
};

static TFM::Kerning C_77_Kerning[] = {
  { 0x6c, 0x0000f135 }
};

static TFM::Ligature C_0b_Ligature[] = {
  { 0x69, 0x00, 0x0e },
  { 0x6c, 0x00, 0x0f }
};

static TFM::Ligature C_21_Ligature[] = {
  { 0x60, 0x00, 0x3c }
};

static TFM::Ligature C_27_Ligature[] = {
  { 0x27, 0x00, 0x22 }
};

static TFM::Ligature C_2d_Ligature[] = {
  { 0x2d, 0x00, 0x7b }
};

static TFM::Ligature C_3f_Ligature[] = {
  { 0x60, 0x00, 0x3e }
};

static TFM::Ligature C_60_Ligature[] = {
  { 0x60, 0x00, 0x5c }
};

static TFM::Ligature C_66_Ligature[] = {
  { 0x66, 0x00, 0x0b },
  { 0x69, 0x00, 0x0c },
  { 0x6c, 0x00, 0x0d }
};

static TFM::Ligature C_7b_Ligature[] = {
  { 0x2d, 0x00, 0x7c }
};


static TFM::Character character[] = {
  { 0x00, 0x000b2a12, 0x000afa50, 0x00000000, 0x000112c8, 0, 0, 0, 0 },
  { 0x01, 0x000f1c68, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000e2b33, 0x000afa50, 0x00000000, 0x00006af3, 0, 0, 0, 0 },
  { 0x03, 0x000ce813, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000c48ca, 0x000afa50, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x000e5670, 0x000afa50, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x06, 0x000d39fe, 0x000afa50, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x07, 0x000e2b33, 0x000afa50, 0x00000000, 0x00014e82, 0, 0, 0, 0 },
  { 0x08, 0x000d39fe, 0x000afa50, 0x00000000, 0x0000e6ae, 0, 0, 0, 0 },
  { 0x09, 0x000e2b33, 0x000afa50, 0x00000000, 0x00014e82, 0, 0, 0, 0 },
  { 0x0a, 0x000d39fe, 0x000afa50, 0x00000000, 0x000112c8, 0, 0, 0, 0 },
  { 0x0b, 0x000c16c0, 0x000b1c72, 0x00031c72, 0x000112c8, 5, C_0b_Kerning, 2, C_0b_Ligature },
  { 0x0c, 0x000aca85, 0x000b1c72, 0x00031c72, 0x000152c8, 0, 0, 0, 0 },
  { 0x0d, 0x000b431e, 0x000b1c72, 0x00031c72, 0x000152c8, 0, 0, 0, 0 },
  { 0x0e, 0x0010b72a, 0x000b1c72, 0x00031c72, 0x000152c8, 0, 0, 0, 0 },
  { 0x0f, 0x0010f376, 0x000b1c72, 0x00031c72, 0x000152c8, 0, 0, 0, 0 },
  { 0x10, 0x0005b058, 0x00071c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x11, 0x000628f3, 0x00071c72, 0x00031c72, 0x0000bce2, 0, 0, 0, 0 },
  { 0x12, 0x0009752b, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x0009752b, 0x000b1c72, 0x00000000, 0x000068d3, 0, 0, 0, 0 },
  { 0x14, 0x0009752b, 0x000a1c72, 0x00000000, 0x000152c8, 0, 0, 0, 0 },
  { 0x15, 0x0009752b, 0x000b1c72, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x16, 0x0009752b, 0x000982d6, 0x00000000, 0x000141fe, 0, 0, 0, 0 },
  { 0x17, 0x000f2e9d, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000883f6, 0x00000000, 0x0002b8e3, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000aa3d6, 0x000b1c72, 0x00031c72, 0x00010c85, 0, 0, 0, 0 },
  { 0x1a, 0x000d39fe, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000d39fe, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x0009752b, 0x0008aaab, 0x00018e3a, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x1d, 0x00105d42, 0x000afa50, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x1e, 0x00123fab, 0x000afa50, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x1f, 0x000e2b33, 0x000bc16d, 0x0000c71d, 0x00006af3, 0, 0, 0, 0 },
  { 0x20, 0x0004bf23, 0x00071c72, 0x00000000, 0x00000000, 2, C_20_Kerning, 0, 0 },
  { 0x21, 0x00062d80, 0x000b1c72, 0x00000000, 0x00008765, 0, 0, 1, C_21_Ligature },
  { 0x22, 0x0009edc8, 0x000b1c72, 0x00000000, 0x00014530, 0, 0, 0, 0 },
  { 0x23, 0x000f1c68, 0x000b1c72, 0x00031c70, 0x000117e5, 0, 0, 0, 0 },
  { 0x24, 0x000de583, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x000f1c68, 0x000c0000, 0x0000e38e, 0x00011236, 0, 0, 0, 0 },
  { 0x26, 0x000e2b33, 0x000b1c72, 0x00000000, 0x000068d3, 0, 0, 0, 0 },
  { 0x27, 0x0005b058, 0x000b1c72, 0x00000000, 0x000117e5, 2, C_27_Kerning, 1, C_27_Ligature },
  { 0x28, 0x000792c2, 0x000c0000, 0x00040000, 0x00006af3, 0, 0, 0, 0 },
  { 0x29, 0x000792c2, 0x000c0000, 0x00040000, 0x00008765, 0, 0, 0, 0 },
  { 0x2a, 0x0009752b, 0x000c0000, 0x00000000, 0x00014e82, 0, 0, 0, 0 },
  { 0x2b, 0x000e2b33, 0x0009a73d, 0x0001a73d, 0x00008765, 0, 0, 0, 0 },
  { 0x2c, 0x0005b058, 0x00025b06, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x0006a18d, 0x00071c72, 0x00000000, 0x00006af3, 0, 0, 1, C_2d_Ligature },
  { 0x2e, 0x0005b058, 0x00025b06, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x0009752b, 0x000c0000, 0x00040000, 0x00006af3, 0, 0, 0, 0 },
  { 0x30, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x31, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x32, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x33, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x34, 0x0009752b, 0x000a4fa5, 0x00031c72, 0x00012cf2, 0, 0, 0, 0 },
  { 0x35, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x36, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x37, 0x0009752b, 0x000a4fa5, 0x00031c72, 0x00012cf2, 0, 0, 0, 0 },
  { 0x38, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x39, 0x0009752b, 0x000a4fa5, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x3a, 0x0005b058, 0x00071c72, 0x00000000, 0x00011236, 0, 0, 0, 0 },
  { 0x3b, 0x0005b058, 0x00071c72, 0x00031c72, 0x00011236, 0, 0, 0, 0 },
  { 0x3c, 0x00062d80, 0x00080000, 0x00031c72, 0x00010c85, 0, 0, 0, 0 },
  { 0x3d, 0x000e2b33, 0x000641fe, 0xfffe41fe, 0x000117e5, 0, 0, 0, 0 },
  { 0x3e, 0x0009752b, 0x00080000, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x0009752b, 0x000b1c72, 0x00000000, 0x0000d5e8, 0, 0, 1, C_3f_Ligature },
  { 0x40, 0x000e2b33, 0x000b1c72, 0x00000000, 0x00008765, 0, 0, 0, 0 },
  { 0x41, 0x000dd948, 0x000afa50, 0x00000000, 0x00000000, 28, C_41_Kerning, 0, 0 },
  { 0x42, 0x000d110a, 0x000afa50, 0x00000000, 0x000112c8, 0, 0, 0, 0 },
  { 0x43, 0x000d39fe, 0x000afa50, 0x00000000, 0x00014530, 0, 0, 0, 0 },
  { 0x44, 0x000e023e, 0x000afa50, 0x00000000, 0x00006af3, 5, C_44_Kerning, 0, 0 },
  { 0x45, 0x000c1b46, 0x000afa50, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x46, 0x000ba2ad, 0x000afa50, 0x00000000, 0x000112c8, 10, C_46_Kerning, 0, 0 },
  { 0x47, 0x000e5306, 0x000afa50, 0x00000000, 0x00012cf2, 0, 0, 0, 0 },
  { 0x48, 0x000e5670, 0x000afa50, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x49, 0x00078bf0, 0x000afa50, 0x00000000, 0x000068d3, 0, 0, 0, 0 },
  { 0x4a, 0x0009c4d0, 0x000afa50, 0x00000000, 0x000152c8, 0, 0, 0, 0 },
  { 0x4b, 0x000e51e3, 0x000afa50, 0x00000000, 0x00014530, 4, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000b2a12, 0x000afa50, 0x00000000, 0x00000000, 11, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00112a0e, 0x000afa50, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x4e, 0x000e5670, 0x000afa50, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x4f, 0x000dae0b, 0x000afa50, 0x00000000, 0x00006af3, 5, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000c986e, 0x000afa50, 0x00000000, 0x000112c8, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000dae0b, 0x000afa50, 0x00031c72, 0x00006af3, 0, 0, 0, 0 },
  { 0x52, 0x000dc042, 0x000afa50, 0x00000000, 0x000068d3, 28, C_52_Kerning, 0, 0 },
  { 0x53, 0x000a6660, 0x000afa50, 0x00000000, 0x000068d3, 0, 0, 0, 0 },
  { 0x54, 0x000cbcd6, 0x000afa50, 0x00000000, 0x000112c8, 7, C_54_Kerning, 0, 0 },
  { 0x55, 0x000e17dd, 0x000afa50, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x56, 0x000dd948, 0x000afa50, 0x00000000, 0x0000e6ae, 10, C_56_Kerning, 0, 0 },
  { 0x57, 0x00128f50, 0x000afa50, 0x00000000, 0x0000e6ae, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000dd948, 0x000afa50, 0x00000000, 0x000068d3, 4, C_58_Kerning, 0, 0 },
  { 0x59, 0x000dd948, 0x000afa50, 0x00000000, 0x00011236, 6, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000b5795, 0x000afa50, 0x00000000, 0x00014530, 0, 0, 0, 0 },
  { 0x5b, 0x0005b2a0, 0x000c0000, 0x00040000, 0x00010c85, 0, 0, 0, 0 },
  { 0x5c, 0x0009edc8, 0x000b1c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x5d, 0x0005b2a0, 0x000c0000, 0x00040000, 0x000117e5, 0, 0, 0, 0 },
  { 0x5e, 0x0009752b, 0x000b1c72, 0x00000000, 0x000112c8, 0, 0, 0, 0 },
  { 0x5f, 0x0005b058, 0x000b1c72, 0x00000000, 0x000117e5, 0, 0, 0, 0 },
  { 0x60, 0x0005b058, 0x000b1c72, 0x00000000, 0x000117e5, 0, 0, 1, C_60_Ligature },
  { 0x61, 0x0009752b, 0x00071c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x62, 0x000883f6, 0x000b1c72, 0x00000000, 0x000141fe, 7, C_62_Kerning, 0, 0 },
  { 0x63, 0x000883f6, 0x00071c72, 0x00000000, 0x0000d5e8, 7, C_63_Kerning, 0, 0 },
  { 0x64, 0x0009752b, 0x000b1c72, 0x00000000, 0x000152c8, 1, C_64_Kerning, 0, 0 },
  { 0x65, 0x000883f6, 0x00071c72, 0x00000000, 0x00000000, 7, C_65_Kerning, 0, 0 },
  { 0x66, 0x00066668, 0x000b1c72, 0x00031c72, 0x000112c8, 5, C_66_Kerning, 3, C_66_Ligature },
  { 0x67, 0x000883f6, 0x00071c72, 0x00031c72, 0x00014530, 0, 0, 0, 0 },
  { 0x68, 0x0009752b, 0x000b1c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x69, 0x0005b058, 0x000b1793, 0x00000000, 0x00006af3, 0, 0, 0, 0 },
  { 0x6a, 0x0005b058, 0x000b1793, 0x00031c72, 0x00008765, 0, 0, 0, 0 },
  { 0x6b, 0x000883f6, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x0004bf23, 0x000b1c72, 0x00000000, 0x000152c8, 1, C_6c_Kerning, 0, 0 },
  { 0x6d, 0x000f1c68, 0x00071c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x6e, 0x000a6660, 0x00071c72, 0x00000000, 0x0000bce2, 1, C_6e_Kerning, 0, 0 },
  { 0x6f, 0x0009752b, 0x00071c72, 0x00000000, 0x000141fe, 7, C_6f_Kerning, 0, 0 },
  { 0x70, 0x0009752b, 0x00071c72, 0x00031c72, 0x000141fe, 7, C_70_Kerning, 0, 0 },
  { 0x71, 0x000883f6, 0x00071c72, 0x00031c72, 0x00014530, 0, 0, 0, 0 },
  { 0x72, 0x000806d2, 0x00071c72, 0x00000000, 0x00000000, 7, C_72_Kerning, 0, 0 },
  { 0x73, 0x0007ca83, 0x00071c72, 0x00000000, 0x00014e82, 0, 0, 0, 0 },
  { 0x74, 0x000628f3, 0x000a28a3, 0x00000000, 0x0000e6ae, 0, 0, 0, 0 },
  { 0x75, 0x0009edc6, 0x00071c72, 0x00000000, 0x0000bce2, 0, 0, 0, 0 },
  { 0x76, 0x000883f6, 0x00071c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000c48ca, 0x00071c72, 0x00000000, 0x00000000, 1, C_77_Kerning, 0, 0 },
  { 0x78, 0x0008f806, 0x00071c72, 0x00000000, 0x00010c85, 0, 0, 0, 0 },
  { 0x79, 0x0008fc92, 0x00071c72, 0x00031c72, 0x00014530, 0, 0, 0, 0 },
  { 0x7a, 0x0007d94e, 0x00071c72, 0x00000000, 0x000141fe, 0, 0, 0, 0 },
  { 0x7b, 0x0009752b, 0x00071c72, 0x00000000, 0x00011236, 0, 0, 1, C_7b_Ligature },
  { 0x7c, 0x0012ea56, 0x00071c72, 0x00000000, 0x00011236, 0, 0, 0, 0 },
  { 0x7d, 0x0009752b, 0x000b1c72, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x7e, 0x0009752b, 0x000b1c72, 0x00000000, 0x0000d5e8, 0, 0, 0, 0 },
  { 0x7f, 0x0009752b, 0x000b1c72, 0x00000000, 0x0000e6ae, 0, 0, 0, 0 }
};

void
cmbxti10_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
