// Copyright (C) 2000-2005, Luca Padovani <luca.padovani@cs.unibo.it>.
//
// This file is part of GtkMathView, a Gtk widget for MathML.
// 
// GtkMathView is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// GtkMathView is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with GtkMathView; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
// 
// For details, see the GtkMathView World-Wide-Web page,
// http://helm.cs.unibo.it/mml-widget/, or send a mail to
// <lpadovan@cs.unibo.it>

#include "TFM.hh"

static TFM::Font font = {
  "CMSY",
  0xf0,
  "TeX math symbols",
  0x00700000,
  0x4f21e285,
  22,
  128
};

static TFM::Dimension dimension[] = {
  { 0x01, "slant", 0x00040000 },
  { 0x02, "space", 0x00000000 },
  { 0x03, "space_stretch", 0x00000000 },
  { 0x04, "space_shrink", 0x00000000 },
  { 0x05, "x_height", 0x0006e38e },
  { 0x06, "quad", 0x0012baf2 },
  { 0x07, "extra_space", 0x00000000 },
  { 0x08, "num1", 0x000bb78e },
  { 0x09, "num2", 0x00062477 },
  { 0x0a, "num3", 0x00078a0e },
  { 0x0b, "denom1", 0x000c08ce },
  { 0x0c, "denom2", 0x000581e7 },
  { 0x0d, "sup1", 0x00080a6b },
  { 0x0e, "sup2", 0x0006e5d9 },
  { 0x0f, "sup3", 0x00049249 },
  { 0x10, "sub1", 0x00024925 },
  { 0x11, "sub2", 0x00049249 },
  { 0x12, "supdrop", 0x0005a697 },
  { 0x13, "subdrop", 0x00012492 },
  { 0x14, "delim1", 0x001b3332 },
  { 0x15, "delim2", 0x001283a9 },
  { 0x16, "axis_height", 0x00040000 }
};


static TFM::Kerning C_41_Kerning[] = {
  { 0x30, 0x000371d0 }
};

static TFM::Kerning C_42_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_43_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_44_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_45_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_46_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_47_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_48_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_49_Kerning[] = {
  { 0x30, 0x00007df9 }
};

static TFM::Kerning C_4a_Kerning[] = {
  { 0x30, 0x0002f3d7 }
};

static TFM::Kerning C_4b_Kerning[] = {
  { 0x30, 0x0000fbf2 }
};

static TFM::Kerning C_4c_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_4d_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_4e_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_4f_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_50_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_51_Kerning[] = {
  { 0x30, 0x0001f7e5 }
};

static TFM::Kerning C_52_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_53_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_54_Kerning[] = {
  { 0x30, 0x00007df9 }
};

static TFM::Kerning C_55_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_56_Kerning[] = {
  { 0x30, 0x00007df9 }
};

static TFM::Kerning C_57_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_58_Kerning[] = {
  { 0x30, 0x000275de }
};

static TFM::Kerning C_59_Kerning[] = {
  { 0x30, 0x000179eb }
};

static TFM::Kerning C_5a_Kerning[] = {
  { 0x30, 0x000275de }
};


static TFM::Character character[] = {
  { 0x00, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x01, 0x00056db9, 0x000771c9, 0xffff71c9, 0x00000000, 0, 0, 0, 0 },
  { 0x02, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x03, 0x00095d79, 0x000771c7, 0xffff71c7, 0x00000000, 0, 0, 0, 0 },
  { 0x04, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x05, 0x00095d79, 0x000771c9, 0xffff71c9, 0x00000000, 0, 0, 0, 0 },
  { 0x06, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x07, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x08, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x09, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x0a, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x0b, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x0c, 0x000e4929, 0x0009e7a0, 0x0001e7a0, 0x00000000, 0, 0, 0, 0 },
  { 0x0d, 0x001238e9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x0e, 0x00095d79, 0x000771c9, 0xffff71c9, 0x00000000, 0, 0, 0, 0 },
  { 0x0f, 0x00095d79, 0x000771c9, 0xffff71c9, 0x00000000, 0, 0, 0, 0 },
  { 0x10, 0x000e4929, 0x0007e6e5, 0xffffe6e5, 0x00000000, 0, 0, 0, 0 },
  { 0x11, 0x000e4929, 0x0007e6e5, 0xffffe6e5, 0x00000000, 0, 0, 0, 0 },
  { 0x12, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x13, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x14, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x15, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x16, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x17, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x18, 0x000e4929, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x19, 0x000e4929, 0x000840d5, 0x000040d5, 0x00000000, 0, 0, 0, 0 },
  { 0x1a, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x1b, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x1c, 0x001238e9, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x1d, 0x001238e9, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x1e, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x1f, 0x000e4929, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x20, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x21, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x22, 0x00095d79, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x23, 0x00095d79, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x24, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x25, 0x001238e9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x26, 0x001238e9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x27, 0x000e4929, 0x0007e6e5, 0xffffe6e5, 0x00000000, 0, 0, 0, 0 },
  { 0x28, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x29, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x2a, 0x000b5559, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2b, 0x000b5559, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2c, 0x001238e9, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x2d, 0x001238e9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2e, 0x001238e9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x2f, 0x000e4929, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x30, 0x00054515, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x31, 0x001238e9, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x32, 0x000c5149, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x33, 0x000c5149, 0x000935f7, 0x000135f7, 0x00000000, 0, 0, 0, 0 },
  { 0x34, 0x00104109, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x35, 0x00104109, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x36, 0x00000000, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x37, 0x00000000, 0x00062530, 0xfffe2530, 0x00000000, 0, 0, 0, 0 },
  { 0x38, 0x000a5969, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x39, 0x000a5969, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3a, 0x000c5149, 0x0006e38e, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3b, 0x00095d79, 0x000c0000, 0x0000e38e, 0x00000000, 0, 0, 0, 0 },
  { 0x3c, 0x000d4d39, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3d, 0x000d4d39, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3e, 0x000e4929, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x3f, 0x000e4929, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x40, 0x000b5559, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x41, 0x000eae80, 0x000aeef0, 0x00000000, 0x00000000, 1, C_41_Kerning, 0, 0 },
  { 0x42, 0x000c0e15, 0x000aeef0, 0x00000000, 0x00006470, 1, C_42_Kerning, 0, 0 },
  { 0x43, 0x0009ec47, 0x000aeef0, 0x00000000, 0x0000cc92, 1, C_43_Kerning, 0, 0 },
  { 0x44, 0x000e3b30, 0x000aeef0, 0x00000000, 0x00007df9, 1, C_44_Kerning, 0, 0 },
  { 0x45, 0x0009db75, 0x000aeef0, 0x00000000, 0x000159a0, 1, C_45_Kerning, 0, 0 },
  { 0x46, 0x000d17fb, 0x000aeef0, 0x00000000, 0x00019cd9, 1, C_46_Kerning, 0, 0 },
  { 0x47, 0x000b042b, 0x000aeef0, 0x00018e39, 0x0000e772, 1, C_47_Kerning, 0, 0 },
  { 0x48, 0x000fa887, 0x000aeef0, 0x00000000, 0x00000000, 1, C_48_Kerning, 0, 0 },
  { 0x49, 0x000a5812, 0x000aeef0, 0x00000000, 0x000109f7, 1, C_49_Kerning, 0, 0 },
  { 0x4a, 0x000c83ae, 0x000aeef0, 0x00018e39, 0x0002fab7, 1, C_4a_Kerning, 0, 0 },
  { 0x4b, 0x000df265, 0x000aeef0, 0x00000000, 0x00000589, 1, C_4b_Kerning, 0, 0 },
  { 0x4c, 0x000caadb, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4c_Kerning, 0, 0 },
  { 0x4d, 0x00157ba7, 0x000aeef0, 0x00000000, 0x00000000, 1, C_4d_Kerning, 0, 0 },
  { 0x4e, 0x000ef819, 0x000aeef0, 0x00000000, 0x000267c9, 1, C_4e_Kerning, 0, 0 },
  { 0x4f, 0x000e7e50, 0x000aeef0, 0x00000000, 0x00007df9, 1, C_4f_Kerning, 0, 0 },
  { 0x50, 0x000cf249, 0x000aeef0, 0x00000000, 0x000156e2, 1, C_50_Kerning, 0, 0 },
  { 0x51, 0x000ef987, 0x000aeef0, 0x00018e39, 0x00000000, 1, C_51_Kerning, 0, 0 },
  { 0x52, 0x000fb252, 0x000aeef0, 0x00000000, 0x00000000, 1, C_52_Kerning, 0, 0 },
  { 0x53, 0x000b3c29, 0x000aeef0, 0x00000000, 0x00012720, 1, C_53_Kerning, 0, 0 },
  { 0x54, 0x000a5d79, 0x000aeef0, 0x00000000, 0x00000000, 1, C_54_Kerning, 0, 0 },
  { 0x55, 0x000b7c1b, 0x000aeef0, 0x00000000, 0x00019cd9, 1, C_55_Kerning, 0, 0 },
  { 0x56, 0x000b84d2, 0x000aeef0, 0x00000000, 0x000156e2, 1, C_56_Kerning, 0, 0 },
  { 0x57, 0x00122967, 0x000aeef0, 0x00000000, 0x000156e2, 1, C_57_Kerning, 0, 0 },
  { 0x58, 0x000d1a09, 0x000aeef0, 0x00000000, 0x000257c5, 1, C_58_Kerning, 0, 0 },
  { 0x59, 0x000c3ade, 0x000aeef0, 0x00018e39, 0x000156e2, 1, C_59_Kerning, 0, 0 },
  { 0x5a, 0x000d2b97, 0x000aeef0, 0x00000000, 0x00014a47, 1, C_5a_Kerning, 0, 0 },
  { 0x5b, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5c, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5d, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5e, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x5f, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x60, 0x000b5559, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x61, 0x000b5559, 0x000b1c72, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x62, 0x00086189, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x63, 0x00086189, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x64, 0x00086189, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x65, 0x00086189, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x66, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x67, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x68, 0x00076599, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x69, 0x00076599, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6a, 0x00056db9, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6b, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6c, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6d, 0x000b5559, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6e, 0x00095d79, 0x000c0000, 0x00040000, 0x00000000, 0, 0, 0, 0 },
  { 0x6f, 0x00056db9, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x70, 0x000f0415, 0x0000c6f2, 0x000f390e, 0x00000000, 0, 0, 0, 0 },
  { 0x71, 0x000dbf02, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x72, 0x000f4519, 0x000aeef0, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x73, 0x0007e59b, 0x000b1c72, 0x00031c72, 0x0001f7e0, 0, 0, 0, 0 },
  { 0x74, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x75, 0x000c5149, 0x0008e390, 0x00000000, 0x00000000, 0, 0, 0, 0 },
  { 0x76, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x77, 0x000e4929, 0x000af7ae, 0x0002f7ae, 0x00000000, 0, 0, 0, 0 },
  { 0x78, 0x0008618b, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x79, 0x00086189, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7a, 0x00086189, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7b, 0x000b5559, 0x000b1c72, 0x00031c72, 0x00000000, 0, 0, 0, 0 },
  { 0x7c, 0x000e4929, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7d, 0x000e4929, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7e, 0x000e4929, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 },
  { 0x7f, 0x000e4929, 0x000b1c72, 0x000212f7, 0x00000000, 0, 0, 0, 0 }
};

void
cmsy7_tables(TFM::Font*& _font, TFM::Dimension*& _dimension, TFM::Character*& _character)
{
  _font = &font;
  _dimension = dimension;
  _character = character;
}
