/* $Id: gucharmap-script-codepoint-list.h,v 1.5 2004/01/30 07:33:04 nlevitt Exp $ */
/*
 * Copyright (c) 2004 Noah Levitt
 *
 * This program is free software; you can redistribute it and/or modify it
 * under the terms of the GNU General Public License as published by the
 * Free Software Foundation; either version 2 of the License, or (at your
 * option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program; if not, write to the Free Software Foundation, Inc.,
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307  USA
 */

#ifndef GUCHARMAP_SCRIPT_CODEPOINT_LIST_H
#define GUCHARMAP_SCRIPT_CODEPOINT_LIST_H

#include <glib-object.h>
#include <glib.h>
#include <gucharmap/gucharmap-codepoint-list.h>
#include <gucharmap/gucharmap-unicode-info.h>

G_BEGIN_DECLS

#define GUCHARMAP_SCRIPT_CODEPOINT_LIST(obj) \
            (G_TYPE_CHECK_INSTANCE_CAST ((obj), gucharmap_script_codepoint_list_get_type (), GucharmapScriptCodepointList))

#define GUCHARMAP_SCRIPT_CODEPOINT_LIST_CLASS(clazz) \
            (G_TYPE_CHECK_CLASS_CAST ((clazz), gucharmap_script_codepoint_list_get_type (), GucharmapScriptCodepointListClass))

#define IS_GUCHARMAP_SCRIPT_CODEPOINT_LIST(obj) \
             (G_TYPE_CHECK_INSTANCE_TYPE ((obj), gucharmap_script_codepoint_list_get_type ()))

#define GUCHARMAP_SCRIPT_CODEPOINT_LIST_GET_CLASS(obj) \
             (G_TYPE_INSTANCE_GET_CLASS ((obj), gucharmap_script_codepoint_list_get_type (), GucharmapScriptCodepointListClass))

typedef struct _GucharmapScriptCodepointList GucharmapScriptCodepointList;
typedef struct _GucharmapScriptCodepointListClass GucharmapScriptCodepointListClass;

struct _GucharmapScriptCodepointList
{
  GucharmapCodepointList parent;
};

struct _GucharmapScriptCodepointListClass
{
  GucharmapCodepointListClass parent_class;
};

GType                    gucharmap_script_codepoint_list_get_type       ();
GucharmapCodepointList * gucharmap_script_codepoint_list_new            ();
gboolean                 gucharmap_script_codepoint_list_set_script     (GucharmapScriptCodepointList  *list,
	                                                                 const gchar                   *script);
gboolean                 gucharmap_script_codepoint_list_set_scripts    (GucharmapScriptCodepointList  *list,
	                                                                 const gchar                  **scripts);
gboolean                 gucharmap_script_codepoint_list_append_script  (GucharmapScriptCodepointList  *list,
                                                                         const gchar                   *script);
/* XXX: gucharmap_script_codepoint_list_get_script? seems unnecessary */

G_END_DECLS

#endif /* #ifndef GUCHARMAP_SCRIPT_CODEPOINT_LIST_H */
