/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

public class AttachmentsItem : TabBarStreamItem
{
  private Gtk.Alignment _align;
  private Gtk.HBox box;

  public AttachmentsItem (Gee.HashMap streams)
  {
    Object (stream:"images", icon_name:"mail-attachment", tooltip:_("Attachments"), streams:streams);
  }

  construct
  {

    _align = new Gtk.Alignment (0.5f, 0.5f, 1.0f, 1.0f);
    
    box = new Gtk.HBox (false, 12);
    _align.add (box);

    var images_but = new TabWidgets.RadioButton (_("Images"));
    images_but.join_group (images_but);
    images_but.clicked.connect(() => {
      if (images_but.active)
      {
        view.model = streams["images"];
        view.stream = "images";
      }
    });
    box.pack_start (images_but, false, false, 0);

    var links_but = new TabWidgets.RadioButton (_("Links"));
    links_but.join_group (images_but);
    links_but.clicked.connect(() => {
      if (links_but.active)
      {
        view.model = streams["links"];
        view.stream = "links";
      }
    });
    box.pack_start (links_but, false, false, 0);

    var videos_but = new TabWidgets.RadioButton (_("Videos"));
    videos_but.join_group (links_but);
    videos_but.clicked.connect(() => {
      if (videos_but.active)
      {
        view.model = streams["videos"];
        view.stream = "videos";
      }
    });
    box.pack_start (videos_but, false, false, 0);

    _align.show_all ();
  }

  public override Gtk.Widget? get_toolbar ()
  {
    return _align;
  }
  
  public override Gtk.Widget? get_view ()
  {
    return view;
  }
}
