/* stream-entry.c generated by valac 0.12.1, the Vala compiler
 * generated from stream-entry.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gwibber-gtk.h>
#include <gwibber.h>
#include <float.h>
#include <math.h>
#include <cairo.h>
#include <gdk/gdk.h>


#define TYPE_STREAM_ENTRY (stream_entry_get_type ())
#define STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_STREAM_ENTRY, StreamEntry))
#define STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_STREAM_ENTRY, StreamEntryClass))
#define IS_STREAM_ENTRY(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_STREAM_ENTRY))
#define IS_STREAM_ENTRY_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_STREAM_ENTRY))
#define STREAM_ENTRY_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_STREAM_ENTRY, StreamEntryClass))

typedef struct _StreamEntry StreamEntry;
typedef struct _StreamEntryClass StreamEntryClass;
typedef struct _StreamEntryPrivate StreamEntryPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _cairo_pattern_destroy0(var) ((var == NULL) ? NULL : (var = (cairo_pattern_destroy (var), NULL)))

struct _StreamEntry {
	GtkAlignment parent_instance;
	StreamEntryPrivate * priv;
	GwibberGtkInputTextView* text_view;
	GtkImage* private;
	GwibberGtkAccountTargetBar* target_bar;
};

struct _StreamEntryClass {
	GtkAlignmentClass parent_class;
};

struct _StreamEntryPrivate {
	GtkVBox* _vbox;
	GtkAlignment* _align;
	GtkLabel* _spacing;
	GwibberService* _service;
	guint _anim_id;
	gfloat _anim_offset;
	gint64 _anim_start;
	gboolean _showing;
};


static gpointer stream_entry_parent_class = NULL;

GType stream_entry_get_type (void) G_GNUC_CONST;
#define STREAM_ENTRY_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_STREAM_ENTRY, StreamEntryPrivate))
enum  {
	STREAM_ENTRY_DUMMY_PROPERTY,
	STREAM_ENTRY_SHOWING
};
StreamEntry* stream_entry_new (void);
StreamEntry* stream_entry_construct (GType object_type);
static gboolean stream_entry_real_draw (GtkWidget* base, cairo_t* cr);
gboolean stream_entry_get_showing (StreamEntry* self);
void stream_entry_set_showing (StreamEntry* self, gboolean value);
static GObject * stream_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _lambda0_ (GtkWidget* t, GdkEventKey* e, StreamEntry* self);
static gboolean __lambda0__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
static void _lambda1_ (StreamEntry* self);
static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self);
static void _lambda2_ (StreamEntry* self);
static void __lambda2__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self);
static void _lambda3_ (StreamEntry* self);
static void __lambda3__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda4_ (StreamEntry* self);
static void __lambda4__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda5_ (StreamEntry* self);
static void __lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self);
static void _lambda6_ (StreamEntry* self);
static void __lambda6__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self);
static gboolean _lambda7_ (StreamEntry* self);
static gboolean __lambda7__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void _lambda8_ (StreamEntry* self);
static gboolean _lambda9_ (StreamEntry* self);
static gboolean __lambda9__gsource_func (gpointer self);
static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void stream_entry_finalize (GObject* obj);
static void _vala_stream_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_stream_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


StreamEntry* stream_entry_construct (GType object_type) {
	StreamEntry * self = NULL;
	self = (StreamEntry*) g_object_new (object_type, NULL);
	return self;
}


StreamEntry* stream_entry_new (void) {
	return stream_entry_construct (TYPE_STREAM_ENTRY);
}


static gboolean stream_entry_real_draw (GtkWidget* base, cairo_t* cr) {
	StreamEntry * self;
	gboolean result = FALSE;
	GtkAllocation a = {0};
	GtkAllocation _tmp0_ = {0};
	gfloat r;
	gint _tmp1_;
	cairo_pattern_t* _tmp2_ = NULL;
	cairo_pattern_t* pat;
	cairo_pattern_t* _tmp3_ = NULL;
	gboolean _tmp4_;
	cairo_pattern_t* _tmp7_ = NULL;
	self = (StreamEntry*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	cairo_push_group (cr);
	cairo_save (cr);
	gtk_widget_get_allocation ((GtkWidget*) self->priv->_align, &_tmp0_);
	a = _tmp0_;
	cairo_translate (cr, (gdouble) 0, (gdouble) (((-1) * a.height) + (a.height * self->priv->_anim_offset)));
	a.height = a.height - 12;
	r = 4.0f;
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) a.y, (gdouble) a.width, (gdouble) a.height);
	_tmp1_ = gtk_widget_get_allocated_height ((GtkWidget*) self->priv->_align);
	_tmp2_ = cairo_pattern_create_linear ((gdouble) 0, (gdouble) 0, (gdouble) 0, (gdouble) _tmp1_);
	pat = _tmp2_;
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 0, 69 / 255.0, 69 / 255.0, 69 / 255.0, 0.85);
	cairo_pattern_add_color_stop_rgba (pat, 1.0, 20 / 255.0, 20 / 255.0, 20 / 255.0, 0.85);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.3f);
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) a.y, (gdouble) a.width, (gdouble) 1);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) (a.y + 1), (gdouble) a.width, (gdouble) 1);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 1.0f, (gdouble) 0.2f);
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) ((a.y + a.height) - 2), (gdouble) a.width, (gdouble) 1);
	cairo_fill (cr);
	cairo_set_source_rgba (cr, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.3f);
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) ((a.y + a.height) - 1), (gdouble) a.width, (gdouble) 1);
	cairo_fill (cr);
	_tmp3_ = cairo_pattern_create_linear ((gdouble) a.x, (gdouble) (a.y + a.height), (gdouble) a.x, (gdouble) ((a.y + a.height) + 12));
	_cairo_pattern_destroy0 (pat);
	pat = _tmp3_;
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.4f);
	cairo_pattern_add_color_stop_rgba (pat, (gdouble) 1.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f, (gdouble) 0.0f);
	cairo_rectangle (cr, (gdouble) a.x, (gdouble) (a.y + a.height), (gdouble) a.width, (gdouble) 12);
	cairo_set_source (cr, pat);
	cairo_fill (cr);
	_tmp4_ = gtk_widget_get_visible ((GtkWidget*) self->text_view);
	if (_tmp4_) {
		GtkAllocation _tmp5_ = {0};
		gtk_widget_get_allocation ((GtkWidget*) self->text_view, &_tmp5_);
		a = _tmp5_;
	} else {
		GtkAllocation _tmp6_ = {0};
		gtk_widget_get_allocation ((GtkWidget*) self->priv->_spacing, &_tmp6_);
		a = _tmp6_;
	}
	_tmp7_ = cairo_pattern_create_linear ((gdouble) a.x, (gdouble) a.y, (gdouble) a.x, (gdouble) (a.y + a.height));
	_cairo_pattern_destroy0 (pat);
	pat = _tmp7_;
	cairo_pattern_add_color_stop_rgba (pat, 0.99, (gdouble) (24 / 255.0f), (gdouble) (24 / 255.0f), (gdouble) (24 / 255.0f), 1.0);
	cairo_pattern_add_color_stop_rgba (pat, 1.0, (gdouble) (90 / 255.0f), (gdouble) (90 / 255.0f), (gdouble) (90 / 255.0f), 0.9);
	cairo_set_source (cr, pat);
	cairo_rectangle (cr, (gdouble) (a.x - 1), (gdouble) (a.y - 1), (gdouble) (a.width + 2), (gdouble) (a.height + 2));
	cairo_fill (cr);
	cairo_move_to (cr, (gdouble) (a.x - 1), (gdouble) (a.y - 1));
	cairo_line_to (cr, (gdouble) (((a.x - 1) + a.width) + 2), (gdouble) (a.y - 1));
	cairo_set_source_rgba (cr, (gdouble) (10 / 255.0f), (gdouble) (10 / 255.0f), (gdouble) (10 / 255.0f), (gdouble) 1.0f);
	cairo_stroke (cr);
	gtk_container_propagate_draw ((GtkContainer*) self, (GtkWidget*) self->priv->_vbox, cr);
	cairo_restore (cr);
	cairo_pop_group_to_source (cr);
	cairo_paint_with_alpha (cr, (gdouble) self->priv->_anim_offset);
	result = TRUE;
	_cairo_pattern_destroy0 (pat);
	return result;
}


gboolean stream_entry_get_showing (StreamEntry* self) {
	gboolean result;
	g_return_val_if_fail (self != NULL, FALSE);
	result = self->priv->_showing;
	return result;
}


void stream_entry_set_showing (StreamEntry* self, gboolean value) {
	g_return_if_fail (self != NULL);
	self->priv->_showing = value;
	if (self->priv->_showing) {
		gtk_widget_show ((GtkWidget*) self);
	} else {
		gtk_widget_hide ((GtkWidget*) self->private);
		gwibber_gtk_account_target_bar_set_selected (self->target_bar, NULL);
		gtk_widget_hide ((GtkWidget*) self->text_view);
		gtk_widget_show ((GtkWidget*) self->priv->_spacing);
	}
	g_object_notify ((GObject *) self, "showing");
}


static gboolean _lambda0_ (GtkWidget* t, GdkEventKey* e, StreamEntry* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (t != NULL, FALSE);
	if ((*e).keyval == 65307) {
		stream_entry_set_showing (self, FALSE);
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


static gboolean __lambda0__gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = _lambda0_ (_sender, event, self);
	return result;
}


static void _lambda1_ (StreamEntry* self) {
	g_signal_emit_by_name (self->text_view, "submit");
}


static void __lambda1__gtk_button_clicked (GtkButton* _sender, gpointer self) {
	_lambda1_ (self);
}


static void _lambda2_ (StreamEntry* self) {
	stream_entry_set_showing (self, FALSE);
}


static void __lambda2__gwibber_gtk_input_text_view_submit (GwibberGtkInputTextView* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _lambda3_ (StreamEntry* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __lambda3__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda3_ (self);
}


static void _lambda4_ (StreamEntry* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __lambda4__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda4_ (self);
}


static void _lambda5_ (StreamEntry* self) {
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static void __lambda5__gtk_widget_size_allocate (GtkWidget* _sender, GdkRectangle* allocation, gpointer self) {
	_lambda5_ (self);
}


static void _lambda6_ (StreamEntry* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	gint _tmp1_;
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self->text_view);
	_tmp1_ = gtk_text_buffer_get_char_count (_tmp0_);
	gwibber_gtk_account_target_bar_set_counter (self->target_bar, _tmp1_);
}


static void __lambda6__gtk_text_buffer_changed (GtkTextBuffer* _sender, gpointer self) {
	_lambda6_ (self);
}


static gboolean _lambda7_ (StreamEntry* self) {
	gboolean result = FALSE;
	stream_entry_set_showing (self, FALSE);
	result = TRUE;
	return result;
}


static gboolean __lambda7__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda7_ (self);
	return result;
}


static gboolean _lambda9_ (StreamEntry* self) {
	gboolean result = FALSE;
	gfloat LENGTH;
	gint64 _tmp0_;
	gint64 diff;
	gfloat progress;
	LENGTH = 120000.0f;
	_tmp0_ = g_get_monotonic_time ();
	diff = _tmp0_ - self->priv->_anim_start;
	progress = diff / LENGTH;
	gtk_widget_queue_draw ((GtkWidget*) self);
	if (self->priv->_showing) {
		self->priv->_anim_offset = self->priv->_anim_offset + ((1.0f - self->priv->_anim_offset) * progress);
	} else {
		self->priv->_anim_offset = self->priv->_anim_offset - (self->priv->_anim_offset * progress);
	}
	if (diff > LENGTH) {
		gfloat _tmp1_ = 0.0F;
		self->priv->_anim_id = (guint) 0;
		if (self->priv->_showing) {
			_tmp1_ = 1.0f;
		} else {
			_tmp1_ = 0.0f;
		}
		self->priv->_anim_offset = _tmp1_;
		gtk_widget_set_visible ((GtkWidget*) self->text_view, self->priv->_showing);
		gtk_widget_set_visible ((GtkWidget*) self->priv->_spacing, !self->priv->_showing);
		gtk_widget_set_visible ((GtkWidget*) self, self->priv->_showing);
		result = FALSE;
		return result;
	}
	result = TRUE;
	return result;
}


static gboolean __lambda9__gsource_func (gpointer self) {
	gboolean result;
	result = _lambda9_ (self);
	return result;
}


static void _lambda8_ (StreamEntry* self) {
	gint64 _tmp0_;
	guint _tmp1_;
	if (self->priv->_anim_id != 0) {
		g_source_remove (self->priv->_anim_id);
	}
	_tmp0_ = g_get_monotonic_time ();
	self->priv->_anim_start = _tmp0_;
	_tmp1_ = g_timeout_add_full (G_PRIORITY_DEFAULT, (guint) 15, __lambda9__gsource_func, g_object_ref (self), g_object_unref);
	self->priv->_anim_id = _tmp1_;
}


static void __lambda8__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	_lambda8_ (self);
}


static GObject * stream_entry_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	StreamEntry * self;
	GtkVBox* _tmp0_ = NULL;
	GtkAlignment* _tmp1_ = NULL;
	GtkVBox* _tmp2_ = NULL;
	GtkVBox* box;
	GwibberService* _tmp3_ = NULL;
	GtkSizeGroup* _tmp4_ = NULL;
	GtkSizeGroup* group;
	GtkLabel* _tmp5_ = NULL;
	GwibberGtkInputTextView* _tmp6_ = NULL;
	GdkRGBA color = {0};
	GdkColor _tmp7_ = {0};
	GtkHBox* _tmp8_ = NULL;
	GtkHBox* hbox;
	GtkImage* _tmp9_ = NULL;
	GwibberGtkAccountTargetBar* _tmp10_ = NULL;
	GtkTextBuffer* _tmp11_ = NULL;
	GtkEventBox* _tmp12_ = NULL;
	GtkEventBox* eb;
	parent_class = G_OBJECT_CLASS (stream_entry_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = STREAM_ENTRY (obj);
	gtk_container_set_reallocate_redraws ((GtkContainer*) self, TRUE);
	_tmp0_ = (GtkVBox*) gtk_vbox_new (FALSE, 0);
	_g_object_unref0 (self->priv->_vbox);
	self->priv->_vbox = g_object_ref_sink (_tmp0_);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_vbox);
	_tmp1_ = (GtkAlignment*) gtk_alignment_new (0.0f, 0.0f, 1.0f, 1.0f);
	_g_object_unref0 (self->priv->_align);
	self->priv->_align = g_object_ref_sink (_tmp1_);
	gtk_alignment_set_padding (self->priv->_align, (guint) 18, (guint) 18, (guint) 18, (guint) 18);
	gtk_box_pack_start ((GtkBox*) self->priv->_vbox, (GtkWidget*) self->priv->_align, FALSE, FALSE, (guint) 0);
	_tmp2_ = (GtkVBox*) gtk_vbox_new (FALSE, 4);
	box = g_object_ref_sink (_tmp2_);
	gtk_container_add ((GtkContainer*) self->priv->_align, (GtkWidget*) box);
	_tmp3_ = gwibber_service_new ();
	_g_object_unref0 (self->priv->_service);
	self->priv->_service = _tmp3_;
	_tmp4_ = gtk_size_group_new (GTK_SIZE_GROUP_VERTICAL);
	group = _tmp4_;
	_tmp5_ = (GtkLabel*) gtk_label_new (" ");
	_g_object_unref0 (self->priv->_spacing);
	self->priv->_spacing = g_object_ref_sink (_tmp5_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->priv->_spacing, FALSE, TRUE, (guint) 0);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->_spacing, TRUE);
	gtk_widget_show ((GtkWidget*) self->priv->_spacing);
	gtk_size_group_add_widget (group, (GtkWidget*) self->priv->_spacing);
	_tmp6_ = gwibber_gtk_input_text_view_new (self->priv->_service);
	_g_object_unref0 (self->text_view);
	self->text_view = g_object_ref_sink (_tmp6_);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self->text_view, GTK_WRAP_WORD_CHAR);
	gtk_text_view_set_border_window_size ((GtkTextView*) self->text_view, GTK_TEXT_WINDOW_LEFT, 0);
	gtk_text_view_set_border_window_size ((GtkTextView*) self->text_view, GTK_TEXT_WINDOW_RIGHT, 0);
	gtk_text_view_set_border_window_size ((GtkTextView*) self->text_view, GTK_TEXT_WINDOW_TOP, 0);
	gtk_text_view_set_border_window_size ((GtkTextView*) self->text_view, GTK_TEXT_WINDOW_BOTTOM, 0);
	gtk_widget_set_no_show_all ((GtkWidget*) self->text_view, TRUE);
	gtk_size_group_add_widget (group, (GtkWidget*) self->text_view);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) self->text_view, FALSE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) self->text_view, "key-press-event", (GCallback) __lambda0__gtk_widget_key_press_event, self, 0);
	color.red = (gdouble) (34 / 255.0f);
	color.green = (gdouble) (34 / 255.0f);
	color.blue = (gdouble) (34 / 255.0f);
	color.alpha = (gdouble) 1.0f;
	gtk_widget_override_background_color ((GtkWidget*) self->text_view, GTK_STATE_FLAG_NORMAL, &color);
	color.red = (gdouble) 1.0f;
	color.green = (gdouble) 1.0f;
	color.blue = (gdouble) 1.0f;
	gtk_widget_override_color ((GtkWidget*) self->text_view, GTK_STATE_FLAG_NORMAL, &color);
	_tmp7_.pixel = (guint32) 0;
	_tmp7_.red = (guint16) 65535;
	_tmp7_.green = (guint16) 65535;
	_tmp7_.blue = (guint16) 65535;
	self->text_view->fg_color = _tmp7_;
	color.alpha = (gdouble) 0.5f;
	gtk_widget_override_background_color ((GtkWidget*) self->text_view, GTK_STATE_FLAG_SELECTED, &color);
	color.red = (gdouble) 0.0f;
	color.green = (gdouble) 0.0f;
	color.blue = (gdouble) 0.0f;
	color.alpha = (gdouble) 1.0f;
	gtk_widget_override_color ((GtkWidget*) self->text_view, GTK_STATE_FLAG_SELECTED, &color);
	_tmp8_ = (GtkHBox*) gtk_hbox_new (FALSE, 12);
	hbox = g_object_ref_sink (_tmp8_);
	gtk_box_pack_start ((GtkBox*) box, (GtkWidget*) hbox, FALSE, FALSE, (guint) 0);
	_tmp9_ = (GtkImage*) gtk_image_new_from_icon_name ("status_lock", GTK_ICON_SIZE_MENU);
	_g_object_unref0 (self->private);
	self->private = g_object_ref_sink (_tmp9_);
	gtk_widget_set_no_show_all ((GtkWidget*) self->private, TRUE);
	gtk_box_pack_end ((GtkBox*) hbox, (GtkWidget*) self->private, FALSE, FALSE, (guint) 0);
	_tmp10_ = gwibber_gtk_account_target_bar_new ();
	_g_object_unref0 (self->target_bar);
	self->target_bar = g_object_ref_sink (_tmp10_);
	gtk_box_pack_start ((GtkBox*) hbox, (GtkWidget*) self->target_bar, TRUE, TRUE, (guint) 0);
	color.red = (gdouble) 1.0f;
	color.green = (gdouble) 1.0f;
	color.blue = (gdouble) 1.0f;
	color.alpha = (gdouble) 0.5f;
	gtk_widget_override_color ((GtkWidget*) self->target_bar, GTK_STATE_FLAG_NORMAL, &color);
	gtk_widget_override_color ((GtkWidget*) self->target_bar->count, GTK_STATE_FLAG_NORMAL, &color);
	g_signal_connect_object (self->target_bar->send, "clicked", (GCallback) __lambda1__gtk_button_clicked, self, 0);
	g_signal_connect_object (self->text_view, "submit", (GCallback) __lambda2__gwibber_gtk_input_text_view_submit, self, 0);
	g_signal_connect_object ((GtkWidget*) self->priv->_align, "size-allocate", (GCallback) __lambda3__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) self->text_view, "size-allocate", (GCallback) __lambda4__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	g_signal_connect_object ((GtkWidget*) box, "size-allocate", (GCallback) __lambda5__gtk_widget_size_allocate, self, G_CONNECT_AFTER);
	_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self->text_view);
	g_signal_connect_object (_tmp11_, "changed", (GCallback) __lambda6__gtk_text_buffer_changed, self, 0);
	_tmp12_ = (GtkEventBox*) gtk_event_box_new ();
	eb = g_object_ref_sink (_tmp12_);
	gtk_event_box_set_visible_window (eb, FALSE);
	gtk_event_box_set_above_child (eb, FALSE);
	gtk_box_pack_end ((GtkBox*) self->priv->_vbox, (GtkWidget*) eb, TRUE, TRUE, (guint) 0);
	g_signal_connect_object ((GtkWidget*) eb, "button-press-event", (GCallback) __lambda7__gtk_widget_button_press_event, self, 0);
	g_signal_connect_object ((GObject*) self, "notify::showing", (GCallback) __lambda8__g_object_notify, self, 0);
	_g_object_unref0 (eb);
	_g_object_unref0 (hbox);
	_g_object_unref0 (group);
	_g_object_unref0 (box);
	return obj;
}


static void stream_entry_class_init (StreamEntryClass * klass) {
	stream_entry_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (StreamEntryPrivate));
	GTK_WIDGET_CLASS (klass)->draw = stream_entry_real_draw;
	G_OBJECT_CLASS (klass)->get_property = _vala_stream_entry_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_stream_entry_set_property;
	G_OBJECT_CLASS (klass)->constructor = stream_entry_constructor;
	G_OBJECT_CLASS (klass)->finalize = stream_entry_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), STREAM_ENTRY_SHOWING, g_param_spec_boolean ("showing", "showing", "showing", FALSE, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE));
}


static void stream_entry_instance_init (StreamEntry * self) {
	self->priv = STREAM_ENTRY_GET_PRIVATE (self);
	self->priv->_anim_id = (guint) 0;
	self->priv->_anim_offset = 0.0f;
	self->priv->_anim_start = (gint64) 0;
	self->priv->_showing = FALSE;
}


static void stream_entry_finalize (GObject* obj) {
	StreamEntry * self;
	self = STREAM_ENTRY (obj);
	_g_object_unref0 (self->priv->_vbox);
	_g_object_unref0 (self->priv->_align);
	_g_object_unref0 (self->text_view);
	_g_object_unref0 (self->priv->_spacing);
	_g_object_unref0 (self->private);
	_g_object_unref0 (self->priv->_service);
	_g_object_unref0 (self->target_bar);
	G_OBJECT_CLASS (stream_entry_parent_class)->finalize (obj);
}


GType stream_entry_get_type (void) {
	static volatile gsize stream_entry_type_id__volatile = 0;
	if (g_once_init_enter (&stream_entry_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (StreamEntryClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) stream_entry_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (StreamEntry), 0, (GInstanceInitFunc) stream_entry_instance_init, NULL };
		GType stream_entry_type_id;
		stream_entry_type_id = g_type_register_static (GTK_TYPE_ALIGNMENT, "StreamEntry", &g_define_type_info, 0);
		g_once_init_leave (&stream_entry_type_id__volatile, stream_entry_type_id);
	}
	return stream_entry_type_id__volatile;
}


static void _vala_stream_entry_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	StreamEntry * self;
	self = STREAM_ENTRY (object);
	switch (property_id) {
		case STREAM_ENTRY_SHOWING:
		g_value_set_boolean (value, stream_entry_get_showing (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_stream_entry_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	StreamEntry * self;
	self = STREAM_ENTRY (object);
	switch (property_id) {
		case STREAM_ENTRY_SHOWING:
		stream_entry_set_showing (self, g_value_get_boolean (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



