/* action-box.c generated by valac 0.12.1, the Vala compiler
 * generated from action-box.vala, do not modify */

/*
 * Copyright (C) 2011 Canonical Ltd.
 *
 * This program is free software: you can redistribute it and/or modify it
 * under the terms of the GNU General Public License version 3, as published
 * by the Free Software Foundation.

 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranties of
 * MERCHANTABILITY, SATISFACTORY QUALITY, or FITNESS FOR A PARTICULAR
 * PURPOSE.  See the GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License along
 * with this program.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authored by Ken VanDine <ken@vandine.org>
 */

#include <glib.h>
#include <glib-object.h>
#include "gwibber-gtk.h"
#include <stdlib.h>
#include <string.h>
#include <gtk/gtk.h>
#include <gwibber.h>
#include <glib/gi18n-lib.h>
#include <json-glib/json-glib.h>
#include <gio/gio.h>
#include <libnotify/notify.h>
#include <config.h>
#include <glib/gstdio.h>
#include <gdk/gdk.h>

#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_list_free0(var) ((var == NULL) ? NULL : (var = (g_list_free (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
#define _json_object_unref0(var) ((var == NULL) ? NULL : (var = (json_object_unref (var), NULL)))

struct _GwibberGtkActionBoxItemPrivate {
	gchar* _service;
	gchar* _stream;
	gchar* _account;
	gchar* _mid;
	gchar* _sender;
	gchar* _action;
	gchar* _tooltip;
	GtkImage* _image;
	gchar* _icon;
	gchar* _scalable_icon;
	GtkMenu* menu;
	GtkMenuItem* amenu;
};


static gpointer gwibber_gtk_action_box_parent_class = NULL;
static gpointer gwibber_gtk_action_box_item_parent_class = NULL;

enum  {
	GWIBBER_GTK_ACTION_BOX_DUMMY_PROPERTY
};
static GObject * gwibber_gtk_action_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
#define GWIBBER_GTK_ACTION_BOX_ITEM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), GWIBBER_GTK_TYPE_ACTION_BOX_ITEM, GwibberGtkActionBoxItemPrivate))
enum  {
	GWIBBER_GTK_ACTION_BOX_ITEM_DUMMY_PROPERTY,
	GWIBBER_GTK_ACTION_BOX_ITEM_SERVICE,
	GWIBBER_GTK_ACTION_BOX_ITEM_STREAM,
	GWIBBER_GTK_ACTION_BOX_ITEM_ACCOUNT,
	GWIBBER_GTK_ACTION_BOX_ITEM_MID,
	GWIBBER_GTK_ACTION_BOX_ITEM_SENDER,
	GWIBBER_GTK_ACTION_BOX_ITEM_ACTION,
	GWIBBER_GTK_ACTION_BOX_ITEM_TOOLTIP
};
static void gwibber_gtk_action_box_item_user_stream (GwibberGtkActionBoxItem* self, const gchar* account, const gchar* sender);
static GtkMenu* gwibber_gtk_action_box_item_build_menu (GwibberGtkActionBoxItem* self);
static void _lambda0_ (GwibberGtkActionBoxItem* self);
static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda1_ (GwibberGtkActionBoxItem* self);
static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda2_ (GwibberGtkActionBoxItem* self);
static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void _lambda3_ (GwibberGtkActionBoxItem* self);
static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void gwibber_gtk_action_box_item_real_reply (GwibberGtkActionBoxItem* self, const gchar* mid, const gchar* account, const gchar* sender);
static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static GObject * gwibber_gtk_action_box_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties);
static gboolean _lambda4_ (GdkEventButton* event, GwibberGtkActionBoxItem* self);
static gboolean __lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void gwibber_gtk_action_box_item_finalize (GObject* obj);
static void _vala_gwibber_gtk_action_box_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_gwibber_gtk_action_box_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);


GwibberGtkActionBox* gwibber_gtk_action_box_construct (GType object_type) {
	GwibberGtkActionBox * self = NULL;
	self = (GwibberGtkActionBox*) g_object_new (object_type, NULL);
	return self;
}


GwibberGtkActionBox* gwibber_gtk_action_box_new (void) {
	return gwibber_gtk_action_box_construct (GWIBBER_GTK_TYPE_ACTION_BOX);
}


static GObject * gwibber_gtk_action_box_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkActionBox * self;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_action_box_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACTION_BOX (obj);
	return obj;
}


static void gwibber_gtk_action_box_class_init (GwibberGtkActionBoxClass * klass) {
	gwibber_gtk_action_box_parent_class = g_type_class_peek_parent (klass);
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_action_box_constructor;
}


static void gwibber_gtk_action_box_instance_init (GwibberGtkActionBox * self) {
}


GType gwibber_gtk_action_box_get_type (void) {
	static volatile gsize gwibber_gtk_action_box_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_action_box_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkActionBoxClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_action_box_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkActionBox), 0, (GInstanceInitFunc) gwibber_gtk_action_box_instance_init, NULL };
		GType gwibber_gtk_action_box_type_id;
		gwibber_gtk_action_box_type_id = g_type_register_static (GTK_TYPE_HBOX, "GwibberGtkActionBox", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_action_box_type_id__volatile, gwibber_gtk_action_box_type_id);
	}
	return gwibber_gtk_action_box_type_id__volatile;
}


GwibberGtkActionBoxItem* gwibber_gtk_action_box_item_construct (GType object_type, const gchar* service, const gchar* stream, const gchar* account, const gchar* mid, const gchar* sender, const gchar* tooltip) {
	GwibberGtkActionBoxItem * self = NULL;
	g_return_val_if_fail (service != NULL, NULL);
	g_return_val_if_fail (stream != NULL, NULL);
	g_return_val_if_fail (account != NULL, NULL);
	g_return_val_if_fail (mid != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	g_return_val_if_fail (tooltip != NULL, NULL);
	self = (GwibberGtkActionBoxItem*) g_object_new (object_type, "service", service, "stream", stream, "account", account, "mid", mid, "sender", sender, "tooltip", tooltip, NULL);
	return self;
}


GwibberGtkActionBoxItem* gwibber_gtk_action_box_item_new (const gchar* service, const gchar* stream, const gchar* account, const gchar* mid, const gchar* sender, const gchar* tooltip) {
	return gwibber_gtk_action_box_item_construct (GWIBBER_GTK_TYPE_ACTION_BOX_ITEM, service, stream, account, mid, sender, tooltip);
}


static gchar* string_replace (const gchar* self, const gchar* old, const gchar* replacement) {
	gchar* result = NULL;
	gchar* _tmp0_ = NULL;
	gchar* _tmp1_;
	GRegex* _tmp2_ = NULL;
	GRegex* _tmp3_;
	GRegex* regex;
	gchar* _tmp4_ = NULL;
	gchar* _tmp5_;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_tmp0_ = g_regex_escape_string (old, -1);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_regex_new (_tmp1_, 0, 0, &_inner_error_);
	_tmp3_ = _tmp2_;
	_g_free0 (_tmp1_);
	regex = _tmp3_;
	if (_inner_error_ != NULL) {
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	_tmp4_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
	_tmp5_ = _tmp4_;
	if (_inner_error_ != NULL) {
		_g_regex_unref0 (regex);
		if (_inner_error_->domain == G_REGEX_ERROR) {
			goto __catch0_g_regex_error;
		}
		_g_regex_unref0 (regex);
		g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	result = _tmp5_;
	_g_regex_unref0 (regex);
	return result;
	_g_regex_unref0 (regex);
	goto __finally0;
	__catch0_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_assert_not_reached ();
		_g_error_free0 (e);
	}
	__finally0:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


static void gwibber_gtk_action_box_item_user_stream (GwibberGtkActionBoxItem* self, const gchar* account, const gchar* sender) {
	GwibberStreams* _tmp0_ = NULL;
	GwibberStreams* streams;
	gchar* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_ = NULL;
	gchar* _tmp4_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
	_tmp0_ = gwibber_streams_new ();
	streams = _tmp0_;
	_tmp1_ = string_replace (sender, "@", "");
	_tmp2_ = _tmp1_;
	_tmp3_ = gwibber_streams_create (streams, account, _tmp2_, "user_messages");
	_tmp4_ = _tmp3_;
	_g_free0 (_tmp4_);
	_g_free0 (_tmp2_);
	_g_object_unref0 (streams);
}


gboolean gwibber_gtk_action_box_item_share (GwibberGtkActionBoxItem* self, const gchar* mid, const gchar* account) {
	gboolean result = FALSE;
	GwibberService* _tmp0_ = NULL;
	GwibberService* service;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mid != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	_tmp0_ = gwibber_service_new ();
	service = _tmp0_;
	_tmp1_ = gwibber_service_retweet (service, mid, account);
	result = _tmp1_;
	_g_object_unref0 (service);
	return result;
}


gboolean gwibber_gtk_action_box_item_like (GwibberGtkActionBoxItem* self, const gchar* mid, const gchar* account) {
	gboolean result = FALSE;
	GwibberService* _tmp0_ = NULL;
	GwibberService* service;
	gboolean _tmp1_;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (mid != NULL, FALSE);
	g_return_val_if_fail (account != NULL, FALSE);
	_tmp0_ = gwibber_service_new ();
	service = _tmp0_;
	_tmp1_ = gwibber_service_like (service, mid, account);
	result = _tmp1_;
	_g_object_unref0 (service);
	return result;
}


static gpointer _json_object_ref0 (gpointer self) {
	return self ? json_object_ref (self) : NULL;
}


static void _lambda0_ (GwibberGtkActionBoxItem* self) {
	gchar* _tmp0_;
	gchar* nick;
	JsonObject* obj;
	JsonObject* sender_obj;
	GwibberMessages* _tmp1_ = NULL;
	GwibberMessages* messages;
	gchar* _tmp2_ = NULL;
	gchar* msg;
	JsonParser* _tmp3_ = NULL;
	JsonParser* parser;
	JsonNode* _tmp4_ = NULL;
	JsonObject* _tmp5_ = NULL;
	JsonObject* _tmp6_;
	gint _tmp13_;
	GError * _inner_error_ = NULL;
	_tmp0_ = g_strdup ("");
	nick = _tmp0_;
	obj = NULL;
	sender_obj = NULL;
	_tmp1_ = gwibber_messages_new ();
	messages = _tmp1_;
	_tmp2_ = gwibber_messages_get_message (messages, self->priv->_mid);
	msg = _tmp2_;
	_tmp3_ = json_parser_new ();
	parser = _tmp3_;
	json_parser_load_from_data (parser, msg, (gssize) (-1), &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_object_unref0 (parser);
		_g_free0 (msg);
		_g_object_unref0 (messages);
		if (_inner_error_->domain == G_IO_ERROR) {
			goto __catch1_g_io_error;
		}
		goto __finally1;
	}
	_tmp4_ = json_parser_get_root (parser);
	_tmp5_ = json_node_get_object (_tmp4_);
	_tmp6_ = _json_object_ref0 (_tmp5_);
	_json_object_unref0 (obj);
	obj = _tmp6_;
	if (obj != NULL) {
		gboolean _tmp7_;
		_tmp7_ = json_object_has_member (obj, "sender");
		if (_tmp7_) {
			JsonObject* _tmp8_ = NULL;
			JsonObject* _tmp9_;
			_tmp8_ = json_object_get_object_member (obj, "sender");
			_tmp9_ = _json_object_ref0 (_tmp8_);
			_json_object_unref0 (sender_obj);
			sender_obj = _tmp9_;
			if (sender_obj != NULL) {
				gboolean _tmp10_;
				_tmp10_ = json_object_has_member (sender_obj, "nick");
				if (_tmp10_) {
					const gchar* _tmp11_ = NULL;
					gchar* _tmp12_;
					_tmp11_ = json_object_get_string_member (sender_obj, "nick");
					_tmp12_ = g_strdup (_tmp11_);
					_g_free0 (nick);
					nick = _tmp12_;
				}
			}
		}
	}
	_g_object_unref0 (parser);
	_g_free0 (msg);
	_g_object_unref0 (messages);
	goto __finally1;
	__catch1_g_io_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		g_warning ("action-box.vala:178: %s", e->message);
		_g_error_free0 (e);
	}
	__finally1:
	if (_inner_error_ != NULL) {
		_json_object_unref0 (sender_obj);
		_json_object_unref0 (obj);
		_g_free0 (nick);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp13_ = strlen (nick);
	if (_tmp13_ > 0) {
		gchar* _tmp14_;
		_tmp14_ = g_strconcat ("@", nick, NULL);
		_g_free0 (nick);
		nick = _tmp14_;
	}
	g_signal_emit_by_name (self, "reply", self->priv->_mid, self->priv->_account, nick);
	_json_object_unref0 (sender_obj);
	_json_object_unref0 (obj);
	_g_free0 (nick);
}


static void __lambda0__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda0_ (self);
}


static void _lambda1_ (GwibberGtkActionBoxItem* self) {
	gboolean _tmp0_;
	gboolean ret;
	GError * _inner_error_ = NULL;
	_tmp0_ = gwibber_gtk_action_box_item_like (self, self->priv->_mid, self->priv->_account);
	ret = _tmp0_;
	if (ret) {
		gchar* _tmp1_;
		gchar* name;
		gchar* _tmp2_;
		gchar* nick;
		JsonObject* obj;
		JsonObject* sender_obj;
		GwibberMessages* _tmp3_ = NULL;
		GwibberMessages* messages;
		gchar* _tmp4_ = NULL;
		gchar* msg;
		JsonParser* _tmp5_ = NULL;
		JsonParser* parser;
		JsonNode* _tmp6_ = NULL;
		JsonObject* _tmp7_ = NULL;
		JsonObject* _tmp8_;
		gint _tmp18_;
		const gchar* _tmp20_ = NULL;
		const gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		NotifyNotification* _tmp24_ = NULL;
		NotifyNotification* _tmp25_;
		NotifyNotification* notification;
		_tmp1_ = g_strdup ("");
		name = _tmp1_;
		_tmp2_ = g_strdup ("");
		nick = _tmp2_;
		obj = NULL;
		sender_obj = NULL;
		_tmp3_ = gwibber_messages_new ();
		messages = _tmp3_;
		_tmp4_ = gwibber_messages_get_message (messages, self->priv->_mid);
		msg = _tmp4_;
		_tmp5_ = json_parser_new ();
		parser = _tmp5_;
		json_parser_load_from_data (parser, msg, (gssize) (-1), &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (parser);
			_g_free0 (msg);
			_g_object_unref0 (messages);
			if (_inner_error_->domain == G_IO_ERROR) {
				goto __catch2_g_io_error;
			}
			goto __finally2;
		}
		_tmp6_ = json_parser_get_root (parser);
		_tmp7_ = json_node_get_object (_tmp6_);
		_tmp8_ = _json_object_ref0 (_tmp7_);
		_json_object_unref0 (obj);
		obj = _tmp8_;
		if (obj != NULL) {
			gboolean _tmp9_;
			_tmp9_ = json_object_has_member (obj, "sender");
			if (_tmp9_) {
				JsonObject* _tmp10_ = NULL;
				JsonObject* _tmp11_;
				_tmp10_ = json_object_get_object_member (obj, "sender");
				_tmp11_ = _json_object_ref0 (_tmp10_);
				_json_object_unref0 (sender_obj);
				sender_obj = _tmp11_;
				if (sender_obj != NULL) {
					gboolean _tmp12_;
					gboolean _tmp15_;
					_tmp12_ = json_object_has_member (sender_obj, "nick");
					if (_tmp12_) {
						const gchar* _tmp13_ = NULL;
						gchar* _tmp14_;
						_tmp13_ = json_object_get_string_member (sender_obj, "nick");
						_tmp14_ = g_strdup (_tmp13_);
						_g_free0 (nick);
						nick = _tmp14_;
					}
					_tmp15_ = json_object_has_member (sender_obj, "name");
					if (_tmp15_) {
						const gchar* _tmp16_ = NULL;
						gchar* _tmp17_;
						_tmp16_ = json_object_get_string_member (sender_obj, "name");
						_tmp17_ = g_strdup (_tmp16_);
						_g_free0 (name);
						name = _tmp17_;
					}
				}
			}
		}
		_g_object_unref0 (parser);
		_g_free0 (msg);
		_g_object_unref0 (messages);
		goto __finally2;
		__catch2_g_io_error:
		{
			GError * e;
			e = _inner_error_;
			_inner_error_ = NULL;
			g_warning ("action-box.vala:222: %s", e->message);
			_g_error_free0 (e);
		}
		__finally2:
		if (_inner_error_ != NULL) {
			_json_object_unref0 (sender_obj);
			_json_object_unref0 (obj);
			_g_free0 (nick);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp18_ = strlen (name);
		if (_tmp18_ > 0) {
			gchar* _tmp19_;
			_tmp19_ = g_strdup (name);
			_g_free0 (nick);
			nick = _tmp19_;
		}
		_tmp20_ = _ ("Liked");
		_tmp21_ = _ ("Liked post from ");
		_tmp22_ = g_strconcat (_tmp21_, nick, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = notify_notification_new (_tmp20_, _tmp23_, self->priv->_scalable_icon);
		_tmp25_ = _tmp24_;
		_g_free0 (_tmp23_);
		notification = _tmp25_;
		notify_notification_show (notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (notification);
			_json_object_unref0 (sender_obj);
			_json_object_unref0 (obj);
			_g_free0 (nick);
			_g_free0 (name);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (notification);
		_json_object_unref0 (sender_obj);
		_json_object_unref0 (obj);
		_g_free0 (nick);
		_g_free0 (name);
	}
}


static void __lambda1__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda1_ (self);
}


static void _lambda2_ (GwibberGtkActionBoxItem* self) {
	gboolean _tmp0_;
	gboolean ret;
	GError * _inner_error_ = NULL;
	_tmp0_ = gwibber_gtk_action_box_item_share (self, self->priv->_mid, self->priv->_account);
	ret = _tmp0_;
	if (ret) {
		const gchar* _tmp1_ = NULL;
		const gchar* _tmp2_ = NULL;
		gchar* _tmp3_;
		gchar* _tmp4_;
		NotifyNotification* _tmp5_ = NULL;
		NotifyNotification* _tmp6_;
		NotifyNotification* notification;
		_tmp1_ = _ ("Shared");
		_tmp2_ = _ ("Shared post from ");
		_tmp3_ = g_strconcat (_tmp2_, self->priv->_sender, NULL);
		_tmp4_ = _tmp3_;
		_tmp5_ = notify_notification_new (_tmp1_, _tmp4_, self->priv->_scalable_icon);
		_tmp6_ = _tmp5_;
		_g_free0 (_tmp4_);
		notification = _tmp6_;
		notify_notification_show (notification, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_object_unref0 (notification);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_g_object_unref0 (notification);
	}
}


static void __lambda2__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda2_ (self);
}


static void _lambda3_ (GwibberGtkActionBoxItem* self) {
	gwibber_gtk_action_box_item_user_stream (self, self->priv->_account, self->priv->_sender);
}


static void __lambda3__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_lambda3_ (self);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static GtkMenu* gwibber_gtk_action_box_item_build_menu (GwibberGtkActionBoxItem* self) {
	GtkMenu* result = NULL;
	GtkMenu* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	gboolean _tmp10_ = FALSE;
	gboolean _tmp11_ = FALSE;
	gboolean _tmp14_ = FALSE;
	gboolean _tmp15_ = FALSE;
	gboolean _tmp16_ = FALSE;
	gboolean _tmp17_ = FALSE;
	gboolean _tmp18_ = FALSE;
	gboolean _tmp25_ = FALSE;
	gboolean _tmp26_ = FALSE;
	gboolean _tmp27_ = FALSE;
	GtkMenu* _tmp30_;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = (GtkMenu*) gtk_menu_new ();
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = g_object_ref_sink (_tmp0_);
	if (g_strcmp0 (self->priv->_service, "flicker") != 0) {
		_tmp3_ = g_strcmp0 (self->priv->_service, "pingfm") != 0;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		_tmp2_ = g_strcmp0 (self->priv->_service, "foursquare") != 0;
	} else {
		_tmp2_ = FALSE;
	}
	if (_tmp2_) {
		_tmp1_ = g_strcmp0 (self->priv->_service, "digg") != 0;
	} else {
		_tmp1_ = FALSE;
	}
	if (_tmp1_) {
		const gchar* _tmp4_ = NULL;
		GtkMenuItem* _tmp5_ = NULL;
		_tmp4_ = _ ("_Reply");
		_tmp5_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp4_);
		_g_object_unref0 (self->priv->amenu);
		self->priv->amenu = g_object_ref_sink (_tmp5_);
		g_signal_connect_object (self->priv->amenu, "activate", (GCallback) __lambda0__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->amenu);
	}
	if (g_strcmp0 (self->priv->_service, "flicker") != 0) {
		_tmp11_ = g_strcmp0 (self->priv->_service, "pingfm") != 0;
	} else {
		_tmp11_ = FALSE;
	}
	if (_tmp11_) {
		_tmp10_ = g_strcmp0 (self->priv->_service, "foursquare") != 0;
	} else {
		_tmp10_ = FALSE;
	}
	if (_tmp10_) {
		_tmp9_ = g_strcmp0 (self->priv->_service, "digg") != 0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		_tmp8_ = g_strcmp0 (self->priv->_service, "qaiku") != 0;
	} else {
		_tmp8_ = FALSE;
	}
	if (_tmp8_) {
		_tmp7_ = g_strcmp0 (self->priv->_service, "buzz") != 0;
	} else {
		_tmp7_ = FALSE;
	}
	if (_tmp7_) {
		_tmp6_ = g_strcmp0 (self->priv->_stream, "private") != 0;
	} else {
		_tmp6_ = FALSE;
	}
	if (_tmp6_) {
		const gchar* _tmp12_ = NULL;
		GtkMenuItem* _tmp13_ = NULL;
		_tmp12_ = _ ("_Like");
		_tmp13_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp12_);
		_g_object_unref0 (self->priv->amenu);
		self->priv->amenu = g_object_ref_sink (_tmp13_);
		g_signal_connect_object (self->priv->amenu, "activate", (GCallback) __lambda1__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->amenu);
	}
	if (g_strcmp0 (self->priv->_service, "twitter") == 0) {
		_tmp18_ = TRUE;
	} else {
		_tmp18_ = g_strcmp0 (self->priv->_service, "identica") == 0;
	}
	if (_tmp18_) {
		_tmp17_ = TRUE;
	} else {
		_tmp17_ = g_strcmp0 (self->priv->_service, "statusnet") == 0;
	}
	if (_tmp17_) {
		_tmp16_ = TRUE;
	} else {
		_tmp16_ = g_strcmp0 (self->priv->_service, "sina") == 0;
	}
	if (_tmp16_) {
		_tmp15_ = TRUE;
	} else {
		_tmp15_ = g_strcmp0 (self->priv->_service, "sohu") == 0;
	}
	if (_tmp15_) {
		_tmp14_ = g_strcmp0 (self->priv->_stream, "private") != 0;
	} else {
		_tmp14_ = FALSE;
	}
	if (_tmp14_) {
		GtkMenuItem* _tmp19_ = NULL;
		gboolean _tmp22_ = FALSE;
		_tmp19_ = (GtkMenuItem*) gtk_menu_item_new ();
		_g_object_unref0 (self->priv->amenu);
		self->priv->amenu = g_object_ref_sink (_tmp19_);
		if (g_strcmp0 (self->priv->_service, "twitter") == 0) {
			const gchar* _tmp20_ = NULL;
			GtkMenuItem* _tmp21_ = NULL;
			_tmp20_ = _ ("Re_tweet");
			_tmp21_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp20_);
			_g_object_unref0 (self->priv->amenu);
			self->priv->amenu = g_object_ref_sink (_tmp21_);
		}
		if (g_strcmp0 (self->priv->_service, "identica") == 0) {
			_tmp22_ = TRUE;
		} else {
			_tmp22_ = g_strcmp0 (self->priv->_service, "statusnet") == 0;
		}
		if (_tmp22_) {
			const gchar* _tmp23_ = NULL;
			GtkMenuItem* _tmp24_ = NULL;
			_tmp23_ = _ ("Re_peat");
			_tmp24_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp23_);
			_g_object_unref0 (self->priv->amenu);
			self->priv->amenu = g_object_ref_sink (_tmp24_);
		}
		g_signal_connect_object (self->priv->amenu, "activate", (GCallback) __lambda2__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->amenu);
	}
	if (g_strcmp0 (self->priv->_service, "twitter") == 0) {
		_tmp27_ = TRUE;
	} else {
		_tmp27_ = g_strcmp0 (self->priv->_service, "identica") == 0;
	}
	if (_tmp27_) {
		_tmp26_ = TRUE;
	} else {
		_tmp26_ = g_strcmp0 (self->priv->_service, "statusnet") == 0;
	}
	if (_tmp26_) {
		_tmp25_ = g_strcmp0 (self->priv->_stream, "user") != 0;
	} else {
		_tmp25_ = FALSE;
	}
	if (_tmp25_) {
		const gchar* _tmp28_ = NULL;
		GtkMenuItem* _tmp29_ = NULL;
		_tmp28_ = _ ("View User _Profile");
		_tmp29_ = (GtkMenuItem*) gtk_menu_item_new_with_mnemonic (_tmp28_);
		_g_object_unref0 (self->priv->amenu);
		self->priv->amenu = g_object_ref_sink (_tmp29_);
		g_signal_connect_object (self->priv->amenu, "activate", (GCallback) __lambda3__gtk_menu_item_activate, self, 0);
		gtk_menu_shell_append ((GtkMenuShell*) self->priv->menu, (GtkWidget*) self->priv->amenu);
	}
	gtk_widget_show_all ((GtkWidget*) self->priv->menu);
	_tmp30_ = _g_object_ref0 (self->priv->menu);
	result = _tmp30_;
	return result;
}


const gchar* gwibber_gtk_action_box_item_get_service (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_service;
	return result;
}


void gwibber_gtk_action_box_item_set_service (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_service);
	self->priv->_service = _tmp0_;
	g_object_notify ((GObject *) self, "service");
}


const gchar* gwibber_gtk_action_box_item_get_stream (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_stream;
	return result;
}


void gwibber_gtk_action_box_item_set_stream (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_stream);
	self->priv->_stream = _tmp0_;
	g_object_notify ((GObject *) self, "stream");
}


const gchar* gwibber_gtk_action_box_item_get_account (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_account;
	return result;
}


void gwibber_gtk_action_box_item_set_account (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_account);
	self->priv->_account = _tmp0_;
	g_object_notify ((GObject *) self, "account");
}


const gchar* gwibber_gtk_action_box_item_get_mid (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_mid;
	return result;
}


void gwibber_gtk_action_box_item_set_mid (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_mid);
	self->priv->_mid = _tmp0_;
	g_object_notify ((GObject *) self, "mid");
}


const gchar* gwibber_gtk_action_box_item_get_sender (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_sender;
	return result;
}


void gwibber_gtk_action_box_item_set_sender (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_sender);
	self->priv->_sender = _tmp0_;
	g_object_notify ((GObject *) self, "sender");
}


const gchar* gwibber_gtk_action_box_item_get_action (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_action;
	return result;
}


void gwibber_gtk_action_box_item_set_action (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_action);
	self->priv->_action = _tmp0_;
	g_object_notify ((GObject *) self, "action");
}


const gchar* gwibber_gtk_action_box_item_get_tooltip (GwibberGtkActionBoxItem* self) {
	const gchar* result;
	g_return_val_if_fail (self != NULL, NULL);
	result = self->priv->_tooltip;
	return result;
}


void gwibber_gtk_action_box_item_set_tooltip (GwibberGtkActionBoxItem* self, const gchar* value) {
	gchar* _tmp0_;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_strdup (value);
	_g_free0 (self->priv->_tooltip);
	self->priv->_tooltip = _tmp0_;
	g_object_notify ((GObject *) self, "tooltip");
}


static void gwibber_gtk_action_box_item_real_reply (GwibberGtkActionBoxItem* self, const gchar* mid, const gchar* account, const gchar* sender) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mid != NULL);
	g_return_if_fail (account != NULL);
	g_return_if_fail (sender != NULL);
}


static void g_cclosure_user_marshal_VOID__STRING_STRING_STRING (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__STRING_STRING_STRING) (gpointer data1, const char* arg_1, const char* arg_2, const char* arg_3, gpointer data2);
	register GMarshalFunc_VOID__STRING_STRING_STRING callback;
	register GCClosure * cc;
	register gpointer data1, data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 4);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__STRING_STRING_STRING) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_string (param_values + 1), g_value_get_string (param_values + 2), g_value_get_string (param_values + 3), data2);
}


static gboolean _lambda4_ (GdkEventButton* event, GwibberGtkActionBoxItem* self) {
	gboolean result = FALSE;
	GList* _tmp0_ = NULL;
	GList* _tmp1_;
	guint _tmp2_;
	gboolean _tmp3_;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->menu);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_list_length (_tmp1_);
	_tmp3_ = _tmp2_ > 0;
	_g_list_free0 (_tmp1_);
	if (_tmp3_) {
		gtk_menu_popup (self->priv->menu, NULL, NULL, NULL, NULL, (*event).button, (*event).time);
	}
	result = TRUE;
	return result;
}


static gboolean __lambda4__gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = _lambda4_ (event, self);
	return result;
}


static GObject * gwibber_gtk_action_box_item_constructor (GType type, guint n_construct_properties, GObjectConstructParam * construct_properties) {
	GObject * obj;
	GObjectClass * parent_class;
	GwibberGtkActionBoxItem * self;
	gint _tmp0_;
	GtkImage* _tmp1_ = NULL;
	gchar* _tmp2_;
	gchar* _tmp3_;
	gchar* _tmp4_;
	gchar* _tmp5_;
	gchar* _tmp6_ = NULL;
	gchar* _tmp7_;
	gchar* _tmp8_;
	gchar* _tmp9_;
	gchar* _tmp10_;
	gchar* _tmp11_ = NULL;
	gboolean _tmp12_;
	GtkMenu* _tmp31_ = NULL;
	GtkWidget* _tmp32_ = NULL;
	parent_class = G_OBJECT_CLASS (gwibber_gtk_action_box_item_parent_class);
	obj = parent_class->constructor (type, n_construct_properties, construct_properties);
	self = GWIBBER_GTK_ACTION_BOX_ITEM (obj);
	_tmp0_ = strlen (self->priv->_tooltip);
	if (_tmp0_ < 1) {
		gwibber_gtk_action_box_item_set_tooltip (self, self->priv->_service);
	}
	_tmp1_ = (GtkImage*) gtk_image_new ();
	_g_object_unref0 (self->priv->_image);
	self->priv->_image = g_object_ref_sink (_tmp1_);
	_tmp2_ = g_strconcat ("ui/icons/breakdance/16x16/", self->priv->_service, NULL);
	_tmp3_ = _tmp2_;
	_tmp4_ = g_strconcat (_tmp3_, ".png", NULL);
	_tmp5_ = _tmp4_;
	_tmp6_ = g_build_filename (PKGDATADIR, _tmp5_, NULL);
	_g_free0 (self->priv->_icon);
	self->priv->_icon = _tmp6_;
	_g_free0 (_tmp5_);
	_g_free0 (_tmp3_);
	_tmp7_ = g_strconcat ("ui/icons/breakdance/scalable/", self->priv->_service, NULL);
	_tmp8_ = _tmp7_;
	_tmp9_ = g_strconcat (_tmp8_, ".svg", NULL);
	_tmp10_ = _tmp9_;
	_tmp11_ = g_build_filename (PKGDATADIR, _tmp10_, NULL);
	_g_free0 (self->priv->_scalable_icon);
	self->priv->_scalable_icon = _tmp11_;
	_g_free0 (_tmp10_);
	_g_free0 (_tmp8_);
	_tmp12_ = g_file_test (self->priv->_icon, G_FILE_TEST_EXISTS);
	if (!_tmp12_) {
		gchar* _tmp13_;
		gchar* _tmp14_;
		gchar* _tmp15_;
		gchar* _tmp16_;
		gchar* _tmp17_;
		gchar* _tmp18_;
		gchar* _tmp19_;
		gchar* _tmp20_;
		gchar* _tmp21_ = NULL;
		gchar* _tmp22_;
		gchar* _tmp23_;
		gchar* _tmp24_;
		gchar* _tmp25_;
		gchar* _tmp26_;
		gchar* _tmp27_;
		gchar* _tmp28_;
		gchar* _tmp29_;
		gchar* _tmp30_ = NULL;
		_tmp13_ = g_strconcat (PKGDATADIR "/plugins/", self->priv->_service, NULL);
		_tmp14_ = _tmp13_;
		_tmp15_ = g_strconcat (_tmp14_, "/ui/icons/16x16/", NULL);
		_tmp16_ = _tmp15_;
		_tmp17_ = g_strconcat (_tmp16_, self->priv->_service, NULL);
		_tmp18_ = _tmp17_;
		_tmp19_ = g_strconcat (_tmp18_, ".png", NULL);
		_tmp20_ = _tmp19_;
		_tmp21_ = g_build_filename (_tmp20_, NULL);
		_g_free0 (self->priv->_icon);
		self->priv->_icon = _tmp21_;
		_g_free0 (_tmp20_);
		_g_free0 (_tmp18_);
		_g_free0 (_tmp16_);
		_g_free0 (_tmp14_);
		_tmp22_ = g_strconcat (PKGDATADIR "/plugins/", self->priv->_service, NULL);
		_tmp23_ = _tmp22_;
		_tmp24_ = g_strconcat (_tmp23_, "/ui/icons/scalable/", NULL);
		_tmp25_ = _tmp24_;
		_tmp26_ = g_strconcat (_tmp25_, self->priv->_service, NULL);
		_tmp27_ = _tmp26_;
		_tmp28_ = g_strconcat (_tmp27_, ".svg", NULL);
		_tmp29_ = _tmp28_;
		_tmp30_ = g_build_filename (_tmp29_, NULL);
		_g_free0 (self->priv->_scalable_icon);
		self->priv->_scalable_icon = _tmp30_;
		_g_free0 (_tmp29_);
		_g_free0 (_tmp27_);
		_g_free0 (_tmp25_);
		_g_free0 (_tmp23_);
	}
	gtk_image_set_from_file (self->priv->_image, self->priv->_icon);
	gtk_widget_set_no_show_all ((GtkWidget*) self->priv->_image, FALSE);
	gtk_widget_set_tooltip_text ((GtkWidget*) self->priv->_image, self->priv->_tooltip);
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) self->priv->_image);
	_tmp31_ = gwibber_gtk_action_box_item_build_menu (self);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = _tmp31_;
	_tmp32_ = gtk_widget_get_parent ((GtkWidget*) self);
	if (GTK_IS_WIDGET (_tmp32_)) {
		gtk_widget_reparent ((GtkWidget*) self, (GtkWidget*) self->priv->menu);
	} else {
		gtk_menu_attach_to_widget (self->priv->menu, (GtkWidget*) self, NULL);
	}
	g_signal_connect_object ((GtkWidget*) self, "button-press-event", (GCallback) __lambda4__gtk_widget_button_press_event, self, 0);
	return obj;
}


static void gwibber_gtk_action_box_item_class_init (GwibberGtkActionBoxItemClass * klass) {
	gwibber_gtk_action_box_item_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (GwibberGtkActionBoxItemPrivate));
	GWIBBER_GTK_ACTION_BOX_ITEM_CLASS (klass)->reply = gwibber_gtk_action_box_item_real_reply;
	G_OBJECT_CLASS (klass)->get_property = _vala_gwibber_gtk_action_box_item_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_gwibber_gtk_action_box_item_set_property;
	G_OBJECT_CLASS (klass)->constructor = gwibber_gtk_action_box_item_constructor;
	G_OBJECT_CLASS (klass)->finalize = gwibber_gtk_action_box_item_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_SERVICE, g_param_spec_string ("service", "service", "service", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_STREAM, g_param_spec_string ("stream", "stream", "stream", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_ACCOUNT, g_param_spec_string ("account", "account", "account", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_MID, g_param_spec_string ("mid", "mid", "mid", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_SENDER, g_param_spec_string ("sender", "sender", "sender", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_ACTION, g_param_spec_string ("action", "action", "action", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_object_class_install_property (G_OBJECT_CLASS (klass), GWIBBER_GTK_ACTION_BOX_ITEM_TOOLTIP, g_param_spec_string ("tooltip", "tooltip", "tooltip", NULL, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
	g_signal_new ("reply", GWIBBER_GTK_TYPE_ACTION_BOX_ITEM, G_SIGNAL_RUN_LAST | G_SIGNAL_ACTION, G_STRUCT_OFFSET (GwibberGtkActionBoxItemClass, reply), NULL, NULL, g_cclosure_user_marshal_VOID__STRING_STRING_STRING, G_TYPE_NONE, 3, G_TYPE_STRING, G_TYPE_STRING, G_TYPE_STRING);
}


static void gwibber_gtk_action_box_item_instance_init (GwibberGtkActionBoxItem * self) {
	self->priv = GWIBBER_GTK_ACTION_BOX_ITEM_GET_PRIVATE (self);
}


static void gwibber_gtk_action_box_item_finalize (GObject* obj) {
	GwibberGtkActionBoxItem * self;
	GList* _tmp0_ = NULL;
	self = GWIBBER_GTK_ACTION_BOX_ITEM (obj);
	gtk_widget_destroy ((GtkWidget*) self->priv->_image);
	_g_object_unref0 (self->priv->_image);
	self->priv->_image = NULL;
	_tmp0_ = gtk_container_get_children ((GtkContainer*) self->priv->menu);
	{
		GList* _w_collection;
		GList* _w_it;
		_w_collection = _tmp0_;
		for (_w_it = _w_collection; _w_it != NULL; _w_it = _w_it->next) {
			GtkWidget* _w;
			_w = (GtkWidget*) _w_it->data;
			{
				gtk_container_remove ((GtkContainer*) self->priv->menu, _w);
				gtk_widget_destroy (_w);
				_w = NULL;
			}
		}
		_g_list_free0 (_w_collection);
	}
	gtk_widget_destroy ((GtkWidget*) self->priv->menu);
	_g_object_unref0 (self->priv->menu);
	self->priv->menu = NULL;
	_g_free0 (self->priv->_service);
	_g_free0 (self->priv->_stream);
	_g_free0 (self->priv->_account);
	_g_free0 (self->priv->_mid);
	_g_free0 (self->priv->_sender);
	_g_free0 (self->priv->_action);
	_g_free0 (self->priv->_tooltip);
	_g_object_unref0 (self->priv->_image);
	_g_free0 (self->priv->_icon);
	_g_free0 (self->priv->_scalable_icon);
	_g_object_unref0 (self->priv->menu);
	_g_object_unref0 (self->priv->amenu);
	G_OBJECT_CLASS (gwibber_gtk_action_box_item_parent_class)->finalize (obj);
}


GType gwibber_gtk_action_box_item_get_type (void) {
	static volatile gsize gwibber_gtk_action_box_item_type_id__volatile = 0;
	if (g_once_init_enter (&gwibber_gtk_action_box_item_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (GwibberGtkActionBoxItemClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) gwibber_gtk_action_box_item_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (GwibberGtkActionBoxItem), 0, (GInstanceInitFunc) gwibber_gtk_action_box_item_instance_init, NULL };
		GType gwibber_gtk_action_box_item_type_id;
		gwibber_gtk_action_box_item_type_id = g_type_register_static (GTK_TYPE_EVENT_BOX, "GwibberGtkActionBoxItem", &g_define_type_info, 0);
		g_once_init_leave (&gwibber_gtk_action_box_item_type_id__volatile, gwibber_gtk_action_box_item_type_id);
	}
	return gwibber_gtk_action_box_item_type_id__volatile;
}


static void _vala_gwibber_gtk_action_box_item_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	GwibberGtkActionBoxItem * self;
	self = GWIBBER_GTK_ACTION_BOX_ITEM (object);
	switch (property_id) {
		case GWIBBER_GTK_ACTION_BOX_ITEM_SERVICE:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_service (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_STREAM:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_stream (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_ACCOUNT:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_account (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_MID:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_mid (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_SENDER:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_sender (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_ACTION:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_action (self));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_TOOLTIP:
		g_value_set_string (value, gwibber_gtk_action_box_item_get_tooltip (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_gwibber_gtk_action_box_item_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	GwibberGtkActionBoxItem * self;
	self = GWIBBER_GTK_ACTION_BOX_ITEM (object);
	switch (property_id) {
		case GWIBBER_GTK_ACTION_BOX_ITEM_SERVICE:
		gwibber_gtk_action_box_item_set_service (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_STREAM:
		gwibber_gtk_action_box_item_set_stream (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_ACCOUNT:
		gwibber_gtk_action_box_item_set_account (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_MID:
		gwibber_gtk_action_box_item_set_mid (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_SENDER:
		gwibber_gtk_action_box_item_set_sender (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_ACTION:
		gwibber_gtk_action_box_item_set_action (self, g_value_get_string (value));
		break;
		case GWIBBER_GTK_ACTION_BOX_ITEM_TOOLTIP:
		gwibber_gtk_action_box_item_set_tooltip (self, g_value_get_string (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}



