/*
 * Copyright (C) 2010 Neil Jagdish Patel
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <njpatel@gmail.com>
 */

using Gwibber;

namespace GwibberGtk
{
  public class SearchViewTile : Gtk.EventBox
  {
    private const int our_padding = 6;

    private Gtk.Alignment align;
    private Gtk.HBox   main_box;
    private Gtk.Alignment lalignment;
    private Gtk.Alignment ralignment;
    private Gtk.EventBox  close_box;
    private Gtk.Image  close_icon;
    private Gtk.VBox   vbox;
    private new Gtk.Label  name;
    public Gwibber.Searches searches { get; construct set; }
    private ulong bp_handler_id;
    private ulong cb_handler_id;

    public SearchViewTile (Gwibber.Searches searches)
    {
      Object (above_child:false, visible_window:false, searches:searches);
    }

    construct
    {
      draw.connect (on_draw);

      //set_no_show_all (true);

      align = new Gtk.Alignment (0.0f, 0.0f, 1.0f, 1.0f);
      align.set_padding (our_padding, our_padding, our_padding, our_padding);
      add (align);

      main_box = new Gtk.HBox (false, 12);
      align.add (main_box);

      lalignment = new Gtk.Alignment (0.5f, 0.0f, 0.0f, 0.0f);
      ralignment = new Gtk.Alignment (0.5f, 0.0f, 0.0f, 0.0f);
      main_box.pack_start (lalignment, false, false, 0);
      main_box.pack_end (ralignment, false, false, 0);

      vbox = new Gtk.VBox (false, 0);
      main_box.pack_start (vbox, true, true, 0);
      
      var hbox = new Gtk.HBox (false, 0);
      vbox.pack_start (hbox, false, false, 2);
      
      name = new Gtk.Label ("");
      name.set_markup ("<b></b>");
      name.set_alignment (0.0f, 0.5f);
      hbox.pack_start (name, true, true, 0);

      close_icon = new Gtk.Image.from_stock (Gtk.Stock.CLOSE, Gtk.IconSize.MENU);
      close_box = new Gtk.EventBox ();
      close_box.set_visible_window (false);

      close_box.add (close_icon);
      ralignment.add (close_box);
    }

    [Signal (action=true)]
    public virtual signal void show_transient (string id, string name)
    {
    }

    private bool on_draw (Cairo.Context cr)
    {
      Gtk.Allocation alloc;
      get_allocation (out alloc);

      cr.set_line_width (1.0);

      cr.set_source_rgba (1.0, 1.0, 1.0, 1.0);
      cr.move_to (alloc.x, 0.5);
      cr.line_to (alloc.x + alloc.width, 0.5);
      cr.stroke ();

      var pat = new Cairo.Pattern.linear (0, 0, 0, alloc.height);
      pat.add_color_stop_rgba (0.0f, 1.0f, 1.0f, 1.0f, 0.2f);
      pat.add_color_stop_rgba (1.0f, 1.0f, 1.0f, 1.0f, 0.0f);

      cr.rectangle (0, 0, alloc.width, alloc.height);
      cr.set_source (pat);
      cr.fill ();

      cr.set_source_rgba (0.0, 0.0, 0.0, 0.1);
      cr.move_to (alloc.x, alloc.height - 0.5);
      cr.line_to (alloc.x + alloc.width, alloc.height - 0.5);
      cr.stroke ();

      propagate_draw (align, cr);

      return true;
    }

    public void reset ()
    {
      hide ();
    }

    public void set_details (Gee.HashMap<string?, string?> search)
    {
      name.set_markup ("<b>" + search["name"] + "</b>");
       
      if (cb_handler_id > 0)
        close_box.disconnect (cb_handler_id);
      cb_handler_id = close_box.button_press_event.connect ((event) => {
        reset ();
        Idle.add (() => {
          searches.delete (search["id"]);
          return false;
          });
        return true;
        });

      if (bp_handler_id > 0)
        disconnect (bp_handler_id);
      bp_handler_id = button_press_event.connect (() => {
        show_transient (search["id"], search["name"]);
        return true;
      });

      queue_resize ();
      show ();
    }                        
  }
}
