/*
 * Copyright(C) 2010 Neil Jagdish Patel
 * Copyright(C) 2010 Canonical Ltd.
 *
 * This library is free software; you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License
 * version 3.0 as published by the Free Software Foundation.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3.0 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library. If not, see
 * <http://www.gnu.org/licenses/>.
 *
 * Authored by Neil Jagdish Patel <neil.patel@canonical.com>
 * Authored by Ken VaDine <ken.vandine@canonical.com>
 */

[DBus (name = "com.Gwibber.URLShorten")]
private interface URLShortenInterface : Object {
        public abstract string Shorten (string url) throws GLib.IOError;
}

namespace Gwibber
{
    public class URLShorten : Object
    {
        private const string url_name  = "com.Gwibber.URLShorten";
        private const string url_path  = "/com/gwibber/URLShorten";

        private URLShortenInterface url_service;
	private Gwibber.Utils utils;

	/** 
            URLShorten::is_available:
            @arg0: The current state

            Emitted when com.Gwibber.URLShorten availability state changes
	*/
	public signal void is_available(bool is_up);

        construct
        {
            try
            {
                url_service = Bus.get_proxy_sync(BusType.SESSION,
                                                      url_name,
                                                      url_path);
                utils = new Gwibber.Utils();
                utils.setup(url_name);
                utils.available.connect(url_available);
            }
            catch (GLib.IOError e)
            {
                warning ("Unable to get Gwibber URLShorten: "+e.message);
            }
        }


        /**
         * com.Gwibber.URLShorten
         **/
        public string shorten(string url)
        {
            try
            {
                return url_service.Shorten(url);
            }
            catch (GLib.IOError e)
            {
                warning (e.message);
                return "Failed";
            }
        }   

	public void url_available(bool is_up)
	{
		is_available(is_up);
	}
    }
}
