#!/bin/sh
### BEGIN INIT INFO
# Provides:          hotkey-setup
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      1
# Short-Description: Set up laptop keys to generate keycodes.
### END INIT INFO

test -x /usr/sbin/dumpkeycodes || exit 0

xorg_driver() {
    vendor=$(lspci | grep VGA | head -1)
    case $vendor in
    *Intel*)
        driver=intel
        ;;
    *AMD*|*ATI*)
        driver=ati
        ;;
    esac
    echo $driver
}

do_video () {
    VIDEO=`xorg_driver`
    case $VIDEO in
	intel|ati)
	    for x in /proc/acpi/video/*/DOS; do
		if [ -e "$x" ]; then
		    echo -n 7 >$x;
		fi
	    done
	;;
    esac
}

case "$1" in
    start)

# This entire block does nothing on desktops right now
    if laptop-detect; then

    do_video

    fi
    ;;
    restart|force-reload)
    $0 stop || true
    $0 start
    ;;
esac

exit 0
