#!/bin/sh
### BEGIN INIT INFO
# Provides:          hotkey-setup
# Required-Start:    $remote_fs $syslog
# Required-Stop:     $remote_fs $syslog
# Default-Start:     2 3 4 5
# Default-Stop:      1
# Short-Description: Set up laptop keys to generate keycodes.
### END INIT INFO

# do not run if not package is not installed
test -x /usr/sbin/dumpkeycodes || exit 0

manufacturer=`dmidecode --string system-manufacturer`
name=`dmidecode --string system-product-name`
version=`dmidecode --string system-version`

SAVED_STATE=/var/run/hotkey-setup
THINKPAD_LOCKFILE=$SAVED_STATE.thinkpad-keys
THINKPAD_HOTKEY_MASK=/sys/devices/platform/thinkpad_acpi/hotkey_mask
THINKPAD_KEYS=/usr/sbin/thinkpad-keys
THINKPAD_HOTKEY_MASK_RECOMMENDED=/sys/devices/platform/thinkpad_acpi/hotkey_recommended_mask

xorg_driver() {
    if [ -e /etc/X11/xorg.conf ] ; then
	driver=$(sed -n -e '/^[ \t]*section[ \\t]*"device"/I,/^[ \t]*endsection/I{/^[ \t]*driver[ \t]*/I{s/^[ \t]*driver[ \t]*"*//I;s/"*[ \t]*$//;p}}' /etc/X11/xorg.conf)
    fi
    if [ -z "$driver" ] ; then
	vendor=$(lspci | grep VGA | head -1)
	case $vendor in
		*Intel*)
			driver=intel
		;;
		*AMD*)
			driver=ati
		;;
		*ATI*)
			driver=ati
		;;
	esac
    fi
    echo $driver
}

do_video () {
    VIDEO=`xorg_driver`
    case $VIDEO in
	intel|ati|radeon)
	    for x in /proc/acpi/video/*/DOS; do
		if [ -e "$x" ]; then
		    echo -n 7 >$x;
		fi
	    done
	;;
    esac
}

# This is here because it needs to be executed both if we have a
# Lenovo that also IDs as a ThinkPad, or if we have a real IBM one.
do_thinkpad () {
    . /usr/share/hotkey-setup/ibm.hk
    modprobe thinkpad-acpi || return 1

    thinkpad_keys_args="$1"

	# Unconditionally enable brightness and volume groups
	# Try to enable ThinkPad key
	recommended_hotkey_mask=$(cat $THINKPAD_HOTKEY_MASK_RECOMMENDED)
	wanted_hotkey_mask=$(($recommended_hotkey_mask | $TP_NVRAM_HKEY_GROUP_BRIGHTNESS | $TP_NVRAM_HKEY_GROUP_VOLUME | $TP_ACPI_HKEY_THINKPAD_MASK))

	echo $wanted_hotkey_mask > $THINKPAD_HOTKEY_MASK
	accepted_hotkey_mask=$(cat $THINKPAD_HOTKEY_MASK)

    # If the ThinkPad key bit was accepted, we don't need the polling daemon
    if [ $(($accepted_hotkey_mask & $TP_ACPI_HKEY_THINKPAD_MASK)) -eq 0 ] && test -x $THINKPAD_KEYS; then
        if [ ! -c /dev/input/uinput ]; then
            modprobe uinput
        fi
        if [ ! -c /dev/nvram ]; then
            modprobe nvram
        fi
        $THINKPAD_KEYS $thinkpad_keys_args && touch $THINKPAD_LOCKFILE
    fi
}

case "$1" in
    start)

# This entire block does nothing on desktops right now
    if laptop-detect; then

    do_video

    /usr/sbin/dumpkeycodes >$SAVED_STATE
    
    if [ $? -gt 0 ]; then
	rm -f $SAVED_STATE
    fi

    . /usr/share/hotkey-setup/key-constants

    case "$manufacturer" in
	Acer*)
	. /usr/share/hotkey-setup/acer.hk
	case "$name" in
	    Aspire\ 16*)
	    . /usr/share/hotkey-setup/acer-aspire-1600.hk
	    ;;
	esac
	;;

	ASUS*)
	. /usr/share/hotkey-setup/asus.hk
	;;

	Compaq*)
	case "$name" in
	    Armada*E500*|Evo*N620*)
	    . /usr/share/hotkey-setup/compaq.hk
	    ;;
	esac
	;;

	Dell*)
	. /usr/share/hotkey-setup/dell.hk
	;;

	Hewlett-Packard*)
	# Load this _first_, so that it can be overridden
	. /usr/share/hotkey-setup/hp.hk
	case "$name" in
	    # Please open a bug if uncommenting these "Presario" entries works for you...
	    #*Presario\ V2000*)
	    #. /usr/share/hotkey-setup/hp-v2000.hk
	    #;;
	    *Tablet*|*tc*)
	    . /usr/share/hotkey-setup/hp-tablet.hk
	    ;;
	esac
	;;

	IBM*)
	do_thinkpad IBM
	;;

	LENOVO*)
	case "$version" in
	    *Think[Pp]ad*)
	    do_thinkpad --no-brightness
	    ;;
	    *)
	    . /usr/share/hotkey-setup/lenovo.hk
	    ;;
	esac
	;;
	
	MEDION*)
	case "$name" in
	    *FID2060*)
	    . /usr/share/hotkey-setup/medion-md6200.hk
	    ;;
	esac
	;;

	MICRO-STAR*)
	case "$name" in
	    *INFINITY*)
	    . /usr/share/hotkey-setup/micro-star-infinity.hk
	    ;;
	esac
	;;

	Samsung*|SAMSUNG*)
	. /usr/share/hotkey-setup/samsung.hk
	;;

	Sony*)
	modprobe sonypi; # Needed to get hotkey events
	modprobe sony-laptop
	;;

        FUJITSU\ SIEMENS)
        case "$name" in
            AMILO\ Pa\ 2548)
            . /usr/share/hotkey-setup/fujitsu-siemens-pa2548.hk
            ;;
        esac
        ;;

	*)
	. /usr/share/hotkey-setup/default.hk	
    esac
    . /usr/share/hotkey-setup/generic.hk
    fi
    ;;
    stop)
	if [ -f $THINKPAD_LOCKFILE ]; then
	    pid=`pidof thinkpad-keys`
	    if [ "$pid" ] ; then
	        kill $pid || true
	    fi
	    rm -f $THINKPAD_LOCKFILE
	fi
	if [ -f $SAVED_STATE ]; then
		setkeycodes $(cat $SAVED_STATE) || true
	fi
    ;;
    restart|force-reload)
    $0 stop || true
    $0 start
    ;;
esac

exit 0
