#!/bin/bash

manufacturer=$(dmidecode | grep "System Information" -A 10 | grep -m1 Manufacturer | sed -e 's/.*Manufacturer: \(.*\)/\1/')
name=$(dmidecode | grep "System Information" -A 10 | grep -m1 Product | sed -e 's/.*Product Name: \(.*\)/\1/')
version=$(dmidecode | grep "System Information" -A 10 | grep -m1 Version | sed -e 's/.*Version: \(.*\)/\1/')

case "$1" in
    start)

    /usr/sbin/dumpkeycodes >/var/run/hotkey-setup
    
    if [ $? -gt 0 ]; then
	rm /var/run/hotkey-setup
    fi

    case "$manufacturer" in
	Hewlett-Packard*)
	case "$name" in
		*Tablet*)
		. /usr/share/hotkey-setup/hptablet.hk
		;;
		esac
	. /usr/share/hotkey-setup/hp.hk
	;;
	Acer*)
	. /usr/share/hotkey-setup/acer.hk
	;;
	ASUS*)
	. /usr/share/hotkey-setup/asus.hk
	;;
	Sony*)
	modprobe sonypi; # Needed to get hotkey events
	;;
	Dell*)
	. /usr/share/hotkey-setup/dell.hk
	;;
	IBM*)
	. /usr/share/hotkey-setup/ibm.hk
	;;
 	*)
	. /usr/share/hotkey-setup/default.hk	
    esac
    . /usr/share/hotkey-setup/generic.hk
    ;;
    stop)
	if [ -f /var/run/hotkey-setup ]; then
		cat /var/run/hotkey-setup | while read scancode keycode; do
			setkeycodes $scancode $keycode;
		done
	fi
    ;;
    restart|force-reload)
    $0 stop || true
    $0 start
    ;;
esac
		
