/* written bby David Borowski.
    Copyright (C ) 2003  David Borowski.

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option ) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
*/

/* included by ../console.c for speakup modularization */

static spk_con_func addr_spk_allocate = NULL;
static spk_con_func addr_spk_bs = NULL;
static spk_write_func addr_spk_con_write = NULL;
static spk_con_func addr_spk_con_update = NULL;

#define speakup_allocate(c) if (addr_spk_allocate) (*addr_spk_allocate)(c)
#define speakup_bs(c) if (addr_spk_bs) (*addr_spk_bs)(c)
#define speakup_con_write(c,s,l) if (addr_spk_con_write) (*addr_spk_con_write)(c,s,l)
#define speakup_con_update(c) if (addr_spk_con_update) (*addr_spk_con_update)(c)

extern spk_key_func addr_spk_key;

void speakup_set_addresses( spk_con_func allocate, spk_con_func bs,
	spk_write_func con_write, spk_con_func con_update, spk_key_func key )
{
	addr_spk_allocate = allocate;
	addr_spk_bs = bs;
	addr_spk_con_write = con_write;
	addr_spk_con_update = con_update;
	addr_spk_key = key;
}

EXPORT_SYMBOL(speakup_set_addresses);
